// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a stakeholder title for Domains in Atlan
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class StakeholderTitle extends Asset implements IStakeholderTitle, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(StakeholderTitle.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "StakeholderTitle";
    /**
     * Fixed typeName for StakeholderTitles.
     */
    String typeName;
    /**
     * qualified name array representing the Domains for which this StakeholderTitle is applicable
     */
    @Attribute
    SortedSet<String> stakeholderTitleDomainQualifiedNames;
    /**
     * Stakeholder-Personas created for this Stakeholder-title
     */
    @Attribute
    SortedSet<IStakeholder> stakeholders;

    /**
     * Builds the minimal object necessary to create a relationship to a StakeholderTitle, from a potentially
     * more-complete StakeholderTitle object.
     *
     * @return the minimal object necessary to relate to the StakeholderTitle
     * @throws InvalidRequestException if any of the minimal set of required properties for a StakeholderTitle relationship are not found in the initial object
     */
    @Override
    public StakeholderTitle trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all StakeholderTitle assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) StakeholderTitle assets will be included.
     *
     * @return a fluent search that includes all StakeholderTitle assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all StakeholderTitle assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) StakeholderTitle assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all StakeholderTitle assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all StakeholderTitle assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) StakeholderTitles will be included
     * @return a fluent search that includes all StakeholderTitle assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all StakeholderTitle assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) StakeholderTitles will be included
     * @return a fluent search that includes all StakeholderTitle assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a StakeholderTitle by GUID. Use this to create a relationship to this StakeholderTitle,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the StakeholderTitle to reference
     * @return reference to a StakeholderTitle that can be used for defining a relationship to a StakeholderTitle
     */
    public static StakeholderTitle refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a StakeholderTitle by GUID. Use this to create a relationship to this StakeholderTitle,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the StakeholderTitle to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a StakeholderTitle that can be used for defining a relationship to a StakeholderTitle
     */
    public static StakeholderTitle refByGuid(String guid, Reference.SaveSemantic semantic) {
        return StakeholderTitle._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a StakeholderTitle by qualifiedName. Use this to create a relationship to this StakeholderTitle,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the StakeholderTitle to reference
     * @return reference to a StakeholderTitle that can be used for defining a relationship to a StakeholderTitle
     */
    public static StakeholderTitle refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a StakeholderTitle by qualifiedName. Use this to create a relationship to this StakeholderTitle,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the StakeholderTitle to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a StakeholderTitle that can be used for defining a relationship to a StakeholderTitle
     */
    public static StakeholderTitle refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return StakeholderTitle._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a StakeholderTitle by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the StakeholderTitle to retrieve, either its GUID or its full qualifiedName
     * @return the requested full StakeholderTitle, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the StakeholderTitle does not exist or the provided GUID is not a StakeholderTitle
     */
    @JsonIgnore
    public static StakeholderTitle get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a StakeholderTitle by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the StakeholderTitle to retrieve, either its GUID or its full qualifiedName
     * @return the requested full StakeholderTitle, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the StakeholderTitle does not exist or the provided GUID is not a StakeholderTitle
     */
    @JsonIgnore
    public static StakeholderTitle get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a StakeholderTitle by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the StakeholderTitle to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full StakeholderTitle, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the StakeholderTitle does not exist or the provided GUID is not a StakeholderTitle
     */
    @JsonIgnore
    public static StakeholderTitle get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof StakeholderTitle) {
                return (StakeholderTitle) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof StakeholderTitle) {
                return (StakeholderTitle) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) StakeholderTitle to active.
     *
     * @param qualifiedName for the StakeholderTitle
     * @return true if the StakeholderTitle is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) StakeholderTitle to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the StakeholderTitle
     * @return true if the StakeholderTitle is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a StakeholderTitle.
     *
     * @param qualifiedName of the StakeholderTitle
     * @param name of the StakeholderTitle
     * @return the minimal request necessary to update the StakeholderTitle, as a builder
     */
    public static StakeholderTitleBuilder<?, ?> updater(String qualifiedName, String name) {
        return StakeholderTitle._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a StakeholderTitle, from a potentially
     * more-complete StakeholderTitle object.
     *
     * @return the minimal object necessary to update the StakeholderTitle, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for StakeholderTitle are not found in the initial object
     */
    @Override
    public StakeholderTitleBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a StakeholderTitle.
     *
     * @param qualifiedName of the StakeholderTitle
     * @param name of the StakeholderTitle
     * @return the updated StakeholderTitle, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a StakeholderTitle.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the StakeholderTitle
     * @param name of the StakeholderTitle
     * @return the updated StakeholderTitle, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (StakeholderTitle) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a StakeholderTitle.
     *
     * @param qualifiedName of the StakeholderTitle
     * @param name of the StakeholderTitle
     * @return the updated StakeholderTitle, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a StakeholderTitle.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the StakeholderTitle
     * @param name of the StakeholderTitle
     * @return the updated StakeholderTitle, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (StakeholderTitle) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a StakeholderTitle.
     *
     * @param qualifiedName of the StakeholderTitle
     * @param name of the StakeholderTitle
     * @return the updated StakeholderTitle, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a StakeholderTitle.
     *
     * @param client connectivity to the Atlan tenant from which to remove the StakeholderTitle's owners
     * @param qualifiedName of the StakeholderTitle
     * @param name of the StakeholderTitle
     * @return the updated StakeholderTitle, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (StakeholderTitle) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a StakeholderTitle.
     *
     * @param qualifiedName of the StakeholderTitle
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated StakeholderTitle, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a StakeholderTitle.
     *
     * @param client connectivity to the Atlan tenant on which to update the StakeholderTitle's certificate
     * @param qualifiedName of the StakeholderTitle
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated StakeholderTitle, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (StakeholderTitle) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a StakeholderTitle.
     *
     * @param qualifiedName of the StakeholderTitle
     * @param name of the StakeholderTitle
     * @return the updated StakeholderTitle, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a StakeholderTitle.
     *
     * @param client connectivity to the Atlan tenant from which to remove the StakeholderTitle's certificate
     * @param qualifiedName of the StakeholderTitle
     * @param name of the StakeholderTitle
     * @return the updated StakeholderTitle, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (StakeholderTitle) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a StakeholderTitle.
     *
     * @param qualifiedName of the StakeholderTitle
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a StakeholderTitle.
     *
     * @param client connectivity to the Atlan tenant on which to update the StakeholderTitle's announcement
     * @param qualifiedName of the StakeholderTitle
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (StakeholderTitle) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a StakeholderTitle.
     *
     * @param qualifiedName of the StakeholderTitle
     * @param name of the StakeholderTitle
     * @return the updated StakeholderTitle, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a StakeholderTitle.
     *
     * @param client connectivity to the Atlan client from which to remove the StakeholderTitle's announcement
     * @param qualifiedName of the StakeholderTitle
     * @param name of the StakeholderTitle
     * @return the updated StakeholderTitle, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (StakeholderTitle) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the StakeholderTitle.
     *
     * @param qualifiedName for the StakeholderTitle
     * @param name human-readable name of the StakeholderTitle
     * @param terms the list of terms to replace on the StakeholderTitle, or null to remove all terms from the StakeholderTitle
     * @return the StakeholderTitle that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the StakeholderTitle.
     *
     * @param client connectivity to the Atlan tenant on which to replace the StakeholderTitle's assigned terms
     * @param qualifiedName for the StakeholderTitle
     * @param name human-readable name of the StakeholderTitle
     * @param terms the list of terms to replace on the StakeholderTitle, or null to remove all terms from the StakeholderTitle
     * @return the StakeholderTitle that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (StakeholderTitle) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the StakeholderTitle, without replacing existing terms linked to the StakeholderTitle.
     * Note: this operation must make two API calls — one to retrieve the StakeholderTitle's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the StakeholderTitle
     * @param terms the list of terms to append to the StakeholderTitle
     * @return the StakeholderTitle that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the StakeholderTitle, without replacing existing terms linked to the StakeholderTitle.
     * Note: this operation must make two API calls — one to retrieve the StakeholderTitle's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the StakeholderTitle
     * @param qualifiedName for the StakeholderTitle
     * @param terms the list of terms to append to the StakeholderTitle
     * @return the StakeholderTitle that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (StakeholderTitle) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a StakeholderTitle, without replacing all existing terms linked to the StakeholderTitle.
     * Note: this operation must make two API calls — one to retrieve the StakeholderTitle's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the StakeholderTitle
     * @param terms the list of terms to remove from the StakeholderTitle, which must be referenced by GUID
     * @return the StakeholderTitle that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a StakeholderTitle, without replacing all existing terms linked to the StakeholderTitle.
     * Note: this operation must make two API calls — one to retrieve the StakeholderTitle's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the StakeholderTitle
     * @param qualifiedName for the StakeholderTitle
     * @param terms the list of terms to remove from the StakeholderTitle, which must be referenced by GUID
     * @return the StakeholderTitle that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static StakeholderTitle removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (StakeholderTitle) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a StakeholderTitle, without replacing existing Atlan tags linked to the StakeholderTitle.
     * Note: this operation must make two API calls — one to retrieve the StakeholderTitle's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the StakeholderTitle
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated StakeholderTitle
     */
    public static StakeholderTitle appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a StakeholderTitle, without replacing existing Atlan tags linked to the StakeholderTitle.
     * Note: this operation must make two API calls — one to retrieve the StakeholderTitle's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the StakeholderTitle
     * @param qualifiedName of the StakeholderTitle
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated StakeholderTitle
     */
    public static StakeholderTitle appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (StakeholderTitle) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a StakeholderTitle, without replacing existing Atlan tags linked to the StakeholderTitle.
     * Note: this operation must make two API calls — one to retrieve the StakeholderTitle's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the StakeholderTitle
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated StakeholderTitle
     */
    public static StakeholderTitle appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a StakeholderTitle, without replacing existing Atlan tags linked to the StakeholderTitle.
     * Note: this operation must make two API calls — one to retrieve the StakeholderTitle's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the StakeholderTitle
     * @param qualifiedName of the StakeholderTitle
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated StakeholderTitle
     */
    public static StakeholderTitle appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (StakeholderTitle) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a StakeholderTitle.
     *
     * @param qualifiedName of the StakeholderTitle
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the StakeholderTitle
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a StakeholderTitle.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a StakeholderTitle
     * @param qualifiedName of the StakeholderTitle
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the StakeholderTitle
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class StakeholderTitleBuilder<C extends StakeholderTitle, B extends StakeholderTitle.StakeholderTitleBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> stakeholderTitleDomainQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IStakeholder> stakeholders;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            StakeholderTitle.StakeholderTitleBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final StakeholderTitle instance, final StakeholderTitle.StakeholderTitleBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.stakeholderTitleDomainQualifiedNames(instance.stakeholderTitleDomainQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.stakeholderTitleDomainQualifiedNames);
            b.stakeholders(instance.stakeholders == null ? java.util.Collections.<IStakeholder>emptySortedSet() : instance.stakeholders);
        }

        /**
         * Fixed typeName for StakeholderTitles.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B stakeholderTitleDomainQualifiedName(final String stakeholderTitleDomainQualifiedName) {
            if (this.stakeholderTitleDomainQualifiedNames == null) this.stakeholderTitleDomainQualifiedNames = new java.util.ArrayList<String>();
            this.stakeholderTitleDomainQualifiedNames.add(stakeholderTitleDomainQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B stakeholderTitleDomainQualifiedNames(final java.util.Collection<? extends String> stakeholderTitleDomainQualifiedNames) {
            if (stakeholderTitleDomainQualifiedNames == null) {
                throw new java.lang.NullPointerException("stakeholderTitleDomainQualifiedNames cannot be null");
            }
            if (this.stakeholderTitleDomainQualifiedNames == null) this.stakeholderTitleDomainQualifiedNames = new java.util.ArrayList<String>();
            this.stakeholderTitleDomainQualifiedNames.addAll(stakeholderTitleDomainQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearStakeholderTitleDomainQualifiedNames() {
            if (this.stakeholderTitleDomainQualifiedNames != null) this.stakeholderTitleDomainQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B stakeholder(final IStakeholder stakeholder) {
            if (this.stakeholders == null) this.stakeholders = new java.util.ArrayList<IStakeholder>();
            this.stakeholders.add(stakeholder);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B stakeholders(final java.util.Collection<? extends IStakeholder> stakeholders) {
            if (stakeholders == null) {
                throw new java.lang.NullPointerException("stakeholders cannot be null");
            }
            if (this.stakeholders == null) this.stakeholders = new java.util.ArrayList<IStakeholder>();
            this.stakeholders.addAll(stakeholders);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearStakeholders() {
            if (this.stakeholders != null) this.stakeholders.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "StakeholderTitle.StakeholderTitleBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", stakeholderTitleDomainQualifiedNames=" + this.stakeholderTitleDomainQualifiedNames + ", stakeholders=" + this.stakeholders + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class StakeholderTitleBuilderImpl extends StakeholderTitle.StakeholderTitleBuilder<StakeholderTitle, StakeholderTitle.StakeholderTitleBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private StakeholderTitleBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected StakeholderTitle.StakeholderTitleBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public StakeholderTitle build() {
            return new StakeholderTitle(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected StakeholderTitle(final StakeholderTitle.StakeholderTitleBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = StakeholderTitle.$default$typeName();
        java.util.SortedSet<String> stakeholderTitleDomainQualifiedNames = new java.util.TreeSet<String>();
        if (b.stakeholderTitleDomainQualifiedNames != null) stakeholderTitleDomainQualifiedNames.addAll(b.stakeholderTitleDomainQualifiedNames);
        stakeholderTitleDomainQualifiedNames = java.util.Collections.unmodifiableSortedSet(stakeholderTitleDomainQualifiedNames);
        this.stakeholderTitleDomainQualifiedNames = stakeholderTitleDomainQualifiedNames;
        java.util.SortedSet<IStakeholder> stakeholders = new java.util.TreeSet<IStakeholder>();
        if (b.stakeholders != null) stakeholders.addAll(b.stakeholders);
        stakeholders = java.util.Collections.unmodifiableSortedSet(stakeholders);
        this.stakeholders = stakeholders;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static StakeholderTitle.StakeholderTitleBuilder<?, ?> _internal() {
        return new StakeholderTitle.StakeholderTitleBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public StakeholderTitle.StakeholderTitleBuilder<?, ?> toBuilder() {
        return new StakeholderTitle.StakeholderTitleBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * qualified name array representing the Domains for which this StakeholderTitle is applicable
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getStakeholderTitleDomainQualifiedNames() {
        return this.stakeholderTitleDomainQualifiedNames;
    }

    /**
     * Stakeholder-Personas created for this Stakeholder-title
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IStakeholder> getStakeholders() {
        return this.stakeholders;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof StakeholderTitle)) return false;
        final StakeholderTitle other = (StakeholderTitle) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$stakeholderTitleDomainQualifiedNames = this.getStakeholderTitleDomainQualifiedNames();
        final java.lang.Object other$stakeholderTitleDomainQualifiedNames = other.getStakeholderTitleDomainQualifiedNames();
        if (this$stakeholderTitleDomainQualifiedNames == null ? other$stakeholderTitleDomainQualifiedNames != null : !this$stakeholderTitleDomainQualifiedNames.equals(other$stakeholderTitleDomainQualifiedNames)) return false;
        final java.lang.Object this$stakeholders = this.getStakeholders();
        final java.lang.Object other$stakeholders = other.getStakeholders();
        if (this$stakeholders == null ? other$stakeholders != null : !this$stakeholders.equals(other$stakeholders)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof StakeholderTitle;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $stakeholderTitleDomainQualifiedNames = this.getStakeholderTitleDomainQualifiedNames();
        result = result * PRIME + ($stakeholderTitleDomainQualifiedNames == null ? 43 : $stakeholderTitleDomainQualifiedNames.hashCode());
        final java.lang.Object $stakeholders = this.getStakeholders();
        result = result * PRIME + ($stakeholders == null ? 43 : $stakeholders.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "StakeholderTitle(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", stakeholderTitleDomainQualifiedNames=" + this.getStakeholderTitleDomainQualifiedNames() + ", stakeholders=" + this.getStakeholders() + ")";
    }

    /**
     * Fixed typeName for StakeholderTitles.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
