// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instances of Superset Chart in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class SupersetChart extends Asset implements ISupersetChart, ISuperset, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SupersetChart.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SupersetChart";
    /**
     * Fixed typeName for SupersetCharts.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Description markdown of the chart.
     */
    @Attribute
    String supersetChartDescriptionMarkdown;
    /**
     * Data stored for the chart in key value pairs.
     */
    @Attribute
    Map<String, String> supersetChartFormData;
    /**
     * SupersetDashboard asset containing this SupersetChart.
     */
    @Attribute
    ISupersetDashboard supersetDashboard;
    /**
     * Identifier of the dashboard in which this asset exists, in Superset.
     */
    @Attribute
    Long supersetDashboardId;
    /**
     * Unique name of the dashboard in which this asset exists.
     */
    @Attribute
    String supersetDashboardQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a SupersetChart, from a potentially
     * more-complete SupersetChart object.
     *
     * @return the minimal object necessary to relate to the SupersetChart
     * @throws InvalidRequestException if any of the minimal set of required properties for a SupersetChart relationship are not found in the initial object
     */
    @Override
    public SupersetChart trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all SupersetChart assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SupersetChart assets will be included.
     *
     * @return a fluent search that includes all SupersetChart assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all SupersetChart assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SupersetChart assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all SupersetChart assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all SupersetChart assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) SupersetCharts will be included
     * @return a fluent search that includes all SupersetChart assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all SupersetChart assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) SupersetCharts will be included
     * @return a fluent search that includes all SupersetChart assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a SupersetChart by GUID. Use this to create a relationship to this SupersetChart,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the SupersetChart to reference
     * @return reference to a SupersetChart that can be used for defining a relationship to a SupersetChart
     */
    public static SupersetChart refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SupersetChart by GUID. Use this to create a relationship to this SupersetChart,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the SupersetChart to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SupersetChart that can be used for defining a relationship to a SupersetChart
     */
    public static SupersetChart refByGuid(String guid, Reference.SaveSemantic semantic) {
        return SupersetChart._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a SupersetChart by qualifiedName. Use this to create a relationship to this SupersetChart,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the SupersetChart to reference
     * @return reference to a SupersetChart that can be used for defining a relationship to a SupersetChart
     */
    public static SupersetChart refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SupersetChart by qualifiedName. Use this to create a relationship to this SupersetChart,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the SupersetChart to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SupersetChart that can be used for defining a relationship to a SupersetChart
     */
    public static SupersetChart refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return SupersetChart._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a SupersetChart by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the SupersetChart to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SupersetChart, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SupersetChart does not exist or the provided GUID is not a SupersetChart
     */
    @JsonIgnore
    public static SupersetChart get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a SupersetChart by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SupersetChart to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SupersetChart, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SupersetChart does not exist or the provided GUID is not a SupersetChart
     */
    @JsonIgnore
    public static SupersetChart get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a SupersetChart by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SupersetChart to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full SupersetChart, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SupersetChart does not exist or the provided GUID is not a SupersetChart
     */
    @JsonIgnore
    public static SupersetChart get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof SupersetChart) {
                return (SupersetChart) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof SupersetChart) {
                return (SupersetChart) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) SupersetChart to active.
     *
     * @param qualifiedName for the SupersetChart
     * @return true if the SupersetChart is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) SupersetChart to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the SupersetChart
     * @return true if the SupersetChart is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Superset chart.
     *
     * @param name of the chart
     * @param dashboard in which the chart should be created, which must have at least
     *                   a qualifiedName
     * @return the minimal request necessary to create the chart, as a builder
     * @throws InvalidRequestException if the dashboard provided is without a qualifiedName
     */
    public static SupersetChartBuilder<?, ?> creator(String name, SupersetDashboard dashboard) throws InvalidRequestException {
        validateRelationship(SupersetDashboard.TYPE_NAME, Map.of("connectionQualifiedName", dashboard.getConnectionQualifiedName(), "qualifiedName", dashboard.getQualifiedName()));
        return creator(name, dashboard.getConnectionQualifiedName(), dashboard.getQualifiedName()).supersetDashboard(dashboard.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a Superset chart.
     *
     * @param name of the chart
     * @param dashboardQualifiedName unique name of the dashboard in which the chart exists
     * @return the minimal object necessary to create the chart, as a builder
     */
    public static SupersetChartBuilder<?, ?> creator(String name, String dashboardQualifiedName) {
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(dashboardQualifiedName);
        return creator(name, connectionQualifiedName, dashboardQualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Superset chart.
     *
     * @param name of the chart
     * @param connectionQualifiedName unique name of the connection in which to create the SupersetChart
     * @param dashboardQualifiedName unique name of the SupersetDashboard in which to create the SupersetChart
     * @return the minimal object necessary to create the chart, as a builder
     */
    public static SupersetChartBuilder<?, ?> creator(String name, String connectionQualifiedName, String dashboardQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return SupersetChart._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).name(name).qualifiedName(dashboardQualifiedName + "/" + name).connectorType(connectorType).supersetDashboardQualifiedName(dashboardQualifiedName).supersetDashboard(SupersetDashboard.refByQualifiedName(dashboardQualifiedName)).connectionQualifiedName(connectionQualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a SupersetChart.
     *
     * @param qualifiedName of the SupersetChart
     * @param name of the SupersetChart
     * @return the minimal request necessary to update the SupersetChart, as a builder
     */
    public static SupersetChartBuilder<?, ?> updater(String qualifiedName, String name) {
        return SupersetChart._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a SupersetChart, from a potentially
     * more-complete SupersetChart object.
     *
     * @return the minimal object necessary to update the SupersetChart, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for SupersetChart are not found in the initial object
     */
    @Override
    public SupersetChartBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a SupersetChart.
     *
     * @param qualifiedName of the SupersetChart
     * @param name of the SupersetChart
     * @return the updated SupersetChart, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a SupersetChart.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SupersetChart
     * @param name of the SupersetChart
     * @return the updated SupersetChart, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetChart) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a SupersetChart.
     *
     * @param qualifiedName of the SupersetChart
     * @param name of the SupersetChart
     * @return the updated SupersetChart, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a SupersetChart.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SupersetChart
     * @param name of the SupersetChart
     * @return the updated SupersetChart, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetChart) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a SupersetChart.
     *
     * @param qualifiedName of the SupersetChart
     * @param name of the SupersetChart
     * @return the updated SupersetChart, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a SupersetChart.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SupersetChart's owners
     * @param qualifiedName of the SupersetChart
     * @param name of the SupersetChart
     * @return the updated SupersetChart, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetChart) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a SupersetChart.
     *
     * @param qualifiedName of the SupersetChart
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SupersetChart, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a SupersetChart.
     *
     * @param client connectivity to the Atlan tenant on which to update the SupersetChart's certificate
     * @param qualifiedName of the SupersetChart
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SupersetChart, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SupersetChart) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a SupersetChart.
     *
     * @param qualifiedName of the SupersetChart
     * @param name of the SupersetChart
     * @return the updated SupersetChart, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a SupersetChart.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SupersetChart's certificate
     * @param qualifiedName of the SupersetChart
     * @param name of the SupersetChart
     * @return the updated SupersetChart, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetChart) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a SupersetChart.
     *
     * @param qualifiedName of the SupersetChart
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a SupersetChart.
     *
     * @param client connectivity to the Atlan tenant on which to update the SupersetChart's announcement
     * @param qualifiedName of the SupersetChart
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SupersetChart) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a SupersetChart.
     *
     * @param qualifiedName of the SupersetChart
     * @param name of the SupersetChart
     * @return the updated SupersetChart, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a SupersetChart.
     *
     * @param client connectivity to the Atlan client from which to remove the SupersetChart's announcement
     * @param qualifiedName of the SupersetChart
     * @param name of the SupersetChart
     * @return the updated SupersetChart, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetChart) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the SupersetChart.
     *
     * @param qualifiedName for the SupersetChart
     * @param name human-readable name of the SupersetChart
     * @param terms the list of terms to replace on the SupersetChart, or null to remove all terms from the SupersetChart
     * @return the SupersetChart that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetChart replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the SupersetChart.
     *
     * @param client connectivity to the Atlan tenant on which to replace the SupersetChart's assigned terms
     * @param qualifiedName for the SupersetChart
     * @param name human-readable name of the SupersetChart
     * @param terms the list of terms to replace on the SupersetChart, or null to remove all terms from the SupersetChart
     * @return the SupersetChart that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetChart replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SupersetChart) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the SupersetChart, without replacing existing terms linked to the SupersetChart.
     * Note: this operation must make two API calls — one to retrieve the SupersetChart's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the SupersetChart
     * @param terms the list of terms to append to the SupersetChart
     * @return the SupersetChart that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetChart appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the SupersetChart, without replacing existing terms linked to the SupersetChart.
     * Note: this operation must make two API calls — one to retrieve the SupersetChart's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the SupersetChart
     * @param qualifiedName for the SupersetChart
     * @param terms the list of terms to append to the SupersetChart
     * @return the SupersetChart that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetChart appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SupersetChart) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a SupersetChart, without replacing all existing terms linked to the SupersetChart.
     * Note: this operation must make two API calls — one to retrieve the SupersetChart's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the SupersetChart
     * @param terms the list of terms to remove from the SupersetChart, which must be referenced by GUID
     * @return the SupersetChart that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a SupersetChart, without replacing all existing terms linked to the SupersetChart.
     * Note: this operation must make two API calls — one to retrieve the SupersetChart's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the SupersetChart
     * @param qualifiedName for the SupersetChart
     * @param terms the list of terms to remove from the SupersetChart, which must be referenced by GUID
     * @return the SupersetChart that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetChart removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SupersetChart) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a SupersetChart, without replacing existing Atlan tags linked to the SupersetChart.
     * Note: this operation must make two API calls — one to retrieve the SupersetChart's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SupersetChart
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SupersetChart
     */
    public static SupersetChart appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SupersetChart, without replacing existing Atlan tags linked to the SupersetChart.
     * Note: this operation must make two API calls — one to retrieve the SupersetChart's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SupersetChart
     * @param qualifiedName of the SupersetChart
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SupersetChart
     */
    public static SupersetChart appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SupersetChart) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SupersetChart, without replacing existing Atlan tags linked to the SupersetChart.
     * Note: this operation must make two API calls — one to retrieve the SupersetChart's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SupersetChart
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SupersetChart
     */
    public static SupersetChart appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a SupersetChart, without replacing existing Atlan tags linked to the SupersetChart.
     * Note: this operation must make two API calls — one to retrieve the SupersetChart's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SupersetChart
     * @param qualifiedName of the SupersetChart
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SupersetChart
     */
    public static SupersetChart appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SupersetChart) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a SupersetChart.
     *
     * @param qualifiedName of the SupersetChart
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SupersetChart
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a SupersetChart.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a SupersetChart
     * @param qualifiedName of the SupersetChart
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SupersetChart
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SupersetChartBuilder<C extends SupersetChart, B extends SupersetChart.SupersetChartBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String supersetChartDescriptionMarkdown;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> supersetChartFormData$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> supersetChartFormData$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ISupersetDashboard supersetDashboard;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long supersetDashboardId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String supersetDashboardQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SupersetChart.SupersetChartBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SupersetChart instance, final SupersetChart.SupersetChartBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.supersetChartDescriptionMarkdown(instance.supersetChartDescriptionMarkdown);
            b.supersetChartFormData(instance.supersetChartFormData == null ? java.util.Collections.<String, String>emptyMap() : instance.supersetChartFormData);
            b.supersetDashboard(instance.supersetDashboard);
            b.supersetDashboardId(instance.supersetDashboardId);
            b.supersetDashboardQualifiedName(instance.supersetDashboardQualifiedName);
        }

        /**
         * Fixed typeName for SupersetCharts.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Description markdown of the chart.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetChartDescriptionMarkdown(final String supersetChartDescriptionMarkdown) {
            this.supersetChartDescriptionMarkdown = supersetChartDescriptionMarkdown;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putSupersetChartFormData(final String putSupersetChartFormDataKey, final String putSupersetChartFormDataValue) {
            if (this.supersetChartFormData$key == null) {
                this.supersetChartFormData$key = new java.util.ArrayList<String>();
                this.supersetChartFormData$value = new java.util.ArrayList<String>();
            }
            this.supersetChartFormData$key.add(putSupersetChartFormDataKey);
            this.supersetChartFormData$value.add(putSupersetChartFormDataValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetChartFormData(final java.util.Map<? extends String, ? extends String> supersetChartFormData) {
            if (supersetChartFormData == null) {
                throw new java.lang.NullPointerException("supersetChartFormData cannot be null");
            }
            if (this.supersetChartFormData$key == null) {
                this.supersetChartFormData$key = new java.util.ArrayList<String>();
                this.supersetChartFormData$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : supersetChartFormData.entrySet()) {
                this.supersetChartFormData$key.add($lombokEntry.getKey());
                this.supersetChartFormData$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSupersetChartFormData() {
            if (this.supersetChartFormData$key != null) {
                this.supersetChartFormData$key.clear();
                this.supersetChartFormData$value.clear();
            }
            return self();
        }

        /**
         * SupersetDashboard asset containing this SupersetChart.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDashboard(final ISupersetDashboard supersetDashboard) {
            this.supersetDashboard = supersetDashboard;
            return self();
        }

        /**
         * Identifier of the dashboard in which this asset exists, in Superset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDashboardId(final Long supersetDashboardId) {
            this.supersetDashboardId = supersetDashboardId;
            return self();
        }

        /**
         * Unique name of the dashboard in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDashboardQualifiedName(final String supersetDashboardQualifiedName) {
            this.supersetDashboardQualifiedName = supersetDashboardQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SupersetChart.SupersetChartBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", supersetChartDescriptionMarkdown=" + this.supersetChartDescriptionMarkdown + ", supersetChartFormData$key=" + this.supersetChartFormData$key + ", supersetChartFormData$value=" + this.supersetChartFormData$value + ", supersetDashboard=" + this.supersetDashboard + ", supersetDashboardId=" + this.supersetDashboardId + ", supersetDashboardQualifiedName=" + this.supersetDashboardQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SupersetChartBuilderImpl extends SupersetChart.SupersetChartBuilder<SupersetChart, SupersetChart.SupersetChartBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SupersetChartBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SupersetChart.SupersetChartBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SupersetChart build() {
            return new SupersetChart(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SupersetChart(final SupersetChart.SupersetChartBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = SupersetChart.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.supersetChartDescriptionMarkdown = b.supersetChartDescriptionMarkdown;
        java.util.Map<String, String> supersetChartFormData;
        switch (b.supersetChartFormData$key == null ? 0 : b.supersetChartFormData$key.size()) {
        case 0: 
            supersetChartFormData = java.util.Collections.emptyMap();
            break;
        case 1: 
            supersetChartFormData = java.util.Collections.singletonMap(b.supersetChartFormData$key.get(0), b.supersetChartFormData$value.get(0));
            break;
        default: 
            supersetChartFormData = new java.util.LinkedHashMap<String, String>(b.supersetChartFormData$key.size() < 1073741824 ? 1 + b.supersetChartFormData$key.size() + (b.supersetChartFormData$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.supersetChartFormData$key.size(); $i++) supersetChartFormData.put(b.supersetChartFormData$key.get($i), (String) b.supersetChartFormData$value.get($i));
            supersetChartFormData = java.util.Collections.unmodifiableMap(supersetChartFormData);
        }
        this.supersetChartFormData = supersetChartFormData;
        this.supersetDashboard = b.supersetDashboard;
        this.supersetDashboardId = b.supersetDashboardId;
        this.supersetDashboardQualifiedName = b.supersetDashboardQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SupersetChart.SupersetChartBuilder<?, ?> _internal() {
        return new SupersetChart.SupersetChartBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SupersetChart.SupersetChartBuilder<?, ?> toBuilder() {
        return new SupersetChart.SupersetChartBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Description markdown of the chart.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupersetChartDescriptionMarkdown() {
        return this.supersetChartDescriptionMarkdown;
    }

    /**
     * Data stored for the chart in key value pairs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getSupersetChartFormData() {
        return this.supersetChartFormData;
    }

    /**
     * SupersetDashboard asset containing this SupersetChart.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ISupersetDashboard getSupersetDashboard() {
        return this.supersetDashboard;
    }

    /**
     * Identifier of the dashboard in which this asset exists, in Superset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSupersetDashboardId() {
        return this.supersetDashboardId;
    }

    /**
     * Unique name of the dashboard in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupersetDashboardQualifiedName() {
        return this.supersetDashboardQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SupersetChart)) return false;
        final SupersetChart other = (SupersetChart) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$supersetDashboardId = this.getSupersetDashboardId();
        final java.lang.Object other$supersetDashboardId = other.getSupersetDashboardId();
        if (this$supersetDashboardId == null ? other$supersetDashboardId != null : !this$supersetDashboardId.equals(other$supersetDashboardId)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$supersetChartDescriptionMarkdown = this.getSupersetChartDescriptionMarkdown();
        final java.lang.Object other$supersetChartDescriptionMarkdown = other.getSupersetChartDescriptionMarkdown();
        if (this$supersetChartDescriptionMarkdown == null ? other$supersetChartDescriptionMarkdown != null : !this$supersetChartDescriptionMarkdown.equals(other$supersetChartDescriptionMarkdown)) return false;
        final java.lang.Object this$supersetChartFormData = this.getSupersetChartFormData();
        final java.lang.Object other$supersetChartFormData = other.getSupersetChartFormData();
        if (this$supersetChartFormData == null ? other$supersetChartFormData != null : !this$supersetChartFormData.equals(other$supersetChartFormData)) return false;
        final java.lang.Object this$supersetDashboard = this.getSupersetDashboard();
        final java.lang.Object other$supersetDashboard = other.getSupersetDashboard();
        if (this$supersetDashboard == null ? other$supersetDashboard != null : !this$supersetDashboard.equals(other$supersetDashboard)) return false;
        final java.lang.Object this$supersetDashboardQualifiedName = this.getSupersetDashboardQualifiedName();
        final java.lang.Object other$supersetDashboardQualifiedName = other.getSupersetDashboardQualifiedName();
        if (this$supersetDashboardQualifiedName == null ? other$supersetDashboardQualifiedName != null : !this$supersetDashboardQualifiedName.equals(other$supersetDashboardQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SupersetChart;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $supersetDashboardId = this.getSupersetDashboardId();
        result = result * PRIME + ($supersetDashboardId == null ? 43 : $supersetDashboardId.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $supersetChartDescriptionMarkdown = this.getSupersetChartDescriptionMarkdown();
        result = result * PRIME + ($supersetChartDescriptionMarkdown == null ? 43 : $supersetChartDescriptionMarkdown.hashCode());
        final java.lang.Object $supersetChartFormData = this.getSupersetChartFormData();
        result = result * PRIME + ($supersetChartFormData == null ? 43 : $supersetChartFormData.hashCode());
        final java.lang.Object $supersetDashboard = this.getSupersetDashboard();
        result = result * PRIME + ($supersetDashboard == null ? 43 : $supersetDashboard.hashCode());
        final java.lang.Object $supersetDashboardQualifiedName = this.getSupersetDashboardQualifiedName();
        result = result * PRIME + ($supersetDashboardQualifiedName == null ? 43 : $supersetDashboardQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SupersetChart(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", supersetChartDescriptionMarkdown=" + this.getSupersetChartDescriptionMarkdown() + ", supersetChartFormData=" + this.getSupersetChartFormData() + ", supersetDashboard=" + this.getSupersetDashboard() + ", supersetDashboardId=" + this.getSupersetDashboardId() + ", supersetDashboardQualifiedName=" + this.getSupersetDashboardQualifiedName() + ")";
    }

    /**
     * Fixed typeName for SupersetCharts.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
