// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instances of SupersetDashboard in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class SupersetDashboard extends Asset implements ISupersetDashboard, ISuperset, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SupersetDashboard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SupersetDashboard";
    /**
     * Fixed typeName for SupersetDashboards.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * SupersetCharts assets contained within this SupersetDashboard.
     */
    @Attribute
    SortedSet<ISupersetChart> supersetCharts;
    /**
     * Name of the user who changed the dashboard.
     */
    @Attribute
    String supersetDashboardChangedByName;
    /**
     * URL of the user profile that changed the dashboard
     */
    @Attribute
    String supersetDashboardChangedByURL;
    /**
     * Count of charts present in the dashboard.
     */
    @Attribute
    Long supersetDashboardChartCount;
    /**
     * Identifier of the dashboard in which this asset exists, in Superset.
     */
    @Attribute
    Long supersetDashboardId;
    /**
     * Whether the dashboard is manager externally (true) or not (false).
     */
    @Attribute
    Boolean supersetDashboardIsManagedExternally;
    /**
     * Whether the dashboard is published (true) or not (false).
     */
    @Attribute
    Boolean supersetDashboardIsPublished;
    /**
     * Unique name of the dashboard in which this asset exists.
     */
    @Attribute
    String supersetDashboardQualifiedName;
    /**
     * URL for the dashboard thumbnail image in superset.
     */
    @Attribute
    String supersetDashboardThumbnailURL;
    /**
     * SupersetDatasets assets contained within this SupersetDashboard.
     */
    @Attribute
    SortedSet<ISupersetDataset> supersetDatasets;

    /**
     * Builds the minimal object necessary to create a relationship to a SupersetDashboard, from a potentially
     * more-complete SupersetDashboard object.
     *
     * @return the minimal object necessary to relate to the SupersetDashboard
     * @throws InvalidRequestException if any of the minimal set of required properties for a SupersetDashboard relationship are not found in the initial object
     */
    @Override
    public SupersetDashboard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all SupersetDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SupersetDashboard assets will be included.
     *
     * @return a fluent search that includes all SupersetDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all SupersetDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SupersetDashboard assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all SupersetDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all SupersetDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) SupersetDashboards will be included
     * @return a fluent search that includes all SupersetDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all SupersetDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) SupersetDashboards will be included
     * @return a fluent search that includes all SupersetDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a SupersetDashboard by GUID. Use this to create a relationship to this SupersetDashboard,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the SupersetDashboard to reference
     * @return reference to a SupersetDashboard that can be used for defining a relationship to a SupersetDashboard
     */
    public static SupersetDashboard refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SupersetDashboard by GUID. Use this to create a relationship to this SupersetDashboard,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the SupersetDashboard to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SupersetDashboard that can be used for defining a relationship to a SupersetDashboard
     */
    public static SupersetDashboard refByGuid(String guid, Reference.SaveSemantic semantic) {
        return SupersetDashboard._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a SupersetDashboard by qualifiedName. Use this to create a relationship to this SupersetDashboard,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the SupersetDashboard to reference
     * @return reference to a SupersetDashboard that can be used for defining a relationship to a SupersetDashboard
     */
    public static SupersetDashboard refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SupersetDashboard by qualifiedName. Use this to create a relationship to this SupersetDashboard,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the SupersetDashboard to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SupersetDashboard that can be used for defining a relationship to a SupersetDashboard
     */
    public static SupersetDashboard refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return SupersetDashboard._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a SupersetDashboard by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the SupersetDashboard to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SupersetDashboard, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SupersetDashboard does not exist or the provided GUID is not a SupersetDashboard
     */
    @JsonIgnore
    public static SupersetDashboard get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a SupersetDashboard by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SupersetDashboard to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SupersetDashboard, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SupersetDashboard does not exist or the provided GUID is not a SupersetDashboard
     */
    @JsonIgnore
    public static SupersetDashboard get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a SupersetDashboard by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SupersetDashboard to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full SupersetDashboard, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SupersetDashboard does not exist or the provided GUID is not a SupersetDashboard
     */
    @JsonIgnore
    public static SupersetDashboard get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof SupersetDashboard) {
                return (SupersetDashboard) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof SupersetDashboard) {
                return (SupersetDashboard) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) SupersetDashboard to active.
     *
     * @param qualifiedName for the SupersetDashboard
     * @return true if the SupersetDashboard is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) SupersetDashboard to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the SupersetDashboard
     * @return true if the SupersetDashboard is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Superset dashboard.
     *
     * @param name of the dashboard
     * @param connectionQualifiedName unique name of the connection through which the dashboard is accessible
     * @return the minimal object necessary to create the dashboard, as a builder
     */
    public static SupersetDashboardBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return SupersetDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(generateQualifiedName(connectionQualifiedName, name)).name(name).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.SUPERSET);
    }

    /**
     * Builds the minimal object necessary to update a SupersetDashboard.
     *
     * @param qualifiedName of the SupersetDashboard
     * @param name of the SupersetDashboard
     * @return the minimal request necessary to update the SupersetDashboard, as a builder
     */
    public static SupersetDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return SupersetDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a SupersetDashboard, from a potentially
     * more-complete SupersetDashboard object.
     *
     * @return the minimal object necessary to update the SupersetDashboard, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for SupersetDashboard are not found in the initial object
     */
    @Override
    public SupersetDashboardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Generate a unique Preset workspace name.
     *
     * @param connectionQualifiedName unique name of the connection
     * @param name for the workspace
     * @return a unique name for the workspace
     */
    private static String generateQualifiedName(String connectionQualifiedName, String name) {
        return connectionQualifiedName + "/" + name;
    }

    /**
     * Remove the system description from a SupersetDashboard.
     *
     * @param qualifiedName of the SupersetDashboard
     * @param name of the SupersetDashboard
     * @return the updated SupersetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a SupersetDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SupersetDashboard
     * @param name of the SupersetDashboard
     * @return the updated SupersetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetDashboard) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a SupersetDashboard.
     *
     * @param qualifiedName of the SupersetDashboard
     * @param name of the SupersetDashboard
     * @return the updated SupersetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a SupersetDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SupersetDashboard
     * @param name of the SupersetDashboard
     * @return the updated SupersetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetDashboard) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a SupersetDashboard.
     *
     * @param qualifiedName of the SupersetDashboard
     * @param name of the SupersetDashboard
     * @return the updated SupersetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a SupersetDashboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SupersetDashboard's owners
     * @param qualifiedName of the SupersetDashboard
     * @param name of the SupersetDashboard
     * @return the updated SupersetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetDashboard) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a SupersetDashboard.
     *
     * @param qualifiedName of the SupersetDashboard
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SupersetDashboard, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a SupersetDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to update the SupersetDashboard's certificate
     * @param qualifiedName of the SupersetDashboard
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SupersetDashboard, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SupersetDashboard) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a SupersetDashboard.
     *
     * @param qualifiedName of the SupersetDashboard
     * @param name of the SupersetDashboard
     * @return the updated SupersetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a SupersetDashboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SupersetDashboard's certificate
     * @param qualifiedName of the SupersetDashboard
     * @param name of the SupersetDashboard
     * @return the updated SupersetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetDashboard) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a SupersetDashboard.
     *
     * @param qualifiedName of the SupersetDashboard
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a SupersetDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to update the SupersetDashboard's announcement
     * @param qualifiedName of the SupersetDashboard
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SupersetDashboard) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a SupersetDashboard.
     *
     * @param qualifiedName of the SupersetDashboard
     * @param name of the SupersetDashboard
     * @return the updated SupersetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a SupersetDashboard.
     *
     * @param client connectivity to the Atlan client from which to remove the SupersetDashboard's announcement
     * @param qualifiedName of the SupersetDashboard
     * @param name of the SupersetDashboard
     * @return the updated SupersetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetDashboard) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the SupersetDashboard.
     *
     * @param qualifiedName for the SupersetDashboard
     * @param name human-readable name of the SupersetDashboard
     * @param terms the list of terms to replace on the SupersetDashboard, or null to remove all terms from the SupersetDashboard
     * @return the SupersetDashboard that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the SupersetDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to replace the SupersetDashboard's assigned terms
     * @param qualifiedName for the SupersetDashboard
     * @param name human-readable name of the SupersetDashboard
     * @param terms the list of terms to replace on the SupersetDashboard, or null to remove all terms from the SupersetDashboard
     * @return the SupersetDashboard that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SupersetDashboard) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the SupersetDashboard, without replacing existing terms linked to the SupersetDashboard.
     * Note: this operation must make two API calls — one to retrieve the SupersetDashboard's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the SupersetDashboard
     * @param terms the list of terms to append to the SupersetDashboard
     * @return the SupersetDashboard that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the SupersetDashboard, without replacing existing terms linked to the SupersetDashboard.
     * Note: this operation must make two API calls — one to retrieve the SupersetDashboard's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the SupersetDashboard
     * @param qualifiedName for the SupersetDashboard
     * @param terms the list of terms to append to the SupersetDashboard
     * @return the SupersetDashboard that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SupersetDashboard) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a SupersetDashboard, without replacing all existing terms linked to the SupersetDashboard.
     * Note: this operation must make two API calls — one to retrieve the SupersetDashboard's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the SupersetDashboard
     * @param terms the list of terms to remove from the SupersetDashboard, which must be referenced by GUID
     * @return the SupersetDashboard that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a SupersetDashboard, without replacing all existing terms linked to the SupersetDashboard.
     * Note: this operation must make two API calls — one to retrieve the SupersetDashboard's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the SupersetDashboard
     * @param qualifiedName for the SupersetDashboard
     * @param terms the list of terms to remove from the SupersetDashboard, which must be referenced by GUID
     * @return the SupersetDashboard that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SupersetDashboard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SupersetDashboard) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a SupersetDashboard, without replacing existing Atlan tags linked to the SupersetDashboard.
     * Note: this operation must make two API calls — one to retrieve the SupersetDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SupersetDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SupersetDashboard
     */
    public static SupersetDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SupersetDashboard, without replacing existing Atlan tags linked to the SupersetDashboard.
     * Note: this operation must make two API calls — one to retrieve the SupersetDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SupersetDashboard
     * @param qualifiedName of the SupersetDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SupersetDashboard
     */
    public static SupersetDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SupersetDashboard) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SupersetDashboard, without replacing existing Atlan tags linked to the SupersetDashboard.
     * Note: this operation must make two API calls — one to retrieve the SupersetDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SupersetDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SupersetDashboard
     */
    public static SupersetDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a SupersetDashboard, without replacing existing Atlan tags linked to the SupersetDashboard.
     * Note: this operation must make two API calls — one to retrieve the SupersetDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SupersetDashboard
     * @param qualifiedName of the SupersetDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SupersetDashboard
     */
    public static SupersetDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SupersetDashboard) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a SupersetDashboard.
     *
     * @param qualifiedName of the SupersetDashboard
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SupersetDashboard
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a SupersetDashboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a SupersetDashboard
     * @param qualifiedName of the SupersetDashboard
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SupersetDashboard
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SupersetDashboardBuilder<C extends SupersetDashboard, B extends SupersetDashboard.SupersetDashboardBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISupersetChart> supersetCharts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String supersetDashboardChangedByName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String supersetDashboardChangedByURL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long supersetDashboardChartCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long supersetDashboardId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean supersetDashboardIsManagedExternally;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean supersetDashboardIsPublished;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String supersetDashboardQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String supersetDashboardThumbnailURL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISupersetDataset> supersetDatasets;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SupersetDashboard.SupersetDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SupersetDashboard instance, final SupersetDashboard.SupersetDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.supersetCharts(instance.supersetCharts == null ? java.util.Collections.<ISupersetChart>emptySortedSet() : instance.supersetCharts);
            b.supersetDashboardChangedByName(instance.supersetDashboardChangedByName);
            b.supersetDashboardChangedByURL(instance.supersetDashboardChangedByURL);
            b.supersetDashboardChartCount(instance.supersetDashboardChartCount);
            b.supersetDashboardId(instance.supersetDashboardId);
            b.supersetDashboardIsManagedExternally(instance.supersetDashboardIsManagedExternally);
            b.supersetDashboardIsPublished(instance.supersetDashboardIsPublished);
            b.supersetDashboardQualifiedName(instance.supersetDashboardQualifiedName);
            b.supersetDashboardThumbnailURL(instance.supersetDashboardThumbnailURL);
            b.supersetDatasets(instance.supersetDatasets == null ? java.util.Collections.<ISupersetDataset>emptySortedSet() : instance.supersetDatasets);
        }

        /**
         * Fixed typeName for SupersetDashboards.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetChart(final ISupersetChart supersetChart) {
            if (this.supersetCharts == null) this.supersetCharts = new java.util.ArrayList<ISupersetChart>();
            this.supersetCharts.add(supersetChart);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetCharts(final java.util.Collection<? extends ISupersetChart> supersetCharts) {
            if (supersetCharts == null) {
                throw new java.lang.NullPointerException("supersetCharts cannot be null");
            }
            if (this.supersetCharts == null) this.supersetCharts = new java.util.ArrayList<ISupersetChart>();
            this.supersetCharts.addAll(supersetCharts);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSupersetCharts() {
            if (this.supersetCharts != null) this.supersetCharts.clear();
            return self();
        }

        /**
         * Name of the user who changed the dashboard.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDashboardChangedByName(final String supersetDashboardChangedByName) {
            this.supersetDashboardChangedByName = supersetDashboardChangedByName;
            return self();
        }

        /**
         * URL of the user profile that changed the dashboard
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDashboardChangedByURL(final String supersetDashboardChangedByURL) {
            this.supersetDashboardChangedByURL = supersetDashboardChangedByURL;
            return self();
        }

        /**
         * Count of charts present in the dashboard.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDashboardChartCount(final Long supersetDashboardChartCount) {
            this.supersetDashboardChartCount = supersetDashboardChartCount;
            return self();
        }

        /**
         * Identifier of the dashboard in which this asset exists, in Superset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDashboardId(final Long supersetDashboardId) {
            this.supersetDashboardId = supersetDashboardId;
            return self();
        }

        /**
         * Whether the dashboard is manager externally (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDashboardIsManagedExternally(final Boolean supersetDashboardIsManagedExternally) {
            this.supersetDashboardIsManagedExternally = supersetDashboardIsManagedExternally;
            return self();
        }

        /**
         * Whether the dashboard is published (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDashboardIsPublished(final Boolean supersetDashboardIsPublished) {
            this.supersetDashboardIsPublished = supersetDashboardIsPublished;
            return self();
        }

        /**
         * Unique name of the dashboard in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDashboardQualifiedName(final String supersetDashboardQualifiedName) {
            this.supersetDashboardQualifiedName = supersetDashboardQualifiedName;
            return self();
        }

        /**
         * URL for the dashboard thumbnail image in superset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDashboardThumbnailURL(final String supersetDashboardThumbnailURL) {
            this.supersetDashboardThumbnailURL = supersetDashboardThumbnailURL;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDataset(final ISupersetDataset supersetDataset) {
            if (this.supersetDatasets == null) this.supersetDatasets = new java.util.ArrayList<ISupersetDataset>();
            this.supersetDatasets.add(supersetDataset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B supersetDatasets(final java.util.Collection<? extends ISupersetDataset> supersetDatasets) {
            if (supersetDatasets == null) {
                throw new java.lang.NullPointerException("supersetDatasets cannot be null");
            }
            if (this.supersetDatasets == null) this.supersetDatasets = new java.util.ArrayList<ISupersetDataset>();
            this.supersetDatasets.addAll(supersetDatasets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSupersetDatasets() {
            if (this.supersetDatasets != null) this.supersetDatasets.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SupersetDashboard.SupersetDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", supersetCharts=" + this.supersetCharts + ", supersetDashboardChangedByName=" + this.supersetDashboardChangedByName + ", supersetDashboardChangedByURL=" + this.supersetDashboardChangedByURL + ", supersetDashboardChartCount=" + this.supersetDashboardChartCount + ", supersetDashboardId=" + this.supersetDashboardId + ", supersetDashboardIsManagedExternally=" + this.supersetDashboardIsManagedExternally + ", supersetDashboardIsPublished=" + this.supersetDashboardIsPublished + ", supersetDashboardQualifiedName=" + this.supersetDashboardQualifiedName + ", supersetDashboardThumbnailURL=" + this.supersetDashboardThumbnailURL + ", supersetDatasets=" + this.supersetDatasets + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SupersetDashboardBuilderImpl extends SupersetDashboard.SupersetDashboardBuilder<SupersetDashboard, SupersetDashboard.SupersetDashboardBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SupersetDashboardBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SupersetDashboard.SupersetDashboardBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SupersetDashboard build() {
            return new SupersetDashboard(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SupersetDashboard(final SupersetDashboard.SupersetDashboardBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = SupersetDashboard.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<ISupersetChart> supersetCharts = new java.util.TreeSet<ISupersetChart>();
        if (b.supersetCharts != null) supersetCharts.addAll(b.supersetCharts);
        supersetCharts = java.util.Collections.unmodifiableSortedSet(supersetCharts);
        this.supersetCharts = supersetCharts;
        this.supersetDashboardChangedByName = b.supersetDashboardChangedByName;
        this.supersetDashboardChangedByURL = b.supersetDashboardChangedByURL;
        this.supersetDashboardChartCount = b.supersetDashboardChartCount;
        this.supersetDashboardId = b.supersetDashboardId;
        this.supersetDashboardIsManagedExternally = b.supersetDashboardIsManagedExternally;
        this.supersetDashboardIsPublished = b.supersetDashboardIsPublished;
        this.supersetDashboardQualifiedName = b.supersetDashboardQualifiedName;
        this.supersetDashboardThumbnailURL = b.supersetDashboardThumbnailURL;
        java.util.SortedSet<ISupersetDataset> supersetDatasets = new java.util.TreeSet<ISupersetDataset>();
        if (b.supersetDatasets != null) supersetDatasets.addAll(b.supersetDatasets);
        supersetDatasets = java.util.Collections.unmodifiableSortedSet(supersetDatasets);
        this.supersetDatasets = supersetDatasets;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SupersetDashboard.SupersetDashboardBuilder<?, ?> _internal() {
        return new SupersetDashboard.SupersetDashboardBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SupersetDashboard.SupersetDashboardBuilder<?, ?> toBuilder() {
        return new SupersetDashboard.SupersetDashboardBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * SupersetCharts assets contained within this SupersetDashboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISupersetChart> getSupersetCharts() {
        return this.supersetCharts;
    }

    /**
     * Name of the user who changed the dashboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupersetDashboardChangedByName() {
        return this.supersetDashboardChangedByName;
    }

    /**
     * URL of the user profile that changed the dashboard
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupersetDashboardChangedByURL() {
        return this.supersetDashboardChangedByURL;
    }

    /**
     * Count of charts present in the dashboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSupersetDashboardChartCount() {
        return this.supersetDashboardChartCount;
    }

    /**
     * Identifier of the dashboard in which this asset exists, in Superset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSupersetDashboardId() {
        return this.supersetDashboardId;
    }

    /**
     * Whether the dashboard is manager externally (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSupersetDashboardIsManagedExternally() {
        return this.supersetDashboardIsManagedExternally;
    }

    /**
     * Whether the dashboard is published (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSupersetDashboardIsPublished() {
        return this.supersetDashboardIsPublished;
    }

    /**
     * Unique name of the dashboard in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupersetDashboardQualifiedName() {
        return this.supersetDashboardQualifiedName;
    }

    /**
     * URL for the dashboard thumbnail image in superset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupersetDashboardThumbnailURL() {
        return this.supersetDashboardThumbnailURL;
    }

    /**
     * SupersetDatasets assets contained within this SupersetDashboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISupersetDataset> getSupersetDatasets() {
        return this.supersetDatasets;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SupersetDashboard)) return false;
        final SupersetDashboard other = (SupersetDashboard) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$supersetDashboardChartCount = this.getSupersetDashboardChartCount();
        final java.lang.Object other$supersetDashboardChartCount = other.getSupersetDashboardChartCount();
        if (this$supersetDashboardChartCount == null ? other$supersetDashboardChartCount != null : !this$supersetDashboardChartCount.equals(other$supersetDashboardChartCount)) return false;
        final java.lang.Object this$supersetDashboardId = this.getSupersetDashboardId();
        final java.lang.Object other$supersetDashboardId = other.getSupersetDashboardId();
        if (this$supersetDashboardId == null ? other$supersetDashboardId != null : !this$supersetDashboardId.equals(other$supersetDashboardId)) return false;
        final java.lang.Object this$supersetDashboardIsManagedExternally = this.getSupersetDashboardIsManagedExternally();
        final java.lang.Object other$supersetDashboardIsManagedExternally = other.getSupersetDashboardIsManagedExternally();
        if (this$supersetDashboardIsManagedExternally == null ? other$supersetDashboardIsManagedExternally != null : !this$supersetDashboardIsManagedExternally.equals(other$supersetDashboardIsManagedExternally)) return false;
        final java.lang.Object this$supersetDashboardIsPublished = this.getSupersetDashboardIsPublished();
        final java.lang.Object other$supersetDashboardIsPublished = other.getSupersetDashboardIsPublished();
        if (this$supersetDashboardIsPublished == null ? other$supersetDashboardIsPublished != null : !this$supersetDashboardIsPublished.equals(other$supersetDashboardIsPublished)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$supersetCharts = this.getSupersetCharts();
        final java.lang.Object other$supersetCharts = other.getSupersetCharts();
        if (this$supersetCharts == null ? other$supersetCharts != null : !this$supersetCharts.equals(other$supersetCharts)) return false;
        final java.lang.Object this$supersetDashboardChangedByName = this.getSupersetDashboardChangedByName();
        final java.lang.Object other$supersetDashboardChangedByName = other.getSupersetDashboardChangedByName();
        if (this$supersetDashboardChangedByName == null ? other$supersetDashboardChangedByName != null : !this$supersetDashboardChangedByName.equals(other$supersetDashboardChangedByName)) return false;
        final java.lang.Object this$supersetDashboardChangedByURL = this.getSupersetDashboardChangedByURL();
        final java.lang.Object other$supersetDashboardChangedByURL = other.getSupersetDashboardChangedByURL();
        if (this$supersetDashboardChangedByURL == null ? other$supersetDashboardChangedByURL != null : !this$supersetDashboardChangedByURL.equals(other$supersetDashboardChangedByURL)) return false;
        final java.lang.Object this$supersetDashboardQualifiedName = this.getSupersetDashboardQualifiedName();
        final java.lang.Object other$supersetDashboardQualifiedName = other.getSupersetDashboardQualifiedName();
        if (this$supersetDashboardQualifiedName == null ? other$supersetDashboardQualifiedName != null : !this$supersetDashboardQualifiedName.equals(other$supersetDashboardQualifiedName)) return false;
        final java.lang.Object this$supersetDashboardThumbnailURL = this.getSupersetDashboardThumbnailURL();
        final java.lang.Object other$supersetDashboardThumbnailURL = other.getSupersetDashboardThumbnailURL();
        if (this$supersetDashboardThumbnailURL == null ? other$supersetDashboardThumbnailURL != null : !this$supersetDashboardThumbnailURL.equals(other$supersetDashboardThumbnailURL)) return false;
        final java.lang.Object this$supersetDatasets = this.getSupersetDatasets();
        final java.lang.Object other$supersetDatasets = other.getSupersetDatasets();
        if (this$supersetDatasets == null ? other$supersetDatasets != null : !this$supersetDatasets.equals(other$supersetDatasets)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SupersetDashboard;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $supersetDashboardChartCount = this.getSupersetDashboardChartCount();
        result = result * PRIME + ($supersetDashboardChartCount == null ? 43 : $supersetDashboardChartCount.hashCode());
        final java.lang.Object $supersetDashboardId = this.getSupersetDashboardId();
        result = result * PRIME + ($supersetDashboardId == null ? 43 : $supersetDashboardId.hashCode());
        final java.lang.Object $supersetDashboardIsManagedExternally = this.getSupersetDashboardIsManagedExternally();
        result = result * PRIME + ($supersetDashboardIsManagedExternally == null ? 43 : $supersetDashboardIsManagedExternally.hashCode());
        final java.lang.Object $supersetDashboardIsPublished = this.getSupersetDashboardIsPublished();
        result = result * PRIME + ($supersetDashboardIsPublished == null ? 43 : $supersetDashboardIsPublished.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $supersetCharts = this.getSupersetCharts();
        result = result * PRIME + ($supersetCharts == null ? 43 : $supersetCharts.hashCode());
        final java.lang.Object $supersetDashboardChangedByName = this.getSupersetDashboardChangedByName();
        result = result * PRIME + ($supersetDashboardChangedByName == null ? 43 : $supersetDashboardChangedByName.hashCode());
        final java.lang.Object $supersetDashboardChangedByURL = this.getSupersetDashboardChangedByURL();
        result = result * PRIME + ($supersetDashboardChangedByURL == null ? 43 : $supersetDashboardChangedByURL.hashCode());
        final java.lang.Object $supersetDashboardQualifiedName = this.getSupersetDashboardQualifiedName();
        result = result * PRIME + ($supersetDashboardQualifiedName == null ? 43 : $supersetDashboardQualifiedName.hashCode());
        final java.lang.Object $supersetDashboardThumbnailURL = this.getSupersetDashboardThumbnailURL();
        result = result * PRIME + ($supersetDashboardThumbnailURL == null ? 43 : $supersetDashboardThumbnailURL.hashCode());
        final java.lang.Object $supersetDatasets = this.getSupersetDatasets();
        result = result * PRIME + ($supersetDatasets == null ? 43 : $supersetDatasets.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SupersetDashboard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", supersetCharts=" + this.getSupersetCharts() + ", supersetDashboardChangedByName=" + this.getSupersetDashboardChangedByName() + ", supersetDashboardChangedByURL=" + this.getSupersetDashboardChangedByURL() + ", supersetDashboardChartCount=" + this.getSupersetDashboardChartCount() + ", supersetDashboardId=" + this.getSupersetDashboardId() + ", supersetDashboardIsManagedExternally=" + this.getSupersetDashboardIsManagedExternally() + ", supersetDashboardIsPublished=" + this.getSupersetDashboardIsPublished() + ", supersetDashboardQualifiedName=" + this.getSupersetDashboardQualifiedName() + ", supersetDashboardThumbnailURL=" + this.getSupersetDashboardThumbnailURL() + ", supersetDatasets=" + this.getSupersetDatasets() + ")";
    }

    /**
     * Fixed typeName for SupersetDashboards.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
