// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a database table partition in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class TablePartition extends Asset implements ITablePartition, ISQL, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(TablePartition.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TablePartition";
    /**
     * Fixed typeName for TablePartitions.
     */
    String typeName;
    /**
     * Alias for this partition.
     */
    @Attribute
    String alias;
    /**
     * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @Attribute
    String calculationViewName;
    /**
     * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @Attribute
    String calculationViewQualifiedName;
    /**
     * Partitions that exist within this partition.
     */
    @Attribute
    SortedSet<ITablePartition> childTablePartitions;
    /**
     * Number of columns in this partition.
     */
    @Attribute
    Long columnCount;
    /**
     * Columns that exist within this table partition.
     */
    @Attribute
    SortedSet<IColumn> columns;
    /**
     * Constraint that defines this table partition.
     */
    @Attribute
    String constraint;
    /**
     * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @Attribute
    String databaseName;
    /**
     * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @Attribute
    String databaseQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    /**
     * External location of this partition, for example: an S3 object location.
     */
    @Attribute
    String externalLocation;
    /**
     * Format of the external location of this partition, for example: JSON, CSV, PARQUET, etc.
     */
    @Attribute
    String externalLocationFormat;
    /**
     * Region of the external location of this partition, for example: S3 region.
     */
    @Attribute
    String externalLocationRegion;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Whether this partition is further partitioned (true) or not (false).
     */
    @Attribute
    Boolean isPartitioned;
    /**
     * Whether this asset has been profiled (true) or not (false).
     */
    @Attribute
    Boolean isProfiled;
    /**
     * Whether preview queries for this partition are allowed (true) or not (false).
     */
    @Attribute
    Boolean isQueryPreview;
    /**
     * Whether this partition is temporary (true) or not (false).
     */
    @Attribute
    Boolean isTemporary;
    /**
     * Time (epoch) at which this asset was last profiled, in milliseconds.
     */
    @Attribute
    @Date
    Long lastProfiledAt;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Table in which this partition exists.
     */
    @Attribute
    ITable parentTable;
    /**
     * Partition in which this partition exists.
     */
    @Attribute
    ITablePartition parentTablePartition;
    /**
     * Number of sub-partitions of this partition.
     */
    @Attribute
    Long partitionCount;
    /**
     * List of sub-partitions in this partition.
     */
    @Attribute
    String partitionList;
    /**
     * Partition strategy of this partition.
     */
    @Attribute
    String partitionStrategy;
    /**
     * Number of times this asset has been queried.
     */
    @Attribute
    Long queryCount;
    /**
     * Time (epoch) at which the query count was last updated, in milliseconds.
     */
    @Attribute
    @Date
    Long queryCountUpdatedAt;
    /**
     * Configuration for the preview queries.
     */
    @Attribute
    Map<String, String> queryPreviewConfig;
    /**
     * Number of unique users who have queried this asset.
     */
    @Attribute
    Long queryUserCount;
    /**
     * Map of unique users who have queried this asset to the number of times they have queried it.
     */
    @Attribute
    Map<String, Long> queryUserMap;
    /**
     * Number of rows in this partition.
     */
    @Attribute
    Long rowCount;
    /**
     * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @Attribute
    String schemaName;
    /**
     * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @Attribute
    String schemaQualifiedName;
    /**
     * Size of this partition, in bytes.
     */
    @Attribute
    Long sizeBytes;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    /**
     * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @Attribute
    String tableName;
    /**
     * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @Attribute
    String tableQualifiedName;
    /**
     * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @Attribute
    String viewName;
    /**
     * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @Attribute
    String viewQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a TablePartition, from a potentially
     * more-complete TablePartition object.
     *
     * @return the minimal object necessary to relate to the TablePartition
     * @throws InvalidRequestException if any of the minimal set of required properties for a TablePartition relationship are not found in the initial object
     */
    @Override
    public TablePartition trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all TablePartition assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TablePartition assets will be included.
     *
     * @return a fluent search that includes all TablePartition assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all TablePartition assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TablePartition assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all TablePartition assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all TablePartition assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) TablePartitions will be included
     * @return a fluent search that includes all TablePartition assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all TablePartition assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) TablePartitions will be included
     * @return a fluent search that includes all TablePartition assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a TablePartition by GUID. Use this to create a relationship to this TablePartition,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the TablePartition to reference
     * @return reference to a TablePartition that can be used for defining a relationship to a TablePartition
     */
    public static TablePartition refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TablePartition by GUID. Use this to create a relationship to this TablePartition,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the TablePartition to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TablePartition that can be used for defining a relationship to a TablePartition
     */
    public static TablePartition refByGuid(String guid, Reference.SaveSemantic semantic) {
        return TablePartition._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a TablePartition by qualifiedName. Use this to create a relationship to this TablePartition,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the TablePartition to reference
     * @return reference to a TablePartition that can be used for defining a relationship to a TablePartition
     */
    public static TablePartition refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TablePartition by qualifiedName. Use this to create a relationship to this TablePartition,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the TablePartition to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TablePartition that can be used for defining a relationship to a TablePartition
     */
    public static TablePartition refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return TablePartition._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a TablePartition by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the TablePartition to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TablePartition, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TablePartition does not exist or the provided GUID is not a TablePartition
     */
    @JsonIgnore
    public static TablePartition get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a TablePartition by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TablePartition to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TablePartition, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TablePartition does not exist or the provided GUID is not a TablePartition
     */
    @JsonIgnore
    public static TablePartition get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a TablePartition by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TablePartition to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full TablePartition, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TablePartition does not exist or the provided GUID is not a TablePartition
     */
    @JsonIgnore
    public static TablePartition get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof TablePartition) {
                return (TablePartition) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof TablePartition) {
                return (TablePartition) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) TablePartition to active.
     *
     * @param qualifiedName for the TablePartition
     * @return true if the TablePartition is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) TablePartition to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the TablePartition
     * @return true if the TablePartition is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a table partition.
     *
     * @param name of the table partition
     * @param table in which the partition should be created, which must have at least
     *              a qualifiedName
     * @return the minimal request necessary to create the table partition, as a builder
     * @throws InvalidRequestException if the table provided is without a qualifiedName
     */
    public static TablePartitionBuilder<?, ?> creator(String name, Table table) throws InvalidRequestException {
        if (table.getQualifiedName() == null || table.getQualifiedName().isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, "Table", "qualifiedName");
        }
        return creator(name, table.getQualifiedName()).parentTable(table.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a table partition.
     *
     * @param name of the table partition
     * @param tableQualifiedName unique name of the table in which this table partition exists
     * @return the minimal request necessary to create the table partition, as a builder
     */
    public static TablePartitionBuilder<?, ?> creator(String name, String tableQualifiedName) {
        String[] tokens = tableQualifiedName.split("/");
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(tokens);
        String tableName = StringUtils.getNameFromQualifiedName(tableQualifiedName);
        String schemaQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(tableQualifiedName);
        String schemaName = StringUtils.getNameFromQualifiedName(schemaQualifiedName);
        String databaseQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(schemaQualifiedName);
        String databaseName = StringUtils.getNameFromQualifiedName(databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
        return TablePartition._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).name(name).qualifiedName(generateQualifiedName(name, tableQualifiedName)).connectorType(connectorType).tableName(tableName).tableQualifiedName(tableQualifiedName).parentTable(Table.refByQualifiedName(tableQualifiedName)).schemaName(schemaName).schemaQualifiedName(schemaQualifiedName).databaseName(databaseName).databaseQualifiedName(databaseQualifiedName).connectionQualifiedName(connectionQualifiedName);
    }

    /**
     * Generate a unique table partition name.
     *
     * @param name of the table partition
     * @param tableQualifiedName unique name of the table in which this partition exists
     * @return a unique name for the table partition
     */
    public static String generateQualifiedName(String name, String tableQualifiedName) {
        return tableQualifiedName + "/" + name;
    }

    /**
     * Builds the minimal object necessary to update a TablePartition.
     *
     * @param qualifiedName of the TablePartition
     * @param name of the TablePartition
     * @return the minimal request necessary to update the TablePartition, as a builder
     */
    public static TablePartitionBuilder<?, ?> updater(String qualifiedName, String name) {
        return TablePartition._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a TablePartition, from a potentially
     * more-complete TablePartition object.
     *
     * @return the minimal object necessary to update the TablePartition, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for TablePartition are not found in the initial object
     */
    @Override
    public TablePartitionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a TablePartition.
     *
     * @param qualifiedName of the TablePartition
     * @param name of the TablePartition
     * @return the updated TablePartition, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a TablePartition.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TablePartition
     * @param name of the TablePartition
     * @return the updated TablePartition, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TablePartition) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a TablePartition.
     *
     * @param qualifiedName of the TablePartition
     * @param name of the TablePartition
     * @return the updated TablePartition, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a TablePartition.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TablePartition
     * @param name of the TablePartition
     * @return the updated TablePartition, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TablePartition) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a TablePartition.
     *
     * @param qualifiedName of the TablePartition
     * @param name of the TablePartition
     * @return the updated TablePartition, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a TablePartition.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TablePartition's owners
     * @param qualifiedName of the TablePartition
     * @param name of the TablePartition
     * @return the updated TablePartition, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TablePartition) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a TablePartition.
     *
     * @param qualifiedName of the TablePartition
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TablePartition, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a TablePartition.
     *
     * @param client connectivity to the Atlan tenant on which to update the TablePartition's certificate
     * @param qualifiedName of the TablePartition
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TablePartition, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TablePartition) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a TablePartition.
     *
     * @param qualifiedName of the TablePartition
     * @param name of the TablePartition
     * @return the updated TablePartition, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a TablePartition.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TablePartition's certificate
     * @param qualifiedName of the TablePartition
     * @param name of the TablePartition
     * @return the updated TablePartition, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TablePartition) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a TablePartition.
     *
     * @param qualifiedName of the TablePartition
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a TablePartition.
     *
     * @param client connectivity to the Atlan tenant on which to update the TablePartition's announcement
     * @param qualifiedName of the TablePartition
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TablePartition) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a TablePartition.
     *
     * @param qualifiedName of the TablePartition
     * @param name of the TablePartition
     * @return the updated TablePartition, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a TablePartition.
     *
     * @param client connectivity to the Atlan client from which to remove the TablePartition's announcement
     * @param qualifiedName of the TablePartition
     * @param name of the TablePartition
     * @return the updated TablePartition, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TablePartition) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the TablePartition.
     *
     * @param qualifiedName for the TablePartition
     * @param name human-readable name of the TablePartition
     * @param terms the list of terms to replace on the TablePartition, or null to remove all terms from the TablePartition
     * @return the TablePartition that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TablePartition replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the TablePartition.
     *
     * @param client connectivity to the Atlan tenant on which to replace the TablePartition's assigned terms
     * @param qualifiedName for the TablePartition
     * @param name human-readable name of the TablePartition
     * @param terms the list of terms to replace on the TablePartition, or null to remove all terms from the TablePartition
     * @return the TablePartition that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TablePartition replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TablePartition) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the TablePartition, without replacing existing terms linked to the TablePartition.
     * Note: this operation must make two API calls — one to retrieve the TablePartition's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the TablePartition
     * @param terms the list of terms to append to the TablePartition
     * @return the TablePartition that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TablePartition appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the TablePartition, without replacing existing terms linked to the TablePartition.
     * Note: this operation must make two API calls — one to retrieve the TablePartition's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the TablePartition
     * @param qualifiedName for the TablePartition
     * @param terms the list of terms to append to the TablePartition
     * @return the TablePartition that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TablePartition appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TablePartition) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a TablePartition, without replacing all existing terms linked to the TablePartition.
     * Note: this operation must make two API calls — one to retrieve the TablePartition's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the TablePartition
     * @param terms the list of terms to remove from the TablePartition, which must be referenced by GUID
     * @return the TablePartition that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a TablePartition, without replacing all existing terms linked to the TablePartition.
     * Note: this operation must make two API calls — one to retrieve the TablePartition's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the TablePartition
     * @param qualifiedName for the TablePartition
     * @param terms the list of terms to remove from the TablePartition, which must be referenced by GUID
     * @return the TablePartition that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TablePartition removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TablePartition) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a TablePartition, without replacing existing Atlan tags linked to the TablePartition.
     * Note: this operation must make two API calls — one to retrieve the TablePartition's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TablePartition
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TablePartition
     */
    public static TablePartition appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TablePartition, without replacing existing Atlan tags linked to the TablePartition.
     * Note: this operation must make two API calls — one to retrieve the TablePartition's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TablePartition
     * @param qualifiedName of the TablePartition
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TablePartition
     */
    public static TablePartition appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TablePartition) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TablePartition, without replacing existing Atlan tags linked to the TablePartition.
     * Note: this operation must make two API calls — one to retrieve the TablePartition's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TablePartition
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TablePartition
     */
    public static TablePartition appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a TablePartition, without replacing existing Atlan tags linked to the TablePartition.
     * Note: this operation must make two API calls — one to retrieve the TablePartition's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TablePartition
     * @param qualifiedName of the TablePartition
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TablePartition
     */
    public static TablePartition appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TablePartition) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a TablePartition.
     *
     * @param qualifiedName of the TablePartition
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TablePartition
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a TablePartition.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a TablePartition
     * @param qualifiedName of the TablePartition
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TablePartition
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class TablePartitionBuilder<C extends TablePartition, B extends TablePartition.TablePartitionBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String alias;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String calculationViewName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String calculationViewQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ITablePartition> childTablePartitions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long columnCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IColumn> columns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String constraint;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String databaseName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String databaseQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModel> dbtModels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtSource> dbtSources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtTest> dbtTests;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String externalLocation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String externalLocationFormat;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String externalLocationRegion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isPartitioned;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isProfiled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isQueryPreview;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isTemporary;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long lastProfiledAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ITable parentTable;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ITablePartition parentTablePartition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long partitionCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String partitionList;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String partitionStrategy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryCountUpdatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> queryPreviewConfig$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> queryPreviewConfig$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryUserCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> queryUserMap$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Long> queryUserMap$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long rowCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sizeBytes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtSource> sqlDBTSources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModel> sqlDbtModels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String viewName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String viewQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            TablePartition.TablePartitionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final TablePartition instance, final TablePartition.TablePartitionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.alias(instance.alias);
            b.calculationViewName(instance.calculationViewName);
            b.calculationViewQualifiedName(instance.calculationViewQualifiedName);
            b.childTablePartitions(instance.childTablePartitions == null ? java.util.Collections.<ITablePartition>emptySortedSet() : instance.childTablePartitions);
            b.columnCount(instance.columnCount);
            b.columns(instance.columns == null ? java.util.Collections.<IColumn>emptySortedSet() : instance.columns);
            b.constraint(instance.constraint);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtModels(instance.dbtModels == null ? java.util.Collections.<IDbtModel>emptySortedSet() : instance.dbtModels);
            b.dbtSources(instance.dbtSources == null ? java.util.Collections.<IDbtSource>emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? java.util.Collections.<IDbtTest>emptySortedSet() : instance.dbtTests);
            b.externalLocation(instance.externalLocation);
            b.externalLocationFormat(instance.externalLocationFormat);
            b.externalLocationRegion(instance.externalLocationRegion);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.isPartitioned(instance.isPartitioned);
            b.isProfiled(instance.isProfiled);
            b.isQueryPreview(instance.isQueryPreview);
            b.isTemporary(instance.isTemporary);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.parentTable(instance.parentTable);
            b.parentTablePartition(instance.parentTablePartition);
            b.partitionCount(instance.partitionCount);
            b.partitionList(instance.partitionList);
            b.partitionStrategy(instance.partitionStrategy);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryPreviewConfig(instance.queryPreviewConfig == null ? java.util.Collections.<String, String>emptyMap() : instance.queryPreviewConfig);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? java.util.Collections.<String, Long>emptyMap() : instance.queryUserMap);
            b.rowCount(instance.rowCount);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.sizeBytes(instance.sizeBytes);
            b.sqlDBTSources(instance.sqlDBTSources == null ? java.util.Collections.<IDbtSource>emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? java.util.Collections.<IDbtModel>emptySortedSet() : instance.sqlDbtModels);
            b.tableName(instance.tableName);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
        }

        /**
         * Fixed typeName for TablePartitions.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Alias for this partition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B alias(final String alias) {
            this.alias = alias;
            return self();
        }

        /**
         * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationViewName(final String calculationViewName) {
            this.calculationViewName = calculationViewName;
            return self();
        }

        /**
         * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationViewQualifiedName(final String calculationViewQualifiedName) {
            this.calculationViewQualifiedName = calculationViewQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B childTablePartition(final ITablePartition childTablePartition) {
            if (this.childTablePartitions == null) this.childTablePartitions = new java.util.ArrayList<ITablePartition>();
            this.childTablePartitions.add(childTablePartition);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B childTablePartitions(final java.util.Collection<? extends ITablePartition> childTablePartitions) {
            if (childTablePartitions == null) {
                throw new java.lang.NullPointerException("childTablePartitions cannot be null");
            }
            if (this.childTablePartitions == null) this.childTablePartitions = new java.util.ArrayList<ITablePartition>();
            this.childTablePartitions.addAll(childTablePartitions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearChildTablePartitions() {
            if (this.childTablePartitions != null) this.childTablePartitions.clear();
            return self();
        }

        /**
         * Number of columns in this partition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnCount(final Long columnCount) {
            this.columnCount = columnCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B column(final IColumn column) {
            if (this.columns == null) this.columns = new java.util.ArrayList<IColumn>();
            this.columns.add(column);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columns(final java.util.Collection<? extends IColumn> columns) {
            if (columns == null) {
                throw new java.lang.NullPointerException("columns cannot be null");
            }
            if (this.columns == null) this.columns = new java.util.ArrayList<IColumn>();
            this.columns.addAll(columns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumns() {
            if (this.columns != null) this.columns.clear();
            return self();
        }

        /**
         * Constraint that defines this table partition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B constraint(final String constraint) {
            this.constraint = constraint;
            return self();
        }

        /**
         * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B databaseName(final String databaseName) {
            this.databaseName = databaseName;
            return self();
        }

        /**
         * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B databaseQualifiedName(final String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModel(final IDbtModel dbtModel) {
            if (this.dbtModels == null) this.dbtModels = new java.util.ArrayList<IDbtModel>();
            this.dbtModels.add(dbtModel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModels(final java.util.Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new java.lang.NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) this.dbtModels = new java.util.ArrayList<IDbtModel>();
            this.dbtModels.addAll(dbtModels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) this.dbtModels.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSource(final IDbtSource dbtSource) {
            if (this.dbtSources == null) this.dbtSources = new java.util.ArrayList<IDbtSource>();
            this.dbtSources.add(dbtSource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSources(final java.util.Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new java.lang.NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) this.dbtSources = new java.util.ArrayList<IDbtSource>();
            this.dbtSources.addAll(dbtSources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) this.dbtSources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTest(final IDbtTest dbtTest) {
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.add(dbtTest);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTests(final java.util.Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new java.lang.NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.addAll(dbtTests);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) this.dbtTests.clear();
            return self();
        }

        /**
         * External location of this partition, for example: an S3 object location.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B externalLocation(final String externalLocation) {
            this.externalLocation = externalLocation;
            return self();
        }

        /**
         * Format of the external location of this partition, for example: JSON, CSV, PARQUET, etc.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B externalLocationFormat(final String externalLocationFormat) {
            this.externalLocationFormat = externalLocationFormat;
            return self();
        }

        /**
         * Region of the external location of this partition, for example: S3 region.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B externalLocationRegion(final String externalLocationRegion) {
            this.externalLocationRegion = externalLocationRegion;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Whether this partition is further partitioned (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isPartitioned(final Boolean isPartitioned) {
            this.isPartitioned = isPartitioned;
            return self();
        }

        /**
         * Whether this asset has been profiled (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isProfiled(final Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return self();
        }

        /**
         * Whether preview queries for this partition are allowed (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isQueryPreview(final Boolean isQueryPreview) {
            this.isQueryPreview = isQueryPreview;
            return self();
        }

        /**
         * Whether this partition is temporary (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isTemporary(final Boolean isTemporary) {
            this.isTemporary = isTemporary;
            return self();
        }

        /**
         * Time (epoch) at which this asset was last profiled, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lastProfiledAt(final Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Table in which this partition exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parentTable(final ITable parentTable) {
            this.parentTable = parentTable;
            return self();
        }

        /**
         * Partition in which this partition exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parentTablePartition(final ITablePartition parentTablePartition) {
            this.parentTablePartition = parentTablePartition;
            return self();
        }

        /**
         * Number of sub-partitions of this partition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B partitionCount(final Long partitionCount) {
            this.partitionCount = partitionCount;
            return self();
        }

        /**
         * List of sub-partitions in this partition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B partitionList(final String partitionList) {
            this.partitionList = partitionList;
            return self();
        }

        /**
         * Partition strategy of this partition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B partitionStrategy(final String partitionStrategy) {
            this.partitionStrategy = partitionStrategy;
            return self();
        }

        /**
         * Number of times this asset has been queried.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryCount(final Long queryCount) {
            this.queryCount = queryCount;
            return self();
        }

        /**
         * Time (epoch) at which the query count was last updated, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryCountUpdatedAt(final Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putQueryPreviewConfig(final String putQueryPreviewConfigKey, final String putQueryPreviewConfigValue) {
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new java.util.ArrayList<String>();
                this.queryPreviewConfig$value = new java.util.ArrayList<String>();
            }
            this.queryPreviewConfig$key.add(putQueryPreviewConfigKey);
            this.queryPreviewConfig$value.add(putQueryPreviewConfigValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryPreviewConfig(final java.util.Map<? extends String, ? extends String> queryPreviewConfig) {
            if (queryPreviewConfig == null) {
                throw new java.lang.NullPointerException("queryPreviewConfig cannot be null");
            }
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new java.util.ArrayList<String>();
                this.queryPreviewConfig$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : queryPreviewConfig.entrySet()) {
                this.queryPreviewConfig$key.add($lombokEntry.getKey());
                this.queryPreviewConfig$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQueryPreviewConfig() {
            if (this.queryPreviewConfig$key != null) {
                this.queryPreviewConfig$key.clear();
                this.queryPreviewConfig$value.clear();
            }
            return self();
        }

        /**
         * Number of unique users who have queried this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryUserCount(final Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putQueryUserMap(final String putQueryUserMapKey, final Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new java.util.ArrayList<String>();
                this.queryUserMap$value = new java.util.ArrayList<Long>();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryUserMap(final java.util.Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new java.lang.NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new java.util.ArrayList<String>();
                this.queryUserMap$value = new java.util.ArrayList<Long>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return self();
        }

        /**
         * Number of rows in this partition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B rowCount(final Long rowCount) {
            this.rowCount = rowCount;
            return self();
        }

        /**
         * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaName(final String schemaName) {
            this.schemaName = schemaName;
            return self();
        }

        /**
         * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaQualifiedName(final String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return self();
        }

        /**
         * Size of this partition, in bytes.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sizeBytes(final Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDBTSource(final IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) this.sqlDBTSources = new java.util.ArrayList<IDbtSource>();
            this.sqlDBTSources.add(sqlDBTSource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDBTSources(final java.util.Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new java.lang.NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) this.sqlDBTSources = new java.util.ArrayList<IDbtSource>();
            this.sqlDBTSources.addAll(sqlDBTSources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) this.sqlDBTSources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDbtModel(final IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) this.sqlDbtModels = new java.util.ArrayList<IDbtModel>();
            this.sqlDbtModels.add(sqlDbtModel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDbtModels(final java.util.Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new java.lang.NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) this.sqlDbtModels = new java.util.ArrayList<IDbtModel>();
            this.sqlDbtModels.addAll(sqlDbtModels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) this.sqlDbtModels.clear();
            return self();
        }

        /**
         * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableName(final String tableName) {
            this.tableName = tableName;
            return self();
        }

        /**
         * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableQualifiedName(final String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return self();
        }

        /**
         * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewName(final String viewName) {
            this.viewName = viewName;
            return self();
        }

        /**
         * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewQualifiedName(final String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TablePartition.TablePartitionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", alias=" + this.alias + ", calculationViewName=" + this.calculationViewName + ", calculationViewQualifiedName=" + this.calculationViewQualifiedName + ", childTablePartitions=" + this.childTablePartitions + ", columnCount=" + this.columnCount + ", columns=" + this.columns + ", constraint=" + this.constraint + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtModels=" + this.dbtModels + ", dbtSources=" + this.dbtSources + ", dbtTests=" + this.dbtTests + ", externalLocation=" + this.externalLocation + ", externalLocationFormat=" + this.externalLocationFormat + ", externalLocationRegion=" + this.externalLocationRegion + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isPartitioned=" + this.isPartitioned + ", isProfiled=" + this.isProfiled + ", isQueryPreview=" + this.isQueryPreview + ", isTemporary=" + this.isTemporary + ", lastProfiledAt=" + this.lastProfiledAt + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", parentTable=" + this.parentTable + ", parentTablePartition=" + this.parentTablePartition + ", partitionCount=" + this.partitionCount + ", partitionList=" + this.partitionList + ", partitionStrategy=" + this.partitionStrategy + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryPreviewConfig$key=" + this.queryPreviewConfig$key + ", queryPreviewConfig$value=" + this.queryPreviewConfig$value + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + this.queryUserMap$key + ", queryUserMap$value=" + this.queryUserMap$value + ", rowCount=" + this.rowCount + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", sizeBytes=" + this.sizeBytes + ", sqlDBTSources=" + this.sqlDBTSources + ", sqlDbtModels=" + this.sqlDbtModels + ", tableName=" + this.tableName + ", tableQualifiedName=" + this.tableQualifiedName + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class TablePartitionBuilderImpl extends TablePartition.TablePartitionBuilder<TablePartition, TablePartition.TablePartitionBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TablePartitionBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected TablePartition.TablePartitionBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TablePartition build() {
            return new TablePartition(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected TablePartition(final TablePartition.TablePartitionBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = TablePartition.$default$typeName();
        this.alias = b.alias;
        this.calculationViewName = b.calculationViewName;
        this.calculationViewQualifiedName = b.calculationViewQualifiedName;
        java.util.SortedSet<ITablePartition> childTablePartitions = new java.util.TreeSet<ITablePartition>();
        if (b.childTablePartitions != null) childTablePartitions.addAll(b.childTablePartitions);
        childTablePartitions = java.util.Collections.unmodifiableSortedSet(childTablePartitions);
        this.childTablePartitions = childTablePartitions;
        this.columnCount = b.columnCount;
        java.util.SortedSet<IColumn> columns = new java.util.TreeSet<IColumn>();
        if (b.columns != null) columns.addAll(b.columns);
        columns = java.util.Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        this.constraint = b.constraint;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        java.util.SortedSet<IDbtModel> dbtModels = new java.util.TreeSet<IDbtModel>();
        if (b.dbtModels != null) dbtModels.addAll(b.dbtModels);
        dbtModels = java.util.Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        java.util.SortedSet<IDbtSource> dbtSources = new java.util.TreeSet<IDbtSource>();
        if (b.dbtSources != null) dbtSources.addAll(b.dbtSources);
        dbtSources = java.util.Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        java.util.SortedSet<IDbtTest> dbtTests = new java.util.TreeSet<IDbtTest>();
        if (b.dbtTests != null) dbtTests.addAll(b.dbtTests);
        dbtTests = java.util.Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        this.externalLocation = b.externalLocation;
        this.externalLocationFormat = b.externalLocationFormat;
        this.externalLocationRegion = b.externalLocationRegion;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isPartitioned = b.isPartitioned;
        this.isProfiled = b.isProfiled;
        this.isQueryPreview = b.isQueryPreview;
        this.isTemporary = b.isTemporary;
        this.lastProfiledAt = b.lastProfiledAt;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.parentTable = b.parentTable;
        this.parentTablePartition = b.parentTablePartition;
        this.partitionCount = b.partitionCount;
        this.partitionList = b.partitionList;
        this.partitionStrategy = b.partitionStrategy;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        java.util.Map<String, String> queryPreviewConfig;
        switch (b.queryPreviewConfig$key == null ? 0 : b.queryPreviewConfig$key.size()) {
        case 0: 
            queryPreviewConfig = java.util.Collections.emptyMap();
            break;
        case 1: 
            queryPreviewConfig = java.util.Collections.singletonMap(b.queryPreviewConfig$key.get(0), b.queryPreviewConfig$value.get(0));
            break;
        default: 
            queryPreviewConfig = new java.util.LinkedHashMap<String, String>(b.queryPreviewConfig$key.size() < 1073741824 ? 1 + b.queryPreviewConfig$key.size() + (b.queryPreviewConfig$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.queryPreviewConfig$key.size(); $i++) queryPreviewConfig.put(b.queryPreviewConfig$key.get($i), (String) b.queryPreviewConfig$value.get($i));
            queryPreviewConfig = java.util.Collections.unmodifiableMap(queryPreviewConfig);
        }
        this.queryPreviewConfig = queryPreviewConfig;
        this.queryUserCount = b.queryUserCount;
        java.util.Map<String, Long> queryUserMap;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
        case 0: 
            queryUserMap = java.util.Collections.emptyMap();
            break;
        case 1: 
            queryUserMap = java.util.Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
            break;
        default: 
            queryUserMap = new java.util.LinkedHashMap<String, Long>(b.queryUserMap$key.size() < 1073741824 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.queryUserMap$key.size(); $i++) queryUserMap.put(b.queryUserMap$key.get($i), (Long) b.queryUserMap$value.get($i));
            queryUserMap = java.util.Collections.unmodifiableMap(queryUserMap);
        }
        this.queryUserMap = queryUserMap;
        this.rowCount = b.rowCount;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        this.sizeBytes = b.sizeBytes;
        java.util.SortedSet<IDbtSource> sqlDBTSources = new java.util.TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) sqlDBTSources.addAll(b.sqlDBTSources);
        sqlDBTSources = java.util.Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        java.util.SortedSet<IDbtModel> sqlDbtModels = new java.util.TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) sqlDbtModels.addAll(b.sqlDbtModels);
        sqlDbtModels = java.util.Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.tableName = b.tableName;
        this.tableQualifiedName = b.tableQualifiedName;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static TablePartition.TablePartitionBuilder<?, ?> _internal() {
        return new TablePartition.TablePartitionBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TablePartition.TablePartitionBuilder<?, ?> toBuilder() {
        return new TablePartition.TablePartitionBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Alias for this partition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAlias() {
        return this.alias;
    }

    /**
     * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCalculationViewName() {
        return this.calculationViewName;
    }

    /**
     * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCalculationViewQualifiedName() {
        return this.calculationViewQualifiedName;
    }

    /**
     * Partitions that exist within this partition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ITablePartition> getChildTablePartitions() {
        return this.childTablePartitions;
    }

    /**
     * Number of columns in this partition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getColumnCount() {
        return this.columnCount;
    }

    /**
     * Columns that exist within this table partition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IColumn> getColumns() {
        return this.columns;
    }

    /**
     * Constraint that defines this table partition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getConstraint() {
        return this.constraint;
    }

    /**
     * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    /**
     * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    /**
     * External location of this partition, for example: an S3 object location.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getExternalLocation() {
        return this.externalLocation;
    }

    /**
     * Format of the external location of this partition, for example: JSON, CSV, PARQUET, etc.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getExternalLocationFormat() {
        return this.externalLocationFormat;
    }

    /**
     * Region of the external location of this partition, for example: S3 region.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getExternalLocationRegion() {
        return this.externalLocationRegion;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Whether this partition is further partitioned (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    /**
     * Whether this asset has been profiled (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    /**
     * Whether preview queries for this partition are allowed (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsQueryPreview() {
        return this.isQueryPreview;
    }

    /**
     * Whether this partition is temporary (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsTemporary() {
        return this.isTemporary;
    }

    /**
     * Time (epoch) at which this asset was last profiled, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Table in which this partition exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ITable getParentTable() {
        return this.parentTable;
    }

    /**
     * Partition in which this partition exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ITablePartition getParentTablePartition() {
        return this.parentTablePartition;
    }

    /**
     * Number of sub-partitions of this partition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPartitionCount() {
        return this.partitionCount;
    }

    /**
     * List of sub-partitions in this partition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPartitionList() {
        return this.partitionList;
    }

    /**
     * Partition strategy of this partition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    /**
     * Number of times this asset has been queried.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    /**
     * Time (epoch) at which the query count was last updated, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    /**
     * Configuration for the preview queries.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getQueryPreviewConfig() {
        return this.queryPreviewConfig;
    }

    /**
     * Number of unique users who have queried this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    /**
     * Map of unique users who have queried this asset to the number of times they have queried it.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    /**
     * Number of rows in this partition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getRowCount() {
        return this.rowCount;
    }

    /**
     * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    /**
     * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    /**
     * Size of this partition, in bytes.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    /**
     * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableName() {
        return this.tableName;
    }

    /**
     * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    /**
     * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getViewName() {
        return this.viewName;
    }

    /**
     * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TablePartition)) return false;
        final TablePartition other = (TablePartition) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$columnCount = this.getColumnCount();
        final java.lang.Object other$columnCount = other.getColumnCount();
        if (this$columnCount == null ? other$columnCount != null : !this$columnCount.equals(other$columnCount)) return false;
        final java.lang.Object this$isPartitioned = this.getIsPartitioned();
        final java.lang.Object other$isPartitioned = other.getIsPartitioned();
        if (this$isPartitioned == null ? other$isPartitioned != null : !this$isPartitioned.equals(other$isPartitioned)) return false;
        final java.lang.Object this$isProfiled = this.getIsProfiled();
        final java.lang.Object other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !this$isProfiled.equals(other$isProfiled)) return false;
        final java.lang.Object this$isQueryPreview = this.getIsQueryPreview();
        final java.lang.Object other$isQueryPreview = other.getIsQueryPreview();
        if (this$isQueryPreview == null ? other$isQueryPreview != null : !this$isQueryPreview.equals(other$isQueryPreview)) return false;
        final java.lang.Object this$isTemporary = this.getIsTemporary();
        final java.lang.Object other$isTemporary = other.getIsTemporary();
        if (this$isTemporary == null ? other$isTemporary != null : !this$isTemporary.equals(other$isTemporary)) return false;
        final java.lang.Object this$lastProfiledAt = this.getLastProfiledAt();
        final java.lang.Object other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !this$lastProfiledAt.equals(other$lastProfiledAt)) return false;
        final java.lang.Object this$partitionCount = this.getPartitionCount();
        final java.lang.Object other$partitionCount = other.getPartitionCount();
        if (this$partitionCount == null ? other$partitionCount != null : !this$partitionCount.equals(other$partitionCount)) return false;
        final java.lang.Object this$queryCount = this.getQueryCount();
        final java.lang.Object other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !this$queryCount.equals(other$queryCount)) return false;
        final java.lang.Object this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        final java.lang.Object other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !this$queryCountUpdatedAt.equals(other$queryCountUpdatedAt)) return false;
        final java.lang.Object this$queryUserCount = this.getQueryUserCount();
        final java.lang.Object other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !this$queryUserCount.equals(other$queryUserCount)) return false;
        final java.lang.Object this$rowCount = this.getRowCount();
        final java.lang.Object other$rowCount = other.getRowCount();
        if (this$rowCount == null ? other$rowCount != null : !this$rowCount.equals(other$rowCount)) return false;
        final java.lang.Object this$sizeBytes = this.getSizeBytes();
        final java.lang.Object other$sizeBytes = other.getSizeBytes();
        if (this$sizeBytes == null ? other$sizeBytes != null : !this$sizeBytes.equals(other$sizeBytes)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$alias = this.getAlias();
        final java.lang.Object other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) return false;
        final java.lang.Object this$calculationViewName = this.getCalculationViewName();
        final java.lang.Object other$calculationViewName = other.getCalculationViewName();
        if (this$calculationViewName == null ? other$calculationViewName != null : !this$calculationViewName.equals(other$calculationViewName)) return false;
        final java.lang.Object this$calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        final java.lang.Object other$calculationViewQualifiedName = other.getCalculationViewQualifiedName();
        if (this$calculationViewQualifiedName == null ? other$calculationViewQualifiedName != null : !this$calculationViewQualifiedName.equals(other$calculationViewQualifiedName)) return false;
        final java.lang.Object this$childTablePartitions = this.getChildTablePartitions();
        final java.lang.Object other$childTablePartitions = other.getChildTablePartitions();
        if (this$childTablePartitions == null ? other$childTablePartitions != null : !this$childTablePartitions.equals(other$childTablePartitions)) return false;
        final java.lang.Object this$columns = this.getColumns();
        final java.lang.Object other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) return false;
        final java.lang.Object this$constraint = this.getConstraint();
        final java.lang.Object other$constraint = other.getConstraint();
        if (this$constraint == null ? other$constraint != null : !this$constraint.equals(other$constraint)) return false;
        final java.lang.Object this$databaseName = this.getDatabaseName();
        final java.lang.Object other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) return false;
        final java.lang.Object this$databaseQualifiedName = this.getDatabaseQualifiedName();
        final java.lang.Object other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) return false;
        final java.lang.Object this$dbtModels = this.getDbtModels();
        final java.lang.Object other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) return false;
        final java.lang.Object this$dbtSources = this.getDbtSources();
        final java.lang.Object other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) return false;
        final java.lang.Object this$dbtTests = this.getDbtTests();
        final java.lang.Object other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) return false;
        final java.lang.Object this$externalLocation = this.getExternalLocation();
        final java.lang.Object other$externalLocation = other.getExternalLocation();
        if (this$externalLocation == null ? other$externalLocation != null : !this$externalLocation.equals(other$externalLocation)) return false;
        final java.lang.Object this$externalLocationFormat = this.getExternalLocationFormat();
        final java.lang.Object other$externalLocationFormat = other.getExternalLocationFormat();
        if (this$externalLocationFormat == null ? other$externalLocationFormat != null : !this$externalLocationFormat.equals(other$externalLocationFormat)) return false;
        final java.lang.Object this$externalLocationRegion = this.getExternalLocationRegion();
        final java.lang.Object other$externalLocationRegion = other.getExternalLocationRegion();
        if (this$externalLocationRegion == null ? other$externalLocationRegion != null : !this$externalLocationRegion.equals(other$externalLocationRegion)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$parentTable = this.getParentTable();
        final java.lang.Object other$parentTable = other.getParentTable();
        if (this$parentTable == null ? other$parentTable != null : !this$parentTable.equals(other$parentTable)) return false;
        final java.lang.Object this$parentTablePartition = this.getParentTablePartition();
        final java.lang.Object other$parentTablePartition = other.getParentTablePartition();
        if (this$parentTablePartition == null ? other$parentTablePartition != null : !this$parentTablePartition.equals(other$parentTablePartition)) return false;
        final java.lang.Object this$partitionList = this.getPartitionList();
        final java.lang.Object other$partitionList = other.getPartitionList();
        if (this$partitionList == null ? other$partitionList != null : !this$partitionList.equals(other$partitionList)) return false;
        final java.lang.Object this$partitionStrategy = this.getPartitionStrategy();
        final java.lang.Object other$partitionStrategy = other.getPartitionStrategy();
        if (this$partitionStrategy == null ? other$partitionStrategy != null : !this$partitionStrategy.equals(other$partitionStrategy)) return false;
        final java.lang.Object this$queryPreviewConfig = this.getQueryPreviewConfig();
        final java.lang.Object other$queryPreviewConfig = other.getQueryPreviewConfig();
        if (this$queryPreviewConfig == null ? other$queryPreviewConfig != null : !this$queryPreviewConfig.equals(other$queryPreviewConfig)) return false;
        final java.lang.Object this$queryUserMap = this.getQueryUserMap();
        final java.lang.Object other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !this$queryUserMap.equals(other$queryUserMap)) return false;
        final java.lang.Object this$schemaName = this.getSchemaName();
        final java.lang.Object other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) return false;
        final java.lang.Object this$schemaQualifiedName = this.getSchemaQualifiedName();
        final java.lang.Object other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) return false;
        final java.lang.Object this$sqlDBTSources = this.getSqlDBTSources();
        final java.lang.Object other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) return false;
        final java.lang.Object this$sqlDbtModels = this.getSqlDbtModels();
        final java.lang.Object other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) return false;
        final java.lang.Object this$tableName = this.getTableName();
        final java.lang.Object other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) return false;
        final java.lang.Object this$tableQualifiedName = this.getTableQualifiedName();
        final java.lang.Object other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) return false;
        final java.lang.Object this$viewName = this.getViewName();
        final java.lang.Object other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) return false;
        final java.lang.Object this$viewQualifiedName = this.getViewQualifiedName();
        final java.lang.Object other$viewQualifiedName = other.getViewQualifiedName();
        if (this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TablePartition;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $columnCount = this.getColumnCount();
        result = result * PRIME + ($columnCount == null ? 43 : $columnCount.hashCode());
        final java.lang.Object $isPartitioned = this.getIsPartitioned();
        result = result * PRIME + ($isPartitioned == null ? 43 : $isPartitioned.hashCode());
        final java.lang.Object $isProfiled = this.getIsProfiled();
        result = result * PRIME + ($isProfiled == null ? 43 : $isProfiled.hashCode());
        final java.lang.Object $isQueryPreview = this.getIsQueryPreview();
        result = result * PRIME + ($isQueryPreview == null ? 43 : $isQueryPreview.hashCode());
        final java.lang.Object $isTemporary = this.getIsTemporary();
        result = result * PRIME + ($isTemporary == null ? 43 : $isTemporary.hashCode());
        final java.lang.Object $lastProfiledAt = this.getLastProfiledAt();
        result = result * PRIME + ($lastProfiledAt == null ? 43 : $lastProfiledAt.hashCode());
        final java.lang.Object $partitionCount = this.getPartitionCount();
        result = result * PRIME + ($partitionCount == null ? 43 : $partitionCount.hashCode());
        final java.lang.Object $queryCount = this.getQueryCount();
        result = result * PRIME + ($queryCount == null ? 43 : $queryCount.hashCode());
        final java.lang.Object $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * PRIME + ($queryCountUpdatedAt == null ? 43 : $queryCountUpdatedAt.hashCode());
        final java.lang.Object $queryUserCount = this.getQueryUserCount();
        result = result * PRIME + ($queryUserCount == null ? 43 : $queryUserCount.hashCode());
        final java.lang.Object $rowCount = this.getRowCount();
        result = result * PRIME + ($rowCount == null ? 43 : $rowCount.hashCode());
        final java.lang.Object $sizeBytes = this.getSizeBytes();
        result = result * PRIME + ($sizeBytes == null ? 43 : $sizeBytes.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $alias = this.getAlias();
        result = result * PRIME + ($alias == null ? 43 : $alias.hashCode());
        final java.lang.Object $calculationViewName = this.getCalculationViewName();
        result = result * PRIME + ($calculationViewName == null ? 43 : $calculationViewName.hashCode());
        final java.lang.Object $calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        result = result * PRIME + ($calculationViewQualifiedName == null ? 43 : $calculationViewQualifiedName.hashCode());
        final java.lang.Object $childTablePartitions = this.getChildTablePartitions();
        result = result * PRIME + ($childTablePartitions == null ? 43 : $childTablePartitions.hashCode());
        final java.lang.Object $columns = this.getColumns();
        result = result * PRIME + ($columns == null ? 43 : $columns.hashCode());
        final java.lang.Object $constraint = this.getConstraint();
        result = result * PRIME + ($constraint == null ? 43 : $constraint.hashCode());
        final java.lang.Object $databaseName = this.getDatabaseName();
        result = result * PRIME + ($databaseName == null ? 43 : $databaseName.hashCode());
        final java.lang.Object $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * PRIME + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        final java.lang.Object $dbtModels = this.getDbtModels();
        result = result * PRIME + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        final java.lang.Object $dbtSources = this.getDbtSources();
        result = result * PRIME + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        final java.lang.Object $dbtTests = this.getDbtTests();
        result = result * PRIME + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        final java.lang.Object $externalLocation = this.getExternalLocation();
        result = result * PRIME + ($externalLocation == null ? 43 : $externalLocation.hashCode());
        final java.lang.Object $externalLocationFormat = this.getExternalLocationFormat();
        result = result * PRIME + ($externalLocationFormat == null ? 43 : $externalLocationFormat.hashCode());
        final java.lang.Object $externalLocationRegion = this.getExternalLocationRegion();
        result = result * PRIME + ($externalLocationRegion == null ? 43 : $externalLocationRegion.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $parentTable = this.getParentTable();
        result = result * PRIME + ($parentTable == null ? 43 : $parentTable.hashCode());
        final java.lang.Object $parentTablePartition = this.getParentTablePartition();
        result = result * PRIME + ($parentTablePartition == null ? 43 : $parentTablePartition.hashCode());
        final java.lang.Object $partitionList = this.getPartitionList();
        result = result * PRIME + ($partitionList == null ? 43 : $partitionList.hashCode());
        final java.lang.Object $partitionStrategy = this.getPartitionStrategy();
        result = result * PRIME + ($partitionStrategy == null ? 43 : $partitionStrategy.hashCode());
        final java.lang.Object $queryPreviewConfig = this.getQueryPreviewConfig();
        result = result * PRIME + ($queryPreviewConfig == null ? 43 : $queryPreviewConfig.hashCode());
        final java.lang.Object $queryUserMap = this.getQueryUserMap();
        result = result * PRIME + ($queryUserMap == null ? 43 : $queryUserMap.hashCode());
        final java.lang.Object $schemaName = this.getSchemaName();
        result = result * PRIME + ($schemaName == null ? 43 : $schemaName.hashCode());
        final java.lang.Object $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * PRIME + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        final java.lang.Object $sqlDBTSources = this.getSqlDBTSources();
        result = result * PRIME + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        final java.lang.Object $sqlDbtModels = this.getSqlDbtModels();
        result = result * PRIME + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        final java.lang.Object $tableName = this.getTableName();
        result = result * PRIME + ($tableName == null ? 43 : $tableName.hashCode());
        final java.lang.Object $tableQualifiedName = this.getTableQualifiedName();
        result = result * PRIME + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        final java.lang.Object $viewName = this.getViewName();
        result = result * PRIME + ($viewName == null ? 43 : $viewName.hashCode());
        final java.lang.Object $viewQualifiedName = this.getViewQualifiedName();
        result = result * PRIME + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TablePartition(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", alias=" + this.getAlias() + ", calculationViewName=" + this.getCalculationViewName() + ", calculationViewQualifiedName=" + this.getCalculationViewQualifiedName() + ", childTablePartitions=" + this.getChildTablePartitions() + ", columnCount=" + this.getColumnCount() + ", columns=" + this.getColumns() + ", constraint=" + this.getConstraint() + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtModels=" + this.getDbtModels() + ", dbtSources=" + this.getDbtSources() + ", dbtTests=" + this.getDbtTests() + ", externalLocation=" + this.getExternalLocation() + ", externalLocationFormat=" + this.getExternalLocationFormat() + ", externalLocationRegion=" + this.getExternalLocationRegion() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isPartitioned=" + this.getIsPartitioned() + ", isProfiled=" + this.getIsProfiled() + ", isQueryPreview=" + this.getIsQueryPreview() + ", isTemporary=" + this.getIsTemporary() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", parentTable=" + this.getParentTable() + ", parentTablePartition=" + this.getParentTablePartition() + ", partitionCount=" + this.getPartitionCount() + ", partitionList=" + this.getPartitionList() + ", partitionStrategy=" + this.getPartitionStrategy() + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryPreviewConfig=" + this.getQueryPreviewConfig() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + this.getQueryUserMap() + ", rowCount=" + this.getRowCount() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", sizeBytes=" + this.getSizeBytes() + ", sqlDBTSources=" + this.getSqlDBTSources() + ", sqlDbtModels=" + this.getSqlDbtModels() + ", tableName=" + this.getTableName() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ")";
    }

    /**
     * Fixed typeName for TablePartitions.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
