// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Tableau calculated field in Atlan. These are created by combining two or more fields using a formula, and can be created at datasource or worksheet level.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class TableauCalculatedField extends Asset implements ITableauField, ITableauCalculatedField, ITableau, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(TableauCalculatedField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauCalculatedField";
    /**
     * Fixed typeName for TableauCalculatedFields.
     */
    String typeName;
    /**
     * Data category of this field.
     */
    @Attribute
    String dataCategory;
    /**
     * Datasource in which this calculated field exists.
     */
    @Attribute
    ITableauDatasource datasource;
    /**
     * Unique name of the datasource in which this calculated field exists.
     */
    @Attribute
    String datasourceQualifiedName;
    /**
     * Formula for this calculated field.
     */
    @Attribute
    String formula;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * List of top-level projects and their nested projects.
     */
    @Attribute
    List<Map<String, String>> projectHierarchy;
    /**
     * Unique name of the project in which this calculated field exists.
     */
    @Attribute
    String projectQualifiedName;
    /**
     * Role of this field, for example: 'dimension', 'measure', or 'unknown'.
     */
    @Attribute
    String role;
    /**
     * Unique name of the site in which this calculated field exists.
     */
    @Attribute
    String siteQualifiedName;
    /**
     * Data type of the field, from Tableau.
     */
    @Attribute
    String tableauDataType;
    /**
     * Unique name of the top-level project in which this calculated field exists.
     */
    @Attribute
    String topLevelProjectQualifiedName;
    /**
     * List of fields that are upstream to this calculated field.
     */
    @Attribute
    List<Map<String, String>> upstreamFields;
    /**
     * Unique name of the workbook in which this calculated field exists.
     */
    @Attribute
    String workbookQualifiedName;
    /**
     * Worksheets that use this calculated field.
     */
    @Attribute
    SortedSet<ITableauWorksheet> worksheets;

    /**
     * Builds the minimal object necessary to create a relationship to a TableauCalculatedField, from a potentially
     * more-complete TableauCalculatedField object.
     *
     * @return the minimal object necessary to relate to the TableauCalculatedField
     * @throws InvalidRequestException if any of the minimal set of required properties for a TableauCalculatedField relationship are not found in the initial object
     */
    @Override
    public TableauCalculatedField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all TableauCalculatedField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TableauCalculatedField assets will be included.
     *
     * @return a fluent search that includes all TableauCalculatedField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all TableauCalculatedField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TableauCalculatedField assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all TableauCalculatedField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all TableauCalculatedField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) TableauCalculatedFields will be included
     * @return a fluent search that includes all TableauCalculatedField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all TableauCalculatedField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) TableauCalculatedFields will be included
     * @return a fluent search that includes all TableauCalculatedField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a TableauCalculatedField by GUID. Use this to create a relationship to this TableauCalculatedField,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the TableauCalculatedField to reference
     * @return reference to a TableauCalculatedField that can be used for defining a relationship to a TableauCalculatedField
     */
    public static TableauCalculatedField refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TableauCalculatedField by GUID. Use this to create a relationship to this TableauCalculatedField,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the TableauCalculatedField to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TableauCalculatedField that can be used for defining a relationship to a TableauCalculatedField
     */
    public static TableauCalculatedField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return TableauCalculatedField._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a TableauCalculatedField by qualifiedName. Use this to create a relationship to this TableauCalculatedField,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the TableauCalculatedField to reference
     * @return reference to a TableauCalculatedField that can be used for defining a relationship to a TableauCalculatedField
     */
    public static TableauCalculatedField refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TableauCalculatedField by qualifiedName. Use this to create a relationship to this TableauCalculatedField,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the TableauCalculatedField to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TableauCalculatedField that can be used for defining a relationship to a TableauCalculatedField
     */
    public static TableauCalculatedField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return TableauCalculatedField._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a TableauCalculatedField by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the TableauCalculatedField to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TableauCalculatedField, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauCalculatedField does not exist or the provided GUID is not a TableauCalculatedField
     */
    @JsonIgnore
    public static TableauCalculatedField get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a TableauCalculatedField by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TableauCalculatedField to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TableauCalculatedField, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauCalculatedField does not exist or the provided GUID is not a TableauCalculatedField
     */
    @JsonIgnore
    public static TableauCalculatedField get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a TableauCalculatedField by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TableauCalculatedField to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full TableauCalculatedField, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauCalculatedField does not exist or the provided GUID is not a TableauCalculatedField
     */
    @JsonIgnore
    public static TableauCalculatedField get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof TableauCalculatedField) {
                return (TableauCalculatedField) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof TableauCalculatedField) {
                return (TableauCalculatedField) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) TableauCalculatedField to active.
     *
     * @param qualifiedName for the TableauCalculatedField
     * @return true if the TableauCalculatedField is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) TableauCalculatedField to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the TableauCalculatedField
     * @return true if the TableauCalculatedField is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a TableauCalculatedField.
     *
     * @param qualifiedName of the TableauCalculatedField
     * @param name of the TableauCalculatedField
     * @return the minimal request necessary to update the TableauCalculatedField, as a builder
     */
    public static TableauCalculatedFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return TableauCalculatedField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a TableauCalculatedField, from a potentially
     * more-complete TableauCalculatedField object.
     *
     * @return the minimal object necessary to update the TableauCalculatedField, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for TableauCalculatedField are not found in the initial object
     */
    @Override
    public TableauCalculatedFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a TableauCalculatedField.
     *
     * @param qualifiedName of the TableauCalculatedField
     * @param name of the TableauCalculatedField
     * @return the updated TableauCalculatedField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a TableauCalculatedField.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TableauCalculatedField
     * @param name of the TableauCalculatedField
     * @return the updated TableauCalculatedField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauCalculatedField) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a TableauCalculatedField.
     *
     * @param qualifiedName of the TableauCalculatedField
     * @param name of the TableauCalculatedField
     * @return the updated TableauCalculatedField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a TableauCalculatedField.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TableauCalculatedField
     * @param name of the TableauCalculatedField
     * @return the updated TableauCalculatedField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauCalculatedField) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a TableauCalculatedField.
     *
     * @param qualifiedName of the TableauCalculatedField
     * @param name of the TableauCalculatedField
     * @return the updated TableauCalculatedField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a TableauCalculatedField.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TableauCalculatedField's owners
     * @param qualifiedName of the TableauCalculatedField
     * @param name of the TableauCalculatedField
     * @return the updated TableauCalculatedField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauCalculatedField) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a TableauCalculatedField.
     *
     * @param qualifiedName of the TableauCalculatedField
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TableauCalculatedField, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a TableauCalculatedField.
     *
     * @param client connectivity to the Atlan tenant on which to update the TableauCalculatedField's certificate
     * @param qualifiedName of the TableauCalculatedField
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TableauCalculatedField, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TableauCalculatedField) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a TableauCalculatedField.
     *
     * @param qualifiedName of the TableauCalculatedField
     * @param name of the TableauCalculatedField
     * @return the updated TableauCalculatedField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a TableauCalculatedField.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TableauCalculatedField's certificate
     * @param qualifiedName of the TableauCalculatedField
     * @param name of the TableauCalculatedField
     * @return the updated TableauCalculatedField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauCalculatedField) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a TableauCalculatedField.
     *
     * @param qualifiedName of the TableauCalculatedField
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a TableauCalculatedField.
     *
     * @param client connectivity to the Atlan tenant on which to update the TableauCalculatedField's announcement
     * @param qualifiedName of the TableauCalculatedField
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauCalculatedField) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a TableauCalculatedField.
     *
     * @param qualifiedName of the TableauCalculatedField
     * @param name of the TableauCalculatedField
     * @return the updated TableauCalculatedField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a TableauCalculatedField.
     *
     * @param client connectivity to the Atlan client from which to remove the TableauCalculatedField's announcement
     * @param qualifiedName of the TableauCalculatedField
     * @param name of the TableauCalculatedField
     * @return the updated TableauCalculatedField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauCalculatedField) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the TableauCalculatedField.
     *
     * @param qualifiedName for the TableauCalculatedField
     * @param name human-readable name of the TableauCalculatedField
     * @param terms the list of terms to replace on the TableauCalculatedField, or null to remove all terms from the TableauCalculatedField
     * @return the TableauCalculatedField that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the TableauCalculatedField.
     *
     * @param client connectivity to the Atlan tenant on which to replace the TableauCalculatedField's assigned terms
     * @param qualifiedName for the TableauCalculatedField
     * @param name human-readable name of the TableauCalculatedField
     * @param terms the list of terms to replace on the TableauCalculatedField, or null to remove all terms from the TableauCalculatedField
     * @return the TableauCalculatedField that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauCalculatedField) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the TableauCalculatedField, without replacing existing terms linked to the TableauCalculatedField.
     * Note: this operation must make two API calls — one to retrieve the TableauCalculatedField's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the TableauCalculatedField
     * @param terms the list of terms to append to the TableauCalculatedField
     * @return the TableauCalculatedField that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the TableauCalculatedField, without replacing existing terms linked to the TableauCalculatedField.
     * Note: this operation must make two API calls — one to retrieve the TableauCalculatedField's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the TableauCalculatedField
     * @param qualifiedName for the TableauCalculatedField
     * @param terms the list of terms to append to the TableauCalculatedField
     * @return the TableauCalculatedField that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauCalculatedField) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a TableauCalculatedField, without replacing all existing terms linked to the TableauCalculatedField.
     * Note: this operation must make two API calls — one to retrieve the TableauCalculatedField's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the TableauCalculatedField
     * @param terms the list of terms to remove from the TableauCalculatedField, which must be referenced by GUID
     * @return the TableauCalculatedField that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a TableauCalculatedField, without replacing all existing terms linked to the TableauCalculatedField.
     * Note: this operation must make two API calls — one to retrieve the TableauCalculatedField's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the TableauCalculatedField
     * @param qualifiedName for the TableauCalculatedField
     * @param terms the list of terms to remove from the TableauCalculatedField, which must be referenced by GUID
     * @return the TableauCalculatedField that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TableauCalculatedField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauCalculatedField) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a TableauCalculatedField, without replacing existing Atlan tags linked to the TableauCalculatedField.
     * Note: this operation must make two API calls — one to retrieve the TableauCalculatedField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TableauCalculatedField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TableauCalculatedField
     */
    public static TableauCalculatedField appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TableauCalculatedField, without replacing existing Atlan tags linked to the TableauCalculatedField.
     * Note: this operation must make two API calls — one to retrieve the TableauCalculatedField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TableauCalculatedField
     * @param qualifiedName of the TableauCalculatedField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TableauCalculatedField
     */
    public static TableauCalculatedField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TableauCalculatedField) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TableauCalculatedField, without replacing existing Atlan tags linked to the TableauCalculatedField.
     * Note: this operation must make two API calls — one to retrieve the TableauCalculatedField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TableauCalculatedField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TableauCalculatedField
     */
    public static TableauCalculatedField appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a TableauCalculatedField, without replacing existing Atlan tags linked to the TableauCalculatedField.
     * Note: this operation must make two API calls — one to retrieve the TableauCalculatedField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TableauCalculatedField
     * @param qualifiedName of the TableauCalculatedField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TableauCalculatedField
     */
    public static TableauCalculatedField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TableauCalculatedField) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a TableauCalculatedField.
     *
     * @param qualifiedName of the TableauCalculatedField
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TableauCalculatedField
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a TableauCalculatedField.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a TableauCalculatedField
     * @param qualifiedName of the TableauCalculatedField
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TableauCalculatedField
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class TableauCalculatedFieldBuilder<C extends TableauCalculatedField, B extends TableauCalculatedField.TableauCalculatedFieldBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataCategory;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ITableauDatasource datasource;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String datasourceQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String formula;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> projectHierarchy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String projectQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String role;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String siteQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableauDataType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String topLevelProjectQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> upstreamFields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workbookQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ITableauWorksheet> worksheets;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            TableauCalculatedField.TableauCalculatedFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final TableauCalculatedField instance, final TableauCalculatedField.TableauCalculatedFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dataCategory(instance.dataCategory);
            b.datasource(instance.datasource);
            b.datasourceQualifiedName(instance.datasourceQualifiedName);
            b.formula(instance.formula);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.projectHierarchy(instance.projectHierarchy == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.projectHierarchy);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.role(instance.role);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.tableauDataType(instance.tableauDataType);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.upstreamFields(instance.upstreamFields == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.upstreamFields);
            b.workbookQualifiedName(instance.workbookQualifiedName);
            b.worksheets(instance.worksheets == null ? java.util.Collections.<ITableauWorksheet>emptySortedSet() : instance.worksheets);
        }

        /**
         * Fixed typeName for TableauCalculatedFields.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Data category of this field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataCategory(final String dataCategory) {
            this.dataCategory = dataCategory;
            return self();
        }

        /**
         * Datasource in which this calculated field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B datasource(final ITableauDatasource datasource) {
            this.datasource = datasource;
            return self();
        }

        /**
         * Unique name of the datasource in which this calculated field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B datasourceQualifiedName(final String datasourceQualifiedName) {
            this.datasourceQualifiedName = datasourceQualifiedName;
            return self();
        }

        /**
         * Formula for this calculated field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B formula(final String formula) {
            this.formula = formula;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addProjectHierarchy(final Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) this.projectHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.projectHierarchy.add(addProjectHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B projectHierarchy(final java.util.Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new java.lang.NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) this.projectHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.projectHierarchy.addAll(projectHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) this.projectHierarchy.clear();
            return self();
        }

        /**
         * Unique name of the project in which this calculated field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B projectQualifiedName(final String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return self();
        }

        /**
         * Role of this field, for example: 'dimension', 'measure', or 'unknown'.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B role(final String role) {
            this.role = role;
            return self();
        }

        /**
         * Unique name of the site in which this calculated field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B siteQualifiedName(final String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return self();
        }

        /**
         * Data type of the field, from Tableau.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableauDataType(final String tableauDataType) {
            this.tableauDataType = tableauDataType;
            return self();
        }

        /**
         * Unique name of the top-level project in which this calculated field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B topLevelProjectQualifiedName(final String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamField(final Map<String, String> upstreamField) {
            if (this.upstreamFields == null) this.upstreamFields = new java.util.ArrayList<Map<String, String>>();
            this.upstreamFields.add(upstreamField);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamFields(final java.util.Collection<? extends Map<String, String>> upstreamFields) {
            if (upstreamFields == null) {
                throw new java.lang.NullPointerException("upstreamFields cannot be null");
            }
            if (this.upstreamFields == null) this.upstreamFields = new java.util.ArrayList<Map<String, String>>();
            this.upstreamFields.addAll(upstreamFields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearUpstreamFields() {
            if (this.upstreamFields != null) this.upstreamFields.clear();
            return self();
        }

        /**
         * Unique name of the workbook in which this calculated field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workbookQualifiedName(final String workbookQualifiedName) {
            this.workbookQualifiedName = workbookQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B worksheet(final ITableauWorksheet worksheet) {
            if (this.worksheets == null) this.worksheets = new java.util.ArrayList<ITableauWorksheet>();
            this.worksheets.add(worksheet);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B worksheets(final java.util.Collection<? extends ITableauWorksheet> worksheets) {
            if (worksheets == null) {
                throw new java.lang.NullPointerException("worksheets cannot be null");
            }
            if (this.worksheets == null) this.worksheets = new java.util.ArrayList<ITableauWorksheet>();
            this.worksheets.addAll(worksheets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearWorksheets() {
            if (this.worksheets != null) this.worksheets.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TableauCalculatedField.TableauCalculatedFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dataCategory=" + this.dataCategory + ", datasource=" + this.datasource + ", datasourceQualifiedName=" + this.datasourceQualifiedName + ", formula=" + this.formula + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", projectHierarchy=" + this.projectHierarchy + ", projectQualifiedName=" + this.projectQualifiedName + ", role=" + this.role + ", siteQualifiedName=" + this.siteQualifiedName + ", tableauDataType=" + this.tableauDataType + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", upstreamFields=" + this.upstreamFields + ", workbookQualifiedName=" + this.workbookQualifiedName + ", worksheets=" + this.worksheets + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class TableauCalculatedFieldBuilderImpl extends TableauCalculatedField.TableauCalculatedFieldBuilder<TableauCalculatedField, TableauCalculatedField.TableauCalculatedFieldBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TableauCalculatedFieldBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected TableauCalculatedField.TableauCalculatedFieldBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TableauCalculatedField build() {
            return new TableauCalculatedField(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected TableauCalculatedField(final TableauCalculatedField.TableauCalculatedFieldBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = TableauCalculatedField.$default$typeName();
        this.dataCategory = b.dataCategory;
        this.datasource = b.datasource;
        this.datasourceQualifiedName = b.datasourceQualifiedName;
        this.formula = b.formula;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.List<Map<String, String>> projectHierarchy;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
        case 0: 
            projectHierarchy = java.util.Collections.emptyList();
            break;
        case 1: 
            projectHierarchy = java.util.Collections.singletonList(b.projectHierarchy.get(0));
            break;
        default: 
            projectHierarchy = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.projectHierarchy));
        }
        this.projectHierarchy = projectHierarchy;
        this.projectQualifiedName = b.projectQualifiedName;
        this.role = b.role;
        this.siteQualifiedName = b.siteQualifiedName;
        this.tableauDataType = b.tableauDataType;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        java.util.List<Map<String, String>> upstreamFields;
        switch (b.upstreamFields == null ? 0 : b.upstreamFields.size()) {
        case 0: 
            upstreamFields = java.util.Collections.emptyList();
            break;
        case 1: 
            upstreamFields = java.util.Collections.singletonList(b.upstreamFields.get(0));
            break;
        default: 
            upstreamFields = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.upstreamFields));
        }
        this.upstreamFields = upstreamFields;
        this.workbookQualifiedName = b.workbookQualifiedName;
        java.util.SortedSet<ITableauWorksheet> worksheets = new java.util.TreeSet<ITableauWorksheet>();
        if (b.worksheets != null) worksheets.addAll(b.worksheets);
        worksheets = java.util.Collections.unmodifiableSortedSet(worksheets);
        this.worksheets = worksheets;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static TableauCalculatedField.TableauCalculatedFieldBuilder<?, ?> _internal() {
        return new TableauCalculatedField.TableauCalculatedFieldBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TableauCalculatedField.TableauCalculatedFieldBuilder<?, ?> toBuilder() {
        return new TableauCalculatedField.TableauCalculatedFieldBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Data category of this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataCategory() {
        return this.dataCategory;
    }

    /**
     * Datasource in which this calculated field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ITableauDatasource getDatasource() {
        return this.datasource;
    }

    /**
     * Unique name of the datasource in which this calculated field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatasourceQualifiedName() {
        return this.datasourceQualifiedName;
    }

    /**
     * Formula for this calculated field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFormula() {
        return this.formula;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * List of top-level projects and their nested projects.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    /**
     * Unique name of the project in which this calculated field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    /**
     * Role of this field, for example: 'dimension', 'measure', or 'unknown'.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRole() {
        return this.role;
    }

    /**
     * Unique name of the site in which this calculated field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    /**
     * Data type of the field, from Tableau.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableauDataType() {
        return this.tableauDataType;
    }

    /**
     * Unique name of the top-level project in which this calculated field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    /**
     * List of fields that are upstream to this calculated field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getUpstreamFields() {
        return this.upstreamFields;
    }

    /**
     * Unique name of the workbook in which this calculated field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkbookQualifiedName() {
        return this.workbookQualifiedName;
    }

    /**
     * Worksheets that use this calculated field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ITableauWorksheet> getWorksheets() {
        return this.worksheets;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TableauCalculatedField)) return false;
        final TableauCalculatedField other = (TableauCalculatedField) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dataCategory = this.getDataCategory();
        final java.lang.Object other$dataCategory = other.getDataCategory();
        if (this$dataCategory == null ? other$dataCategory != null : !this$dataCategory.equals(other$dataCategory)) return false;
        final java.lang.Object this$datasource = this.getDatasource();
        final java.lang.Object other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !this$datasource.equals(other$datasource)) return false;
        final java.lang.Object this$datasourceQualifiedName = this.getDatasourceQualifiedName();
        final java.lang.Object other$datasourceQualifiedName = other.getDatasourceQualifiedName();
        if (this$datasourceQualifiedName == null ? other$datasourceQualifiedName != null : !this$datasourceQualifiedName.equals(other$datasourceQualifiedName)) return false;
        final java.lang.Object this$formula = this.getFormula();
        final java.lang.Object other$formula = other.getFormula();
        if (this$formula == null ? other$formula != null : !this$formula.equals(other$formula)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$projectHierarchy = this.getProjectHierarchy();
        final java.lang.Object other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !this$projectHierarchy.equals(other$projectHierarchy)) return false;
        final java.lang.Object this$projectQualifiedName = this.getProjectQualifiedName();
        final java.lang.Object other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) return false;
        final java.lang.Object this$role = this.getRole();
        final java.lang.Object other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) return false;
        final java.lang.Object this$siteQualifiedName = this.getSiteQualifiedName();
        final java.lang.Object other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) return false;
        final java.lang.Object this$tableauDataType = this.getTableauDataType();
        final java.lang.Object other$tableauDataType = other.getTableauDataType();
        if (this$tableauDataType == null ? other$tableauDataType != null : !this$tableauDataType.equals(other$tableauDataType)) return false;
        final java.lang.Object this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        final java.lang.Object other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) return false;
        final java.lang.Object this$upstreamFields = this.getUpstreamFields();
        final java.lang.Object other$upstreamFields = other.getUpstreamFields();
        if (this$upstreamFields == null ? other$upstreamFields != null : !this$upstreamFields.equals(other$upstreamFields)) return false;
        final java.lang.Object this$workbookQualifiedName = this.getWorkbookQualifiedName();
        final java.lang.Object other$workbookQualifiedName = other.getWorkbookQualifiedName();
        if (this$workbookQualifiedName == null ? other$workbookQualifiedName != null : !this$workbookQualifiedName.equals(other$workbookQualifiedName)) return false;
        final java.lang.Object this$worksheets = this.getWorksheets();
        final java.lang.Object other$worksheets = other.getWorksheets();
        if (this$worksheets == null ? other$worksheets != null : !this$worksheets.equals(other$worksheets)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TableauCalculatedField;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dataCategory = this.getDataCategory();
        result = result * PRIME + ($dataCategory == null ? 43 : $dataCategory.hashCode());
        final java.lang.Object $datasource = this.getDatasource();
        result = result * PRIME + ($datasource == null ? 43 : $datasource.hashCode());
        final java.lang.Object $datasourceQualifiedName = this.getDatasourceQualifiedName();
        result = result * PRIME + ($datasourceQualifiedName == null ? 43 : $datasourceQualifiedName.hashCode());
        final java.lang.Object $formula = this.getFormula();
        result = result * PRIME + ($formula == null ? 43 : $formula.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $projectHierarchy = this.getProjectHierarchy();
        result = result * PRIME + ($projectHierarchy == null ? 43 : $projectHierarchy.hashCode());
        final java.lang.Object $projectQualifiedName = this.getProjectQualifiedName();
        result = result * PRIME + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        final java.lang.Object $role = this.getRole();
        result = result * PRIME + ($role == null ? 43 : $role.hashCode());
        final java.lang.Object $siteQualifiedName = this.getSiteQualifiedName();
        result = result * PRIME + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        final java.lang.Object $tableauDataType = this.getTableauDataType();
        result = result * PRIME + ($tableauDataType == null ? 43 : $tableauDataType.hashCode());
        final java.lang.Object $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * PRIME + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        final java.lang.Object $upstreamFields = this.getUpstreamFields();
        result = result * PRIME + ($upstreamFields == null ? 43 : $upstreamFields.hashCode());
        final java.lang.Object $workbookQualifiedName = this.getWorkbookQualifiedName();
        result = result * PRIME + ($workbookQualifiedName == null ? 43 : $workbookQualifiedName.hashCode());
        final java.lang.Object $worksheets = this.getWorksheets();
        result = result * PRIME + ($worksheets == null ? 43 : $worksheets.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TableauCalculatedField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dataCategory=" + this.getDataCategory() + ", datasource=" + this.getDatasource() + ", datasourceQualifiedName=" + this.getDatasourceQualifiedName() + ", formula=" + this.getFormula() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", projectHierarchy=" + this.getProjectHierarchy() + ", projectQualifiedName=" + this.getProjectQualifiedName() + ", role=" + this.getRole() + ", siteQualifiedName=" + this.getSiteQualifiedName() + ", tableauDataType=" + this.getTableauDataType() + ", topLevelProjectQualifiedName=" + this.getTopLevelProjectQualifiedName() + ", upstreamFields=" + this.getUpstreamFields() + ", workbookQualifiedName=" + this.getWorkbookQualifiedName() + ", worksheets=" + this.getWorksheets() + ")";
    }

    /**
     * Fixed typeName for TableauCalculatedFields.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
