// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Tableau datasource in Atlan. These include both published and embedded datasources, and are the link between source data and Tableau.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class TableauDatasource extends Asset implements ITableauDatasource, ITableau, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(TableauDatasource.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauDatasource";
    /**
     * Fixed typeName for TableauDatasources.
     */
    String typeName;
    /**
     * Notes related to this datasource being cerfified, in Tableau.
     */
    @Attribute
    String certificationNote;
    /**
     * Users that have marked this datasource as cerified, in Tableau.
     */
    @Attribute
    Map<String, String> certifier;
    /**
     * Name of the user who cerified this datasource, in Tableau.
     */
    @Attribute
    String certifierDisplayName;
    /**
     * Fields that exist within this datasource.
     */
    @Attribute
    SortedSet<ITableauField> fields;
    /**
     * Whether this datasource has extracts (true) or not (false).
     */
    @Attribute
    Boolean hasExtracts;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Whether this datasource is certified in Tableau (true) or not (false).
     */
    @Attribute
    Boolean isCertified;
    /**
     * Whether this datasource is published (true) or embedded (false).
     */
    @Attribute
    Boolean isPublished;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Project in which this datasource exists.
     */
    @Attribute
    ITableauProject project;
    /**
     * List of top-level projects with their nested child projects.
     */
    @Attribute
    List<Map<String, String>> projectHierarchy;
    /**
     * Unique name of the project in which this datasource exists.
     */
    @Attribute
    String projectQualifiedName;
    /**
     * Unique name of the site in which this datasource exists.
     */
    @Attribute
    String siteQualifiedName;
    /**
     * Unique name of the top-level project in which this datasource exists.
     */
    @Attribute
    String topLevelProjectQualifiedName;
    /**
     * List of datasources that are upstream of this datasource.
     */
    @Attribute
    List<Map<String, String>> upstreamDatasources;
    /**
     * List of tables that are upstream of this datasource.
     */
    @Attribute
    List<Map<String, String>> upstreamTables;
    /**
     * Workbook in which this datasource exists.
     */
    @Attribute
    ITableauWorkbook workbook;
    /**
     * Unique name of the workbook in which this datasource exists.
     */
    @Attribute
    String workbookQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a TableauDatasource, from a potentially
     * more-complete TableauDatasource object.
     *
     * @return the minimal object necessary to relate to the TableauDatasource
     * @throws InvalidRequestException if any of the minimal set of required properties for a TableauDatasource relationship are not found in the initial object
     */
    @Override
    public TableauDatasource trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all TableauDatasource assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TableauDatasource assets will be included.
     *
     * @return a fluent search that includes all TableauDatasource assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all TableauDatasource assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TableauDatasource assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all TableauDatasource assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all TableauDatasource assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) TableauDatasources will be included
     * @return a fluent search that includes all TableauDatasource assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all TableauDatasource assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) TableauDatasources will be included
     * @return a fluent search that includes all TableauDatasource assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a TableauDatasource by GUID. Use this to create a relationship to this TableauDatasource,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the TableauDatasource to reference
     * @return reference to a TableauDatasource that can be used for defining a relationship to a TableauDatasource
     */
    public static TableauDatasource refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TableauDatasource by GUID. Use this to create a relationship to this TableauDatasource,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the TableauDatasource to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TableauDatasource that can be used for defining a relationship to a TableauDatasource
     */
    public static TableauDatasource refByGuid(String guid, Reference.SaveSemantic semantic) {
        return TableauDatasource._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a TableauDatasource by qualifiedName. Use this to create a relationship to this TableauDatasource,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the TableauDatasource to reference
     * @return reference to a TableauDatasource that can be used for defining a relationship to a TableauDatasource
     */
    public static TableauDatasource refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TableauDatasource by qualifiedName. Use this to create a relationship to this TableauDatasource,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the TableauDatasource to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TableauDatasource that can be used for defining a relationship to a TableauDatasource
     */
    public static TableauDatasource refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return TableauDatasource._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a TableauDatasource by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the TableauDatasource to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TableauDatasource, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauDatasource does not exist or the provided GUID is not a TableauDatasource
     */
    @JsonIgnore
    public static TableauDatasource get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a TableauDatasource by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TableauDatasource to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TableauDatasource, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauDatasource does not exist or the provided GUID is not a TableauDatasource
     */
    @JsonIgnore
    public static TableauDatasource get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a TableauDatasource by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TableauDatasource to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full TableauDatasource, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauDatasource does not exist or the provided GUID is not a TableauDatasource
     */
    @JsonIgnore
    public static TableauDatasource get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof TableauDatasource) {
                return (TableauDatasource) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof TableauDatasource) {
                return (TableauDatasource) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) TableauDatasource to active.
     *
     * @param qualifiedName for the TableauDatasource
     * @return true if the TableauDatasource is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) TableauDatasource to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the TableauDatasource
     * @return true if the TableauDatasource is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a TableauDatasource.
     *
     * @param qualifiedName of the TableauDatasource
     * @param name of the TableauDatasource
     * @return the minimal request necessary to update the TableauDatasource, as a builder
     */
    public static TableauDatasourceBuilder<?, ?> updater(String qualifiedName, String name) {
        return TableauDatasource._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a TableauDatasource, from a potentially
     * more-complete TableauDatasource object.
     *
     * @return the minimal object necessary to update the TableauDatasource, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for TableauDatasource are not found in the initial object
     */
    @Override
    public TableauDatasourceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a TableauDatasource.
     *
     * @param qualifiedName of the TableauDatasource
     * @param name of the TableauDatasource
     * @return the updated TableauDatasource, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a TableauDatasource.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TableauDatasource
     * @param name of the TableauDatasource
     * @return the updated TableauDatasource, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a TableauDatasource.
     *
     * @param qualifiedName of the TableauDatasource
     * @param name of the TableauDatasource
     * @return the updated TableauDatasource, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a TableauDatasource.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TableauDatasource
     * @param name of the TableauDatasource
     * @return the updated TableauDatasource, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a TableauDatasource.
     *
     * @param qualifiedName of the TableauDatasource
     * @param name of the TableauDatasource
     * @return the updated TableauDatasource, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a TableauDatasource.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TableauDatasource's owners
     * @param qualifiedName of the TableauDatasource
     * @param name of the TableauDatasource
     * @return the updated TableauDatasource, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a TableauDatasource.
     *
     * @param qualifiedName of the TableauDatasource
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TableauDatasource, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a TableauDatasource.
     *
     * @param client connectivity to the Atlan tenant on which to update the TableauDatasource's certificate
     * @param qualifiedName of the TableauDatasource
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TableauDatasource, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TableauDatasource) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a TableauDatasource.
     *
     * @param qualifiedName of the TableauDatasource
     * @param name of the TableauDatasource
     * @return the updated TableauDatasource, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a TableauDatasource.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TableauDatasource's certificate
     * @param qualifiedName of the TableauDatasource
     * @param name of the TableauDatasource
     * @return the updated TableauDatasource, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a TableauDatasource.
     *
     * @param qualifiedName of the TableauDatasource
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a TableauDatasource.
     *
     * @param client connectivity to the Atlan tenant on which to update the TableauDatasource's announcement
     * @param qualifiedName of the TableauDatasource
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauDatasource) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a TableauDatasource.
     *
     * @param qualifiedName of the TableauDatasource
     * @param name of the TableauDatasource
     * @return the updated TableauDatasource, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a TableauDatasource.
     *
     * @param client connectivity to the Atlan client from which to remove the TableauDatasource's announcement
     * @param qualifiedName of the TableauDatasource
     * @param name of the TableauDatasource
     * @return the updated TableauDatasource, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasource) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the TableauDatasource.
     *
     * @param qualifiedName for the TableauDatasource
     * @param name human-readable name of the TableauDatasource
     * @param terms the list of terms to replace on the TableauDatasource, or null to remove all terms from the TableauDatasource
     * @return the TableauDatasource that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the TableauDatasource.
     *
     * @param client connectivity to the Atlan tenant on which to replace the TableauDatasource's assigned terms
     * @param qualifiedName for the TableauDatasource
     * @param name human-readable name of the TableauDatasource
     * @param terms the list of terms to replace on the TableauDatasource, or null to remove all terms from the TableauDatasource
     * @return the TableauDatasource that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasource) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the TableauDatasource, without replacing existing terms linked to the TableauDatasource.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasource's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the TableauDatasource
     * @param terms the list of terms to append to the TableauDatasource
     * @return the TableauDatasource that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the TableauDatasource, without replacing existing terms linked to the TableauDatasource.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasource's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the TableauDatasource
     * @param qualifiedName for the TableauDatasource
     * @param terms the list of terms to append to the TableauDatasource
     * @return the TableauDatasource that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasource) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a TableauDatasource, without replacing all existing terms linked to the TableauDatasource.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasource's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the TableauDatasource
     * @param terms the list of terms to remove from the TableauDatasource, which must be referenced by GUID
     * @return the TableauDatasource that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a TableauDatasource, without replacing all existing terms linked to the TableauDatasource.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasource's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the TableauDatasource
     * @param qualifiedName for the TableauDatasource
     * @param terms the list of terms to remove from the TableauDatasource, which must be referenced by GUID
     * @return the TableauDatasource that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasource removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasource) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a TableauDatasource, without replacing existing Atlan tags linked to the TableauDatasource.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasource's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TableauDatasource
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TableauDatasource
     */
    public static TableauDatasource appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TableauDatasource, without replacing existing Atlan tags linked to the TableauDatasource.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasource's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TableauDatasource
     * @param qualifiedName of the TableauDatasource
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TableauDatasource
     */
    public static TableauDatasource appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TableauDatasource) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TableauDatasource, without replacing existing Atlan tags linked to the TableauDatasource.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasource's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TableauDatasource
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TableauDatasource
     */
    public static TableauDatasource appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a TableauDatasource, without replacing existing Atlan tags linked to the TableauDatasource.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasource's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TableauDatasource
     * @param qualifiedName of the TableauDatasource
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TableauDatasource
     */
    public static TableauDatasource appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TableauDatasource) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a TableauDatasource.
     *
     * @param qualifiedName of the TableauDatasource
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TableauDatasource
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a TableauDatasource.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a TableauDatasource
     * @param qualifiedName of the TableauDatasource
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TableauDatasource
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class TableauDatasourceBuilder<C extends TableauDatasource, B extends TableauDatasource.TableauDatasourceBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String certificationNote;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> certifier$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> certifier$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String certifierDisplayName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ITableauField> fields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean hasExtracts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isCertified;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isPublished;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ITableauProject project;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> projectHierarchy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String projectQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String siteQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String topLevelProjectQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> upstreamDatasources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> upstreamTables;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ITableauWorkbook workbook;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workbookQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            TableauDatasource.TableauDatasourceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final TableauDatasource instance, final TableauDatasource.TableauDatasourceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.certificationNote(instance.certificationNote);
            b.certifier(instance.certifier == null ? java.util.Collections.<String, String>emptyMap() : instance.certifier);
            b.certifierDisplayName(instance.certifierDisplayName);
            b.fields(instance.fields == null ? java.util.Collections.<ITableauField>emptySortedSet() : instance.fields);
            b.hasExtracts(instance.hasExtracts);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.isCertified(instance.isCertified);
            b.isPublished(instance.isPublished);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.project(instance.project);
            b.projectHierarchy(instance.projectHierarchy == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.projectHierarchy);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.upstreamDatasources(instance.upstreamDatasources == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.upstreamDatasources);
            b.upstreamTables(instance.upstreamTables == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.upstreamTables);
            b.workbook(instance.workbook);
            b.workbookQualifiedName(instance.workbookQualifiedName);
        }

        /**
         * Fixed typeName for TableauDatasources.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Notes related to this datasource being cerfified, in Tableau.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B certificationNote(final String certificationNote) {
            this.certificationNote = certificationNote;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putCertifier(final String putCertifierKey, final String putCertifierValue) {
            if (this.certifier$key == null) {
                this.certifier$key = new java.util.ArrayList<String>();
                this.certifier$value = new java.util.ArrayList<String>();
            }
            this.certifier$key.add(putCertifierKey);
            this.certifier$value.add(putCertifierValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B certifier(final java.util.Map<? extends String, ? extends String> certifier) {
            if (certifier == null) {
                throw new java.lang.NullPointerException("certifier cannot be null");
            }
            if (this.certifier$key == null) {
                this.certifier$key = new java.util.ArrayList<String>();
                this.certifier$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : certifier.entrySet()) {
                this.certifier$key.add($lombokEntry.getKey());
                this.certifier$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCertifier() {
            if (this.certifier$key != null) {
                this.certifier$key.clear();
                this.certifier$value.clear();
            }
            return self();
        }

        /**
         * Name of the user who cerified this datasource, in Tableau.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B certifierDisplayName(final String certifierDisplayName) {
            this.certifierDisplayName = certifierDisplayName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B field(final ITableauField field) {
            if (this.fields == null) this.fields = new java.util.ArrayList<ITableauField>();
            this.fields.add(field);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B fields(final java.util.Collection<? extends ITableauField> fields) {
            if (fields == null) {
                throw new java.lang.NullPointerException("fields cannot be null");
            }
            if (this.fields == null) this.fields = new java.util.ArrayList<ITableauField>();
            this.fields.addAll(fields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearFields() {
            if (this.fields != null) this.fields.clear();
            return self();
        }

        /**
         * Whether this datasource has extracts (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B hasExtracts(final Boolean hasExtracts) {
            this.hasExtracts = hasExtracts;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Whether this datasource is certified in Tableau (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isCertified(final Boolean isCertified) {
            this.isCertified = isCertified;
            return self();
        }

        /**
         * Whether this datasource is published (true) or embedded (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isPublished(final Boolean isPublished) {
            this.isPublished = isPublished;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Project in which this datasource exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B project(final ITableauProject project) {
            this.project = project;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addProjectHierarchy(final Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) this.projectHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.projectHierarchy.add(addProjectHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B projectHierarchy(final java.util.Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new java.lang.NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) this.projectHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.projectHierarchy.addAll(projectHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) this.projectHierarchy.clear();
            return self();
        }

        /**
         * Unique name of the project in which this datasource exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B projectQualifiedName(final String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return self();
        }

        /**
         * Unique name of the site in which this datasource exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B siteQualifiedName(final String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return self();
        }

        /**
         * Unique name of the top-level project in which this datasource exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B topLevelProjectQualifiedName(final String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamDatasource(final Map<String, String> upstreamDatasource) {
            if (this.upstreamDatasources == null) this.upstreamDatasources = new java.util.ArrayList<Map<String, String>>();
            this.upstreamDatasources.add(upstreamDatasource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamDatasources(final java.util.Collection<? extends Map<String, String>> upstreamDatasources) {
            if (upstreamDatasources == null) {
                throw new java.lang.NullPointerException("upstreamDatasources cannot be null");
            }
            if (this.upstreamDatasources == null) this.upstreamDatasources = new java.util.ArrayList<Map<String, String>>();
            this.upstreamDatasources.addAll(upstreamDatasources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearUpstreamDatasources() {
            if (this.upstreamDatasources != null) this.upstreamDatasources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamTable(final Map<String, String> upstreamTable) {
            if (this.upstreamTables == null) this.upstreamTables = new java.util.ArrayList<Map<String, String>>();
            this.upstreamTables.add(upstreamTable);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamTables(final java.util.Collection<? extends Map<String, String>> upstreamTables) {
            if (upstreamTables == null) {
                throw new java.lang.NullPointerException("upstreamTables cannot be null");
            }
            if (this.upstreamTables == null) this.upstreamTables = new java.util.ArrayList<Map<String, String>>();
            this.upstreamTables.addAll(upstreamTables);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearUpstreamTables() {
            if (this.upstreamTables != null) this.upstreamTables.clear();
            return self();
        }

        /**
         * Workbook in which this datasource exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workbook(final ITableauWorkbook workbook) {
            this.workbook = workbook;
            return self();
        }

        /**
         * Unique name of the workbook in which this datasource exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workbookQualifiedName(final String workbookQualifiedName) {
            this.workbookQualifiedName = workbookQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TableauDatasource.TableauDatasourceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", certificationNote=" + this.certificationNote + ", certifier$key=" + this.certifier$key + ", certifier$value=" + this.certifier$value + ", certifierDisplayName=" + this.certifierDisplayName + ", fields=" + this.fields + ", hasExtracts=" + this.hasExtracts + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isCertified=" + this.isCertified + ", isPublished=" + this.isPublished + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", project=" + this.project + ", projectHierarchy=" + this.projectHierarchy + ", projectQualifiedName=" + this.projectQualifiedName + ", siteQualifiedName=" + this.siteQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", upstreamDatasources=" + this.upstreamDatasources + ", upstreamTables=" + this.upstreamTables + ", workbook=" + this.workbook + ", workbookQualifiedName=" + this.workbookQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class TableauDatasourceBuilderImpl extends TableauDatasource.TableauDatasourceBuilder<TableauDatasource, TableauDatasource.TableauDatasourceBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TableauDatasourceBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected TableauDatasource.TableauDatasourceBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TableauDatasource build() {
            return new TableauDatasource(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected TableauDatasource(final TableauDatasource.TableauDatasourceBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = TableauDatasource.$default$typeName();
        this.certificationNote = b.certificationNote;
        java.util.Map<String, String> certifier;
        switch (b.certifier$key == null ? 0 : b.certifier$key.size()) {
        case 0: 
            certifier = java.util.Collections.emptyMap();
            break;
        case 1: 
            certifier = java.util.Collections.singletonMap(b.certifier$key.get(0), b.certifier$value.get(0));
            break;
        default: 
            certifier = new java.util.LinkedHashMap<String, String>(b.certifier$key.size() < 1073741824 ? 1 + b.certifier$key.size() + (b.certifier$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.certifier$key.size(); $i++) certifier.put(b.certifier$key.get($i), (String) b.certifier$value.get($i));
            certifier = java.util.Collections.unmodifiableMap(certifier);
        }
        this.certifier = certifier;
        this.certifierDisplayName = b.certifierDisplayName;
        java.util.SortedSet<ITableauField> fields = new java.util.TreeSet<ITableauField>();
        if (b.fields != null) fields.addAll(b.fields);
        fields = java.util.Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        this.hasExtracts = b.hasExtracts;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isCertified = b.isCertified;
        this.isPublished = b.isPublished;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.project = b.project;
        java.util.List<Map<String, String>> projectHierarchy;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
        case 0: 
            projectHierarchy = java.util.Collections.emptyList();
            break;
        case 1: 
            projectHierarchy = java.util.Collections.singletonList(b.projectHierarchy.get(0));
            break;
        default: 
            projectHierarchy = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.projectHierarchy));
        }
        this.projectHierarchy = projectHierarchy;
        this.projectQualifiedName = b.projectQualifiedName;
        this.siteQualifiedName = b.siteQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        java.util.List<Map<String, String>> upstreamDatasources;
        switch (b.upstreamDatasources == null ? 0 : b.upstreamDatasources.size()) {
        case 0: 
            upstreamDatasources = java.util.Collections.emptyList();
            break;
        case 1: 
            upstreamDatasources = java.util.Collections.singletonList(b.upstreamDatasources.get(0));
            break;
        default: 
            upstreamDatasources = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.upstreamDatasources));
        }
        this.upstreamDatasources = upstreamDatasources;
        java.util.List<Map<String, String>> upstreamTables;
        switch (b.upstreamTables == null ? 0 : b.upstreamTables.size()) {
        case 0: 
            upstreamTables = java.util.Collections.emptyList();
            break;
        case 1: 
            upstreamTables = java.util.Collections.singletonList(b.upstreamTables.get(0));
            break;
        default: 
            upstreamTables = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.upstreamTables));
        }
        this.upstreamTables = upstreamTables;
        this.workbook = b.workbook;
        this.workbookQualifiedName = b.workbookQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static TableauDatasource.TableauDatasourceBuilder<?, ?> _internal() {
        return new TableauDatasource.TableauDatasourceBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TableauDatasource.TableauDatasourceBuilder<?, ?> toBuilder() {
        return new TableauDatasource.TableauDatasourceBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Notes related to this datasource being cerfified, in Tableau.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCertificationNote() {
        return this.certificationNote;
    }

    /**
     * Users that have marked this datasource as cerified, in Tableau.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getCertifier() {
        return this.certifier;
    }

    /**
     * Name of the user who cerified this datasource, in Tableau.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCertifierDisplayName() {
        return this.certifierDisplayName;
    }

    /**
     * Fields that exist within this datasource.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ITableauField> getFields() {
        return this.fields;
    }

    /**
     * Whether this datasource has extracts (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getHasExtracts() {
        return this.hasExtracts;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Whether this datasource is certified in Tableau (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsCertified() {
        return this.isCertified;
    }

    /**
     * Whether this datasource is published (true) or embedded (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsPublished() {
        return this.isPublished;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Project in which this datasource exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ITableauProject getProject() {
        return this.project;
    }

    /**
     * List of top-level projects with their nested child projects.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    /**
     * Unique name of the project in which this datasource exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    /**
     * Unique name of the site in which this datasource exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    /**
     * Unique name of the top-level project in which this datasource exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    /**
     * List of datasources that are upstream of this datasource.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getUpstreamDatasources() {
        return this.upstreamDatasources;
    }

    /**
     * List of tables that are upstream of this datasource.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getUpstreamTables() {
        return this.upstreamTables;
    }

    /**
     * Workbook in which this datasource exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ITableauWorkbook getWorkbook() {
        return this.workbook;
    }

    /**
     * Unique name of the workbook in which this datasource exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkbookQualifiedName() {
        return this.workbookQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TableauDatasource)) return false;
        final TableauDatasource other = (TableauDatasource) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$hasExtracts = this.getHasExtracts();
        final java.lang.Object other$hasExtracts = other.getHasExtracts();
        if (this$hasExtracts == null ? other$hasExtracts != null : !this$hasExtracts.equals(other$hasExtracts)) return false;
        final java.lang.Object this$isCertified = this.getIsCertified();
        final java.lang.Object other$isCertified = other.getIsCertified();
        if (this$isCertified == null ? other$isCertified != null : !this$isCertified.equals(other$isCertified)) return false;
        final java.lang.Object this$isPublished = this.getIsPublished();
        final java.lang.Object other$isPublished = other.getIsPublished();
        if (this$isPublished == null ? other$isPublished != null : !this$isPublished.equals(other$isPublished)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$certificationNote = this.getCertificationNote();
        final java.lang.Object other$certificationNote = other.getCertificationNote();
        if (this$certificationNote == null ? other$certificationNote != null : !this$certificationNote.equals(other$certificationNote)) return false;
        final java.lang.Object this$certifier = this.getCertifier();
        final java.lang.Object other$certifier = other.getCertifier();
        if (this$certifier == null ? other$certifier != null : !this$certifier.equals(other$certifier)) return false;
        final java.lang.Object this$certifierDisplayName = this.getCertifierDisplayName();
        final java.lang.Object other$certifierDisplayName = other.getCertifierDisplayName();
        if (this$certifierDisplayName == null ? other$certifierDisplayName != null : !this$certifierDisplayName.equals(other$certifierDisplayName)) return false;
        final java.lang.Object this$fields = this.getFields();
        final java.lang.Object other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$project = this.getProject();
        final java.lang.Object other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) return false;
        final java.lang.Object this$projectHierarchy = this.getProjectHierarchy();
        final java.lang.Object other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !this$projectHierarchy.equals(other$projectHierarchy)) return false;
        final java.lang.Object this$projectQualifiedName = this.getProjectQualifiedName();
        final java.lang.Object other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) return false;
        final java.lang.Object this$siteQualifiedName = this.getSiteQualifiedName();
        final java.lang.Object other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) return false;
        final java.lang.Object this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        final java.lang.Object other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) return false;
        final java.lang.Object this$upstreamDatasources = this.getUpstreamDatasources();
        final java.lang.Object other$upstreamDatasources = other.getUpstreamDatasources();
        if (this$upstreamDatasources == null ? other$upstreamDatasources != null : !this$upstreamDatasources.equals(other$upstreamDatasources)) return false;
        final java.lang.Object this$upstreamTables = this.getUpstreamTables();
        final java.lang.Object other$upstreamTables = other.getUpstreamTables();
        if (this$upstreamTables == null ? other$upstreamTables != null : !this$upstreamTables.equals(other$upstreamTables)) return false;
        final java.lang.Object this$workbook = this.getWorkbook();
        final java.lang.Object other$workbook = other.getWorkbook();
        if (this$workbook == null ? other$workbook != null : !this$workbook.equals(other$workbook)) return false;
        final java.lang.Object this$workbookQualifiedName = this.getWorkbookQualifiedName();
        final java.lang.Object other$workbookQualifiedName = other.getWorkbookQualifiedName();
        if (this$workbookQualifiedName == null ? other$workbookQualifiedName != null : !this$workbookQualifiedName.equals(other$workbookQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TableauDatasource;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $hasExtracts = this.getHasExtracts();
        result = result * PRIME + ($hasExtracts == null ? 43 : $hasExtracts.hashCode());
        final java.lang.Object $isCertified = this.getIsCertified();
        result = result * PRIME + ($isCertified == null ? 43 : $isCertified.hashCode());
        final java.lang.Object $isPublished = this.getIsPublished();
        result = result * PRIME + ($isPublished == null ? 43 : $isPublished.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $certificationNote = this.getCertificationNote();
        result = result * PRIME + ($certificationNote == null ? 43 : $certificationNote.hashCode());
        final java.lang.Object $certifier = this.getCertifier();
        result = result * PRIME + ($certifier == null ? 43 : $certifier.hashCode());
        final java.lang.Object $certifierDisplayName = this.getCertifierDisplayName();
        result = result * PRIME + ($certifierDisplayName == null ? 43 : $certifierDisplayName.hashCode());
        final java.lang.Object $fields = this.getFields();
        result = result * PRIME + ($fields == null ? 43 : $fields.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $project = this.getProject();
        result = result * PRIME + ($project == null ? 43 : $project.hashCode());
        final java.lang.Object $projectHierarchy = this.getProjectHierarchy();
        result = result * PRIME + ($projectHierarchy == null ? 43 : $projectHierarchy.hashCode());
        final java.lang.Object $projectQualifiedName = this.getProjectQualifiedName();
        result = result * PRIME + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        final java.lang.Object $siteQualifiedName = this.getSiteQualifiedName();
        result = result * PRIME + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        final java.lang.Object $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * PRIME + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        final java.lang.Object $upstreamDatasources = this.getUpstreamDatasources();
        result = result * PRIME + ($upstreamDatasources == null ? 43 : $upstreamDatasources.hashCode());
        final java.lang.Object $upstreamTables = this.getUpstreamTables();
        result = result * PRIME + ($upstreamTables == null ? 43 : $upstreamTables.hashCode());
        final java.lang.Object $workbook = this.getWorkbook();
        result = result * PRIME + ($workbook == null ? 43 : $workbook.hashCode());
        final java.lang.Object $workbookQualifiedName = this.getWorkbookQualifiedName();
        result = result * PRIME + ($workbookQualifiedName == null ? 43 : $workbookQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TableauDatasource(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", certificationNote=" + this.getCertificationNote() + ", certifier=" + this.getCertifier() + ", certifierDisplayName=" + this.getCertifierDisplayName() + ", fields=" + this.getFields() + ", hasExtracts=" + this.getHasExtracts() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isCertified=" + this.getIsCertified() + ", isPublished=" + this.getIsPublished() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", project=" + this.getProject() + ", projectHierarchy=" + this.getProjectHierarchy() + ", projectQualifiedName=" + this.getProjectQualifiedName() + ", siteQualifiedName=" + this.getSiteQualifiedName() + ", topLevelProjectQualifiedName=" + this.getTopLevelProjectQualifiedName() + ", upstreamDatasources=" + this.getUpstreamDatasources() + ", upstreamTables=" + this.getUpstreamTables() + ", workbook=" + this.getWorkbook() + ", workbookQualifiedName=" + this.getWorkbookQualifiedName() + ")";
    }

    /**
     * Fixed typeName for TableauDatasources.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
