// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Tableau datasource field in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class TableauDatasourceField extends Asset implements ITableauField, ITableauDatasourceField, ITableau, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(TableauDatasourceField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauDatasourceField";
    /**
     * Fixed typeName for TableauDatasourceFields.
     */
    String typeName;
    /**
     * Datasource in which this field exists.
     */
    @Attribute
    ITableauDatasource datasource;
    /**
     * Type of this datasource field.
     */
    @Attribute
    String datasourceFieldType;
    /**
     * Unique name of the datasource in which this datasource field exists.
     */
    @Attribute
    String datasourceQualifiedName;
    /**
     * Name used internally in Tableau to uniquely identify this field.
     */
    @Attribute
    String fullyQualifiedName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * List of top-level projects and their nested child projects.
     */
    @Attribute
    List<Map<String, String>> projectHierarchy;
    /**
     * Unique name of the project in which this datasource field exists.
     */
    @Attribute
    String projectQualifiedName;
    /**
     * Unique name of the site in which this datasource field exists.
     */
    @Attribute
    String siteQualifiedName;
    /**
     * Bin size of this field.
     */
    @Attribute
    String tableauDatasourceFieldBinSize;
    /**
     * Data category of this field.
     */
    @Attribute
    String tableauDatasourceFieldDataCategory;
    /**
     * Data type of this field.
     */
    @Attribute
    String tableauDatasourceFieldDataType;
    /**
     * Formula for this field.
     */
    @Attribute
    String tableauDatasourceFieldFormula;
    /**
     * Role of this field, for example: 'dimension', 'measure', or 'unknown'.
     */
    @Attribute
    String tableauDatasourceFieldRole;
    /**
     * Unique name of the top-level project in which this datasource field exists.
     */
    @Attribute
    String topLevelProjectQualifiedName;
    /**
     * Columns upstream to this field.
     */
    @Attribute
    List<Map<String, String>> upstreamColumns;
    /**
     * Fields upstream to this field.
     */
    @Attribute
    List<Map<String, String>> upstreamFields;
    /**
     * Tables upstream to this datasource field.
     */
    @Attribute
    List<Map<String, String>> upstreamTables;
    /**
     * Unique name of the workbook in which this datasource field exists.
     */
    @Attribute
    String workbookQualifiedName;
    /**
     * Worksheets that use this datasource field.
     */
    @Attribute
    SortedSet<ITableauWorksheet> worksheets;

    /**
     * Builds the minimal object necessary to create a relationship to a TableauDatasourceField, from a potentially
     * more-complete TableauDatasourceField object.
     *
     * @return the minimal object necessary to relate to the TableauDatasourceField
     * @throws InvalidRequestException if any of the minimal set of required properties for a TableauDatasourceField relationship are not found in the initial object
     */
    @Override
    public TableauDatasourceField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all TableauDatasourceField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TableauDatasourceField assets will be included.
     *
     * @return a fluent search that includes all TableauDatasourceField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all TableauDatasourceField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TableauDatasourceField assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all TableauDatasourceField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all TableauDatasourceField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) TableauDatasourceFields will be included
     * @return a fluent search that includes all TableauDatasourceField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all TableauDatasourceField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) TableauDatasourceFields will be included
     * @return a fluent search that includes all TableauDatasourceField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a TableauDatasourceField by GUID. Use this to create a relationship to this TableauDatasourceField,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the TableauDatasourceField to reference
     * @return reference to a TableauDatasourceField that can be used for defining a relationship to a TableauDatasourceField
     */
    public static TableauDatasourceField refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TableauDatasourceField by GUID. Use this to create a relationship to this TableauDatasourceField,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the TableauDatasourceField to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TableauDatasourceField that can be used for defining a relationship to a TableauDatasourceField
     */
    public static TableauDatasourceField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return TableauDatasourceField._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a TableauDatasourceField by qualifiedName. Use this to create a relationship to this TableauDatasourceField,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the TableauDatasourceField to reference
     * @return reference to a TableauDatasourceField that can be used for defining a relationship to a TableauDatasourceField
     */
    public static TableauDatasourceField refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TableauDatasourceField by qualifiedName. Use this to create a relationship to this TableauDatasourceField,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the TableauDatasourceField to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TableauDatasourceField that can be used for defining a relationship to a TableauDatasourceField
     */
    public static TableauDatasourceField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return TableauDatasourceField._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a TableauDatasourceField by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the TableauDatasourceField to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TableauDatasourceField, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauDatasourceField does not exist or the provided GUID is not a TableauDatasourceField
     */
    @JsonIgnore
    public static TableauDatasourceField get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a TableauDatasourceField by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TableauDatasourceField to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TableauDatasourceField, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauDatasourceField does not exist or the provided GUID is not a TableauDatasourceField
     */
    @JsonIgnore
    public static TableauDatasourceField get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a TableauDatasourceField by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TableauDatasourceField to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full TableauDatasourceField, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauDatasourceField does not exist or the provided GUID is not a TableauDatasourceField
     */
    @JsonIgnore
    public static TableauDatasourceField get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof TableauDatasourceField) {
                return (TableauDatasourceField) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof TableauDatasourceField) {
                return (TableauDatasourceField) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) TableauDatasourceField to active.
     *
     * @param qualifiedName for the TableauDatasourceField
     * @return true if the TableauDatasourceField is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) TableauDatasourceField to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the TableauDatasourceField
     * @return true if the TableauDatasourceField is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a TableauDatasourceField.
     *
     * @param qualifiedName of the TableauDatasourceField
     * @param name of the TableauDatasourceField
     * @return the minimal request necessary to update the TableauDatasourceField, as a builder
     */
    public static TableauDatasourceFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return TableauDatasourceField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a TableauDatasourceField, from a potentially
     * more-complete TableauDatasourceField object.
     *
     * @return the minimal object necessary to update the TableauDatasourceField, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for TableauDatasourceField are not found in the initial object
     */
    @Override
    public TableauDatasourceFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a TableauDatasourceField.
     *
     * @param qualifiedName of the TableauDatasourceField
     * @param name of the TableauDatasourceField
     * @return the updated TableauDatasourceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a TableauDatasourceField.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TableauDatasourceField
     * @param name of the TableauDatasourceField
     * @return the updated TableauDatasourceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a TableauDatasourceField.
     *
     * @param qualifiedName of the TableauDatasourceField
     * @param name of the TableauDatasourceField
     * @return the updated TableauDatasourceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a TableauDatasourceField.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TableauDatasourceField
     * @param name of the TableauDatasourceField
     * @return the updated TableauDatasourceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a TableauDatasourceField.
     *
     * @param qualifiedName of the TableauDatasourceField
     * @param name of the TableauDatasourceField
     * @return the updated TableauDatasourceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a TableauDatasourceField.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TableauDatasourceField's owners
     * @param qualifiedName of the TableauDatasourceField
     * @param name of the TableauDatasourceField
     * @return the updated TableauDatasourceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a TableauDatasourceField.
     *
     * @param qualifiedName of the TableauDatasourceField
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TableauDatasourceField, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a TableauDatasourceField.
     *
     * @param client connectivity to the Atlan tenant on which to update the TableauDatasourceField's certificate
     * @param qualifiedName of the TableauDatasourceField
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TableauDatasourceField, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TableauDatasourceField) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a TableauDatasourceField.
     *
     * @param qualifiedName of the TableauDatasourceField
     * @param name of the TableauDatasourceField
     * @return the updated TableauDatasourceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a TableauDatasourceField.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TableauDatasourceField's certificate
     * @param qualifiedName of the TableauDatasourceField
     * @param name of the TableauDatasourceField
     * @return the updated TableauDatasourceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a TableauDatasourceField.
     *
     * @param qualifiedName of the TableauDatasourceField
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a TableauDatasourceField.
     *
     * @param client connectivity to the Atlan tenant on which to update the TableauDatasourceField's announcement
     * @param qualifiedName of the TableauDatasourceField
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauDatasourceField) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a TableauDatasourceField.
     *
     * @param qualifiedName of the TableauDatasourceField
     * @param name of the TableauDatasourceField
     * @return the updated TableauDatasourceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a TableauDatasourceField.
     *
     * @param client connectivity to the Atlan client from which to remove the TableauDatasourceField's announcement
     * @param qualifiedName of the TableauDatasourceField
     * @param name of the TableauDatasourceField
     * @return the updated TableauDatasourceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the TableauDatasourceField.
     *
     * @param qualifiedName for the TableauDatasourceField
     * @param name human-readable name of the TableauDatasourceField
     * @param terms the list of terms to replace on the TableauDatasourceField, or null to remove all terms from the TableauDatasourceField
     * @return the TableauDatasourceField that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the TableauDatasourceField.
     *
     * @param client connectivity to the Atlan tenant on which to replace the TableauDatasourceField's assigned terms
     * @param qualifiedName for the TableauDatasourceField
     * @param name human-readable name of the TableauDatasourceField
     * @param terms the list of terms to replace on the TableauDatasourceField, or null to remove all terms from the TableauDatasourceField
     * @return the TableauDatasourceField that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasourceField) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the TableauDatasourceField, without replacing existing terms linked to the TableauDatasourceField.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasourceField's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the TableauDatasourceField
     * @param terms the list of terms to append to the TableauDatasourceField
     * @return the TableauDatasourceField that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the TableauDatasourceField, without replacing existing terms linked to the TableauDatasourceField.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasourceField's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the TableauDatasourceField
     * @param qualifiedName for the TableauDatasourceField
     * @param terms the list of terms to append to the TableauDatasourceField
     * @return the TableauDatasourceField that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasourceField) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a TableauDatasourceField, without replacing all existing terms linked to the TableauDatasourceField.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasourceField's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the TableauDatasourceField
     * @param terms the list of terms to remove from the TableauDatasourceField, which must be referenced by GUID
     * @return the TableauDatasourceField that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a TableauDatasourceField, without replacing all existing terms linked to the TableauDatasourceField.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasourceField's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the TableauDatasourceField
     * @param qualifiedName for the TableauDatasourceField
     * @param terms the list of terms to remove from the TableauDatasourceField, which must be referenced by GUID
     * @return the TableauDatasourceField that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TableauDatasourceField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasourceField) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a TableauDatasourceField, without replacing existing Atlan tags linked to the TableauDatasourceField.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasourceField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TableauDatasourceField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TableauDatasourceField
     */
    public static TableauDatasourceField appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TableauDatasourceField, without replacing existing Atlan tags linked to the TableauDatasourceField.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasourceField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TableauDatasourceField
     * @param qualifiedName of the TableauDatasourceField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TableauDatasourceField
     */
    public static TableauDatasourceField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TableauDatasourceField) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TableauDatasourceField, without replacing existing Atlan tags linked to the TableauDatasourceField.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasourceField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TableauDatasourceField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TableauDatasourceField
     */
    public static TableauDatasourceField appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a TableauDatasourceField, without replacing existing Atlan tags linked to the TableauDatasourceField.
     * Note: this operation must make two API calls — one to retrieve the TableauDatasourceField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TableauDatasourceField
     * @param qualifiedName of the TableauDatasourceField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TableauDatasourceField
     */
    public static TableauDatasourceField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TableauDatasourceField) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a TableauDatasourceField.
     *
     * @param qualifiedName of the TableauDatasourceField
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TableauDatasourceField
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a TableauDatasourceField.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a TableauDatasourceField
     * @param qualifiedName of the TableauDatasourceField
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TableauDatasourceField
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class TableauDatasourceFieldBuilder<C extends TableauDatasourceField, B extends TableauDatasourceField.TableauDatasourceFieldBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ITableauDatasource datasource;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String datasourceFieldType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String datasourceQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String fullyQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> projectHierarchy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String projectQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String siteQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableauDatasourceFieldBinSize;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableauDatasourceFieldDataCategory;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableauDatasourceFieldDataType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableauDatasourceFieldFormula;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableauDatasourceFieldRole;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String topLevelProjectQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> upstreamColumns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> upstreamFields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> upstreamTables;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workbookQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ITableauWorksheet> worksheets;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            TableauDatasourceField.TableauDatasourceFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final TableauDatasourceField instance, final TableauDatasourceField.TableauDatasourceFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.datasource(instance.datasource);
            b.datasourceFieldType(instance.datasourceFieldType);
            b.datasourceQualifiedName(instance.datasourceQualifiedName);
            b.fullyQualifiedName(instance.fullyQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.projectHierarchy(instance.projectHierarchy == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.projectHierarchy);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.tableauDatasourceFieldBinSize(instance.tableauDatasourceFieldBinSize);
            b.tableauDatasourceFieldDataCategory(instance.tableauDatasourceFieldDataCategory);
            b.tableauDatasourceFieldDataType(instance.tableauDatasourceFieldDataType);
            b.tableauDatasourceFieldFormula(instance.tableauDatasourceFieldFormula);
            b.tableauDatasourceFieldRole(instance.tableauDatasourceFieldRole);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.upstreamColumns(instance.upstreamColumns == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.upstreamColumns);
            b.upstreamFields(instance.upstreamFields == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.upstreamFields);
            b.upstreamTables(instance.upstreamTables == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.upstreamTables);
            b.workbookQualifiedName(instance.workbookQualifiedName);
            b.worksheets(instance.worksheets == null ? java.util.Collections.<ITableauWorksheet>emptySortedSet() : instance.worksheets);
        }

        /**
         * Fixed typeName for TableauDatasourceFields.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Datasource in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B datasource(final ITableauDatasource datasource) {
            this.datasource = datasource;
            return self();
        }

        /**
         * Type of this datasource field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B datasourceFieldType(final String datasourceFieldType) {
            this.datasourceFieldType = datasourceFieldType;
            return self();
        }

        /**
         * Unique name of the datasource in which this datasource field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B datasourceQualifiedName(final String datasourceQualifiedName) {
            this.datasourceQualifiedName = datasourceQualifiedName;
            return self();
        }

        /**
         * Name used internally in Tableau to uniquely identify this field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B fullyQualifiedName(final String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addProjectHierarchy(final Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) this.projectHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.projectHierarchy.add(addProjectHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B projectHierarchy(final java.util.Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new java.lang.NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) this.projectHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.projectHierarchy.addAll(projectHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) this.projectHierarchy.clear();
            return self();
        }

        /**
         * Unique name of the project in which this datasource field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B projectQualifiedName(final String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return self();
        }

        /**
         * Unique name of the site in which this datasource field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B siteQualifiedName(final String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return self();
        }

        /**
         * Bin size of this field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableauDatasourceFieldBinSize(final String tableauDatasourceFieldBinSize) {
            this.tableauDatasourceFieldBinSize = tableauDatasourceFieldBinSize;
            return self();
        }

        /**
         * Data category of this field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableauDatasourceFieldDataCategory(final String tableauDatasourceFieldDataCategory) {
            this.tableauDatasourceFieldDataCategory = tableauDatasourceFieldDataCategory;
            return self();
        }

        /**
         * Data type of this field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableauDatasourceFieldDataType(final String tableauDatasourceFieldDataType) {
            this.tableauDatasourceFieldDataType = tableauDatasourceFieldDataType;
            return self();
        }

        /**
         * Formula for this field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableauDatasourceFieldFormula(final String tableauDatasourceFieldFormula) {
            this.tableauDatasourceFieldFormula = tableauDatasourceFieldFormula;
            return self();
        }

        /**
         * Role of this field, for example: 'dimension', 'measure', or 'unknown'.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableauDatasourceFieldRole(final String tableauDatasourceFieldRole) {
            this.tableauDatasourceFieldRole = tableauDatasourceFieldRole;
            return self();
        }

        /**
         * Unique name of the top-level project in which this datasource field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B topLevelProjectQualifiedName(final String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamColumn(final Map<String, String> upstreamColumn) {
            if (this.upstreamColumns == null) this.upstreamColumns = new java.util.ArrayList<Map<String, String>>();
            this.upstreamColumns.add(upstreamColumn);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamColumns(final java.util.Collection<? extends Map<String, String>> upstreamColumns) {
            if (upstreamColumns == null) {
                throw new java.lang.NullPointerException("upstreamColumns cannot be null");
            }
            if (this.upstreamColumns == null) this.upstreamColumns = new java.util.ArrayList<Map<String, String>>();
            this.upstreamColumns.addAll(upstreamColumns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearUpstreamColumns() {
            if (this.upstreamColumns != null) this.upstreamColumns.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamField(final Map<String, String> upstreamField) {
            if (this.upstreamFields == null) this.upstreamFields = new java.util.ArrayList<Map<String, String>>();
            this.upstreamFields.add(upstreamField);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamFields(final java.util.Collection<? extends Map<String, String>> upstreamFields) {
            if (upstreamFields == null) {
                throw new java.lang.NullPointerException("upstreamFields cannot be null");
            }
            if (this.upstreamFields == null) this.upstreamFields = new java.util.ArrayList<Map<String, String>>();
            this.upstreamFields.addAll(upstreamFields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearUpstreamFields() {
            if (this.upstreamFields != null) this.upstreamFields.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamTable(final Map<String, String> upstreamTable) {
            if (this.upstreamTables == null) this.upstreamTables = new java.util.ArrayList<Map<String, String>>();
            this.upstreamTables.add(upstreamTable);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B upstreamTables(final java.util.Collection<? extends Map<String, String>> upstreamTables) {
            if (upstreamTables == null) {
                throw new java.lang.NullPointerException("upstreamTables cannot be null");
            }
            if (this.upstreamTables == null) this.upstreamTables = new java.util.ArrayList<Map<String, String>>();
            this.upstreamTables.addAll(upstreamTables);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearUpstreamTables() {
            if (this.upstreamTables != null) this.upstreamTables.clear();
            return self();
        }

        /**
         * Unique name of the workbook in which this datasource field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workbookQualifiedName(final String workbookQualifiedName) {
            this.workbookQualifiedName = workbookQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B worksheet(final ITableauWorksheet worksheet) {
            if (this.worksheets == null) this.worksheets = new java.util.ArrayList<ITableauWorksheet>();
            this.worksheets.add(worksheet);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B worksheets(final java.util.Collection<? extends ITableauWorksheet> worksheets) {
            if (worksheets == null) {
                throw new java.lang.NullPointerException("worksheets cannot be null");
            }
            if (this.worksheets == null) this.worksheets = new java.util.ArrayList<ITableauWorksheet>();
            this.worksheets.addAll(worksheets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearWorksheets() {
            if (this.worksheets != null) this.worksheets.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TableauDatasourceField.TableauDatasourceFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", datasource=" + this.datasource + ", datasourceFieldType=" + this.datasourceFieldType + ", datasourceQualifiedName=" + this.datasourceQualifiedName + ", fullyQualifiedName=" + this.fullyQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", projectHierarchy=" + this.projectHierarchy + ", projectQualifiedName=" + this.projectQualifiedName + ", siteQualifiedName=" + this.siteQualifiedName + ", tableauDatasourceFieldBinSize=" + this.tableauDatasourceFieldBinSize + ", tableauDatasourceFieldDataCategory=" + this.tableauDatasourceFieldDataCategory + ", tableauDatasourceFieldDataType=" + this.tableauDatasourceFieldDataType + ", tableauDatasourceFieldFormula=" + this.tableauDatasourceFieldFormula + ", tableauDatasourceFieldRole=" + this.tableauDatasourceFieldRole + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", upstreamColumns=" + this.upstreamColumns + ", upstreamFields=" + this.upstreamFields + ", upstreamTables=" + this.upstreamTables + ", workbookQualifiedName=" + this.workbookQualifiedName + ", worksheets=" + this.worksheets + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class TableauDatasourceFieldBuilderImpl extends TableauDatasourceField.TableauDatasourceFieldBuilder<TableauDatasourceField, TableauDatasourceField.TableauDatasourceFieldBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TableauDatasourceFieldBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected TableauDatasourceField.TableauDatasourceFieldBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TableauDatasourceField build() {
            return new TableauDatasourceField(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected TableauDatasourceField(final TableauDatasourceField.TableauDatasourceFieldBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = TableauDatasourceField.$default$typeName();
        this.datasource = b.datasource;
        this.datasourceFieldType = b.datasourceFieldType;
        this.datasourceQualifiedName = b.datasourceQualifiedName;
        this.fullyQualifiedName = b.fullyQualifiedName;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.List<Map<String, String>> projectHierarchy;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
        case 0: 
            projectHierarchy = java.util.Collections.emptyList();
            break;
        case 1: 
            projectHierarchy = java.util.Collections.singletonList(b.projectHierarchy.get(0));
            break;
        default: 
            projectHierarchy = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.projectHierarchy));
        }
        this.projectHierarchy = projectHierarchy;
        this.projectQualifiedName = b.projectQualifiedName;
        this.siteQualifiedName = b.siteQualifiedName;
        this.tableauDatasourceFieldBinSize = b.tableauDatasourceFieldBinSize;
        this.tableauDatasourceFieldDataCategory = b.tableauDatasourceFieldDataCategory;
        this.tableauDatasourceFieldDataType = b.tableauDatasourceFieldDataType;
        this.tableauDatasourceFieldFormula = b.tableauDatasourceFieldFormula;
        this.tableauDatasourceFieldRole = b.tableauDatasourceFieldRole;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        java.util.List<Map<String, String>> upstreamColumns;
        switch (b.upstreamColumns == null ? 0 : b.upstreamColumns.size()) {
        case 0: 
            upstreamColumns = java.util.Collections.emptyList();
            break;
        case 1: 
            upstreamColumns = java.util.Collections.singletonList(b.upstreamColumns.get(0));
            break;
        default: 
            upstreamColumns = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.upstreamColumns));
        }
        this.upstreamColumns = upstreamColumns;
        java.util.List<Map<String, String>> upstreamFields;
        switch (b.upstreamFields == null ? 0 : b.upstreamFields.size()) {
        case 0: 
            upstreamFields = java.util.Collections.emptyList();
            break;
        case 1: 
            upstreamFields = java.util.Collections.singletonList(b.upstreamFields.get(0));
            break;
        default: 
            upstreamFields = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.upstreamFields));
        }
        this.upstreamFields = upstreamFields;
        java.util.List<Map<String, String>> upstreamTables;
        switch (b.upstreamTables == null ? 0 : b.upstreamTables.size()) {
        case 0: 
            upstreamTables = java.util.Collections.emptyList();
            break;
        case 1: 
            upstreamTables = java.util.Collections.singletonList(b.upstreamTables.get(0));
            break;
        default: 
            upstreamTables = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.upstreamTables));
        }
        this.upstreamTables = upstreamTables;
        this.workbookQualifiedName = b.workbookQualifiedName;
        java.util.SortedSet<ITableauWorksheet> worksheets = new java.util.TreeSet<ITableauWorksheet>();
        if (b.worksheets != null) worksheets.addAll(b.worksheets);
        worksheets = java.util.Collections.unmodifiableSortedSet(worksheets);
        this.worksheets = worksheets;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static TableauDatasourceField.TableauDatasourceFieldBuilder<?, ?> _internal() {
        return new TableauDatasourceField.TableauDatasourceFieldBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TableauDatasourceField.TableauDatasourceFieldBuilder<?, ?> toBuilder() {
        return new TableauDatasourceField.TableauDatasourceFieldBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Datasource in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ITableauDatasource getDatasource() {
        return this.datasource;
    }

    /**
     * Type of this datasource field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatasourceFieldType() {
        return this.datasourceFieldType;
    }

    /**
     * Unique name of the datasource in which this datasource field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatasourceQualifiedName() {
        return this.datasourceQualifiedName;
    }

    /**
     * Name used internally in Tableau to uniquely identify this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * List of top-level projects and their nested child projects.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    /**
     * Unique name of the project in which this datasource field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    /**
     * Unique name of the site in which this datasource field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    /**
     * Bin size of this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableauDatasourceFieldBinSize() {
        return this.tableauDatasourceFieldBinSize;
    }

    /**
     * Data category of this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableauDatasourceFieldDataCategory() {
        return this.tableauDatasourceFieldDataCategory;
    }

    /**
     * Data type of this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableauDatasourceFieldDataType() {
        return this.tableauDatasourceFieldDataType;
    }

    /**
     * Formula for this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableauDatasourceFieldFormula() {
        return this.tableauDatasourceFieldFormula;
    }

    /**
     * Role of this field, for example: 'dimension', 'measure', or 'unknown'.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableauDatasourceFieldRole() {
        return this.tableauDatasourceFieldRole;
    }

    /**
     * Unique name of the top-level project in which this datasource field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    /**
     * Columns upstream to this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getUpstreamColumns() {
        return this.upstreamColumns;
    }

    /**
     * Fields upstream to this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getUpstreamFields() {
        return this.upstreamFields;
    }

    /**
     * Tables upstream to this datasource field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getUpstreamTables() {
        return this.upstreamTables;
    }

    /**
     * Unique name of the workbook in which this datasource field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkbookQualifiedName() {
        return this.workbookQualifiedName;
    }

    /**
     * Worksheets that use this datasource field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ITableauWorksheet> getWorksheets() {
        return this.worksheets;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TableauDatasourceField)) return false;
        final TableauDatasourceField other = (TableauDatasourceField) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$datasource = this.getDatasource();
        final java.lang.Object other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !this$datasource.equals(other$datasource)) return false;
        final java.lang.Object this$datasourceFieldType = this.getDatasourceFieldType();
        final java.lang.Object other$datasourceFieldType = other.getDatasourceFieldType();
        if (this$datasourceFieldType == null ? other$datasourceFieldType != null : !this$datasourceFieldType.equals(other$datasourceFieldType)) return false;
        final java.lang.Object this$datasourceQualifiedName = this.getDatasourceQualifiedName();
        final java.lang.Object other$datasourceQualifiedName = other.getDatasourceQualifiedName();
        if (this$datasourceQualifiedName == null ? other$datasourceQualifiedName != null : !this$datasourceQualifiedName.equals(other$datasourceQualifiedName)) return false;
        final java.lang.Object this$fullyQualifiedName = this.getFullyQualifiedName();
        final java.lang.Object other$fullyQualifiedName = other.getFullyQualifiedName();
        if (this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$projectHierarchy = this.getProjectHierarchy();
        final java.lang.Object other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !this$projectHierarchy.equals(other$projectHierarchy)) return false;
        final java.lang.Object this$projectQualifiedName = this.getProjectQualifiedName();
        final java.lang.Object other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) return false;
        final java.lang.Object this$siteQualifiedName = this.getSiteQualifiedName();
        final java.lang.Object other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) return false;
        final java.lang.Object this$tableauDatasourceFieldBinSize = this.getTableauDatasourceFieldBinSize();
        final java.lang.Object other$tableauDatasourceFieldBinSize = other.getTableauDatasourceFieldBinSize();
        if (this$tableauDatasourceFieldBinSize == null ? other$tableauDatasourceFieldBinSize != null : !this$tableauDatasourceFieldBinSize.equals(other$tableauDatasourceFieldBinSize)) return false;
        final java.lang.Object this$tableauDatasourceFieldDataCategory = this.getTableauDatasourceFieldDataCategory();
        final java.lang.Object other$tableauDatasourceFieldDataCategory = other.getTableauDatasourceFieldDataCategory();
        if (this$tableauDatasourceFieldDataCategory == null ? other$tableauDatasourceFieldDataCategory != null : !this$tableauDatasourceFieldDataCategory.equals(other$tableauDatasourceFieldDataCategory)) return false;
        final java.lang.Object this$tableauDatasourceFieldDataType = this.getTableauDatasourceFieldDataType();
        final java.lang.Object other$tableauDatasourceFieldDataType = other.getTableauDatasourceFieldDataType();
        if (this$tableauDatasourceFieldDataType == null ? other$tableauDatasourceFieldDataType != null : !this$tableauDatasourceFieldDataType.equals(other$tableauDatasourceFieldDataType)) return false;
        final java.lang.Object this$tableauDatasourceFieldFormula = this.getTableauDatasourceFieldFormula();
        final java.lang.Object other$tableauDatasourceFieldFormula = other.getTableauDatasourceFieldFormula();
        if (this$tableauDatasourceFieldFormula == null ? other$tableauDatasourceFieldFormula != null : !this$tableauDatasourceFieldFormula.equals(other$tableauDatasourceFieldFormula)) return false;
        final java.lang.Object this$tableauDatasourceFieldRole = this.getTableauDatasourceFieldRole();
        final java.lang.Object other$tableauDatasourceFieldRole = other.getTableauDatasourceFieldRole();
        if (this$tableauDatasourceFieldRole == null ? other$tableauDatasourceFieldRole != null : !this$tableauDatasourceFieldRole.equals(other$tableauDatasourceFieldRole)) return false;
        final java.lang.Object this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        final java.lang.Object other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) return false;
        final java.lang.Object this$upstreamColumns = this.getUpstreamColumns();
        final java.lang.Object other$upstreamColumns = other.getUpstreamColumns();
        if (this$upstreamColumns == null ? other$upstreamColumns != null : !this$upstreamColumns.equals(other$upstreamColumns)) return false;
        final java.lang.Object this$upstreamFields = this.getUpstreamFields();
        final java.lang.Object other$upstreamFields = other.getUpstreamFields();
        if (this$upstreamFields == null ? other$upstreamFields != null : !this$upstreamFields.equals(other$upstreamFields)) return false;
        final java.lang.Object this$upstreamTables = this.getUpstreamTables();
        final java.lang.Object other$upstreamTables = other.getUpstreamTables();
        if (this$upstreamTables == null ? other$upstreamTables != null : !this$upstreamTables.equals(other$upstreamTables)) return false;
        final java.lang.Object this$workbookQualifiedName = this.getWorkbookQualifiedName();
        final java.lang.Object other$workbookQualifiedName = other.getWorkbookQualifiedName();
        if (this$workbookQualifiedName == null ? other$workbookQualifiedName != null : !this$workbookQualifiedName.equals(other$workbookQualifiedName)) return false;
        final java.lang.Object this$worksheets = this.getWorksheets();
        final java.lang.Object other$worksheets = other.getWorksheets();
        if (this$worksheets == null ? other$worksheets != null : !this$worksheets.equals(other$worksheets)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TableauDatasourceField;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $datasource = this.getDatasource();
        result = result * PRIME + ($datasource == null ? 43 : $datasource.hashCode());
        final java.lang.Object $datasourceFieldType = this.getDatasourceFieldType();
        result = result * PRIME + ($datasourceFieldType == null ? 43 : $datasourceFieldType.hashCode());
        final java.lang.Object $datasourceQualifiedName = this.getDatasourceQualifiedName();
        result = result * PRIME + ($datasourceQualifiedName == null ? 43 : $datasourceQualifiedName.hashCode());
        final java.lang.Object $fullyQualifiedName = this.getFullyQualifiedName();
        result = result * PRIME + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $projectHierarchy = this.getProjectHierarchy();
        result = result * PRIME + ($projectHierarchy == null ? 43 : $projectHierarchy.hashCode());
        final java.lang.Object $projectQualifiedName = this.getProjectQualifiedName();
        result = result * PRIME + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        final java.lang.Object $siteQualifiedName = this.getSiteQualifiedName();
        result = result * PRIME + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        final java.lang.Object $tableauDatasourceFieldBinSize = this.getTableauDatasourceFieldBinSize();
        result = result * PRIME + ($tableauDatasourceFieldBinSize == null ? 43 : $tableauDatasourceFieldBinSize.hashCode());
        final java.lang.Object $tableauDatasourceFieldDataCategory = this.getTableauDatasourceFieldDataCategory();
        result = result * PRIME + ($tableauDatasourceFieldDataCategory == null ? 43 : $tableauDatasourceFieldDataCategory.hashCode());
        final java.lang.Object $tableauDatasourceFieldDataType = this.getTableauDatasourceFieldDataType();
        result = result * PRIME + ($tableauDatasourceFieldDataType == null ? 43 : $tableauDatasourceFieldDataType.hashCode());
        final java.lang.Object $tableauDatasourceFieldFormula = this.getTableauDatasourceFieldFormula();
        result = result * PRIME + ($tableauDatasourceFieldFormula == null ? 43 : $tableauDatasourceFieldFormula.hashCode());
        final java.lang.Object $tableauDatasourceFieldRole = this.getTableauDatasourceFieldRole();
        result = result * PRIME + ($tableauDatasourceFieldRole == null ? 43 : $tableauDatasourceFieldRole.hashCode());
        final java.lang.Object $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * PRIME + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        final java.lang.Object $upstreamColumns = this.getUpstreamColumns();
        result = result * PRIME + ($upstreamColumns == null ? 43 : $upstreamColumns.hashCode());
        final java.lang.Object $upstreamFields = this.getUpstreamFields();
        result = result * PRIME + ($upstreamFields == null ? 43 : $upstreamFields.hashCode());
        final java.lang.Object $upstreamTables = this.getUpstreamTables();
        result = result * PRIME + ($upstreamTables == null ? 43 : $upstreamTables.hashCode());
        final java.lang.Object $workbookQualifiedName = this.getWorkbookQualifiedName();
        result = result * PRIME + ($workbookQualifiedName == null ? 43 : $workbookQualifiedName.hashCode());
        final java.lang.Object $worksheets = this.getWorksheets();
        result = result * PRIME + ($worksheets == null ? 43 : $worksheets.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TableauDatasourceField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", datasource=" + this.getDatasource() + ", datasourceFieldType=" + this.getDatasourceFieldType() + ", datasourceQualifiedName=" + this.getDatasourceQualifiedName() + ", fullyQualifiedName=" + this.getFullyQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", projectHierarchy=" + this.getProjectHierarchy() + ", projectQualifiedName=" + this.getProjectQualifiedName() + ", siteQualifiedName=" + this.getSiteQualifiedName() + ", tableauDatasourceFieldBinSize=" + this.getTableauDatasourceFieldBinSize() + ", tableauDatasourceFieldDataCategory=" + this.getTableauDatasourceFieldDataCategory() + ", tableauDatasourceFieldDataType=" + this.getTableauDatasourceFieldDataType() + ", tableauDatasourceFieldFormula=" + this.getTableauDatasourceFieldFormula() + ", tableauDatasourceFieldRole=" + this.getTableauDatasourceFieldRole() + ", topLevelProjectQualifiedName=" + this.getTopLevelProjectQualifiedName() + ", upstreamColumns=" + this.getUpstreamColumns() + ", upstreamFields=" + this.getUpstreamFields() + ", upstreamTables=" + this.getUpstreamTables() + ", workbookQualifiedName=" + this.getWorkbookQualifiedName() + ", worksheets=" + this.getWorksheets() + ")";
    }

    /**
     * Fixed typeName for TableauDatasourceFields.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
