// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Tableau flow in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class TableauFlow extends Asset implements ITableauFlow, ITableau, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(TableauFlow.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauFlow";
    /**
     * Fixed typeName for TableauFlows.
     */
    String typeName;
    /**
     * List of fields that are inputs to this flow.
     */
    @Attribute
    List<Map<String, String>> inputFields;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * List of fields that are outputs from this flow.
     */
    @Attribute
    List<Map<String, String>> outputFields;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * List of steps that are outputs from this flow.
     */
    @Attribute
    List<Map<String, String>> outputSteps;
    /**
     * Project in which this flow exists.
     */
    @Attribute
    ITableauProject project;
    /**
     * List of top-level projects with their nested child projects.
     */
    @Attribute
    List<Map<String, String>> projectHierarchy;
    /**
     * Unique name of the project in which this flow exists.
     */
    @Attribute
    String projectQualifiedName;
    /**
     * Unique name of the site in which this flow exists.
     */
    @Attribute
    String siteQualifiedName;
    /**
     * Unique name of the top-level project in which this flow exists.
     */
    @Attribute
    String topLevelProjectQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a TableauFlow, from a potentially
     * more-complete TableauFlow object.
     *
     * @return the minimal object necessary to relate to the TableauFlow
     * @throws InvalidRequestException if any of the minimal set of required properties for a TableauFlow relationship are not found in the initial object
     */
    @Override
    public TableauFlow trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all TableauFlow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TableauFlow assets will be included.
     *
     * @return a fluent search that includes all TableauFlow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all TableauFlow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TableauFlow assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all TableauFlow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all TableauFlow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) TableauFlows will be included
     * @return a fluent search that includes all TableauFlow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all TableauFlow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) TableauFlows will be included
     * @return a fluent search that includes all TableauFlow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a TableauFlow by GUID. Use this to create a relationship to this TableauFlow,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the TableauFlow to reference
     * @return reference to a TableauFlow that can be used for defining a relationship to a TableauFlow
     */
    public static TableauFlow refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TableauFlow by GUID. Use this to create a relationship to this TableauFlow,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the TableauFlow to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TableauFlow that can be used for defining a relationship to a TableauFlow
     */
    public static TableauFlow refByGuid(String guid, Reference.SaveSemantic semantic) {
        return TableauFlow._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a TableauFlow by qualifiedName. Use this to create a relationship to this TableauFlow,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the TableauFlow to reference
     * @return reference to a TableauFlow that can be used for defining a relationship to a TableauFlow
     */
    public static TableauFlow refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TableauFlow by qualifiedName. Use this to create a relationship to this TableauFlow,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the TableauFlow to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TableauFlow that can be used for defining a relationship to a TableauFlow
     */
    public static TableauFlow refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return TableauFlow._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a TableauFlow by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the TableauFlow to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TableauFlow, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauFlow does not exist or the provided GUID is not a TableauFlow
     */
    @JsonIgnore
    public static TableauFlow get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a TableauFlow by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TableauFlow to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TableauFlow, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauFlow does not exist or the provided GUID is not a TableauFlow
     */
    @JsonIgnore
    public static TableauFlow get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a TableauFlow by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TableauFlow to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full TableauFlow, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TableauFlow does not exist or the provided GUID is not a TableauFlow
     */
    @JsonIgnore
    public static TableauFlow get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof TableauFlow) {
                return (TableauFlow) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof TableauFlow) {
                return (TableauFlow) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) TableauFlow to active.
     *
     * @param qualifiedName for the TableauFlow
     * @return true if the TableauFlow is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) TableauFlow to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the TableauFlow
     * @return true if the TableauFlow is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a TableauFlow.
     *
     * @param qualifiedName of the TableauFlow
     * @param name of the TableauFlow
     * @return the minimal request necessary to update the TableauFlow, as a builder
     */
    public static TableauFlowBuilder<?, ?> updater(String qualifiedName, String name) {
        return TableauFlow._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a TableauFlow, from a potentially
     * more-complete TableauFlow object.
     *
     * @return the minimal object necessary to update the TableauFlow, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for TableauFlow are not found in the initial object
     */
    @Override
    public TableauFlowBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a TableauFlow.
     *
     * @param qualifiedName of the TableauFlow
     * @param name of the TableauFlow
     * @return the updated TableauFlow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a TableauFlow.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TableauFlow
     * @param name of the TableauFlow
     * @return the updated TableauFlow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauFlow) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a TableauFlow.
     *
     * @param qualifiedName of the TableauFlow
     * @param name of the TableauFlow
     * @return the updated TableauFlow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a TableauFlow.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TableauFlow
     * @param name of the TableauFlow
     * @return the updated TableauFlow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauFlow) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a TableauFlow.
     *
     * @param qualifiedName of the TableauFlow
     * @param name of the TableauFlow
     * @return the updated TableauFlow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a TableauFlow.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TableauFlow's owners
     * @param qualifiedName of the TableauFlow
     * @param name of the TableauFlow
     * @return the updated TableauFlow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauFlow) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a TableauFlow.
     *
     * @param qualifiedName of the TableauFlow
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TableauFlow, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a TableauFlow.
     *
     * @param client connectivity to the Atlan tenant on which to update the TableauFlow's certificate
     * @param qualifiedName of the TableauFlow
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TableauFlow, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TableauFlow) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a TableauFlow.
     *
     * @param qualifiedName of the TableauFlow
     * @param name of the TableauFlow
     * @return the updated TableauFlow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a TableauFlow.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TableauFlow's certificate
     * @param qualifiedName of the TableauFlow
     * @param name of the TableauFlow
     * @return the updated TableauFlow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauFlow) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a TableauFlow.
     *
     * @param qualifiedName of the TableauFlow
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a TableauFlow.
     *
     * @param client connectivity to the Atlan tenant on which to update the TableauFlow's announcement
     * @param qualifiedName of the TableauFlow
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauFlow) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a TableauFlow.
     *
     * @param qualifiedName of the TableauFlow
     * @param name of the TableauFlow
     * @return the updated TableauFlow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a TableauFlow.
     *
     * @param client connectivity to the Atlan client from which to remove the TableauFlow's announcement
     * @param qualifiedName of the TableauFlow
     * @param name of the TableauFlow
     * @return the updated TableauFlow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauFlow) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the TableauFlow.
     *
     * @param qualifiedName for the TableauFlow
     * @param name human-readable name of the TableauFlow
     * @param terms the list of terms to replace on the TableauFlow, or null to remove all terms from the TableauFlow
     * @return the TableauFlow that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TableauFlow replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the TableauFlow.
     *
     * @param client connectivity to the Atlan tenant on which to replace the TableauFlow's assigned terms
     * @param qualifiedName for the TableauFlow
     * @param name human-readable name of the TableauFlow
     * @param terms the list of terms to replace on the TableauFlow, or null to remove all terms from the TableauFlow
     * @return the TableauFlow that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TableauFlow replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauFlow) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the TableauFlow, without replacing existing terms linked to the TableauFlow.
     * Note: this operation must make two API calls — one to retrieve the TableauFlow's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the TableauFlow
     * @param terms the list of terms to append to the TableauFlow
     * @return the TableauFlow that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TableauFlow appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the TableauFlow, without replacing existing terms linked to the TableauFlow.
     * Note: this operation must make two API calls — one to retrieve the TableauFlow's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the TableauFlow
     * @param qualifiedName for the TableauFlow
     * @param terms the list of terms to append to the TableauFlow
     * @return the TableauFlow that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TableauFlow appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauFlow) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a TableauFlow, without replacing all existing terms linked to the TableauFlow.
     * Note: this operation must make two API calls — one to retrieve the TableauFlow's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the TableauFlow
     * @param terms the list of terms to remove from the TableauFlow, which must be referenced by GUID
     * @return the TableauFlow that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a TableauFlow, without replacing all existing terms linked to the TableauFlow.
     * Note: this operation must make two API calls — one to retrieve the TableauFlow's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the TableauFlow
     * @param qualifiedName for the TableauFlow
     * @param terms the list of terms to remove from the TableauFlow, which must be referenced by GUID
     * @return the TableauFlow that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TableauFlow removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauFlow) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a TableauFlow, without replacing existing Atlan tags linked to the TableauFlow.
     * Note: this operation must make two API calls — one to retrieve the TableauFlow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TableauFlow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TableauFlow
     */
    public static TableauFlow appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TableauFlow, without replacing existing Atlan tags linked to the TableauFlow.
     * Note: this operation must make two API calls — one to retrieve the TableauFlow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TableauFlow
     * @param qualifiedName of the TableauFlow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TableauFlow
     */
    public static TableauFlow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TableauFlow) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TableauFlow, without replacing existing Atlan tags linked to the TableauFlow.
     * Note: this operation must make two API calls — one to retrieve the TableauFlow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TableauFlow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TableauFlow
     */
    public static TableauFlow appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a TableauFlow, without replacing existing Atlan tags linked to the TableauFlow.
     * Note: this operation must make two API calls — one to retrieve the TableauFlow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TableauFlow
     * @param qualifiedName of the TableauFlow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TableauFlow
     */
    public static TableauFlow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TableauFlow) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a TableauFlow.
     *
     * @param qualifiedName of the TableauFlow
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TableauFlow
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a TableauFlow.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a TableauFlow
     * @param qualifiedName of the TableauFlow
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TableauFlow
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class TableauFlowBuilder<C extends TableauFlow, B extends TableauFlow.TableauFlowBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> inputFields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> outputFields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> outputSteps;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ITableauProject project;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> projectHierarchy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String projectQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String siteQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String topLevelProjectQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            TableauFlow.TableauFlowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final TableauFlow instance, final TableauFlow.TableauFlowBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputFields(instance.inputFields == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.inputFields);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFields(instance.outputFields == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.outputFields);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.outputSteps(instance.outputSteps == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.outputSteps);
            b.project(instance.project);
            b.projectHierarchy(instance.projectHierarchy == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.projectHierarchy);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
        }

        /**
         * Fixed typeName for TableauFlows.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputField(final Map<String, String> inputField) {
            if (this.inputFields == null) this.inputFields = new java.util.ArrayList<Map<String, String>>();
            this.inputFields.add(inputField);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputFields(final java.util.Collection<? extends Map<String, String>> inputFields) {
            if (inputFields == null) {
                throw new java.lang.NullPointerException("inputFields cannot be null");
            }
            if (this.inputFields == null) this.inputFields = new java.util.ArrayList<Map<String, String>>();
            this.inputFields.addAll(inputFields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputFields() {
            if (this.inputFields != null) this.inputFields.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputField(final Map<String, String> outputField) {
            if (this.outputFields == null) this.outputFields = new java.util.ArrayList<Map<String, String>>();
            this.outputFields.add(outputField);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFields(final java.util.Collection<? extends Map<String, String>> outputFields) {
            if (outputFields == null) {
                throw new java.lang.NullPointerException("outputFields cannot be null");
            }
            if (this.outputFields == null) this.outputFields = new java.util.ArrayList<Map<String, String>>();
            this.outputFields.addAll(outputFields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFields() {
            if (this.outputFields != null) this.outputFields.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputStep(final Map<String, String> outputStep) {
            if (this.outputSteps == null) this.outputSteps = new java.util.ArrayList<Map<String, String>>();
            this.outputSteps.add(outputStep);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputSteps(final java.util.Collection<? extends Map<String, String>> outputSteps) {
            if (outputSteps == null) {
                throw new java.lang.NullPointerException("outputSteps cannot be null");
            }
            if (this.outputSteps == null) this.outputSteps = new java.util.ArrayList<Map<String, String>>();
            this.outputSteps.addAll(outputSteps);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputSteps() {
            if (this.outputSteps != null) this.outputSteps.clear();
            return self();
        }

        /**
         * Project in which this flow exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B project(final ITableauProject project) {
            this.project = project;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addProjectHierarchy(final Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) this.projectHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.projectHierarchy.add(addProjectHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B projectHierarchy(final java.util.Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new java.lang.NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) this.projectHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.projectHierarchy.addAll(projectHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) this.projectHierarchy.clear();
            return self();
        }

        /**
         * Unique name of the project in which this flow exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B projectQualifiedName(final String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return self();
        }

        /**
         * Unique name of the site in which this flow exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B siteQualifiedName(final String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return self();
        }

        /**
         * Unique name of the top-level project in which this flow exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B topLevelProjectQualifiedName(final String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TableauFlow.TableauFlowBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputFields=" + this.inputFields + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFields=" + this.outputFields + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", outputSteps=" + this.outputSteps + ", project=" + this.project + ", projectHierarchy=" + this.projectHierarchy + ", projectQualifiedName=" + this.projectQualifiedName + ", siteQualifiedName=" + this.siteQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class TableauFlowBuilderImpl extends TableauFlow.TableauFlowBuilder<TableauFlow, TableauFlow.TableauFlowBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TableauFlowBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected TableauFlow.TableauFlowBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TableauFlow build() {
            return new TableauFlow(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected TableauFlow(final TableauFlow.TableauFlowBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = TableauFlow.$default$typeName();
        java.util.List<Map<String, String>> inputFields;
        switch (b.inputFields == null ? 0 : b.inputFields.size()) {
        case 0: 
            inputFields = java.util.Collections.emptyList();
            break;
        case 1: 
            inputFields = java.util.Collections.singletonList(b.inputFields.get(0));
            break;
        default: 
            inputFields = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.inputFields));
        }
        this.inputFields = inputFields;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.List<Map<String, String>> outputFields;
        switch (b.outputFields == null ? 0 : b.outputFields.size()) {
        case 0: 
            outputFields = java.util.Collections.emptyList();
            break;
        case 1: 
            outputFields = java.util.Collections.singletonList(b.outputFields.get(0));
            break;
        default: 
            outputFields = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.outputFields));
        }
        this.outputFields = outputFields;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.List<Map<String, String>> outputSteps;
        switch (b.outputSteps == null ? 0 : b.outputSteps.size()) {
        case 0: 
            outputSteps = java.util.Collections.emptyList();
            break;
        case 1: 
            outputSteps = java.util.Collections.singletonList(b.outputSteps.get(0));
            break;
        default: 
            outputSteps = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.outputSteps));
        }
        this.outputSteps = outputSteps;
        this.project = b.project;
        java.util.List<Map<String, String>> projectHierarchy;
        switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
        case 0: 
            projectHierarchy = java.util.Collections.emptyList();
            break;
        case 1: 
            projectHierarchy = java.util.Collections.singletonList(b.projectHierarchy.get(0));
            break;
        default: 
            projectHierarchy = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.projectHierarchy));
        }
        this.projectHierarchy = projectHierarchy;
        this.projectQualifiedName = b.projectQualifiedName;
        this.siteQualifiedName = b.siteQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static TableauFlow.TableauFlowBuilder<?, ?> _internal() {
        return new TableauFlow.TableauFlowBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TableauFlow.TableauFlowBuilder<?, ?> toBuilder() {
        return new TableauFlow.TableauFlowBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * List of fields that are inputs to this flow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getInputFields() {
        return this.inputFields;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * List of fields that are outputs from this flow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getOutputFields() {
        return this.outputFields;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * List of steps that are outputs from this flow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getOutputSteps() {
        return this.outputSteps;
    }

    /**
     * Project in which this flow exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ITableauProject getProject() {
        return this.project;
    }

    /**
     * List of top-level projects with their nested child projects.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    /**
     * Unique name of the project in which this flow exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    /**
     * Unique name of the site in which this flow exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    /**
     * Unique name of the top-level project in which this flow exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TableauFlow)) return false;
        final TableauFlow other = (TableauFlow) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputFields = this.getInputFields();
        final java.lang.Object other$inputFields = other.getInputFields();
        if (this$inputFields == null ? other$inputFields != null : !this$inputFields.equals(other$inputFields)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFields = this.getOutputFields();
        final java.lang.Object other$outputFields = other.getOutputFields();
        if (this$outputFields == null ? other$outputFields != null : !this$outputFields.equals(other$outputFields)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$outputSteps = this.getOutputSteps();
        final java.lang.Object other$outputSteps = other.getOutputSteps();
        if (this$outputSteps == null ? other$outputSteps != null : !this$outputSteps.equals(other$outputSteps)) return false;
        final java.lang.Object this$project = this.getProject();
        final java.lang.Object other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) return false;
        final java.lang.Object this$projectHierarchy = this.getProjectHierarchy();
        final java.lang.Object other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !this$projectHierarchy.equals(other$projectHierarchy)) return false;
        final java.lang.Object this$projectQualifiedName = this.getProjectQualifiedName();
        final java.lang.Object other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) return false;
        final java.lang.Object this$siteQualifiedName = this.getSiteQualifiedName();
        final java.lang.Object other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) return false;
        final java.lang.Object this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        final java.lang.Object other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TableauFlow;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputFields = this.getInputFields();
        result = result * PRIME + ($inputFields == null ? 43 : $inputFields.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFields = this.getOutputFields();
        result = result * PRIME + ($outputFields == null ? 43 : $outputFields.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $outputSteps = this.getOutputSteps();
        result = result * PRIME + ($outputSteps == null ? 43 : $outputSteps.hashCode());
        final java.lang.Object $project = this.getProject();
        result = result * PRIME + ($project == null ? 43 : $project.hashCode());
        final java.lang.Object $projectHierarchy = this.getProjectHierarchy();
        result = result * PRIME + ($projectHierarchy == null ? 43 : $projectHierarchy.hashCode());
        final java.lang.Object $projectQualifiedName = this.getProjectQualifiedName();
        result = result * PRIME + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        final java.lang.Object $siteQualifiedName = this.getSiteQualifiedName();
        result = result * PRIME + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        final java.lang.Object $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * PRIME + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TableauFlow(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputFields=" + this.getInputFields() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFields=" + this.getOutputFields() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", outputSteps=" + this.getOutputSteps() + ", project=" + this.getProject() + ", projectHierarchy=" + this.getProjectHierarchy() + ", projectQualifiedName=" + this.getProjectQualifiedName() + ", siteQualifiedName=" + this.getSiteQualifiedName() + ", topLevelProjectQualifiedName=" + this.getTopLevelProjectQualifiedName() + ")";
    }

    /**
     * Fixed typeName for TableauFlows.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
