// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Represents Source tag association asset
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class TagAttachment extends Asset implements ITagAttachment, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(TagAttachment.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TagAttachment";
    /**
     * Fixed typeName for TagAttachments.
     */
    String typeName;
    /**
     * Represents associated tag value
     */
    @Attribute
    String tagAttachmentStringValue;
    /**
     * Represents associated source tag's qualified name
     */
    @Attribute
    String tagQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a TagAttachment, from a potentially
     * more-complete TagAttachment object.
     *
     * @return the minimal object necessary to relate to the TagAttachment
     * @throws InvalidRequestException if any of the minimal set of required properties for a TagAttachment relationship are not found in the initial object
     */
    @Override
    public TagAttachment trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all TagAttachment assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TagAttachment assets will be included.
     *
     * @return a fluent search that includes all TagAttachment assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all TagAttachment assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) TagAttachment assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all TagAttachment assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all TagAttachment assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) TagAttachments will be included
     * @return a fluent search that includes all TagAttachment assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all TagAttachment assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) TagAttachments will be included
     * @return a fluent search that includes all TagAttachment assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a TagAttachment by GUID. Use this to create a relationship to this TagAttachment,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the TagAttachment to reference
     * @return reference to a TagAttachment that can be used for defining a relationship to a TagAttachment
     */
    public static TagAttachment refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TagAttachment by GUID. Use this to create a relationship to this TagAttachment,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the TagAttachment to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TagAttachment that can be used for defining a relationship to a TagAttachment
     */
    public static TagAttachment refByGuid(String guid, Reference.SaveSemantic semantic) {
        return TagAttachment._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a TagAttachment by qualifiedName. Use this to create a relationship to this TagAttachment,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the TagAttachment to reference
     * @return reference to a TagAttachment that can be used for defining a relationship to a TagAttachment
     */
    public static TagAttachment refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a TagAttachment by qualifiedName. Use this to create a relationship to this TagAttachment,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the TagAttachment to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a TagAttachment that can be used for defining a relationship to a TagAttachment
     */
    public static TagAttachment refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return TagAttachment._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a TagAttachment by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the TagAttachment to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TagAttachment, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TagAttachment does not exist or the provided GUID is not a TagAttachment
     */
    @JsonIgnore
    public static TagAttachment get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a TagAttachment by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TagAttachment to retrieve, either its GUID or its full qualifiedName
     * @return the requested full TagAttachment, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TagAttachment does not exist or the provided GUID is not a TagAttachment
     */
    @JsonIgnore
    public static TagAttachment get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a TagAttachment by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the TagAttachment to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full TagAttachment, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the TagAttachment does not exist or the provided GUID is not a TagAttachment
     */
    @JsonIgnore
    public static TagAttachment get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof TagAttachment) {
                return (TagAttachment) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof TagAttachment) {
                return (TagAttachment) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) TagAttachment to active.
     *
     * @param qualifiedName for the TagAttachment
     * @return true if the TagAttachment is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) TagAttachment to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the TagAttachment
     * @return true if the TagAttachment is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a TagAttachment.
     *
     * @param qualifiedName of the TagAttachment
     * @param name of the TagAttachment
     * @return the minimal request necessary to update the TagAttachment, as a builder
     */
    public static TagAttachmentBuilder<?, ?> updater(String qualifiedName, String name) {
        return TagAttachment._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a TagAttachment, from a potentially
     * more-complete TagAttachment object.
     *
     * @return the minimal object necessary to update the TagAttachment, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for TagAttachment are not found in the initial object
     */
    @Override
    public TagAttachmentBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a TagAttachment.
     *
     * @param qualifiedName of the TagAttachment
     * @param name of the TagAttachment
     * @return the updated TagAttachment, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a TagAttachment.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TagAttachment
     * @param name of the TagAttachment
     * @return the updated TagAttachment, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TagAttachment) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a TagAttachment.
     *
     * @param qualifiedName of the TagAttachment
     * @param name of the TagAttachment
     * @return the updated TagAttachment, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a TagAttachment.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the TagAttachment
     * @param name of the TagAttachment
     * @return the updated TagAttachment, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TagAttachment) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a TagAttachment.
     *
     * @param qualifiedName of the TagAttachment
     * @param name of the TagAttachment
     * @return the updated TagAttachment, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a TagAttachment.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TagAttachment's owners
     * @param qualifiedName of the TagAttachment
     * @param name of the TagAttachment
     * @return the updated TagAttachment, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TagAttachment) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a TagAttachment.
     *
     * @param qualifiedName of the TagAttachment
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TagAttachment, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a TagAttachment.
     *
     * @param client connectivity to the Atlan tenant on which to update the TagAttachment's certificate
     * @param qualifiedName of the TagAttachment
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated TagAttachment, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TagAttachment) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a TagAttachment.
     *
     * @param qualifiedName of the TagAttachment
     * @param name of the TagAttachment
     * @return the updated TagAttachment, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a TagAttachment.
     *
     * @param client connectivity to the Atlan tenant from which to remove the TagAttachment's certificate
     * @param qualifiedName of the TagAttachment
     * @param name of the TagAttachment
     * @return the updated TagAttachment, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TagAttachment) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a TagAttachment.
     *
     * @param qualifiedName of the TagAttachment
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a TagAttachment.
     *
     * @param client connectivity to the Atlan tenant on which to update the TagAttachment's announcement
     * @param qualifiedName of the TagAttachment
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TagAttachment) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a TagAttachment.
     *
     * @param qualifiedName of the TagAttachment
     * @param name of the TagAttachment
     * @return the updated TagAttachment, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a TagAttachment.
     *
     * @param client connectivity to the Atlan client from which to remove the TagAttachment's announcement
     * @param qualifiedName of the TagAttachment
     * @param name of the TagAttachment
     * @return the updated TagAttachment, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TagAttachment) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the TagAttachment.
     *
     * @param qualifiedName for the TagAttachment
     * @param name human-readable name of the TagAttachment
     * @param terms the list of terms to replace on the TagAttachment, or null to remove all terms from the TagAttachment
     * @return the TagAttachment that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TagAttachment replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the TagAttachment.
     *
     * @param client connectivity to the Atlan tenant on which to replace the TagAttachment's assigned terms
     * @param qualifiedName for the TagAttachment
     * @param name human-readable name of the TagAttachment
     * @param terms the list of terms to replace on the TagAttachment, or null to remove all terms from the TagAttachment
     * @return the TagAttachment that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static TagAttachment replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TagAttachment) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the TagAttachment, without replacing existing terms linked to the TagAttachment.
     * Note: this operation must make two API calls — one to retrieve the TagAttachment's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the TagAttachment
     * @param terms the list of terms to append to the TagAttachment
     * @return the TagAttachment that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TagAttachment appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the TagAttachment, without replacing existing terms linked to the TagAttachment.
     * Note: this operation must make two API calls — one to retrieve the TagAttachment's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the TagAttachment
     * @param qualifiedName for the TagAttachment
     * @param terms the list of terms to append to the TagAttachment
     * @return the TagAttachment that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static TagAttachment appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TagAttachment) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a TagAttachment, without replacing all existing terms linked to the TagAttachment.
     * Note: this operation must make two API calls — one to retrieve the TagAttachment's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the TagAttachment
     * @param terms the list of terms to remove from the TagAttachment, which must be referenced by GUID
     * @return the TagAttachment that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a TagAttachment, without replacing all existing terms linked to the TagAttachment.
     * Note: this operation must make two API calls — one to retrieve the TagAttachment's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the TagAttachment
     * @param qualifiedName for the TagAttachment
     * @param terms the list of terms to remove from the TagAttachment, which must be referenced by GUID
     * @return the TagAttachment that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static TagAttachment removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TagAttachment) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a TagAttachment, without replacing existing Atlan tags linked to the TagAttachment.
     * Note: this operation must make two API calls — one to retrieve the TagAttachment's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TagAttachment
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TagAttachment
     */
    public static TagAttachment appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TagAttachment, without replacing existing Atlan tags linked to the TagAttachment.
     * Note: this operation must make two API calls — one to retrieve the TagAttachment's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TagAttachment
     * @param qualifiedName of the TagAttachment
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated TagAttachment
     */
    public static TagAttachment appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TagAttachment) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a TagAttachment, without replacing existing Atlan tags linked to the TagAttachment.
     * Note: this operation must make two API calls — one to retrieve the TagAttachment's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the TagAttachment
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TagAttachment
     */
    public static TagAttachment appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a TagAttachment, without replacing existing Atlan tags linked to the TagAttachment.
     * Note: this operation must make two API calls — one to retrieve the TagAttachment's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the TagAttachment
     * @param qualifiedName of the TagAttachment
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated TagAttachment
     */
    public static TagAttachment appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TagAttachment) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a TagAttachment.
     *
     * @param qualifiedName of the TagAttachment
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TagAttachment
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a TagAttachment.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a TagAttachment
     * @param qualifiedName of the TagAttachment
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the TagAttachment
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class TagAttachmentBuilder<C extends TagAttachment, B extends TagAttachment.TagAttachmentBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tagAttachmentStringValue;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tagQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            TagAttachment.TagAttachmentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final TagAttachment instance, final TagAttachment.TagAttachmentBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.tagAttachmentStringValue(instance.tagAttachmentStringValue);
            b.tagQualifiedName(instance.tagQualifiedName);
        }

        /**
         * Fixed typeName for TagAttachments.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Represents associated tag value
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tagAttachmentStringValue(final String tagAttachmentStringValue) {
            this.tagAttachmentStringValue = tagAttachmentStringValue;
            return self();
        }

        /**
         * Represents associated source tag's qualified name
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tagQualifiedName(final String tagQualifiedName) {
            this.tagQualifiedName = tagQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TagAttachment.TagAttachmentBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", tagAttachmentStringValue=" + this.tagAttachmentStringValue + ", tagQualifiedName=" + this.tagQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class TagAttachmentBuilderImpl extends TagAttachment.TagAttachmentBuilder<TagAttachment, TagAttachment.TagAttachmentBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TagAttachmentBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected TagAttachment.TagAttachmentBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TagAttachment build() {
            return new TagAttachment(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected TagAttachment(final TagAttachment.TagAttachmentBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = TagAttachment.$default$typeName();
        this.tagAttachmentStringValue = b.tagAttachmentStringValue;
        this.tagQualifiedName = b.tagQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static TagAttachment.TagAttachmentBuilder<?, ?> _internal() {
        return new TagAttachment.TagAttachmentBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TagAttachment.TagAttachmentBuilder<?, ?> toBuilder() {
        return new TagAttachment.TagAttachmentBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Represents associated tag value
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTagAttachmentStringValue() {
        return this.tagAttachmentStringValue;
    }

    /**
     * Represents associated source tag's qualified name
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTagQualifiedName() {
        return this.tagQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TagAttachment)) return false;
        final TagAttachment other = (TagAttachment) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$tagAttachmentStringValue = this.getTagAttachmentStringValue();
        final java.lang.Object other$tagAttachmentStringValue = other.getTagAttachmentStringValue();
        if (this$tagAttachmentStringValue == null ? other$tagAttachmentStringValue != null : !this$tagAttachmentStringValue.equals(other$tagAttachmentStringValue)) return false;
        final java.lang.Object this$tagQualifiedName = this.getTagQualifiedName();
        final java.lang.Object other$tagQualifiedName = other.getTagQualifiedName();
        if (this$tagQualifiedName == null ? other$tagQualifiedName != null : !this$tagQualifiedName.equals(other$tagQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TagAttachment;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $tagAttachmentStringValue = this.getTagAttachmentStringValue();
        result = result * PRIME + ($tagAttachmentStringValue == null ? 43 : $tagAttachmentStringValue.hashCode());
        final java.lang.Object $tagQualifiedName = this.getTagQualifiedName();
        result = result * PRIME + ($tagQualifiedName == null ? 43 : $tagQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TagAttachment(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", tagAttachmentStringValue=" + this.getTagAttachmentStringValue() + ", tagQualifiedName=" + this.getTagQualifiedName() + ")";
    }

    /**
     * Fixed typeName for TagAttachments.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
