// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.Action;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Task for user in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class Task extends Asset implements ITask, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Task.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Task";
    /**
     * Fixed typeName for Tasks.
     */
    String typeName;
    /**
     * List of actions associated with this task.
     */
    @Attribute
    List<Action> taskActions;
    /**
     * username of the user who created this task
     */
    @Attribute
    String taskCreatedBy;
    /**
     * action executed by the recipient
     */
    @Attribute
    String taskExecutionAction;
    /**
     * comment for the action executed by user
     */
    @Attribute
    String taskExecutionComment;
    /**
     * Time (epoch) at which the task expires .
     */
    @Attribute
    @Date
    Long taskExpiresAt;
    /**
     * flag to make task read/unread
     */
    @Attribute
    Boolean taskIsRead;
    /**
     * contains the payload that is proposed to the task
     */
    @Attribute
    String taskProposals;
    /**
     * recipient of the task
     */
    @Attribute
    String taskRecipient;
    /**
     * assetId to preview
     */
    @Attribute
    String taskRelatedAssetGuid;
    /**
     * requestor of the task
     */
    @Attribute
    String taskRequestor;
    /**
     * comment of requestor for the task
     */
    @Attribute
    String taskRequestorComment;
    /**
     * type of task
     */
    @Attribute
    String taskType;
    /**
     * username of the user who updated this task
     */
    @Attribute
    String taskUpdatedBy;

    /**
     * Builds the minimal object necessary to create a relationship to a Task, from a potentially
     * more-complete Task object.
     *
     * @return the minimal object necessary to relate to the Task
     * @throws InvalidRequestException if any of the minimal set of required properties for a Task relationship are not found in the initial object
     */
    @Override
    public Task trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all Task assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Task assets will be included.
     *
     * @return a fluent search that includes all Task assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all Task assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Task assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all Task assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all Task assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) Tasks will be included
     * @return a fluent search that includes all Task assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all Task assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) Tasks will be included
     * @return a fluent search that includes all Task assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a Task by GUID. Use this to create a relationship to this Task,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the Task to reference
     * @return reference to a Task that can be used for defining a relationship to a Task
     */
    public static Task refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Task by GUID. Use this to create a relationship to this Task,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the Task to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Task that can be used for defining a relationship to a Task
     */
    public static Task refByGuid(String guid, Reference.SaveSemantic semantic) {
        return Task._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a Task by qualifiedName. Use this to create a relationship to this Task,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the Task to reference
     * @return reference to a Task that can be used for defining a relationship to a Task
     */
    public static Task refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Task by qualifiedName. Use this to create a relationship to this Task,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the Task to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Task that can be used for defining a relationship to a Task
     */
    public static Task refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return Task._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a Task by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the Task to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Task, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Task does not exist or the provided GUID is not a Task
     */
    @JsonIgnore
    public static Task get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a Task by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Task to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Task, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Task does not exist or the provided GUID is not a Task
     */
    @JsonIgnore
    public static Task get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a Task by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Task to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full Task, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Task does not exist or the provided GUID is not a Task
     */
    @JsonIgnore
    public static Task get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof Task) {
                return (Task) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof Task) {
                return (Task) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) Task to active.
     *
     * @param qualifiedName for the Task
     * @return true if the Task is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) Task to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the Task
     * @return true if the Task is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a Task.
     *
     * @param qualifiedName of the Task
     * @param name of the Task
     * @return the minimal request necessary to update the Task, as a builder
     */
    public static TaskBuilder<?, ?> updater(String qualifiedName, String name) {
        return Task._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a Task, from a potentially
     * more-complete Task object.
     *
     * @return the minimal object necessary to update the Task, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for Task are not found in the initial object
     */
    @Override
    public TaskBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a Task.
     *
     * @param qualifiedName of the Task
     * @param name of the Task
     * @return the updated Task, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Task removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a Task.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Task
     * @param name of the Task
     * @return the updated Task, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Task removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Task) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a Task.
     *
     * @param qualifiedName of the Task
     * @param name of the Task
     * @return the updated Task, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Task removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a Task.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Task
     * @param name of the Task
     * @return the updated Task, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Task removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Task) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a Task.
     *
     * @param qualifiedName of the Task
     * @param name of the Task
     * @return the updated Task, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Task removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a Task.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Task's owners
     * @param qualifiedName of the Task
     * @param name of the Task
     * @return the updated Task, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Task removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Task) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a Task.
     *
     * @param qualifiedName of the Task
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Task, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Task updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a Task.
     *
     * @param client connectivity to the Atlan tenant on which to update the Task's certificate
     * @param qualifiedName of the Task
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Task, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Task updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Task) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a Task.
     *
     * @param qualifiedName of the Task
     * @param name of the Task
     * @return the updated Task, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Task removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a Task.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Task's certificate
     * @param qualifiedName of the Task
     * @param name of the Task
     * @return the updated Task, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Task removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Task) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a Task.
     *
     * @param qualifiedName of the Task
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Task updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a Task.
     *
     * @param client connectivity to the Atlan tenant on which to update the Task's announcement
     * @param qualifiedName of the Task
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Task updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Task) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a Task.
     *
     * @param qualifiedName of the Task
     * @param name of the Task
     * @return the updated Task, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Task removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a Task.
     *
     * @param client connectivity to the Atlan client from which to remove the Task's announcement
     * @param qualifiedName of the Task
     * @param name of the Task
     * @return the updated Task, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Task removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Task) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the Task.
     *
     * @param qualifiedName for the Task
     * @param name human-readable name of the Task
     * @param terms the list of terms to replace on the Task, or null to remove all terms from the Task
     * @return the Task that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Task replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the Task.
     *
     * @param client connectivity to the Atlan tenant on which to replace the Task's assigned terms
     * @param qualifiedName for the Task
     * @param name human-readable name of the Task
     * @param terms the list of terms to replace on the Task, or null to remove all terms from the Task
     * @return the Task that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Task replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Task) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the Task, without replacing existing terms linked to the Task.
     * Note: this operation must make two API calls — one to retrieve the Task's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the Task
     * @param terms the list of terms to append to the Task
     * @return the Task that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Task appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the Task, without replacing existing terms linked to the Task.
     * Note: this operation must make two API calls — one to retrieve the Task's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the Task
     * @param qualifiedName for the Task
     * @param terms the list of terms to append to the Task
     * @return the Task that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Task appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Task) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a Task, without replacing all existing terms linked to the Task.
     * Note: this operation must make two API calls — one to retrieve the Task's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the Task
     * @param terms the list of terms to remove from the Task, which must be referenced by GUID
     * @return the Task that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Task removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a Task, without replacing all existing terms linked to the Task.
     * Note: this operation must make two API calls — one to retrieve the Task's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the Task
     * @param qualifiedName for the Task
     * @param terms the list of terms to remove from the Task, which must be referenced by GUID
     * @return the Task that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Task removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Task) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a Task, without replacing existing Atlan tags linked to the Task.
     * Note: this operation must make two API calls — one to retrieve the Task's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Task
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Task
     */
    public static Task appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Task, without replacing existing Atlan tags linked to the Task.
     * Note: this operation must make two API calls — one to retrieve the Task's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Task
     * @param qualifiedName of the Task
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Task
     */
    public static Task appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Task) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Task, without replacing existing Atlan tags linked to the Task.
     * Note: this operation must make two API calls — one to retrieve the Task's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Task
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Task
     */
    public static Task appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a Task, without replacing existing Atlan tags linked to the Task.
     * Note: this operation must make two API calls — one to retrieve the Task's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Task
     * @param qualifiedName of the Task
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Task
     */
    public static Task appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Task) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a Task.
     *
     * @param qualifiedName of the Task
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Task
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a Task.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a Task
     * @param qualifiedName of the Task
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Task
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class TaskBuilder<C extends Task, B extends Task.TaskBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Action> taskActions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String taskCreatedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String taskExecutionAction;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String taskExecutionComment;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long taskExpiresAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean taskIsRead;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String taskProposals;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String taskRecipient;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String taskRelatedAssetGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String taskRequestor;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String taskRequestorComment;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String taskType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String taskUpdatedBy;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Task.TaskBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Task instance, final Task.TaskBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.taskActions(instance.taskActions == null ? java.util.Collections.<Action>emptyList() : instance.taskActions);
            b.taskCreatedBy(instance.taskCreatedBy);
            b.taskExecutionAction(instance.taskExecutionAction);
            b.taskExecutionComment(instance.taskExecutionComment);
            b.taskExpiresAt(instance.taskExpiresAt);
            b.taskIsRead(instance.taskIsRead);
            b.taskProposals(instance.taskProposals);
            b.taskRecipient(instance.taskRecipient);
            b.taskRelatedAssetGuid(instance.taskRelatedAssetGuid);
            b.taskRequestor(instance.taskRequestor);
            b.taskRequestorComment(instance.taskRequestorComment);
            b.taskType(instance.taskType);
            b.taskUpdatedBy(instance.taskUpdatedBy);
        }

        /**
         * Fixed typeName for Tasks.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskAction(final Action taskAction) {
            if (this.taskActions == null) this.taskActions = new java.util.ArrayList<Action>();
            this.taskActions.add(taskAction);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskActions(final java.util.Collection<? extends Action> taskActions) {
            if (taskActions == null) {
                throw new java.lang.NullPointerException("taskActions cannot be null");
            }
            if (this.taskActions == null) this.taskActions = new java.util.ArrayList<Action>();
            this.taskActions.addAll(taskActions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTaskActions() {
            if (this.taskActions != null) this.taskActions.clear();
            return self();
        }

        /**
         * username of the user who created this task
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskCreatedBy(final String taskCreatedBy) {
            this.taskCreatedBy = taskCreatedBy;
            return self();
        }

        /**
         * action executed by the recipient
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskExecutionAction(final String taskExecutionAction) {
            this.taskExecutionAction = taskExecutionAction;
            return self();
        }

        /**
         * comment for the action executed by user
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskExecutionComment(final String taskExecutionComment) {
            this.taskExecutionComment = taskExecutionComment;
            return self();
        }

        /**
         * Time (epoch) at which the task expires .
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskExpiresAt(final Long taskExpiresAt) {
            this.taskExpiresAt = taskExpiresAt;
            return self();
        }

        /**
         * flag to make task read/unread
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskIsRead(final Boolean taskIsRead) {
            this.taskIsRead = taskIsRead;
            return self();
        }

        /**
         * contains the payload that is proposed to the task
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskProposals(final String taskProposals) {
            this.taskProposals = taskProposals;
            return self();
        }

        /**
         * recipient of the task
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskRecipient(final String taskRecipient) {
            this.taskRecipient = taskRecipient;
            return self();
        }

        /**
         * assetId to preview
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskRelatedAssetGuid(final String taskRelatedAssetGuid) {
            this.taskRelatedAssetGuid = taskRelatedAssetGuid;
            return self();
        }

        /**
         * requestor of the task
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskRequestor(final String taskRequestor) {
            this.taskRequestor = taskRequestor;
            return self();
        }

        /**
         * comment of requestor for the task
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskRequestorComment(final String taskRequestorComment) {
            this.taskRequestorComment = taskRequestorComment;
            return self();
        }

        /**
         * type of task
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskType(final String taskType) {
            this.taskType = taskType;
            return self();
        }

        /**
         * username of the user who updated this task
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B taskUpdatedBy(final String taskUpdatedBy) {
            this.taskUpdatedBy = taskUpdatedBy;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Task.TaskBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", taskActions=" + this.taskActions + ", taskCreatedBy=" + this.taskCreatedBy + ", taskExecutionAction=" + this.taskExecutionAction + ", taskExecutionComment=" + this.taskExecutionComment + ", taskExpiresAt=" + this.taskExpiresAt + ", taskIsRead=" + this.taskIsRead + ", taskProposals=" + this.taskProposals + ", taskRecipient=" + this.taskRecipient + ", taskRelatedAssetGuid=" + this.taskRelatedAssetGuid + ", taskRequestor=" + this.taskRequestor + ", taskRequestorComment=" + this.taskRequestorComment + ", taskType=" + this.taskType + ", taskUpdatedBy=" + this.taskUpdatedBy + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class TaskBuilderImpl extends Task.TaskBuilder<Task, Task.TaskBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TaskBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Task.TaskBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Task build() {
            return new Task(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Task(final Task.TaskBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = Task.$default$typeName();
        java.util.List<Action> taskActions;
        switch (b.taskActions == null ? 0 : b.taskActions.size()) {
        case 0: 
            taskActions = java.util.Collections.emptyList();
            break;
        case 1: 
            taskActions = java.util.Collections.singletonList(b.taskActions.get(0));
            break;
        default: 
            taskActions = java.util.Collections.unmodifiableList(new java.util.ArrayList<Action>(b.taskActions));
        }
        this.taskActions = taskActions;
        this.taskCreatedBy = b.taskCreatedBy;
        this.taskExecutionAction = b.taskExecutionAction;
        this.taskExecutionComment = b.taskExecutionComment;
        this.taskExpiresAt = b.taskExpiresAt;
        this.taskIsRead = b.taskIsRead;
        this.taskProposals = b.taskProposals;
        this.taskRecipient = b.taskRecipient;
        this.taskRelatedAssetGuid = b.taskRelatedAssetGuid;
        this.taskRequestor = b.taskRequestor;
        this.taskRequestorComment = b.taskRequestorComment;
        this.taskType = b.taskType;
        this.taskUpdatedBy = b.taskUpdatedBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Task.TaskBuilder<?, ?> _internal() {
        return new Task.TaskBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Task.TaskBuilder<?, ?> toBuilder() {
        return new Task.TaskBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * List of actions associated with this task.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Action> getTaskActions() {
        return this.taskActions;
    }

    /**
     * username of the user who created this task
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaskCreatedBy() {
        return this.taskCreatedBy;
    }

    /**
     * action executed by the recipient
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaskExecutionAction() {
        return this.taskExecutionAction;
    }

    /**
     * comment for the action executed by user
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaskExecutionComment() {
        return this.taskExecutionComment;
    }

    /**
     * Time (epoch) at which the task expires .
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTaskExpiresAt() {
        return this.taskExpiresAt;
    }

    /**
     * flag to make task read/unread
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getTaskIsRead() {
        return this.taskIsRead;
    }

    /**
     * contains the payload that is proposed to the task
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaskProposals() {
        return this.taskProposals;
    }

    /**
     * recipient of the task
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaskRecipient() {
        return this.taskRecipient;
    }

    /**
     * assetId to preview
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaskRelatedAssetGuid() {
        return this.taskRelatedAssetGuid;
    }

    /**
     * requestor of the task
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaskRequestor() {
        return this.taskRequestor;
    }

    /**
     * comment of requestor for the task
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaskRequestorComment() {
        return this.taskRequestorComment;
    }

    /**
     * type of task
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaskType() {
        return this.taskType;
    }

    /**
     * username of the user who updated this task
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaskUpdatedBy() {
        return this.taskUpdatedBy;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Task)) return false;
        final Task other = (Task) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$taskExpiresAt = this.getTaskExpiresAt();
        final java.lang.Object other$taskExpiresAt = other.getTaskExpiresAt();
        if (this$taskExpiresAt == null ? other$taskExpiresAt != null : !this$taskExpiresAt.equals(other$taskExpiresAt)) return false;
        final java.lang.Object this$taskIsRead = this.getTaskIsRead();
        final java.lang.Object other$taskIsRead = other.getTaskIsRead();
        if (this$taskIsRead == null ? other$taskIsRead != null : !this$taskIsRead.equals(other$taskIsRead)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$taskActions = this.getTaskActions();
        final java.lang.Object other$taskActions = other.getTaskActions();
        if (this$taskActions == null ? other$taskActions != null : !this$taskActions.equals(other$taskActions)) return false;
        final java.lang.Object this$taskCreatedBy = this.getTaskCreatedBy();
        final java.lang.Object other$taskCreatedBy = other.getTaskCreatedBy();
        if (this$taskCreatedBy == null ? other$taskCreatedBy != null : !this$taskCreatedBy.equals(other$taskCreatedBy)) return false;
        final java.lang.Object this$taskExecutionAction = this.getTaskExecutionAction();
        final java.lang.Object other$taskExecutionAction = other.getTaskExecutionAction();
        if (this$taskExecutionAction == null ? other$taskExecutionAction != null : !this$taskExecutionAction.equals(other$taskExecutionAction)) return false;
        final java.lang.Object this$taskExecutionComment = this.getTaskExecutionComment();
        final java.lang.Object other$taskExecutionComment = other.getTaskExecutionComment();
        if (this$taskExecutionComment == null ? other$taskExecutionComment != null : !this$taskExecutionComment.equals(other$taskExecutionComment)) return false;
        final java.lang.Object this$taskProposals = this.getTaskProposals();
        final java.lang.Object other$taskProposals = other.getTaskProposals();
        if (this$taskProposals == null ? other$taskProposals != null : !this$taskProposals.equals(other$taskProposals)) return false;
        final java.lang.Object this$taskRecipient = this.getTaskRecipient();
        final java.lang.Object other$taskRecipient = other.getTaskRecipient();
        if (this$taskRecipient == null ? other$taskRecipient != null : !this$taskRecipient.equals(other$taskRecipient)) return false;
        final java.lang.Object this$taskRelatedAssetGuid = this.getTaskRelatedAssetGuid();
        final java.lang.Object other$taskRelatedAssetGuid = other.getTaskRelatedAssetGuid();
        if (this$taskRelatedAssetGuid == null ? other$taskRelatedAssetGuid != null : !this$taskRelatedAssetGuid.equals(other$taskRelatedAssetGuid)) return false;
        final java.lang.Object this$taskRequestor = this.getTaskRequestor();
        final java.lang.Object other$taskRequestor = other.getTaskRequestor();
        if (this$taskRequestor == null ? other$taskRequestor != null : !this$taskRequestor.equals(other$taskRequestor)) return false;
        final java.lang.Object this$taskRequestorComment = this.getTaskRequestorComment();
        final java.lang.Object other$taskRequestorComment = other.getTaskRequestorComment();
        if (this$taskRequestorComment == null ? other$taskRequestorComment != null : !this$taskRequestorComment.equals(other$taskRequestorComment)) return false;
        final java.lang.Object this$taskType = this.getTaskType();
        final java.lang.Object other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType)) return false;
        final java.lang.Object this$taskUpdatedBy = this.getTaskUpdatedBy();
        final java.lang.Object other$taskUpdatedBy = other.getTaskUpdatedBy();
        if (this$taskUpdatedBy == null ? other$taskUpdatedBy != null : !this$taskUpdatedBy.equals(other$taskUpdatedBy)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Task;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $taskExpiresAt = this.getTaskExpiresAt();
        result = result * PRIME + ($taskExpiresAt == null ? 43 : $taskExpiresAt.hashCode());
        final java.lang.Object $taskIsRead = this.getTaskIsRead();
        result = result * PRIME + ($taskIsRead == null ? 43 : $taskIsRead.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $taskActions = this.getTaskActions();
        result = result * PRIME + ($taskActions == null ? 43 : $taskActions.hashCode());
        final java.lang.Object $taskCreatedBy = this.getTaskCreatedBy();
        result = result * PRIME + ($taskCreatedBy == null ? 43 : $taskCreatedBy.hashCode());
        final java.lang.Object $taskExecutionAction = this.getTaskExecutionAction();
        result = result * PRIME + ($taskExecutionAction == null ? 43 : $taskExecutionAction.hashCode());
        final java.lang.Object $taskExecutionComment = this.getTaskExecutionComment();
        result = result * PRIME + ($taskExecutionComment == null ? 43 : $taskExecutionComment.hashCode());
        final java.lang.Object $taskProposals = this.getTaskProposals();
        result = result * PRIME + ($taskProposals == null ? 43 : $taskProposals.hashCode());
        final java.lang.Object $taskRecipient = this.getTaskRecipient();
        result = result * PRIME + ($taskRecipient == null ? 43 : $taskRecipient.hashCode());
        final java.lang.Object $taskRelatedAssetGuid = this.getTaskRelatedAssetGuid();
        result = result * PRIME + ($taskRelatedAssetGuid == null ? 43 : $taskRelatedAssetGuid.hashCode());
        final java.lang.Object $taskRequestor = this.getTaskRequestor();
        result = result * PRIME + ($taskRequestor == null ? 43 : $taskRequestor.hashCode());
        final java.lang.Object $taskRequestorComment = this.getTaskRequestorComment();
        result = result * PRIME + ($taskRequestorComment == null ? 43 : $taskRequestorComment.hashCode());
        final java.lang.Object $taskType = this.getTaskType();
        result = result * PRIME + ($taskType == null ? 43 : $taskType.hashCode());
        final java.lang.Object $taskUpdatedBy = this.getTaskUpdatedBy();
        result = result * PRIME + ($taskUpdatedBy == null ? 43 : $taskUpdatedBy.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Task(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", taskActions=" + this.getTaskActions() + ", taskCreatedBy=" + this.getTaskCreatedBy() + ", taskExecutionAction=" + this.getTaskExecutionAction() + ", taskExecutionComment=" + this.getTaskExecutionComment() + ", taskExpiresAt=" + this.getTaskExpiresAt() + ", taskIsRead=" + this.getTaskIsRead() + ", taskProposals=" + this.getTaskProposals() + ", taskRecipient=" + this.getTaskRecipient() + ", taskRelatedAssetGuid=" + this.getTaskRelatedAssetGuid() + ", taskRequestor=" + this.getTaskRequestor() + ", taskRequestorComment=" + this.getTaskRequestorComment() + ", taskType=" + this.getTaskType() + ", taskUpdatedBy=" + this.getTaskUpdatedBy() + ")";
    }

    /**
     * Fixed typeName for Tasks.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
