// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Thoughtspot liveboard in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class ThoughtspotLiveboard extends Asset implements IThoughtspotLiveboard, IThoughtspot, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ThoughtspotLiveboard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ThoughtspotLiveboard";
    /**
     * Fixed typeName for ThoughtspotLiveboards.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * TBC
     */
    @Attribute
    String thoughtspotChartType;
    /**
     * Number of Columns.
     */
    @Attribute
    Long thoughtspotColumnCount;
    /**
     * Dashlets that exist within this liveboard.
     */
    @Attribute
    SortedSet<IThoughtspotDashlet> thoughtspotDashlets;
    /**
     * Total number of data table joins executed for analysis.
     */
    @Attribute
    Long thoughtspotJoinCount;
    /**
     * TBC
     */
    @Attribute
    String thoughtspotQuestionText;

    /**
     * Builds the minimal object necessary to create a relationship to a ThoughtspotLiveboard, from a potentially
     * more-complete ThoughtspotLiveboard object.
     *
     * @return the minimal object necessary to relate to the ThoughtspotLiveboard
     * @throws InvalidRequestException if any of the minimal set of required properties for a ThoughtspotLiveboard relationship are not found in the initial object
     */
    @Override
    public ThoughtspotLiveboard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all ThoughtspotLiveboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ThoughtspotLiveboard assets will be included.
     *
     * @return a fluent search that includes all ThoughtspotLiveboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all ThoughtspotLiveboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ThoughtspotLiveboard assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all ThoughtspotLiveboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all ThoughtspotLiveboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) ThoughtspotLiveboards will be included
     * @return a fluent search that includes all ThoughtspotLiveboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all ThoughtspotLiveboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) ThoughtspotLiveboards will be included
     * @return a fluent search that includes all ThoughtspotLiveboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a ThoughtspotLiveboard by GUID. Use this to create a relationship to this ThoughtspotLiveboard,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the ThoughtspotLiveboard to reference
     * @return reference to a ThoughtspotLiveboard that can be used for defining a relationship to a ThoughtspotLiveboard
     */
    public static ThoughtspotLiveboard refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ThoughtspotLiveboard by GUID. Use this to create a relationship to this ThoughtspotLiveboard,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the ThoughtspotLiveboard to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ThoughtspotLiveboard that can be used for defining a relationship to a ThoughtspotLiveboard
     */
    public static ThoughtspotLiveboard refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ThoughtspotLiveboard._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a ThoughtspotLiveboard by qualifiedName. Use this to create a relationship to this ThoughtspotLiveboard,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the ThoughtspotLiveboard to reference
     * @return reference to a ThoughtspotLiveboard that can be used for defining a relationship to a ThoughtspotLiveboard
     */
    public static ThoughtspotLiveboard refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ThoughtspotLiveboard by qualifiedName. Use this to create a relationship to this ThoughtspotLiveboard,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the ThoughtspotLiveboard to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ThoughtspotLiveboard that can be used for defining a relationship to a ThoughtspotLiveboard
     */
    public static ThoughtspotLiveboard refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ThoughtspotLiveboard._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a ThoughtspotLiveboard by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the ThoughtspotLiveboard to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ThoughtspotLiveboard, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ThoughtspotLiveboard does not exist or the provided GUID is not a ThoughtspotLiveboard
     */
    @JsonIgnore
    public static ThoughtspotLiveboard get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a ThoughtspotLiveboard by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ThoughtspotLiveboard to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ThoughtspotLiveboard, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ThoughtspotLiveboard does not exist or the provided GUID is not a ThoughtspotLiveboard
     */
    @JsonIgnore
    public static ThoughtspotLiveboard get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a ThoughtspotLiveboard by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ThoughtspotLiveboard to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full ThoughtspotLiveboard, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ThoughtspotLiveboard does not exist or the provided GUID is not a ThoughtspotLiveboard
     */
    @JsonIgnore
    public static ThoughtspotLiveboard get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof ThoughtspotLiveboard) {
                return (ThoughtspotLiveboard) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof ThoughtspotLiveboard) {
                return (ThoughtspotLiveboard) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) ThoughtspotLiveboard to active.
     *
     * @param qualifiedName for the ThoughtspotLiveboard
     * @return true if the ThoughtspotLiveboard is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) ThoughtspotLiveboard to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the ThoughtspotLiveboard
     * @return true if the ThoughtspotLiveboard is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a ThoughtspotLiveboard.
     *
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param name of the ThoughtspotLiveboard
     * @return the minimal request necessary to update the ThoughtspotLiveboard, as a builder
     */
    public static ThoughtspotLiveboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return ThoughtspotLiveboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a ThoughtspotLiveboard, from a potentially
     * more-complete ThoughtspotLiveboard object.
     *
     * @return the minimal object necessary to update the ThoughtspotLiveboard, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for ThoughtspotLiveboard are not found in the initial object
     */
    @Override
    public ThoughtspotLiveboardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a ThoughtspotLiveboard.
     *
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param name of the ThoughtspotLiveboard
     * @return the updated ThoughtspotLiveboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a ThoughtspotLiveboard.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param name of the ThoughtspotLiveboard
     * @return the updated ThoughtspotLiveboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a ThoughtspotLiveboard.
     *
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param name of the ThoughtspotLiveboard
     * @return the updated ThoughtspotLiveboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a ThoughtspotLiveboard.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param name of the ThoughtspotLiveboard
     * @return the updated ThoughtspotLiveboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a ThoughtspotLiveboard.
     *
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param name of the ThoughtspotLiveboard
     * @return the updated ThoughtspotLiveboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a ThoughtspotLiveboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ThoughtspotLiveboard's owners
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param name of the ThoughtspotLiveboard
     * @return the updated ThoughtspotLiveboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a ThoughtspotLiveboard.
     *
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ThoughtspotLiveboard, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a ThoughtspotLiveboard.
     *
     * @param client connectivity to the Atlan tenant on which to update the ThoughtspotLiveboard's certificate
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ThoughtspotLiveboard, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a ThoughtspotLiveboard.
     *
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param name of the ThoughtspotLiveboard
     * @return the updated ThoughtspotLiveboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a ThoughtspotLiveboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ThoughtspotLiveboard's certificate
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param name of the ThoughtspotLiveboard
     * @return the updated ThoughtspotLiveboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a ThoughtspotLiveboard.
     *
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a ThoughtspotLiveboard.
     *
     * @param client connectivity to the Atlan tenant on which to update the ThoughtspotLiveboard's announcement
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a ThoughtspotLiveboard.
     *
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param name of the ThoughtspotLiveboard
     * @return the updated ThoughtspotLiveboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a ThoughtspotLiveboard.
     *
     * @param client connectivity to the Atlan client from which to remove the ThoughtspotLiveboard's announcement
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param name of the ThoughtspotLiveboard
     * @return the updated ThoughtspotLiveboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the ThoughtspotLiveboard.
     *
     * @param qualifiedName for the ThoughtspotLiveboard
     * @param name human-readable name of the ThoughtspotLiveboard
     * @param terms the list of terms to replace on the ThoughtspotLiveboard, or null to remove all terms from the ThoughtspotLiveboard
     * @return the ThoughtspotLiveboard that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the ThoughtspotLiveboard.
     *
     * @param client connectivity to the Atlan tenant on which to replace the ThoughtspotLiveboard's assigned terms
     * @param qualifiedName for the ThoughtspotLiveboard
     * @param name human-readable name of the ThoughtspotLiveboard
     * @param terms the list of terms to replace on the ThoughtspotLiveboard, or null to remove all terms from the ThoughtspotLiveboard
     * @return the ThoughtspotLiveboard that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the ThoughtspotLiveboard, without replacing existing terms linked to the ThoughtspotLiveboard.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotLiveboard's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the ThoughtspotLiveboard
     * @param terms the list of terms to append to the ThoughtspotLiveboard
     * @return the ThoughtspotLiveboard that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the ThoughtspotLiveboard, without replacing existing terms linked to the ThoughtspotLiveboard.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotLiveboard's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the ThoughtspotLiveboard
     * @param qualifiedName for the ThoughtspotLiveboard
     * @param terms the list of terms to append to the ThoughtspotLiveboard
     * @return the ThoughtspotLiveboard that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a ThoughtspotLiveboard, without replacing all existing terms linked to the ThoughtspotLiveboard.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotLiveboard's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the ThoughtspotLiveboard
     * @param terms the list of terms to remove from the ThoughtspotLiveboard, which must be referenced by GUID
     * @return the ThoughtspotLiveboard that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a ThoughtspotLiveboard, without replacing all existing terms linked to the ThoughtspotLiveboard.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotLiveboard's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the ThoughtspotLiveboard
     * @param qualifiedName for the ThoughtspotLiveboard
     * @param terms the list of terms to remove from the ThoughtspotLiveboard, which must be referenced by GUID
     * @return the ThoughtspotLiveboard that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotLiveboard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a ThoughtspotLiveboard, without replacing existing Atlan tags linked to the ThoughtspotLiveboard.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotLiveboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ThoughtspotLiveboard
     */
    public static ThoughtspotLiveboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ThoughtspotLiveboard, without replacing existing Atlan tags linked to the ThoughtspotLiveboard.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotLiveboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ThoughtspotLiveboard
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ThoughtspotLiveboard
     */
    public static ThoughtspotLiveboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ThoughtspotLiveboard, without replacing existing Atlan tags linked to the ThoughtspotLiveboard.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotLiveboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ThoughtspotLiveboard
     */
    public static ThoughtspotLiveboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a ThoughtspotLiveboard, without replacing existing Atlan tags linked to the ThoughtspotLiveboard.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotLiveboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ThoughtspotLiveboard
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ThoughtspotLiveboard
     */
    public static ThoughtspotLiveboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ThoughtspotLiveboard) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a ThoughtspotLiveboard.
     *
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ThoughtspotLiveboard
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a ThoughtspotLiveboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a ThoughtspotLiveboard
     * @param qualifiedName of the ThoughtspotLiveboard
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ThoughtspotLiveboard
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class ThoughtspotLiveboardBuilder<C extends ThoughtspotLiveboard, B extends ThoughtspotLiveboard.ThoughtspotLiveboardBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String thoughtspotChartType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long thoughtspotColumnCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IThoughtspotDashlet> thoughtspotDashlets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long thoughtspotJoinCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String thoughtspotQuestionText;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            ThoughtspotLiveboard.ThoughtspotLiveboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final ThoughtspotLiveboard instance, final ThoughtspotLiveboard.ThoughtspotLiveboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.thoughtspotChartType(instance.thoughtspotChartType);
            b.thoughtspotColumnCount(instance.thoughtspotColumnCount);
            b.thoughtspotDashlets(instance.thoughtspotDashlets == null ? java.util.Collections.<IThoughtspotDashlet>emptySortedSet() : instance.thoughtspotDashlets);
            b.thoughtspotJoinCount(instance.thoughtspotJoinCount);
            b.thoughtspotQuestionText(instance.thoughtspotQuestionText);
        }

        /**
         * Fixed typeName for ThoughtspotLiveboards.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotChartType(final String thoughtspotChartType) {
            this.thoughtspotChartType = thoughtspotChartType;
            return self();
        }

        /**
         * Number of Columns.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotColumnCount(final Long thoughtspotColumnCount) {
            this.thoughtspotColumnCount = thoughtspotColumnCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotDashlet(final IThoughtspotDashlet thoughtspotDashlet) {
            if (this.thoughtspotDashlets == null) this.thoughtspotDashlets = new java.util.ArrayList<IThoughtspotDashlet>();
            this.thoughtspotDashlets.add(thoughtspotDashlet);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotDashlets(final java.util.Collection<? extends IThoughtspotDashlet> thoughtspotDashlets) {
            if (thoughtspotDashlets == null) {
                throw new java.lang.NullPointerException("thoughtspotDashlets cannot be null");
            }
            if (this.thoughtspotDashlets == null) this.thoughtspotDashlets = new java.util.ArrayList<IThoughtspotDashlet>();
            this.thoughtspotDashlets.addAll(thoughtspotDashlets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearThoughtspotDashlets() {
            if (this.thoughtspotDashlets != null) this.thoughtspotDashlets.clear();
            return self();
        }

        /**
         * Total number of data table joins executed for analysis.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotJoinCount(final Long thoughtspotJoinCount) {
            this.thoughtspotJoinCount = thoughtspotJoinCount;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotQuestionText(final String thoughtspotQuestionText) {
            this.thoughtspotQuestionText = thoughtspotQuestionText;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ThoughtspotLiveboard.ThoughtspotLiveboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", thoughtspotChartType=" + this.thoughtspotChartType + ", thoughtspotColumnCount=" + this.thoughtspotColumnCount + ", thoughtspotDashlets=" + this.thoughtspotDashlets + ", thoughtspotJoinCount=" + this.thoughtspotJoinCount + ", thoughtspotQuestionText=" + this.thoughtspotQuestionText + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class ThoughtspotLiveboardBuilderImpl extends ThoughtspotLiveboard.ThoughtspotLiveboardBuilder<ThoughtspotLiveboard, ThoughtspotLiveboard.ThoughtspotLiveboardBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ThoughtspotLiveboardBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ThoughtspotLiveboard.ThoughtspotLiveboardBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ThoughtspotLiveboard build() {
            return new ThoughtspotLiveboard(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected ThoughtspotLiveboard(final ThoughtspotLiveboard.ThoughtspotLiveboardBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = ThoughtspotLiveboard.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.thoughtspotChartType = b.thoughtspotChartType;
        this.thoughtspotColumnCount = b.thoughtspotColumnCount;
        java.util.SortedSet<IThoughtspotDashlet> thoughtspotDashlets = new java.util.TreeSet<IThoughtspotDashlet>();
        if (b.thoughtspotDashlets != null) thoughtspotDashlets.addAll(b.thoughtspotDashlets);
        thoughtspotDashlets = java.util.Collections.unmodifiableSortedSet(thoughtspotDashlets);
        this.thoughtspotDashlets = thoughtspotDashlets;
        this.thoughtspotJoinCount = b.thoughtspotJoinCount;
        this.thoughtspotQuestionText = b.thoughtspotQuestionText;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ThoughtspotLiveboard.ThoughtspotLiveboardBuilder<?, ?> _internal() {
        return new ThoughtspotLiveboard.ThoughtspotLiveboardBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ThoughtspotLiveboard.ThoughtspotLiveboardBuilder<?, ?> toBuilder() {
        return new ThoughtspotLiveboard.ThoughtspotLiveboardBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getThoughtspotChartType() {
        return this.thoughtspotChartType;
    }

    /**
     * Number of Columns.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getThoughtspotColumnCount() {
        return this.thoughtspotColumnCount;
    }

    /**
     * Dashlets that exist within this liveboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IThoughtspotDashlet> getThoughtspotDashlets() {
        return this.thoughtspotDashlets;
    }

    /**
     * Total number of data table joins executed for analysis.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getThoughtspotJoinCount() {
        return this.thoughtspotJoinCount;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getThoughtspotQuestionText() {
        return this.thoughtspotQuestionText;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ThoughtspotLiveboard)) return false;
        final ThoughtspotLiveboard other = (ThoughtspotLiveboard) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$thoughtspotColumnCount = this.getThoughtspotColumnCount();
        final java.lang.Object other$thoughtspotColumnCount = other.getThoughtspotColumnCount();
        if (this$thoughtspotColumnCount == null ? other$thoughtspotColumnCount != null : !this$thoughtspotColumnCount.equals(other$thoughtspotColumnCount)) return false;
        final java.lang.Object this$thoughtspotJoinCount = this.getThoughtspotJoinCount();
        final java.lang.Object other$thoughtspotJoinCount = other.getThoughtspotJoinCount();
        if (this$thoughtspotJoinCount == null ? other$thoughtspotJoinCount != null : !this$thoughtspotJoinCount.equals(other$thoughtspotJoinCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$thoughtspotChartType = this.getThoughtspotChartType();
        final java.lang.Object other$thoughtspotChartType = other.getThoughtspotChartType();
        if (this$thoughtspotChartType == null ? other$thoughtspotChartType != null : !this$thoughtspotChartType.equals(other$thoughtspotChartType)) return false;
        final java.lang.Object this$thoughtspotDashlets = this.getThoughtspotDashlets();
        final java.lang.Object other$thoughtspotDashlets = other.getThoughtspotDashlets();
        if (this$thoughtspotDashlets == null ? other$thoughtspotDashlets != null : !this$thoughtspotDashlets.equals(other$thoughtspotDashlets)) return false;
        final java.lang.Object this$thoughtspotQuestionText = this.getThoughtspotQuestionText();
        final java.lang.Object other$thoughtspotQuestionText = other.getThoughtspotQuestionText();
        if (this$thoughtspotQuestionText == null ? other$thoughtspotQuestionText != null : !this$thoughtspotQuestionText.equals(other$thoughtspotQuestionText)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ThoughtspotLiveboard;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $thoughtspotColumnCount = this.getThoughtspotColumnCount();
        result = result * PRIME + ($thoughtspotColumnCount == null ? 43 : $thoughtspotColumnCount.hashCode());
        final java.lang.Object $thoughtspotJoinCount = this.getThoughtspotJoinCount();
        result = result * PRIME + ($thoughtspotJoinCount == null ? 43 : $thoughtspotJoinCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $thoughtspotChartType = this.getThoughtspotChartType();
        result = result * PRIME + ($thoughtspotChartType == null ? 43 : $thoughtspotChartType.hashCode());
        final java.lang.Object $thoughtspotDashlets = this.getThoughtspotDashlets();
        result = result * PRIME + ($thoughtspotDashlets == null ? 43 : $thoughtspotDashlets.hashCode());
        final java.lang.Object $thoughtspotQuestionText = this.getThoughtspotQuestionText();
        result = result * PRIME + ($thoughtspotQuestionText == null ? 43 : $thoughtspotQuestionText.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ThoughtspotLiveboard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", thoughtspotChartType=" + this.getThoughtspotChartType() + ", thoughtspotColumnCount=" + this.getThoughtspotColumnCount() + ", thoughtspotDashlets=" + this.getThoughtspotDashlets() + ", thoughtspotJoinCount=" + this.getThoughtspotJoinCount() + ", thoughtspotQuestionText=" + this.getThoughtspotQuestionText() + ")";
    }

    /**
     * Fixed typeName for ThoughtspotLiveboards.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
