// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Thoughtspot table in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class ThoughtspotTable extends Asset implements IThoughtspotTable, IThoughtspot, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ThoughtspotTable.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ThoughtspotTable";
    /**
     * Fixed typeName for ThoughtspotTables.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * TBC
     */
    @Attribute
    String thoughtspotChartType;
    /**
     * Number of Columns.
     */
    @Attribute
    Long thoughtspotColumnCount;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IThoughtspotColumn> thoughtspotColumns;
    /**
     * Total number of data table joins executed for analysis.
     */
    @Attribute
    Long thoughtspotJoinCount;
    /**
     * TBC
     */
    @Attribute
    String thoughtspotQuestionText;

    /**
     * Builds the minimal object necessary to create a relationship to a ThoughtspotTable, from a potentially
     * more-complete ThoughtspotTable object.
     *
     * @return the minimal object necessary to relate to the ThoughtspotTable
     * @throws InvalidRequestException if any of the minimal set of required properties for a ThoughtspotTable relationship are not found in the initial object
     */
    @Override
    public ThoughtspotTable trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all ThoughtspotTable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ThoughtspotTable assets will be included.
     *
     * @return a fluent search that includes all ThoughtspotTable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all ThoughtspotTable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ThoughtspotTable assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all ThoughtspotTable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all ThoughtspotTable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) ThoughtspotTables will be included
     * @return a fluent search that includes all ThoughtspotTable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all ThoughtspotTable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) ThoughtspotTables will be included
     * @return a fluent search that includes all ThoughtspotTable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a ThoughtspotTable by GUID. Use this to create a relationship to this ThoughtspotTable,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the ThoughtspotTable to reference
     * @return reference to a ThoughtspotTable that can be used for defining a relationship to a ThoughtspotTable
     */
    public static ThoughtspotTable refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ThoughtspotTable by GUID. Use this to create a relationship to this ThoughtspotTable,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the ThoughtspotTable to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ThoughtspotTable that can be used for defining a relationship to a ThoughtspotTable
     */
    public static ThoughtspotTable refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ThoughtspotTable._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a ThoughtspotTable by qualifiedName. Use this to create a relationship to this ThoughtspotTable,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the ThoughtspotTable to reference
     * @return reference to a ThoughtspotTable that can be used for defining a relationship to a ThoughtspotTable
     */
    public static ThoughtspotTable refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ThoughtspotTable by qualifiedName. Use this to create a relationship to this ThoughtspotTable,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the ThoughtspotTable to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ThoughtspotTable that can be used for defining a relationship to a ThoughtspotTable
     */
    public static ThoughtspotTable refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ThoughtspotTable._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a ThoughtspotTable by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the ThoughtspotTable to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ThoughtspotTable, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ThoughtspotTable does not exist or the provided GUID is not a ThoughtspotTable
     */
    @JsonIgnore
    public static ThoughtspotTable get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a ThoughtspotTable by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ThoughtspotTable to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ThoughtspotTable, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ThoughtspotTable does not exist or the provided GUID is not a ThoughtspotTable
     */
    @JsonIgnore
    public static ThoughtspotTable get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a ThoughtspotTable by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ThoughtspotTable to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full ThoughtspotTable, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ThoughtspotTable does not exist or the provided GUID is not a ThoughtspotTable
     */
    @JsonIgnore
    public static ThoughtspotTable get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof ThoughtspotTable) {
                return (ThoughtspotTable) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof ThoughtspotTable) {
                return (ThoughtspotTable) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) ThoughtspotTable to active.
     *
     * @param qualifiedName for the ThoughtspotTable
     * @return true if the ThoughtspotTable is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) ThoughtspotTable to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the ThoughtspotTable
     * @return true if the ThoughtspotTable is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a ThoughtspotTable.
     *
     * @param qualifiedName of the ThoughtspotTable
     * @param name of the ThoughtspotTable
     * @return the minimal request necessary to update the ThoughtspotTable, as a builder
     */
    public static ThoughtspotTableBuilder<?, ?> updater(String qualifiedName, String name) {
        return ThoughtspotTable._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a ThoughtspotTable, from a potentially
     * more-complete ThoughtspotTable object.
     *
     * @return the minimal object necessary to update the ThoughtspotTable, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for ThoughtspotTable are not found in the initial object
     */
    @Override
    public ThoughtspotTableBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a ThoughtspotTable.
     *
     * @param qualifiedName of the ThoughtspotTable
     * @param name of the ThoughtspotTable
     * @return the updated ThoughtspotTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a ThoughtspotTable.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ThoughtspotTable
     * @param name of the ThoughtspotTable
     * @return the updated ThoughtspotTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotTable) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a ThoughtspotTable.
     *
     * @param qualifiedName of the ThoughtspotTable
     * @param name of the ThoughtspotTable
     * @return the updated ThoughtspotTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a ThoughtspotTable.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ThoughtspotTable
     * @param name of the ThoughtspotTable
     * @return the updated ThoughtspotTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotTable) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a ThoughtspotTable.
     *
     * @param qualifiedName of the ThoughtspotTable
     * @param name of the ThoughtspotTable
     * @return the updated ThoughtspotTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a ThoughtspotTable.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ThoughtspotTable's owners
     * @param qualifiedName of the ThoughtspotTable
     * @param name of the ThoughtspotTable
     * @return the updated ThoughtspotTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotTable) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a ThoughtspotTable.
     *
     * @param qualifiedName of the ThoughtspotTable
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ThoughtspotTable, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a ThoughtspotTable.
     *
     * @param client connectivity to the Atlan tenant on which to update the ThoughtspotTable's certificate
     * @param qualifiedName of the ThoughtspotTable
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ThoughtspotTable, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ThoughtspotTable) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a ThoughtspotTable.
     *
     * @param qualifiedName of the ThoughtspotTable
     * @param name of the ThoughtspotTable
     * @return the updated ThoughtspotTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a ThoughtspotTable.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ThoughtspotTable's certificate
     * @param qualifiedName of the ThoughtspotTable
     * @param name of the ThoughtspotTable
     * @return the updated ThoughtspotTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotTable) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a ThoughtspotTable.
     *
     * @param qualifiedName of the ThoughtspotTable
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a ThoughtspotTable.
     *
     * @param client connectivity to the Atlan tenant on which to update the ThoughtspotTable's announcement
     * @param qualifiedName of the ThoughtspotTable
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ThoughtspotTable) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a ThoughtspotTable.
     *
     * @param qualifiedName of the ThoughtspotTable
     * @param name of the ThoughtspotTable
     * @return the updated ThoughtspotTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a ThoughtspotTable.
     *
     * @param client connectivity to the Atlan client from which to remove the ThoughtspotTable's announcement
     * @param qualifiedName of the ThoughtspotTable
     * @param name of the ThoughtspotTable
     * @return the updated ThoughtspotTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotTable) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the ThoughtspotTable.
     *
     * @param qualifiedName for the ThoughtspotTable
     * @param name human-readable name of the ThoughtspotTable
     * @param terms the list of terms to replace on the ThoughtspotTable, or null to remove all terms from the ThoughtspotTable
     * @return the ThoughtspotTable that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the ThoughtspotTable.
     *
     * @param client connectivity to the Atlan tenant on which to replace the ThoughtspotTable's assigned terms
     * @param qualifiedName for the ThoughtspotTable
     * @param name human-readable name of the ThoughtspotTable
     * @param terms the list of terms to replace on the ThoughtspotTable, or null to remove all terms from the ThoughtspotTable
     * @return the ThoughtspotTable that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotTable) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the ThoughtspotTable, without replacing existing terms linked to the ThoughtspotTable.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotTable's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the ThoughtspotTable
     * @param terms the list of terms to append to the ThoughtspotTable
     * @return the ThoughtspotTable that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the ThoughtspotTable, without replacing existing terms linked to the ThoughtspotTable.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotTable's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the ThoughtspotTable
     * @param qualifiedName for the ThoughtspotTable
     * @param terms the list of terms to append to the ThoughtspotTable
     * @return the ThoughtspotTable that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotTable) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a ThoughtspotTable, without replacing all existing terms linked to the ThoughtspotTable.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotTable's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the ThoughtspotTable
     * @param terms the list of terms to remove from the ThoughtspotTable, which must be referenced by GUID
     * @return the ThoughtspotTable that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a ThoughtspotTable, without replacing all existing terms linked to the ThoughtspotTable.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotTable's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the ThoughtspotTable
     * @param qualifiedName for the ThoughtspotTable
     * @param terms the list of terms to remove from the ThoughtspotTable, which must be referenced by GUID
     * @return the ThoughtspotTable that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ThoughtspotTable removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotTable) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a ThoughtspotTable, without replacing existing Atlan tags linked to the ThoughtspotTable.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotTable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ThoughtspotTable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ThoughtspotTable
     */
    public static ThoughtspotTable appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ThoughtspotTable, without replacing existing Atlan tags linked to the ThoughtspotTable.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotTable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ThoughtspotTable
     * @param qualifiedName of the ThoughtspotTable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ThoughtspotTable
     */
    public static ThoughtspotTable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ThoughtspotTable) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ThoughtspotTable, without replacing existing Atlan tags linked to the ThoughtspotTable.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotTable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ThoughtspotTable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ThoughtspotTable
     */
    public static ThoughtspotTable appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a ThoughtspotTable, without replacing existing Atlan tags linked to the ThoughtspotTable.
     * Note: this operation must make two API calls — one to retrieve the ThoughtspotTable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ThoughtspotTable
     * @param qualifiedName of the ThoughtspotTable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ThoughtspotTable
     */
    public static ThoughtspotTable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ThoughtspotTable) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a ThoughtspotTable.
     *
     * @param qualifiedName of the ThoughtspotTable
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ThoughtspotTable
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a ThoughtspotTable.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a ThoughtspotTable
     * @param qualifiedName of the ThoughtspotTable
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ThoughtspotTable
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class ThoughtspotTableBuilder<C extends ThoughtspotTable, B extends ThoughtspotTable.ThoughtspotTableBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String thoughtspotChartType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long thoughtspotColumnCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IThoughtspotColumn> thoughtspotColumns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long thoughtspotJoinCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String thoughtspotQuestionText;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            ThoughtspotTable.ThoughtspotTableBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final ThoughtspotTable instance, final ThoughtspotTable.ThoughtspotTableBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.thoughtspotChartType(instance.thoughtspotChartType);
            b.thoughtspotColumnCount(instance.thoughtspotColumnCount);
            b.thoughtspotColumns(instance.thoughtspotColumns == null ? java.util.Collections.<IThoughtspotColumn>emptySortedSet() : instance.thoughtspotColumns);
            b.thoughtspotJoinCount(instance.thoughtspotJoinCount);
            b.thoughtspotQuestionText(instance.thoughtspotQuestionText);
        }

        /**
         * Fixed typeName for ThoughtspotTables.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotChartType(final String thoughtspotChartType) {
            this.thoughtspotChartType = thoughtspotChartType;
            return self();
        }

        /**
         * Number of Columns.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotColumnCount(final Long thoughtspotColumnCount) {
            this.thoughtspotColumnCount = thoughtspotColumnCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotColumn(final IThoughtspotColumn thoughtspotColumn) {
            if (this.thoughtspotColumns == null) this.thoughtspotColumns = new java.util.ArrayList<IThoughtspotColumn>();
            this.thoughtspotColumns.add(thoughtspotColumn);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotColumns(final java.util.Collection<? extends IThoughtspotColumn> thoughtspotColumns) {
            if (thoughtspotColumns == null) {
                throw new java.lang.NullPointerException("thoughtspotColumns cannot be null");
            }
            if (this.thoughtspotColumns == null) this.thoughtspotColumns = new java.util.ArrayList<IThoughtspotColumn>();
            this.thoughtspotColumns.addAll(thoughtspotColumns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearThoughtspotColumns() {
            if (this.thoughtspotColumns != null) this.thoughtspotColumns.clear();
            return self();
        }

        /**
         * Total number of data table joins executed for analysis.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotJoinCount(final Long thoughtspotJoinCount) {
            this.thoughtspotJoinCount = thoughtspotJoinCount;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B thoughtspotQuestionText(final String thoughtspotQuestionText) {
            this.thoughtspotQuestionText = thoughtspotQuestionText;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ThoughtspotTable.ThoughtspotTableBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", thoughtspotChartType=" + this.thoughtspotChartType + ", thoughtspotColumnCount=" + this.thoughtspotColumnCount + ", thoughtspotColumns=" + this.thoughtspotColumns + ", thoughtspotJoinCount=" + this.thoughtspotJoinCount + ", thoughtspotQuestionText=" + this.thoughtspotQuestionText + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class ThoughtspotTableBuilderImpl extends ThoughtspotTable.ThoughtspotTableBuilder<ThoughtspotTable, ThoughtspotTable.ThoughtspotTableBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ThoughtspotTableBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ThoughtspotTable.ThoughtspotTableBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ThoughtspotTable build() {
            return new ThoughtspotTable(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected ThoughtspotTable(final ThoughtspotTable.ThoughtspotTableBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = ThoughtspotTable.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.thoughtspotChartType = b.thoughtspotChartType;
        this.thoughtspotColumnCount = b.thoughtspotColumnCount;
        java.util.SortedSet<IThoughtspotColumn> thoughtspotColumns = new java.util.TreeSet<IThoughtspotColumn>();
        if (b.thoughtspotColumns != null) thoughtspotColumns.addAll(b.thoughtspotColumns);
        thoughtspotColumns = java.util.Collections.unmodifiableSortedSet(thoughtspotColumns);
        this.thoughtspotColumns = thoughtspotColumns;
        this.thoughtspotJoinCount = b.thoughtspotJoinCount;
        this.thoughtspotQuestionText = b.thoughtspotQuestionText;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ThoughtspotTable.ThoughtspotTableBuilder<?, ?> _internal() {
        return new ThoughtspotTable.ThoughtspotTableBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ThoughtspotTable.ThoughtspotTableBuilder<?, ?> toBuilder() {
        return new ThoughtspotTable.ThoughtspotTableBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getThoughtspotChartType() {
        return this.thoughtspotChartType;
    }

    /**
     * Number of Columns.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getThoughtspotColumnCount() {
        return this.thoughtspotColumnCount;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IThoughtspotColumn> getThoughtspotColumns() {
        return this.thoughtspotColumns;
    }

    /**
     * Total number of data table joins executed for analysis.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getThoughtspotJoinCount() {
        return this.thoughtspotJoinCount;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getThoughtspotQuestionText() {
        return this.thoughtspotQuestionText;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ThoughtspotTable)) return false;
        final ThoughtspotTable other = (ThoughtspotTable) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$thoughtspotColumnCount = this.getThoughtspotColumnCount();
        final java.lang.Object other$thoughtspotColumnCount = other.getThoughtspotColumnCount();
        if (this$thoughtspotColumnCount == null ? other$thoughtspotColumnCount != null : !this$thoughtspotColumnCount.equals(other$thoughtspotColumnCount)) return false;
        final java.lang.Object this$thoughtspotJoinCount = this.getThoughtspotJoinCount();
        final java.lang.Object other$thoughtspotJoinCount = other.getThoughtspotJoinCount();
        if (this$thoughtspotJoinCount == null ? other$thoughtspotJoinCount != null : !this$thoughtspotJoinCount.equals(other$thoughtspotJoinCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$thoughtspotChartType = this.getThoughtspotChartType();
        final java.lang.Object other$thoughtspotChartType = other.getThoughtspotChartType();
        if (this$thoughtspotChartType == null ? other$thoughtspotChartType != null : !this$thoughtspotChartType.equals(other$thoughtspotChartType)) return false;
        final java.lang.Object this$thoughtspotColumns = this.getThoughtspotColumns();
        final java.lang.Object other$thoughtspotColumns = other.getThoughtspotColumns();
        if (this$thoughtspotColumns == null ? other$thoughtspotColumns != null : !this$thoughtspotColumns.equals(other$thoughtspotColumns)) return false;
        final java.lang.Object this$thoughtspotQuestionText = this.getThoughtspotQuestionText();
        final java.lang.Object other$thoughtspotQuestionText = other.getThoughtspotQuestionText();
        if (this$thoughtspotQuestionText == null ? other$thoughtspotQuestionText != null : !this$thoughtspotQuestionText.equals(other$thoughtspotQuestionText)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ThoughtspotTable;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $thoughtspotColumnCount = this.getThoughtspotColumnCount();
        result = result * PRIME + ($thoughtspotColumnCount == null ? 43 : $thoughtspotColumnCount.hashCode());
        final java.lang.Object $thoughtspotJoinCount = this.getThoughtspotJoinCount();
        result = result * PRIME + ($thoughtspotJoinCount == null ? 43 : $thoughtspotJoinCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $thoughtspotChartType = this.getThoughtspotChartType();
        result = result * PRIME + ($thoughtspotChartType == null ? 43 : $thoughtspotChartType.hashCode());
        final java.lang.Object $thoughtspotColumns = this.getThoughtspotColumns();
        result = result * PRIME + ($thoughtspotColumns == null ? 43 : $thoughtspotColumns.hashCode());
        final java.lang.Object $thoughtspotQuestionText = this.getThoughtspotQuestionText();
        result = result * PRIME + ($thoughtspotQuestionText == null ? 43 : $thoughtspotQuestionText.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ThoughtspotTable(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", thoughtspotChartType=" + this.getThoughtspotChartType() + ", thoughtspotColumnCount=" + this.getThoughtspotColumnCount() + ", thoughtspotColumns=" + this.getThoughtspotColumns() + ", thoughtspotJoinCount=" + this.getThoughtspotJoinCount() + ", thoughtspotQuestionText=" + this.getThoughtspotQuestionText() + ")";
    }

    /**
     * Fixed typeName for ThoughtspotTables.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
