// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.WorkflowStatus;
import com.atlan.model.enums.WorkflowType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a governance workflow.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class Workflow extends Asset implements IWorkflow, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Workflow.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Workflow";
    /**
     * Fixed typeName for Workflows.
     */
    String typeName;
    /**
     * Details of the workflow.
     */
    @Attribute
    String workflowConfig;
    /**
     * Username of the user who created this workflow.
     */
    @Attribute
    String workflowCreatedBy;
    /**
     * Deletion time of this workflow.
     */
    @Attribute
    @Date
    Long workflowDeletedAt;
    /**
     * Time duration after which a run of this workflow will expire.
     */
    @Attribute
    String workflowRunExpiresIn;
    /**
     * Status of the workflow.
     */
    @Attribute
    WorkflowStatus workflowStatus;
    /**
     * GUID of the workflow template from which this workflow was created.
     */
    @Attribute
    String workflowTemplateGuid;
    /**
     * Type of the workflow.
     */
    @Attribute
    WorkflowType workflowType;
    /**
     * Username of the user who updated this workflow.
     */
    @Attribute
    String workflowUpdatedBy;

    /**
     * Builds the minimal object necessary to create a relationship to a Workflow, from a potentially
     * more-complete Workflow object.
     *
     * @return the minimal object necessary to relate to the Workflow
     * @throws InvalidRequestException if any of the minimal set of required properties for a Workflow relationship are not found in the initial object
     */
    @Override
    public Workflow trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all Workflow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Workflow assets will be included.
     *
     * @return a fluent search that includes all Workflow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all Workflow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Workflow assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all Workflow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all Workflow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) Workflows will be included
     * @return a fluent search that includes all Workflow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all Workflow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) Workflows will be included
     * @return a fluent search that includes all Workflow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a Workflow by GUID. Use this to create a relationship to this Workflow,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the Workflow to reference
     * @return reference to a Workflow that can be used for defining a relationship to a Workflow
     */
    public static Workflow refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Workflow by GUID. Use this to create a relationship to this Workflow,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the Workflow to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Workflow that can be used for defining a relationship to a Workflow
     */
    public static Workflow refByGuid(String guid, Reference.SaveSemantic semantic) {
        return Workflow._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a Workflow by qualifiedName. Use this to create a relationship to this Workflow,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the Workflow to reference
     * @return reference to a Workflow that can be used for defining a relationship to a Workflow
     */
    public static Workflow refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Workflow by qualifiedName. Use this to create a relationship to this Workflow,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the Workflow to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Workflow that can be used for defining a relationship to a Workflow
     */
    public static Workflow refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return Workflow._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a Workflow by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the Workflow to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Workflow, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Workflow does not exist or the provided GUID is not a Workflow
     */
    @JsonIgnore
    public static Workflow get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a Workflow by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Workflow to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Workflow, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Workflow does not exist or the provided GUID is not a Workflow
     */
    @JsonIgnore
    public static Workflow get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a Workflow by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Workflow to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full Workflow, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Workflow does not exist or the provided GUID is not a Workflow
     */
    @JsonIgnore
    public static Workflow get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof Workflow) {
                return (Workflow) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof Workflow) {
                return (Workflow) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) Workflow to active.
     *
     * @param qualifiedName for the Workflow
     * @return true if the Workflow is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) Workflow to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the Workflow
     * @return true if the Workflow is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a Workflow.
     *
     * @param qualifiedName of the Workflow
     * @param name of the Workflow
     * @return the minimal request necessary to update the Workflow, as a builder
     */
    public static WorkflowBuilder<?, ?> updater(String qualifiedName, String name) {
        return Workflow._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a Workflow, from a potentially
     * more-complete Workflow object.
     *
     * @return the minimal object necessary to update the Workflow, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for Workflow are not found in the initial object
     */
    @Override
    public WorkflowBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a Workflow.
     *
     * @param qualifiedName of the Workflow
     * @param name of the Workflow
     * @return the updated Workflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Workflow removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a Workflow.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Workflow
     * @param name of the Workflow
     * @return the updated Workflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Workflow removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Workflow) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a Workflow.
     *
     * @param qualifiedName of the Workflow
     * @param name of the Workflow
     * @return the updated Workflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Workflow removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a Workflow.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Workflow
     * @param name of the Workflow
     * @return the updated Workflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Workflow removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Workflow) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a Workflow.
     *
     * @param qualifiedName of the Workflow
     * @param name of the Workflow
     * @return the updated Workflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Workflow removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a Workflow.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Workflow's owners
     * @param qualifiedName of the Workflow
     * @param name of the Workflow
     * @return the updated Workflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Workflow removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Workflow) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a Workflow.
     *
     * @param qualifiedName of the Workflow
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Workflow, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Workflow updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a Workflow.
     *
     * @param client connectivity to the Atlan tenant on which to update the Workflow's certificate
     * @param qualifiedName of the Workflow
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Workflow, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Workflow updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Workflow) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a Workflow.
     *
     * @param qualifiedName of the Workflow
     * @param name of the Workflow
     * @return the updated Workflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Workflow removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a Workflow.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Workflow's certificate
     * @param qualifiedName of the Workflow
     * @param name of the Workflow
     * @return the updated Workflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Workflow removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Workflow) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a Workflow.
     *
     * @param qualifiedName of the Workflow
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Workflow updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a Workflow.
     *
     * @param client connectivity to the Atlan tenant on which to update the Workflow's announcement
     * @param qualifiedName of the Workflow
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Workflow updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Workflow) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a Workflow.
     *
     * @param qualifiedName of the Workflow
     * @param name of the Workflow
     * @return the updated Workflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Workflow removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a Workflow.
     *
     * @param client connectivity to the Atlan client from which to remove the Workflow's announcement
     * @param qualifiedName of the Workflow
     * @param name of the Workflow
     * @return the updated Workflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Workflow removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Workflow) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the Workflow.
     *
     * @param qualifiedName for the Workflow
     * @param name human-readable name of the Workflow
     * @param terms the list of terms to replace on the Workflow, or null to remove all terms from the Workflow
     * @return the Workflow that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Workflow replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the Workflow.
     *
     * @param client connectivity to the Atlan tenant on which to replace the Workflow's assigned terms
     * @param qualifiedName for the Workflow
     * @param name human-readable name of the Workflow
     * @param terms the list of terms to replace on the Workflow, or null to remove all terms from the Workflow
     * @return the Workflow that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Workflow replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Workflow) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the Workflow, without replacing existing terms linked to the Workflow.
     * Note: this operation must make two API calls — one to retrieve the Workflow's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the Workflow
     * @param terms the list of terms to append to the Workflow
     * @return the Workflow that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Workflow appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the Workflow, without replacing existing terms linked to the Workflow.
     * Note: this operation must make two API calls — one to retrieve the Workflow's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the Workflow
     * @param qualifiedName for the Workflow
     * @param terms the list of terms to append to the Workflow
     * @return the Workflow that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Workflow appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Workflow) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a Workflow, without replacing all existing terms linked to the Workflow.
     * Note: this operation must make two API calls — one to retrieve the Workflow's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the Workflow
     * @param terms the list of terms to remove from the Workflow, which must be referenced by GUID
     * @return the Workflow that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Workflow removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a Workflow, without replacing all existing terms linked to the Workflow.
     * Note: this operation must make two API calls — one to retrieve the Workflow's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the Workflow
     * @param qualifiedName for the Workflow
     * @param terms the list of terms to remove from the Workflow, which must be referenced by GUID
     * @return the Workflow that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Workflow removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Workflow) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a Workflow, without replacing existing Atlan tags linked to the Workflow.
     * Note: this operation must make two API calls — one to retrieve the Workflow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Workflow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Workflow
     */
    public static Workflow appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Workflow, without replacing existing Atlan tags linked to the Workflow.
     * Note: this operation must make two API calls — one to retrieve the Workflow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Workflow
     * @param qualifiedName of the Workflow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Workflow
     */
    public static Workflow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Workflow) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Workflow, without replacing existing Atlan tags linked to the Workflow.
     * Note: this operation must make two API calls — one to retrieve the Workflow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Workflow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Workflow
     */
    public static Workflow appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a Workflow, without replacing existing Atlan tags linked to the Workflow.
     * Note: this operation must make two API calls — one to retrieve the Workflow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Workflow
     * @param qualifiedName of the Workflow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Workflow
     */
    public static Workflow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Workflow) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a Workflow.
     *
     * @param qualifiedName of the Workflow
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Workflow
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a Workflow.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a Workflow
     * @param qualifiedName of the Workflow
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Workflow
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class WorkflowBuilder<C extends Workflow, B extends Workflow.WorkflowBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workflowConfig;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workflowCreatedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long workflowDeletedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workflowRunExpiresIn;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private WorkflowStatus workflowStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workflowTemplateGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private WorkflowType workflowType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workflowUpdatedBy;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Workflow.WorkflowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Workflow instance, final Workflow.WorkflowBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workflowConfig(instance.workflowConfig);
            b.workflowCreatedBy(instance.workflowCreatedBy);
            b.workflowDeletedAt(instance.workflowDeletedAt);
            b.workflowRunExpiresIn(instance.workflowRunExpiresIn);
            b.workflowStatus(instance.workflowStatus);
            b.workflowTemplateGuid(instance.workflowTemplateGuid);
            b.workflowType(instance.workflowType);
            b.workflowUpdatedBy(instance.workflowUpdatedBy);
        }

        /**
         * Fixed typeName for Workflows.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Details of the workflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowConfig(final String workflowConfig) {
            this.workflowConfig = workflowConfig;
            return self();
        }

        /**
         * Username of the user who created this workflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowCreatedBy(final String workflowCreatedBy) {
            this.workflowCreatedBy = workflowCreatedBy;
            return self();
        }

        /**
         * Deletion time of this workflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowDeletedAt(final Long workflowDeletedAt) {
            this.workflowDeletedAt = workflowDeletedAt;
            return self();
        }

        /**
         * Time duration after which a run of this workflow will expire.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowRunExpiresIn(final String workflowRunExpiresIn) {
            this.workflowRunExpiresIn = workflowRunExpiresIn;
            return self();
        }

        /**
         * Status of the workflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowStatus(final WorkflowStatus workflowStatus) {
            this.workflowStatus = workflowStatus;
            return self();
        }

        /**
         * GUID of the workflow template from which this workflow was created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowTemplateGuid(final String workflowTemplateGuid) {
            this.workflowTemplateGuid = workflowTemplateGuid;
            return self();
        }

        /**
         * Type of the workflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowType(final WorkflowType workflowType) {
            this.workflowType = workflowType;
            return self();
        }

        /**
         * Username of the user who updated this workflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowUpdatedBy(final String workflowUpdatedBy) {
            this.workflowUpdatedBy = workflowUpdatedBy;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Workflow.WorkflowBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workflowConfig=" + this.workflowConfig + ", workflowCreatedBy=" + this.workflowCreatedBy + ", workflowDeletedAt=" + this.workflowDeletedAt + ", workflowRunExpiresIn=" + this.workflowRunExpiresIn + ", workflowStatus=" + this.workflowStatus + ", workflowTemplateGuid=" + this.workflowTemplateGuid + ", workflowType=" + this.workflowType + ", workflowUpdatedBy=" + this.workflowUpdatedBy + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class WorkflowBuilderImpl extends Workflow.WorkflowBuilder<Workflow, Workflow.WorkflowBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private WorkflowBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Workflow.WorkflowBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Workflow build() {
            return new Workflow(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Workflow(final Workflow.WorkflowBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = Workflow.$default$typeName();
        this.workflowConfig = b.workflowConfig;
        this.workflowCreatedBy = b.workflowCreatedBy;
        this.workflowDeletedAt = b.workflowDeletedAt;
        this.workflowRunExpiresIn = b.workflowRunExpiresIn;
        this.workflowStatus = b.workflowStatus;
        this.workflowTemplateGuid = b.workflowTemplateGuid;
        this.workflowType = b.workflowType;
        this.workflowUpdatedBy = b.workflowUpdatedBy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Workflow.WorkflowBuilder<?, ?> _internal() {
        return new Workflow.WorkflowBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Workflow.WorkflowBuilder<?, ?> toBuilder() {
        return new Workflow.WorkflowBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Details of the workflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkflowConfig() {
        return this.workflowConfig;
    }

    /**
     * Username of the user who created this workflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkflowCreatedBy() {
        return this.workflowCreatedBy;
    }

    /**
     * Deletion time of this workflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getWorkflowDeletedAt() {
        return this.workflowDeletedAt;
    }

    /**
     * Time duration after which a run of this workflow will expire.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkflowRunExpiresIn() {
        return this.workflowRunExpiresIn;
    }

    /**
     * Status of the workflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WorkflowStatus getWorkflowStatus() {
        return this.workflowStatus;
    }

    /**
     * GUID of the workflow template from which this workflow was created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkflowTemplateGuid() {
        return this.workflowTemplateGuid;
    }

    /**
     * Type of the workflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    /**
     * Username of the user who updated this workflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkflowUpdatedBy() {
        return this.workflowUpdatedBy;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Workflow)) return false;
        final Workflow other = (Workflow) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$workflowDeletedAt = this.getWorkflowDeletedAt();
        final java.lang.Object other$workflowDeletedAt = other.getWorkflowDeletedAt();
        if (this$workflowDeletedAt == null ? other$workflowDeletedAt != null : !this$workflowDeletedAt.equals(other$workflowDeletedAt)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$workflowConfig = this.getWorkflowConfig();
        final java.lang.Object other$workflowConfig = other.getWorkflowConfig();
        if (this$workflowConfig == null ? other$workflowConfig != null : !this$workflowConfig.equals(other$workflowConfig)) return false;
        final java.lang.Object this$workflowCreatedBy = this.getWorkflowCreatedBy();
        final java.lang.Object other$workflowCreatedBy = other.getWorkflowCreatedBy();
        if (this$workflowCreatedBy == null ? other$workflowCreatedBy != null : !this$workflowCreatedBy.equals(other$workflowCreatedBy)) return false;
        final java.lang.Object this$workflowRunExpiresIn = this.getWorkflowRunExpiresIn();
        final java.lang.Object other$workflowRunExpiresIn = other.getWorkflowRunExpiresIn();
        if (this$workflowRunExpiresIn == null ? other$workflowRunExpiresIn != null : !this$workflowRunExpiresIn.equals(other$workflowRunExpiresIn)) return false;
        final java.lang.Object this$workflowStatus = this.getWorkflowStatus();
        final java.lang.Object other$workflowStatus = other.getWorkflowStatus();
        if (this$workflowStatus == null ? other$workflowStatus != null : !this$workflowStatus.equals(other$workflowStatus)) return false;
        final java.lang.Object this$workflowTemplateGuid = this.getWorkflowTemplateGuid();
        final java.lang.Object other$workflowTemplateGuid = other.getWorkflowTemplateGuid();
        if (this$workflowTemplateGuid == null ? other$workflowTemplateGuid != null : !this$workflowTemplateGuid.equals(other$workflowTemplateGuid)) return false;
        final java.lang.Object this$workflowType = this.getWorkflowType();
        final java.lang.Object other$workflowType = other.getWorkflowType();
        if (this$workflowType == null ? other$workflowType != null : !this$workflowType.equals(other$workflowType)) return false;
        final java.lang.Object this$workflowUpdatedBy = this.getWorkflowUpdatedBy();
        final java.lang.Object other$workflowUpdatedBy = other.getWorkflowUpdatedBy();
        if (this$workflowUpdatedBy == null ? other$workflowUpdatedBy != null : !this$workflowUpdatedBy.equals(other$workflowUpdatedBy)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Workflow;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $workflowDeletedAt = this.getWorkflowDeletedAt();
        result = result * PRIME + ($workflowDeletedAt == null ? 43 : $workflowDeletedAt.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $workflowConfig = this.getWorkflowConfig();
        result = result * PRIME + ($workflowConfig == null ? 43 : $workflowConfig.hashCode());
        final java.lang.Object $workflowCreatedBy = this.getWorkflowCreatedBy();
        result = result * PRIME + ($workflowCreatedBy == null ? 43 : $workflowCreatedBy.hashCode());
        final java.lang.Object $workflowRunExpiresIn = this.getWorkflowRunExpiresIn();
        result = result * PRIME + ($workflowRunExpiresIn == null ? 43 : $workflowRunExpiresIn.hashCode());
        final java.lang.Object $workflowStatus = this.getWorkflowStatus();
        result = result * PRIME + ($workflowStatus == null ? 43 : $workflowStatus.hashCode());
        final java.lang.Object $workflowTemplateGuid = this.getWorkflowTemplateGuid();
        result = result * PRIME + ($workflowTemplateGuid == null ? 43 : $workflowTemplateGuid.hashCode());
        final java.lang.Object $workflowType = this.getWorkflowType();
        result = result * PRIME + ($workflowType == null ? 43 : $workflowType.hashCode());
        final java.lang.Object $workflowUpdatedBy = this.getWorkflowUpdatedBy();
        result = result * PRIME + ($workflowUpdatedBy == null ? 43 : $workflowUpdatedBy.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Workflow(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", workflowConfig=" + this.getWorkflowConfig() + ", workflowCreatedBy=" + this.getWorkflowCreatedBy() + ", workflowDeletedAt=" + this.getWorkflowDeletedAt() + ", workflowRunExpiresIn=" + this.getWorkflowRunExpiresIn() + ", workflowStatus=" + this.getWorkflowStatus() + ", workflowTemplateGuid=" + this.getWorkflowTemplateGuid() + ", workflowType=" + this.getWorkflowType() + ", workflowUpdatedBy=" + this.getWorkflowUpdatedBy() + ")";
    }

    /**
     * Fixed typeName for Workflows.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
