// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.WorkflowRunStatus;
import com.atlan.model.enums.WorkflowRunType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of an workflow run.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class WorkflowRun extends Asset implements IWorkflowRun, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(WorkflowRun.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "WorkflowRun";
    /**
     * Fixed typeName for WorkflowRuns.
     */
    String typeName;
    /**
     * The comment added by the requester
     */
    @Attribute
    String workflowRunComment;
    /**
     * Details of the approval workflow run.
     */
    @Attribute
    String workflowRunConfig;
    /**
     * Username of the user who created this workflow run.
     */
    @Attribute
    String workflowRunCreatedBy;
    /**
     * Deletion time of this workflow run.
     */
    @Attribute
    @Date
    Long workflowRunDeletedAt;
    /**
     * Time at which this run will expire.
     */
    @Attribute
    @Date
    Long workflowRunExpiresAt;
    /**
     * The asset for which this run was created.
     */
    @Attribute
    String workflowRunOnAssetGuid;
    /**
     * Status of the run.
     */
    @Attribute
    WorkflowRunStatus workflowRunStatus;
    /**
     * Type of the workflow from which this run was created.
     */
    @Attribute
    WorkflowRunType workflowRunType;
    /**
     * Username of the user who updated this workflow run.
     */
    @Attribute
    String workflowRunUpdatedBy;
    /**
     * GUID of the workflow from which this run was created.
     */
    @Attribute
    String workflowRunWorkflowGuid;

    /**
     * Builds the minimal object necessary to create a relationship to a WorkflowRun, from a potentially
     * more-complete WorkflowRun object.
     *
     * @return the minimal object necessary to relate to the WorkflowRun
     * @throws InvalidRequestException if any of the minimal set of required properties for a WorkflowRun relationship are not found in the initial object
     */
    @Override
    public WorkflowRun trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all WorkflowRun assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) WorkflowRun assets will be included.
     *
     * @return a fluent search that includes all WorkflowRun assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all WorkflowRun assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) WorkflowRun assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all WorkflowRun assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all WorkflowRun assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) WorkflowRuns will be included
     * @return a fluent search that includes all WorkflowRun assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all WorkflowRun assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) WorkflowRuns will be included
     * @return a fluent search that includes all WorkflowRun assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a WorkflowRun by GUID. Use this to create a relationship to this WorkflowRun,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the WorkflowRun to reference
     * @return reference to a WorkflowRun that can be used for defining a relationship to a WorkflowRun
     */
    public static WorkflowRun refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a WorkflowRun by GUID. Use this to create a relationship to this WorkflowRun,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the WorkflowRun to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a WorkflowRun that can be used for defining a relationship to a WorkflowRun
     */
    public static WorkflowRun refByGuid(String guid, Reference.SaveSemantic semantic) {
        return WorkflowRun._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a WorkflowRun by qualifiedName. Use this to create a relationship to this WorkflowRun,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the WorkflowRun to reference
     * @return reference to a WorkflowRun that can be used for defining a relationship to a WorkflowRun
     */
    public static WorkflowRun refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a WorkflowRun by qualifiedName. Use this to create a relationship to this WorkflowRun,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the WorkflowRun to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a WorkflowRun that can be used for defining a relationship to a WorkflowRun
     */
    public static WorkflowRun refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return WorkflowRun._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a WorkflowRun by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the WorkflowRun to retrieve, either its GUID or its full qualifiedName
     * @return the requested full WorkflowRun, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the WorkflowRun does not exist or the provided GUID is not a WorkflowRun
     */
    @JsonIgnore
    public static WorkflowRun get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a WorkflowRun by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the WorkflowRun to retrieve, either its GUID or its full qualifiedName
     * @return the requested full WorkflowRun, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the WorkflowRun does not exist or the provided GUID is not a WorkflowRun
     */
    @JsonIgnore
    public static WorkflowRun get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a WorkflowRun by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the WorkflowRun to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full WorkflowRun, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the WorkflowRun does not exist or the provided GUID is not a WorkflowRun
     */
    @JsonIgnore
    public static WorkflowRun get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof WorkflowRun) {
                return (WorkflowRun) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof WorkflowRun) {
                return (WorkflowRun) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) WorkflowRun to active.
     *
     * @param qualifiedName for the WorkflowRun
     * @return true if the WorkflowRun is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) WorkflowRun to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the WorkflowRun
     * @return true if the WorkflowRun is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a WorkflowRun.
     *
     * @param qualifiedName of the WorkflowRun
     * @param name of the WorkflowRun
     * @return the minimal request necessary to update the WorkflowRun, as a builder
     */
    public static WorkflowRunBuilder<?, ?> updater(String qualifiedName, String name) {
        return WorkflowRun._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a WorkflowRun, from a potentially
     * more-complete WorkflowRun object.
     *
     * @return the minimal object necessary to update the WorkflowRun, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for WorkflowRun are not found in the initial object
     */
    @Override
    public WorkflowRunBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a WorkflowRun.
     *
     * @param qualifiedName of the WorkflowRun
     * @param name of the WorkflowRun
     * @return the updated WorkflowRun, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a WorkflowRun.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the WorkflowRun
     * @param name of the WorkflowRun
     * @return the updated WorkflowRun, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (WorkflowRun) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a WorkflowRun.
     *
     * @param qualifiedName of the WorkflowRun
     * @param name of the WorkflowRun
     * @return the updated WorkflowRun, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a WorkflowRun.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the WorkflowRun
     * @param name of the WorkflowRun
     * @return the updated WorkflowRun, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (WorkflowRun) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a WorkflowRun.
     *
     * @param qualifiedName of the WorkflowRun
     * @param name of the WorkflowRun
     * @return the updated WorkflowRun, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a WorkflowRun.
     *
     * @param client connectivity to the Atlan tenant from which to remove the WorkflowRun's owners
     * @param qualifiedName of the WorkflowRun
     * @param name of the WorkflowRun
     * @return the updated WorkflowRun, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (WorkflowRun) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a WorkflowRun.
     *
     * @param qualifiedName of the WorkflowRun
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated WorkflowRun, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a WorkflowRun.
     *
     * @param client connectivity to the Atlan tenant on which to update the WorkflowRun's certificate
     * @param qualifiedName of the WorkflowRun
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated WorkflowRun, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (WorkflowRun) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a WorkflowRun.
     *
     * @param qualifiedName of the WorkflowRun
     * @param name of the WorkflowRun
     * @return the updated WorkflowRun, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a WorkflowRun.
     *
     * @param client connectivity to the Atlan tenant from which to remove the WorkflowRun's certificate
     * @param qualifiedName of the WorkflowRun
     * @param name of the WorkflowRun
     * @return the updated WorkflowRun, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (WorkflowRun) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a WorkflowRun.
     *
     * @param qualifiedName of the WorkflowRun
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a WorkflowRun.
     *
     * @param client connectivity to the Atlan tenant on which to update the WorkflowRun's announcement
     * @param qualifiedName of the WorkflowRun
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (WorkflowRun) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a WorkflowRun.
     *
     * @param qualifiedName of the WorkflowRun
     * @param name of the WorkflowRun
     * @return the updated WorkflowRun, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a WorkflowRun.
     *
     * @param client connectivity to the Atlan client from which to remove the WorkflowRun's announcement
     * @param qualifiedName of the WorkflowRun
     * @param name of the WorkflowRun
     * @return the updated WorkflowRun, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (WorkflowRun) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the WorkflowRun.
     *
     * @param qualifiedName for the WorkflowRun
     * @param name human-readable name of the WorkflowRun
     * @param terms the list of terms to replace on the WorkflowRun, or null to remove all terms from the WorkflowRun
     * @return the WorkflowRun that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the WorkflowRun.
     *
     * @param client connectivity to the Atlan tenant on which to replace the WorkflowRun's assigned terms
     * @param qualifiedName for the WorkflowRun
     * @param name human-readable name of the WorkflowRun
     * @param terms the list of terms to replace on the WorkflowRun, or null to remove all terms from the WorkflowRun
     * @return the WorkflowRun that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (WorkflowRun) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the WorkflowRun, without replacing existing terms linked to the WorkflowRun.
     * Note: this operation must make two API calls — one to retrieve the WorkflowRun's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the WorkflowRun
     * @param terms the list of terms to append to the WorkflowRun
     * @return the WorkflowRun that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the WorkflowRun, without replacing existing terms linked to the WorkflowRun.
     * Note: this operation must make two API calls — one to retrieve the WorkflowRun's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the WorkflowRun
     * @param qualifiedName for the WorkflowRun
     * @param terms the list of terms to append to the WorkflowRun
     * @return the WorkflowRun that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (WorkflowRun) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a WorkflowRun, without replacing all existing terms linked to the WorkflowRun.
     * Note: this operation must make two API calls — one to retrieve the WorkflowRun's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the WorkflowRun
     * @param terms the list of terms to remove from the WorkflowRun, which must be referenced by GUID
     * @return the WorkflowRun that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a WorkflowRun, without replacing all existing terms linked to the WorkflowRun.
     * Note: this operation must make two API calls — one to retrieve the WorkflowRun's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the WorkflowRun
     * @param qualifiedName for the WorkflowRun
     * @param terms the list of terms to remove from the WorkflowRun, which must be referenced by GUID
     * @return the WorkflowRun that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static WorkflowRun removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (WorkflowRun) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a WorkflowRun, without replacing existing Atlan tags linked to the WorkflowRun.
     * Note: this operation must make two API calls — one to retrieve the WorkflowRun's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the WorkflowRun
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated WorkflowRun
     */
    public static WorkflowRun appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a WorkflowRun, without replacing existing Atlan tags linked to the WorkflowRun.
     * Note: this operation must make two API calls — one to retrieve the WorkflowRun's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the WorkflowRun
     * @param qualifiedName of the WorkflowRun
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated WorkflowRun
     */
    public static WorkflowRun appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (WorkflowRun) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a WorkflowRun, without replacing existing Atlan tags linked to the WorkflowRun.
     * Note: this operation must make two API calls — one to retrieve the WorkflowRun's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the WorkflowRun
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated WorkflowRun
     */
    public static WorkflowRun appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a WorkflowRun, without replacing existing Atlan tags linked to the WorkflowRun.
     * Note: this operation must make two API calls — one to retrieve the WorkflowRun's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the WorkflowRun
     * @param qualifiedName of the WorkflowRun
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated WorkflowRun
     */
    public static WorkflowRun appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (WorkflowRun) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a WorkflowRun.
     *
     * @param qualifiedName of the WorkflowRun
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the WorkflowRun
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a WorkflowRun.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a WorkflowRun
     * @param qualifiedName of the WorkflowRun
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the WorkflowRun
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class WorkflowRunBuilder<C extends WorkflowRun, B extends WorkflowRun.WorkflowRunBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workflowRunComment;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workflowRunConfig;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workflowRunCreatedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long workflowRunDeletedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long workflowRunExpiresAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workflowRunOnAssetGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private WorkflowRunStatus workflowRunStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private WorkflowRunType workflowRunType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workflowRunUpdatedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workflowRunWorkflowGuid;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            WorkflowRun.WorkflowRunBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final WorkflowRun instance, final WorkflowRun.WorkflowRunBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workflowRunComment(instance.workflowRunComment);
            b.workflowRunConfig(instance.workflowRunConfig);
            b.workflowRunCreatedBy(instance.workflowRunCreatedBy);
            b.workflowRunDeletedAt(instance.workflowRunDeletedAt);
            b.workflowRunExpiresAt(instance.workflowRunExpiresAt);
            b.workflowRunOnAssetGuid(instance.workflowRunOnAssetGuid);
            b.workflowRunStatus(instance.workflowRunStatus);
            b.workflowRunType(instance.workflowRunType);
            b.workflowRunUpdatedBy(instance.workflowRunUpdatedBy);
            b.workflowRunWorkflowGuid(instance.workflowRunWorkflowGuid);
        }

        /**
         * Fixed typeName for WorkflowRuns.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * The comment added by the requester
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowRunComment(final String workflowRunComment) {
            this.workflowRunComment = workflowRunComment;
            return self();
        }

        /**
         * Details of the approval workflow run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowRunConfig(final String workflowRunConfig) {
            this.workflowRunConfig = workflowRunConfig;
            return self();
        }

        /**
         * Username of the user who created this workflow run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowRunCreatedBy(final String workflowRunCreatedBy) {
            this.workflowRunCreatedBy = workflowRunCreatedBy;
            return self();
        }

        /**
         * Deletion time of this workflow run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowRunDeletedAt(final Long workflowRunDeletedAt) {
            this.workflowRunDeletedAt = workflowRunDeletedAt;
            return self();
        }

        /**
         * Time at which this run will expire.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowRunExpiresAt(final Long workflowRunExpiresAt) {
            this.workflowRunExpiresAt = workflowRunExpiresAt;
            return self();
        }

        /**
         * The asset for which this run was created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowRunOnAssetGuid(final String workflowRunOnAssetGuid) {
            this.workflowRunOnAssetGuid = workflowRunOnAssetGuid;
            return self();
        }

        /**
         * Status of the run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowRunStatus(final WorkflowRunStatus workflowRunStatus) {
            this.workflowRunStatus = workflowRunStatus;
            return self();
        }

        /**
         * Type of the workflow from which this run was created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowRunType(final WorkflowRunType workflowRunType) {
            this.workflowRunType = workflowRunType;
            return self();
        }

        /**
         * Username of the user who updated this workflow run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowRunUpdatedBy(final String workflowRunUpdatedBy) {
            this.workflowRunUpdatedBy = workflowRunUpdatedBy;
            return self();
        }

        /**
         * GUID of the workflow from which this run was created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workflowRunWorkflowGuid(final String workflowRunWorkflowGuid) {
            this.workflowRunWorkflowGuid = workflowRunWorkflowGuid;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "WorkflowRun.WorkflowRunBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workflowRunComment=" + this.workflowRunComment + ", workflowRunConfig=" + this.workflowRunConfig + ", workflowRunCreatedBy=" + this.workflowRunCreatedBy + ", workflowRunDeletedAt=" + this.workflowRunDeletedAt + ", workflowRunExpiresAt=" + this.workflowRunExpiresAt + ", workflowRunOnAssetGuid=" + this.workflowRunOnAssetGuid + ", workflowRunStatus=" + this.workflowRunStatus + ", workflowRunType=" + this.workflowRunType + ", workflowRunUpdatedBy=" + this.workflowRunUpdatedBy + ", workflowRunWorkflowGuid=" + this.workflowRunWorkflowGuid + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class WorkflowRunBuilderImpl extends WorkflowRun.WorkflowRunBuilder<WorkflowRun, WorkflowRun.WorkflowRunBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private WorkflowRunBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected WorkflowRun.WorkflowRunBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public WorkflowRun build() {
            return new WorkflowRun(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected WorkflowRun(final WorkflowRun.WorkflowRunBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = WorkflowRun.$default$typeName();
        this.workflowRunComment = b.workflowRunComment;
        this.workflowRunConfig = b.workflowRunConfig;
        this.workflowRunCreatedBy = b.workflowRunCreatedBy;
        this.workflowRunDeletedAt = b.workflowRunDeletedAt;
        this.workflowRunExpiresAt = b.workflowRunExpiresAt;
        this.workflowRunOnAssetGuid = b.workflowRunOnAssetGuid;
        this.workflowRunStatus = b.workflowRunStatus;
        this.workflowRunType = b.workflowRunType;
        this.workflowRunUpdatedBy = b.workflowRunUpdatedBy;
        this.workflowRunWorkflowGuid = b.workflowRunWorkflowGuid;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static WorkflowRun.WorkflowRunBuilder<?, ?> _internal() {
        return new WorkflowRun.WorkflowRunBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WorkflowRun.WorkflowRunBuilder<?, ?> toBuilder() {
        return new WorkflowRun.WorkflowRunBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * The comment added by the requester
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkflowRunComment() {
        return this.workflowRunComment;
    }

    /**
     * Details of the approval workflow run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkflowRunConfig() {
        return this.workflowRunConfig;
    }

    /**
     * Username of the user who created this workflow run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkflowRunCreatedBy() {
        return this.workflowRunCreatedBy;
    }

    /**
     * Deletion time of this workflow run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getWorkflowRunDeletedAt() {
        return this.workflowRunDeletedAt;
    }

    /**
     * Time at which this run will expire.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getWorkflowRunExpiresAt() {
        return this.workflowRunExpiresAt;
    }

    /**
     * The asset for which this run was created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkflowRunOnAssetGuid() {
        return this.workflowRunOnAssetGuid;
    }

    /**
     * Status of the run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WorkflowRunStatus getWorkflowRunStatus() {
        return this.workflowRunStatus;
    }

    /**
     * Type of the workflow from which this run was created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WorkflowRunType getWorkflowRunType() {
        return this.workflowRunType;
    }

    /**
     * Username of the user who updated this workflow run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkflowRunUpdatedBy() {
        return this.workflowRunUpdatedBy;
    }

    /**
     * GUID of the workflow from which this run was created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkflowRunWorkflowGuid() {
        return this.workflowRunWorkflowGuid;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof WorkflowRun)) return false;
        final WorkflowRun other = (WorkflowRun) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$workflowRunDeletedAt = this.getWorkflowRunDeletedAt();
        final java.lang.Object other$workflowRunDeletedAt = other.getWorkflowRunDeletedAt();
        if (this$workflowRunDeletedAt == null ? other$workflowRunDeletedAt != null : !this$workflowRunDeletedAt.equals(other$workflowRunDeletedAt)) return false;
        final java.lang.Object this$workflowRunExpiresAt = this.getWorkflowRunExpiresAt();
        final java.lang.Object other$workflowRunExpiresAt = other.getWorkflowRunExpiresAt();
        if (this$workflowRunExpiresAt == null ? other$workflowRunExpiresAt != null : !this$workflowRunExpiresAt.equals(other$workflowRunExpiresAt)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$workflowRunComment = this.getWorkflowRunComment();
        final java.lang.Object other$workflowRunComment = other.getWorkflowRunComment();
        if (this$workflowRunComment == null ? other$workflowRunComment != null : !this$workflowRunComment.equals(other$workflowRunComment)) return false;
        final java.lang.Object this$workflowRunConfig = this.getWorkflowRunConfig();
        final java.lang.Object other$workflowRunConfig = other.getWorkflowRunConfig();
        if (this$workflowRunConfig == null ? other$workflowRunConfig != null : !this$workflowRunConfig.equals(other$workflowRunConfig)) return false;
        final java.lang.Object this$workflowRunCreatedBy = this.getWorkflowRunCreatedBy();
        final java.lang.Object other$workflowRunCreatedBy = other.getWorkflowRunCreatedBy();
        if (this$workflowRunCreatedBy == null ? other$workflowRunCreatedBy != null : !this$workflowRunCreatedBy.equals(other$workflowRunCreatedBy)) return false;
        final java.lang.Object this$workflowRunOnAssetGuid = this.getWorkflowRunOnAssetGuid();
        final java.lang.Object other$workflowRunOnAssetGuid = other.getWorkflowRunOnAssetGuid();
        if (this$workflowRunOnAssetGuid == null ? other$workflowRunOnAssetGuid != null : !this$workflowRunOnAssetGuid.equals(other$workflowRunOnAssetGuid)) return false;
        final java.lang.Object this$workflowRunStatus = this.getWorkflowRunStatus();
        final java.lang.Object other$workflowRunStatus = other.getWorkflowRunStatus();
        if (this$workflowRunStatus == null ? other$workflowRunStatus != null : !this$workflowRunStatus.equals(other$workflowRunStatus)) return false;
        final java.lang.Object this$workflowRunType = this.getWorkflowRunType();
        final java.lang.Object other$workflowRunType = other.getWorkflowRunType();
        if (this$workflowRunType == null ? other$workflowRunType != null : !this$workflowRunType.equals(other$workflowRunType)) return false;
        final java.lang.Object this$workflowRunUpdatedBy = this.getWorkflowRunUpdatedBy();
        final java.lang.Object other$workflowRunUpdatedBy = other.getWorkflowRunUpdatedBy();
        if (this$workflowRunUpdatedBy == null ? other$workflowRunUpdatedBy != null : !this$workflowRunUpdatedBy.equals(other$workflowRunUpdatedBy)) return false;
        final java.lang.Object this$workflowRunWorkflowGuid = this.getWorkflowRunWorkflowGuid();
        final java.lang.Object other$workflowRunWorkflowGuid = other.getWorkflowRunWorkflowGuid();
        if (this$workflowRunWorkflowGuid == null ? other$workflowRunWorkflowGuid != null : !this$workflowRunWorkflowGuid.equals(other$workflowRunWorkflowGuid)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof WorkflowRun;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $workflowRunDeletedAt = this.getWorkflowRunDeletedAt();
        result = result * PRIME + ($workflowRunDeletedAt == null ? 43 : $workflowRunDeletedAt.hashCode());
        final java.lang.Object $workflowRunExpiresAt = this.getWorkflowRunExpiresAt();
        result = result * PRIME + ($workflowRunExpiresAt == null ? 43 : $workflowRunExpiresAt.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $workflowRunComment = this.getWorkflowRunComment();
        result = result * PRIME + ($workflowRunComment == null ? 43 : $workflowRunComment.hashCode());
        final java.lang.Object $workflowRunConfig = this.getWorkflowRunConfig();
        result = result * PRIME + ($workflowRunConfig == null ? 43 : $workflowRunConfig.hashCode());
        final java.lang.Object $workflowRunCreatedBy = this.getWorkflowRunCreatedBy();
        result = result * PRIME + ($workflowRunCreatedBy == null ? 43 : $workflowRunCreatedBy.hashCode());
        final java.lang.Object $workflowRunOnAssetGuid = this.getWorkflowRunOnAssetGuid();
        result = result * PRIME + ($workflowRunOnAssetGuid == null ? 43 : $workflowRunOnAssetGuid.hashCode());
        final java.lang.Object $workflowRunStatus = this.getWorkflowRunStatus();
        result = result * PRIME + ($workflowRunStatus == null ? 43 : $workflowRunStatus.hashCode());
        final java.lang.Object $workflowRunType = this.getWorkflowRunType();
        result = result * PRIME + ($workflowRunType == null ? 43 : $workflowRunType.hashCode());
        final java.lang.Object $workflowRunUpdatedBy = this.getWorkflowRunUpdatedBy();
        result = result * PRIME + ($workflowRunUpdatedBy == null ? 43 : $workflowRunUpdatedBy.hashCode());
        final java.lang.Object $workflowRunWorkflowGuid = this.getWorkflowRunWorkflowGuid();
        result = result * PRIME + ($workflowRunWorkflowGuid == null ? 43 : $workflowRunWorkflowGuid.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "WorkflowRun(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", workflowRunComment=" + this.getWorkflowRunComment() + ", workflowRunConfig=" + this.getWorkflowRunConfig() + ", workflowRunCreatedBy=" + this.getWorkflowRunCreatedBy() + ", workflowRunDeletedAt=" + this.getWorkflowRunDeletedAt() + ", workflowRunExpiresAt=" + this.getWorkflowRunExpiresAt() + ", workflowRunOnAssetGuid=" + this.getWorkflowRunOnAssetGuid() + ", workflowRunStatus=" + this.getWorkflowRunStatus() + ", workflowRunType=" + this.getWorkflowRunType() + ", workflowRunUpdatedBy=" + this.getWorkflowRunUpdatedBy() + ", workflowRunWorkflowGuid=" + this.getWorkflowRunWorkflowGuid() + ")";
    }

    /**
     * Fixed typeName for WorkflowRuns.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
