// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2024 Atlan Pte. Ltd. */
package com.atlan.model.contracts;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.serde.ReadableCustomMetadataDeserializer;
import com.atlan.serde.ReadableCustomMetadataSerializer;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Capture the detailed specification of a data contract for an asset.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "template_version")
@JsonSubTypes({@JsonSubTypes.Type(value = DCS_V_0_0_2.class, name = "0.0.2")})
@SuppressWarnings("cast")
public class DataContractSpec extends AtlanObject {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(DataContractSpec.class);
    private static final long serialVersionUID = 2L;
    /**
     * Controls the specification as one for a data contract.
     */
    String kind;
    /**
     * State of the contract.
     */
    DataContractStatus status;
    /**
     * Version of the template for the data contract.
     */
    @JsonProperty("template_version")
    String templateVersion;
    /**
     * Name of the asset as it exists inside Atlan.
     */
    String dataset;
    /**
     * Type of the dataset in Atlan.
     */
    String type;
    /**
     * Description of this dataset.
     */
    String description;
    /**
     * Name that must match a data source defined in your config file.
     */
    String datasource;
    /**
     * Owners of the dataset, which can include users (by username) and / or groups (by internal Atlan alias).
     */
    Owners owners;
    /**
     * Certification to apply to the dataset.
     */
    Certification certification;
    /**
     * Announcement to apply to the dataset.
     */
    Announcement announcement;
    /**
     * Glossary terms to assign to the dataset.
     */
    List<String> terms;
    /**
     * Atlan tags for the dataset.
     */
    List<DCTag> tags;
    /**
     * Custom metadata for the dataset.
     */
    @JsonProperty("custom_metadata")
    @JsonSerialize(using = ReadableCustomMetadataSerializer.class)
    @JsonDeserialize(using = ReadableCustomMetadataDeserializer.class)
    Map<String, CustomMetadataAttributes> customMetadataSets;
    /**
     * Details of each column in the dataset to be governed.
     */
    List<DCColumn> columns;
    /**
     * List of checks to run to verify data quality of the dataset.
     */
    List<String> checks;
    /**
     * Any extra properties provided in the specification (but unknown to this version of the template).
     */
    @JsonAnySetter
    Map<String, Object> extraProperties;

    @JsonAnyGetter
    public Map<String, Object> getExtraProperties() {
        return extraProperties;
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = DataContractSpec.Owners.OwnersBuilderImpl.class)
    public static final class Owners {
        /**
         * Individual users who own the dataset.
         */
        List<String> users;
        /**
         * Groups that own the dataset.
         */
        List<String> groups;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class OwnersBuilder<C extends DataContractSpec.Owners, B extends DataContractSpec.Owners.OwnersBuilder<C, B>> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private java.util.ArrayList<String> users;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private java.util.ArrayList<String> groups;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                DataContractSpec.Owners.OwnersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final DataContractSpec.Owners instance, final DataContractSpec.Owners.OwnersBuilder<?, ?> b) {
                b.users(instance.users == null ? java.util.Collections.<String>emptyList() : instance.users);
                b.groups(instance.groups == null ? java.util.Collections.<String>emptyList() : instance.groups);
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B user(final String user) {
                if (this.users == null) this.users = new java.util.ArrayList<String>();
                this.users.add(user);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B users(final java.util.Collection<? extends String> users) {
                if (users == null) {
                    throw new java.lang.NullPointerException("users cannot be null");
                }
                if (this.users == null) this.users = new java.util.ArrayList<String>();
                this.users.addAll(users);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B clearUsers() {
                if (this.users != null) this.users.clear();
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B group(final String group) {
                if (this.groups == null) this.groups = new java.util.ArrayList<String>();
                this.groups.add(group);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B groups(final java.util.Collection<? extends String> groups) {
                if (groups == null) {
                    throw new java.lang.NullPointerException("groups cannot be null");
                }
                if (this.groups == null) this.groups = new java.util.ArrayList<String>();
                this.groups.addAll(groups);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B clearGroups() {
                if (this.groups != null) this.groups.clear();
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "DataContractSpec.Owners.OwnersBuilder(users=" + this.users + ", groups=" + this.groups + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class OwnersBuilderImpl extends DataContractSpec.Owners.OwnersBuilder<DataContractSpec.Owners, DataContractSpec.Owners.OwnersBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private OwnersBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected DataContractSpec.Owners.OwnersBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public DataContractSpec.Owners build() {
                return new DataContractSpec.Owners(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Owners(final DataContractSpec.Owners.OwnersBuilder<?, ?> b) {
            java.util.List<String> users;
            switch (b.users == null ? 0 : b.users.size()) {
            case 0: 
                users = java.util.Collections.emptyList();
                break;
            case 1: 
                users = java.util.Collections.singletonList(b.users.get(0));
                break;
            default: 
                users = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.users));
            }
            this.users = users;
            java.util.List<String> groups;
            switch (b.groups == null ? 0 : b.groups.size()) {
            case 0: 
                groups = java.util.Collections.emptyList();
                break;
            case 1: 
                groups = java.util.Collections.singletonList(b.groups.get(0));
                break;
            default: 
                groups = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.groups));
            }
            this.groups = groups;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static DataContractSpec.Owners.OwnersBuilder<?, ?> builder() {
            return new DataContractSpec.Owners.OwnersBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DataContractSpec.Owners.OwnersBuilder<?, ?> toBuilder() {
            return new DataContractSpec.Owners.OwnersBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Individual users who own the dataset.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getUsers() {
            return this.users;
        }

        /**
         * Groups that own the dataset.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getGroups() {
            return this.groups;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof DataContractSpec.Owners)) return false;
            final DataContractSpec.Owners other = (DataContractSpec.Owners) o;
            final java.lang.Object this$users = this.getUsers();
            final java.lang.Object other$users = other.getUsers();
            if (this$users == null ? other$users != null : !this$users.equals(other$users)) return false;
            final java.lang.Object this$groups = this.getGroups();
            final java.lang.Object other$groups = other.getGroups();
            if (this$groups == null ? other$groups != null : !this$groups.equals(other$groups)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $users = this.getUsers();
            result = result * PRIME + ($users == null ? 43 : $users.hashCode());
            final java.lang.Object $groups = this.getGroups();
            result = result * PRIME + ($groups == null ? 43 : $groups.hashCode());
            return result;
        }
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = DataContractSpec.Certification.CertificationBuilderImpl.class)
    public static final class Certification {
        /**
         * State of the certification.
         */
        CertificateStatus status;
        /**
         * Message to accompany the certification.
         */
        String message;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class CertificationBuilder<C extends DataContractSpec.Certification, B extends DataContractSpec.Certification.CertificationBuilder<C, B>> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private CertificateStatus status;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String message;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                DataContractSpec.Certification.CertificationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final DataContractSpec.Certification instance, final DataContractSpec.Certification.CertificationBuilder<?, ?> b) {
                b.status(instance.status);
                b.message(instance.message);
            }

            /**
             * State of the certification.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B status(final CertificateStatus status) {
                this.status = status;
                return self();
            }

            /**
             * Message to accompany the certification.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B message(final String message) {
                this.message = message;
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "DataContractSpec.Certification.CertificationBuilder(status=" + this.status + ", message=" + this.message + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class CertificationBuilderImpl extends DataContractSpec.Certification.CertificationBuilder<DataContractSpec.Certification, DataContractSpec.Certification.CertificationBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private CertificationBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected DataContractSpec.Certification.CertificationBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public DataContractSpec.Certification build() {
                return new DataContractSpec.Certification(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Certification(final DataContractSpec.Certification.CertificationBuilder<?, ?> b) {
            this.status = b.status;
            this.message = b.message;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static DataContractSpec.Certification.CertificationBuilder<?, ?> builder() {
            return new DataContractSpec.Certification.CertificationBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DataContractSpec.Certification.CertificationBuilder<?, ?> toBuilder() {
            return new DataContractSpec.Certification.CertificationBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * State of the certification.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CertificateStatus getStatus() {
            return this.status;
        }

        /**
         * Message to accompany the certification.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getMessage() {
            return this.message;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof DataContractSpec.Certification)) return false;
            final DataContractSpec.Certification other = (DataContractSpec.Certification) o;
            final java.lang.Object this$status = this.getStatus();
            final java.lang.Object other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
            final java.lang.Object this$message = this.getMessage();
            final java.lang.Object other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $status = this.getStatus();
            result = result * PRIME + ($status == null ? 43 : $status.hashCode());
            final java.lang.Object $message = this.getMessage();
            result = result * PRIME + ($message == null ? 43 : $message.hashCode());
            return result;
        }
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = DataContractSpec.Announcement.AnnouncementBuilderImpl.class)
    public static final class Announcement {
        /**
         * Type of announcement.
         */
        AtlanAnnouncementType type;
        /**
         * Title to use for the announcement.
         */
        String title;
        /**
         * Message to accompany the announcement.
         */
        String description;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class AnnouncementBuilder<C extends DataContractSpec.Announcement, B extends DataContractSpec.Announcement.AnnouncementBuilder<C, B>> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private AtlanAnnouncementType type;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String title;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String description;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                DataContractSpec.Announcement.AnnouncementBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final DataContractSpec.Announcement instance, final DataContractSpec.Announcement.AnnouncementBuilder<?, ?> b) {
                b.type(instance.type);
                b.title(instance.title);
                b.description(instance.description);
            }

            /**
             * Type of announcement.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B type(final AtlanAnnouncementType type) {
                this.type = type;
                return self();
            }

            /**
             * Title to use for the announcement.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B title(final String title) {
                this.title = title;
                return self();
            }

            /**
             * Message to accompany the announcement.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B description(final String description) {
                this.description = description;
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "DataContractSpec.Announcement.AnnouncementBuilder(type=" + this.type + ", title=" + this.title + ", description=" + this.description + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class AnnouncementBuilderImpl extends DataContractSpec.Announcement.AnnouncementBuilder<DataContractSpec.Announcement, DataContractSpec.Announcement.AnnouncementBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private AnnouncementBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected DataContractSpec.Announcement.AnnouncementBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public DataContractSpec.Announcement build() {
                return new DataContractSpec.Announcement(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Announcement(final DataContractSpec.Announcement.AnnouncementBuilder<?, ?> b) {
            this.type = b.type;
            this.title = b.title;
            this.description = b.description;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static DataContractSpec.Announcement.AnnouncementBuilder<?, ?> builder() {
            return new DataContractSpec.Announcement.AnnouncementBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DataContractSpec.Announcement.AnnouncementBuilder<?, ?> toBuilder() {
            return new DataContractSpec.Announcement.AnnouncementBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Type of announcement.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanAnnouncementType getType() {
            return this.type;
        }

        /**
         * Title to use for the announcement.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTitle() {
            return this.title;
        }

        /**
         * Message to accompany the announcement.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDescription() {
            return this.description;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof DataContractSpec.Announcement)) return false;
            final DataContractSpec.Announcement other = (DataContractSpec.Announcement) o;
            final java.lang.Object this$type = this.getType();
            final java.lang.Object other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
            final java.lang.Object this$title = this.getTitle();
            final java.lang.Object other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) return false;
            final java.lang.Object this$description = this.getDescription();
            final java.lang.Object other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $type = this.getType();
            result = result * PRIME + ($type == null ? 43 : $type.hashCode());
            final java.lang.Object $title = this.getTitle();
            result = result * PRIME + ($title == null ? 43 : $title.hashCode());
            final java.lang.Object $description = this.getDescription();
            result = result * PRIME + ($description == null ? 43 : $description.hashCode());
            return result;
        }
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = DataContractSpec.DCTag.DCTagBuilderImpl.class)
    public static final class DCTag {
        /**
         * Human-readable name of the Atlan tag.
         */
        String name;
        /**
         * Whether to propagate the tag at all (true) or not (false).
         */
        Boolean propagate;
        /**
         * Whether to propagate the tag through lineage (true) or not (false).
         */
        @JsonProperty("restrict_propagation_through_lineage")
        Boolean propagateThroughLineage;
        /**
         * Whether to propagate the tag through asset's containment hierarchy (true) or not (false).
         */
        @JsonProperty("restrict_propagation_through_hierarchy")
        Boolean propagateThroughHierarchy;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class DCTagBuilder<C extends DataContractSpec.DCTag, B extends DataContractSpec.DCTag.DCTagBuilder<C, B>> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String name;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean propagate;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean propagateThroughLineage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean propagateThroughHierarchy;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                DataContractSpec.DCTag.DCTagBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final DataContractSpec.DCTag instance, final DataContractSpec.DCTag.DCTagBuilder<?, ?> b) {
                b.name(instance.name);
                b.propagate(instance.propagate);
                b.propagateThroughLineage(instance.propagateThroughLineage);
                b.propagateThroughHierarchy(instance.propagateThroughHierarchy);
            }

            /**
             * Human-readable name of the Atlan tag.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B name(final String name) {
                this.name = name;
                return self();
            }

            /**
             * Whether to propagate the tag at all (true) or not (false).
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B propagate(final Boolean propagate) {
                this.propagate = propagate;
                return self();
            }

            /**
             * Whether to propagate the tag through lineage (true) or not (false).
             * @return {@code this}.
             */
            @JsonProperty("restrict_propagation_through_lineage")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B propagateThroughLineage(final Boolean propagateThroughLineage) {
                this.propagateThroughLineage = propagateThroughLineage;
                return self();
            }

            /**
             * Whether to propagate the tag through asset's containment hierarchy (true) or not (false).
             * @return {@code this}.
             */
            @JsonProperty("restrict_propagation_through_hierarchy")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B propagateThroughHierarchy(final Boolean propagateThroughHierarchy) {
                this.propagateThroughHierarchy = propagateThroughHierarchy;
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "DataContractSpec.DCTag.DCTagBuilder(name=" + this.name + ", propagate=" + this.propagate + ", propagateThroughLineage=" + this.propagateThroughLineage + ", propagateThroughHierarchy=" + this.propagateThroughHierarchy + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class DCTagBuilderImpl extends DataContractSpec.DCTag.DCTagBuilder<DataContractSpec.DCTag, DataContractSpec.DCTag.DCTagBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private DCTagBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected DataContractSpec.DCTag.DCTagBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public DataContractSpec.DCTag build() {
                return new DataContractSpec.DCTag(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DCTag(final DataContractSpec.DCTag.DCTagBuilder<?, ?> b) {
            this.name = b.name;
            this.propagate = b.propagate;
            this.propagateThroughLineage = b.propagateThroughLineage;
            this.propagateThroughHierarchy = b.propagateThroughHierarchy;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static DataContractSpec.DCTag.DCTagBuilder<?, ?> builder() {
            return new DataContractSpec.DCTag.DCTagBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DataContractSpec.DCTag.DCTagBuilder<?, ?> toBuilder() {
            return new DataContractSpec.DCTag.DCTagBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Human-readable name of the Atlan tag.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
            return this.name;
        }

        /**
         * Whether to propagate the tag at all (true) or not (false).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getPropagate() {
            return this.propagate;
        }

        /**
         * Whether to propagate the tag through lineage (true) or not (false).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getPropagateThroughLineage() {
            return this.propagateThroughLineage;
        }

        /**
         * Whether to propagate the tag through asset's containment hierarchy (true) or not (false).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getPropagateThroughHierarchy() {
            return this.propagateThroughHierarchy;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof DataContractSpec.DCTag)) return false;
            final DataContractSpec.DCTag other = (DataContractSpec.DCTag) o;
            final java.lang.Object this$propagate = this.getPropagate();
            final java.lang.Object other$propagate = other.getPropagate();
            if (this$propagate == null ? other$propagate != null : !this$propagate.equals(other$propagate)) return false;
            final java.lang.Object this$propagateThroughLineage = this.getPropagateThroughLineage();
            final java.lang.Object other$propagateThroughLineage = other.getPropagateThroughLineage();
            if (this$propagateThroughLineage == null ? other$propagateThroughLineage != null : !this$propagateThroughLineage.equals(other$propagateThroughLineage)) return false;
            final java.lang.Object this$propagateThroughHierarchy = this.getPropagateThroughHierarchy();
            final java.lang.Object other$propagateThroughHierarchy = other.getPropagateThroughHierarchy();
            if (this$propagateThroughHierarchy == null ? other$propagateThroughHierarchy != null : !this$propagateThroughHierarchy.equals(other$propagateThroughHierarchy)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $propagate = this.getPropagate();
            result = result * PRIME + ($propagate == null ? 43 : $propagate.hashCode());
            final java.lang.Object $propagateThroughLineage = this.getPropagateThroughLineage();
            result = result * PRIME + ($propagateThroughLineage == null ? 43 : $propagateThroughLineage.hashCode());
            final java.lang.Object $propagateThroughHierarchy = this.getPropagateThroughHierarchy();
            result = result * PRIME + ($propagateThroughHierarchy == null ? 43 : $propagateThroughHierarchy.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = DataContractSpec.DCColumn.DCColumnBuilderImpl.class)
    public static final class DCColumn {
        /**
         * Name of the column as it is defined in the source system (often technical).
         */
        String name;
        /**
         * Alias for the column, to make its name more readable.
         */
        @JsonProperty("business_name")
        String displayName;
        /**
         * Description of this column, for documentation purposes.
         */
        String description;
        /**
         * When true, this column is the primary key for the table.
         */
        @JsonProperty("is_primary")
        Boolean isPrimary;
        /**
         * Physical data type of values in this column (e.g. {@code varchar(20)}).
         */
        @JsonProperty("data_type")
        String dataType;
        /**
         * Logical data type of values in this column (e.g. {@code string}).
         */
        @JsonProperty("logical_type")
        String logicalType;
        /**
         * Format of data to consider invalid.
         */
        @JsonProperty("invalid_format")
        String invalidFormat;
        /**
         * Format of data to consider valid.
         */
        @JsonProperty("valid_format")
        String validFormat;
        /**
         * Regular expression to match invalid values.
         */
        @JsonProperty("invalid_regex")
        String invalidRegex;
        /**
         * Regular expression to match valid values.
         */
        @JsonProperty("valid_regex")
        String validRegex;
        /**
         * Regular expression to match missing values.
         */
        @JsonProperty("missing_regex")
        String missingRegex;
        /**
         * Enumeration of values that should be considered invalid.
         */
        @JsonProperty("invalid_values")
        List<String> invalidValues;
        /**
         * Enumeration of values that should be considered valid.
         */
        @JsonProperty("valid_values")
        List<String> validValues;
        /**
         * Enumeration of values that should be considered missing.
         */
        @JsonProperty("missing_values")
        List<String> missingValues;
        /**
         * When true, this column cannot be empty (without values).
         */
        @JsonProperty("not_null")
        Boolean notNull;
        /**
         * Fixed length for a string to be considered valid.
         */
        @JsonProperty("valid_length")
        Long validLength;
        /**
         * Maximum length for a string to be considered valid.
         */
        @JsonProperty("valid_max_length")
        Long validMaxLength;
        /**
         * Minimum numeric value considered valid.
         */
        @JsonProperty("valid_min")
        Double validMin;
        /**
         * Maximum numeric value considered valid.
         */
        @JsonProperty("valid_max")
        Double validMax;
        /**
         * Minimum length for a string to be considered valid.
         */
        @JsonProperty("valid_min_length")
        Long validMinLength;
        /**
         * When true, this column must have unique values.
         */
        Boolean unique;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class DCColumnBuilder<C extends DataContractSpec.DCColumn, B extends DataContractSpec.DCColumn.DCColumnBuilder<C, B>> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String name;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String displayName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String description;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean isPrimary;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String dataType;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String logicalType;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String invalidFormat;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String validFormat;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String invalidRegex;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String validRegex;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String missingRegex;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private java.util.ArrayList<String> invalidValues;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private java.util.ArrayList<String> validValues;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private java.util.ArrayList<String> missingValues;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean notNull;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long validLength;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long validMaxLength;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double validMin;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Double validMax;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long validMinLength;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean unique;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                DataContractSpec.DCColumn.DCColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final DataContractSpec.DCColumn instance, final DataContractSpec.DCColumn.DCColumnBuilder<?, ?> b) {
                b.name(instance.name);
                b.displayName(instance.displayName);
                b.description(instance.description);
                b.isPrimary(instance.isPrimary);
                b.dataType(instance.dataType);
                b.logicalType(instance.logicalType);
                b.invalidFormat(instance.invalidFormat);
                b.validFormat(instance.validFormat);
                b.invalidRegex(instance.invalidRegex);
                b.validRegex(instance.validRegex);
                b.missingRegex(instance.missingRegex);
                b.invalidValues(instance.invalidValues == null ? java.util.Collections.<String>emptyList() : instance.invalidValues);
                b.validValues(instance.validValues == null ? java.util.Collections.<String>emptyList() : instance.validValues);
                b.missingValues(instance.missingValues == null ? java.util.Collections.<String>emptyList() : instance.missingValues);
                b.notNull(instance.notNull);
                b.validLength(instance.validLength);
                b.validMaxLength(instance.validMaxLength);
                b.validMin(instance.validMin);
                b.validMax(instance.validMax);
                b.validMinLength(instance.validMinLength);
                b.unique(instance.unique);
            }

            /**
             * Name of the column as it is defined in the source system (often technical).
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B name(final String name) {
                this.name = name;
                return self();
            }

            /**
             * Alias for the column, to make its name more readable.
             * @return {@code this}.
             */
            @JsonProperty("business_name")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B displayName(final String displayName) {
                this.displayName = displayName;
                return self();
            }

            /**
             * Description of this column, for documentation purposes.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B description(final String description) {
                this.description = description;
                return self();
            }

            /**
             * When true, this column is the primary key for the table.
             * @return {@code this}.
             */
            @JsonProperty("is_primary")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B isPrimary(final Boolean isPrimary) {
                this.isPrimary = isPrimary;
                return self();
            }

            /**
             * Physical data type of values in this column (e.g. {@code varchar(20)}).
             * @return {@code this}.
             */
            @JsonProperty("data_type")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B dataType(final String dataType) {
                this.dataType = dataType;
                return self();
            }

            /**
             * Logical data type of values in this column (e.g. {@code string}).
             * @return {@code this}.
             */
            @JsonProperty("logical_type")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B logicalType(final String logicalType) {
                this.logicalType = logicalType;
                return self();
            }

            /**
             * Format of data to consider invalid.
             * @return {@code this}.
             */
            @JsonProperty("invalid_format")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B invalidFormat(final String invalidFormat) {
                this.invalidFormat = invalidFormat;
                return self();
            }

            /**
             * Format of data to consider valid.
             * @return {@code this}.
             */
            @JsonProperty("valid_format")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B validFormat(final String validFormat) {
                this.validFormat = validFormat;
                return self();
            }

            /**
             * Regular expression to match invalid values.
             * @return {@code this}.
             */
            @JsonProperty("invalid_regex")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B invalidRegex(final String invalidRegex) {
                this.invalidRegex = invalidRegex;
                return self();
            }

            /**
             * Regular expression to match valid values.
             * @return {@code this}.
             */
            @JsonProperty("valid_regex")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B validRegex(final String validRegex) {
                this.validRegex = validRegex;
                return self();
            }

            /**
             * Regular expression to match missing values.
             * @return {@code this}.
             */
            @JsonProperty("missing_regex")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B missingRegex(final String missingRegex) {
                this.missingRegex = missingRegex;
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B invalidValue(final String invalidValue) {
                if (this.invalidValues == null) this.invalidValues = new java.util.ArrayList<String>();
                this.invalidValues.add(invalidValue);
                return self();
            }

            @JsonProperty("invalid_values")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B invalidValues(final java.util.Collection<? extends String> invalidValues) {
                if (invalidValues == null) {
                    throw new java.lang.NullPointerException("invalidValues cannot be null");
                }
                if (this.invalidValues == null) this.invalidValues = new java.util.ArrayList<String>();
                this.invalidValues.addAll(invalidValues);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B clearInvalidValues() {
                if (this.invalidValues != null) this.invalidValues.clear();
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B validValue(final String validValue) {
                if (this.validValues == null) this.validValues = new java.util.ArrayList<String>();
                this.validValues.add(validValue);
                return self();
            }

            @JsonProperty("valid_values")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B validValues(final java.util.Collection<? extends String> validValues) {
                if (validValues == null) {
                    throw new java.lang.NullPointerException("validValues cannot be null");
                }
                if (this.validValues == null) this.validValues = new java.util.ArrayList<String>();
                this.validValues.addAll(validValues);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B clearValidValues() {
                if (this.validValues != null) this.validValues.clear();
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B missingValue(final String missingValue) {
                if (this.missingValues == null) this.missingValues = new java.util.ArrayList<String>();
                this.missingValues.add(missingValue);
                return self();
            }

            @JsonProperty("missing_values")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B missingValues(final java.util.Collection<? extends String> missingValues) {
                if (missingValues == null) {
                    throw new java.lang.NullPointerException("missingValues cannot be null");
                }
                if (this.missingValues == null) this.missingValues = new java.util.ArrayList<String>();
                this.missingValues.addAll(missingValues);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B clearMissingValues() {
                if (this.missingValues != null) this.missingValues.clear();
                return self();
            }

            /**
             * When true, this column cannot be empty (without values).
             * @return {@code this}.
             */
            @JsonProperty("not_null")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B notNull(final Boolean notNull) {
                this.notNull = notNull;
                return self();
            }

            /**
             * Fixed length for a string to be considered valid.
             * @return {@code this}.
             */
            @JsonProperty("valid_length")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B validLength(final Long validLength) {
                this.validLength = validLength;
                return self();
            }

            /**
             * Maximum length for a string to be considered valid.
             * @return {@code this}.
             */
            @JsonProperty("valid_max_length")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B validMaxLength(final Long validMaxLength) {
                this.validMaxLength = validMaxLength;
                return self();
            }

            /**
             * Minimum numeric value considered valid.
             * @return {@code this}.
             */
            @JsonProperty("valid_min")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B validMin(final Double validMin) {
                this.validMin = validMin;
                return self();
            }

            /**
             * Maximum numeric value considered valid.
             * @return {@code this}.
             */
            @JsonProperty("valid_max")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B validMax(final Double validMax) {
                this.validMax = validMax;
                return self();
            }

            /**
             * Minimum length for a string to be considered valid.
             * @return {@code this}.
             */
            @JsonProperty("valid_min_length")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B validMinLength(final Long validMinLength) {
                this.validMinLength = validMinLength;
                return self();
            }

            /**
             * When true, this column must have unique values.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B unique(final Boolean unique) {
                this.unique = unique;
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "DataContractSpec.DCColumn.DCColumnBuilder(name=" + this.name + ", displayName=" + this.displayName + ", description=" + this.description + ", isPrimary=" + this.isPrimary + ", dataType=" + this.dataType + ", logicalType=" + this.logicalType + ", invalidFormat=" + this.invalidFormat + ", validFormat=" + this.validFormat + ", invalidRegex=" + this.invalidRegex + ", validRegex=" + this.validRegex + ", missingRegex=" + this.missingRegex + ", invalidValues=" + this.invalidValues + ", validValues=" + this.validValues + ", missingValues=" + this.missingValues + ", notNull=" + this.notNull + ", validLength=" + this.validLength + ", validMaxLength=" + this.validMaxLength + ", validMin=" + this.validMin + ", validMax=" + this.validMax + ", validMinLength=" + this.validMinLength + ", unique=" + this.unique + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class DCColumnBuilderImpl extends DataContractSpec.DCColumn.DCColumnBuilder<DataContractSpec.DCColumn, DataContractSpec.DCColumn.DCColumnBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private DCColumnBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected DataContractSpec.DCColumn.DCColumnBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public DataContractSpec.DCColumn build() {
                return new DataContractSpec.DCColumn(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DCColumn(final DataContractSpec.DCColumn.DCColumnBuilder<?, ?> b) {
            this.name = b.name;
            this.displayName = b.displayName;
            this.description = b.description;
            this.isPrimary = b.isPrimary;
            this.dataType = b.dataType;
            this.logicalType = b.logicalType;
            this.invalidFormat = b.invalidFormat;
            this.validFormat = b.validFormat;
            this.invalidRegex = b.invalidRegex;
            this.validRegex = b.validRegex;
            this.missingRegex = b.missingRegex;
            java.util.List<String> invalidValues;
            switch (b.invalidValues == null ? 0 : b.invalidValues.size()) {
            case 0: 
                invalidValues = java.util.Collections.emptyList();
                break;
            case 1: 
                invalidValues = java.util.Collections.singletonList(b.invalidValues.get(0));
                break;
            default: 
                invalidValues = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.invalidValues));
            }
            this.invalidValues = invalidValues;
            java.util.List<String> validValues;
            switch (b.validValues == null ? 0 : b.validValues.size()) {
            case 0: 
                validValues = java.util.Collections.emptyList();
                break;
            case 1: 
                validValues = java.util.Collections.singletonList(b.validValues.get(0));
                break;
            default: 
                validValues = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.validValues));
            }
            this.validValues = validValues;
            java.util.List<String> missingValues;
            switch (b.missingValues == null ? 0 : b.missingValues.size()) {
            case 0: 
                missingValues = java.util.Collections.emptyList();
                break;
            case 1: 
                missingValues = java.util.Collections.singletonList(b.missingValues.get(0));
                break;
            default: 
                missingValues = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.missingValues));
            }
            this.missingValues = missingValues;
            this.notNull = b.notNull;
            this.validLength = b.validLength;
            this.validMaxLength = b.validMaxLength;
            this.validMin = b.validMin;
            this.validMax = b.validMax;
            this.validMinLength = b.validMinLength;
            this.unique = b.unique;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static DataContractSpec.DCColumn.DCColumnBuilder<?, ?> builder() {
            return new DataContractSpec.DCColumn.DCColumnBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DataContractSpec.DCColumn.DCColumnBuilder<?, ?> toBuilder() {
            return new DataContractSpec.DCColumn.DCColumnBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Name of the column as it is defined in the source system (often technical).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
            return this.name;
        }

        /**
         * Alias for the column, to make its name more readable.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDisplayName() {
            return this.displayName;
        }

        /**
         * Description of this column, for documentation purposes.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDescription() {
            return this.description;
        }

        /**
         * When true, this column is the primary key for the table.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getIsPrimary() {
            return this.isPrimary;
        }

        /**
         * Physical data type of values in this column (e.g. {@code varchar(20)}).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDataType() {
            return this.dataType;
        }

        /**
         * Logical data type of values in this column (e.g. {@code string}).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getLogicalType() {
            return this.logicalType;
        }

        /**
         * Format of data to consider invalid.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getInvalidFormat() {
            return this.invalidFormat;
        }

        /**
         * Format of data to consider valid.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getValidFormat() {
            return this.validFormat;
        }

        /**
         * Regular expression to match invalid values.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getInvalidRegex() {
            return this.invalidRegex;
        }

        /**
         * Regular expression to match valid values.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getValidRegex() {
            return this.validRegex;
        }

        /**
         * Regular expression to match missing values.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getMissingRegex() {
            return this.missingRegex;
        }

        /**
         * Enumeration of values that should be considered invalid.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getInvalidValues() {
            return this.invalidValues;
        }

        /**
         * Enumeration of values that should be considered valid.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getValidValues() {
            return this.validValues;
        }

        /**
         * Enumeration of values that should be considered missing.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getMissingValues() {
            return this.missingValues;
        }

        /**
         * When true, this column cannot be empty (without values).
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getNotNull() {
            return this.notNull;
        }

        /**
         * Fixed length for a string to be considered valid.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getValidLength() {
            return this.validLength;
        }

        /**
         * Maximum length for a string to be considered valid.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getValidMaxLength() {
            return this.validMaxLength;
        }

        /**
         * Minimum numeric value considered valid.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getValidMin() {
            return this.validMin;
        }

        /**
         * Maximum numeric value considered valid.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Double getValidMax() {
            return this.validMax;
        }

        /**
         * Minimum length for a string to be considered valid.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getValidMinLength() {
            return this.validMinLength;
        }

        /**
         * When true, this column must have unique values.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getUnique() {
            return this.unique;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof DataContractSpec.DCColumn)) return false;
            final DataContractSpec.DCColumn other = (DataContractSpec.DCColumn) o;
            final java.lang.Object this$isPrimary = this.getIsPrimary();
            final java.lang.Object other$isPrimary = other.getIsPrimary();
            if (this$isPrimary == null ? other$isPrimary != null : !this$isPrimary.equals(other$isPrimary)) return false;
            final java.lang.Object this$notNull = this.getNotNull();
            final java.lang.Object other$notNull = other.getNotNull();
            if (this$notNull == null ? other$notNull != null : !this$notNull.equals(other$notNull)) return false;
            final java.lang.Object this$validLength = this.getValidLength();
            final java.lang.Object other$validLength = other.getValidLength();
            if (this$validLength == null ? other$validLength != null : !this$validLength.equals(other$validLength)) return false;
            final java.lang.Object this$validMaxLength = this.getValidMaxLength();
            final java.lang.Object other$validMaxLength = other.getValidMaxLength();
            if (this$validMaxLength == null ? other$validMaxLength != null : !this$validMaxLength.equals(other$validMaxLength)) return false;
            final java.lang.Object this$validMin = this.getValidMin();
            final java.lang.Object other$validMin = other.getValidMin();
            if (this$validMin == null ? other$validMin != null : !this$validMin.equals(other$validMin)) return false;
            final java.lang.Object this$validMax = this.getValidMax();
            final java.lang.Object other$validMax = other.getValidMax();
            if (this$validMax == null ? other$validMax != null : !this$validMax.equals(other$validMax)) return false;
            final java.lang.Object this$validMinLength = this.getValidMinLength();
            final java.lang.Object other$validMinLength = other.getValidMinLength();
            if (this$validMinLength == null ? other$validMinLength != null : !this$validMinLength.equals(other$validMinLength)) return false;
            final java.lang.Object this$unique = this.getUnique();
            final java.lang.Object other$unique = other.getUnique();
            if (this$unique == null ? other$unique != null : !this$unique.equals(other$unique)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            final java.lang.Object this$displayName = this.getDisplayName();
            final java.lang.Object other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
            final java.lang.Object this$description = this.getDescription();
            final java.lang.Object other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
            final java.lang.Object this$dataType = this.getDataType();
            final java.lang.Object other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) return false;
            final java.lang.Object this$logicalType = this.getLogicalType();
            final java.lang.Object other$logicalType = other.getLogicalType();
            if (this$logicalType == null ? other$logicalType != null : !this$logicalType.equals(other$logicalType)) return false;
            final java.lang.Object this$invalidFormat = this.getInvalidFormat();
            final java.lang.Object other$invalidFormat = other.getInvalidFormat();
            if (this$invalidFormat == null ? other$invalidFormat != null : !this$invalidFormat.equals(other$invalidFormat)) return false;
            final java.lang.Object this$validFormat = this.getValidFormat();
            final java.lang.Object other$validFormat = other.getValidFormat();
            if (this$validFormat == null ? other$validFormat != null : !this$validFormat.equals(other$validFormat)) return false;
            final java.lang.Object this$invalidRegex = this.getInvalidRegex();
            final java.lang.Object other$invalidRegex = other.getInvalidRegex();
            if (this$invalidRegex == null ? other$invalidRegex != null : !this$invalidRegex.equals(other$invalidRegex)) return false;
            final java.lang.Object this$validRegex = this.getValidRegex();
            final java.lang.Object other$validRegex = other.getValidRegex();
            if (this$validRegex == null ? other$validRegex != null : !this$validRegex.equals(other$validRegex)) return false;
            final java.lang.Object this$missingRegex = this.getMissingRegex();
            final java.lang.Object other$missingRegex = other.getMissingRegex();
            if (this$missingRegex == null ? other$missingRegex != null : !this$missingRegex.equals(other$missingRegex)) return false;
            final java.lang.Object this$invalidValues = this.getInvalidValues();
            final java.lang.Object other$invalidValues = other.getInvalidValues();
            if (this$invalidValues == null ? other$invalidValues != null : !this$invalidValues.equals(other$invalidValues)) return false;
            final java.lang.Object this$validValues = this.getValidValues();
            final java.lang.Object other$validValues = other.getValidValues();
            if (this$validValues == null ? other$validValues != null : !this$validValues.equals(other$validValues)) return false;
            final java.lang.Object this$missingValues = this.getMissingValues();
            final java.lang.Object other$missingValues = other.getMissingValues();
            if (this$missingValues == null ? other$missingValues != null : !this$missingValues.equals(other$missingValues)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $isPrimary = this.getIsPrimary();
            result = result * PRIME + ($isPrimary == null ? 43 : $isPrimary.hashCode());
            final java.lang.Object $notNull = this.getNotNull();
            result = result * PRIME + ($notNull == null ? 43 : $notNull.hashCode());
            final java.lang.Object $validLength = this.getValidLength();
            result = result * PRIME + ($validLength == null ? 43 : $validLength.hashCode());
            final java.lang.Object $validMaxLength = this.getValidMaxLength();
            result = result * PRIME + ($validMaxLength == null ? 43 : $validMaxLength.hashCode());
            final java.lang.Object $validMin = this.getValidMin();
            result = result * PRIME + ($validMin == null ? 43 : $validMin.hashCode());
            final java.lang.Object $validMax = this.getValidMax();
            result = result * PRIME + ($validMax == null ? 43 : $validMax.hashCode());
            final java.lang.Object $validMinLength = this.getValidMinLength();
            result = result * PRIME + ($validMinLength == null ? 43 : $validMinLength.hashCode());
            final java.lang.Object $unique = this.getUnique();
            result = result * PRIME + ($unique == null ? 43 : $unique.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $displayName = this.getDisplayName();
            result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
            final java.lang.Object $description = this.getDescription();
            result = result * PRIME + ($description == null ? 43 : $description.hashCode());
            final java.lang.Object $dataType = this.getDataType();
            result = result * PRIME + ($dataType == null ? 43 : $dataType.hashCode());
            final java.lang.Object $logicalType = this.getLogicalType();
            result = result * PRIME + ($logicalType == null ? 43 : $logicalType.hashCode());
            final java.lang.Object $invalidFormat = this.getInvalidFormat();
            result = result * PRIME + ($invalidFormat == null ? 43 : $invalidFormat.hashCode());
            final java.lang.Object $validFormat = this.getValidFormat();
            result = result * PRIME + ($validFormat == null ? 43 : $validFormat.hashCode());
            final java.lang.Object $invalidRegex = this.getInvalidRegex();
            result = result * PRIME + ($invalidRegex == null ? 43 : $invalidRegex.hashCode());
            final java.lang.Object $validRegex = this.getValidRegex();
            result = result * PRIME + ($validRegex == null ? 43 : $validRegex.hashCode());
            final java.lang.Object $missingRegex = this.getMissingRegex();
            result = result * PRIME + ($missingRegex == null ? 43 : $missingRegex.hashCode());
            final java.lang.Object $invalidValues = this.getInvalidValues();
            result = result * PRIME + ($invalidValues == null ? 43 : $invalidValues.hashCode());
            final java.lang.Object $validValues = this.getValidValues();
            result = result * PRIME + ($validValues == null ? 43 : $validValues.hashCode());
            final java.lang.Object $missingValues = this.getMissingValues();
            result = result * PRIME + ($missingValues == null ? 43 : $missingValues.hashCode());
            return result;
        }
    }

    /**
     * Parse a DataContractSpec object from the provided string form of the specification.
     * Note: all comments and empty fields will be lost during conversion to an object.
     *
     * @param spec YAML string form of the data contract specification
     * @return object representing the data contract
     * @throws IOException on any errors parsing the provided string as a data contract specification
     */
    public static DataContractSpec fromString(String spec) throws IOException {
        return Serde.yamlMapper.readValue(spec, DataContractSpec.class);
    }

    /**
     * Translate this DataContractSpec object into a YAML string representation.
     * Note: will not contain any comments or empty fields.
     *
     * @return YAML string representation of the data contract specification
     */
    @Override
    public String toString() {
        try {
            return Serde.yamlMapper.writeValueAsString(this);
        } catch (JsonProcessingException e) {
            log.error("Error translating DataContractSpec into string.", e);
        }
        return "";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$kind() {
        return "DataContract";
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class DataContractSpecBuilder<C extends DataContractSpec, B extends DataContractSpec.DataContractSpecBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean kind$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String kind$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataContractStatus status;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String templateVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataset;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String type;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String description;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String datasource;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Owners owners;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Certification certification;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Announcement announcement;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> terms;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<DCTag> tags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> customMetadataSets$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<CustomMetadataAttributes> customMetadataSets$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<DCColumn> columns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> checks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> extraProperties$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Object> extraProperties$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            DataContractSpec.DataContractSpecBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final DataContractSpec instance, final DataContractSpec.DataContractSpecBuilder<?, ?> b) {
            b.kind(instance.kind);
            b.status(instance.status);
            b.templateVersion(instance.templateVersion);
            b.dataset(instance.dataset);
            b.type(instance.type);
            b.description(instance.description);
            b.datasource(instance.datasource);
            b.owners(instance.owners);
            b.certification(instance.certification);
            b.announcement(instance.announcement);
            b.terms(instance.terms == null ? java.util.Collections.<String>emptyList() : instance.terms);
            b.tags(instance.tags == null ? java.util.Collections.<DCTag>emptyList() : instance.tags);
            b.customMetadataSets(instance.customMetadataSets == null ? java.util.Collections.<String, CustomMetadataAttributes>emptyMap() : instance.customMetadataSets);
            b.columns(instance.columns == null ? java.util.Collections.<DCColumn>emptyList() : instance.columns);
            b.checks(instance.checks == null ? java.util.Collections.<String>emptyList() : instance.checks);
            b.extraProperties(instance.extraProperties == null ? java.util.Collections.<String, Object>emptyMap() : instance.extraProperties);
        }

        /**
         * Controls the specification as one for a data contract.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B kind(final String kind) {
            this.kind$value = kind;
            kind$set = true;
            return self();
        }

        /**
         * State of the contract.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B status(final DataContractStatus status) {
            this.status = status;
            return self();
        }

        /**
         * Version of the template for the data contract.
         * @return {@code this}.
         */
        @JsonProperty("template_version")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B templateVersion(final String templateVersion) {
            this.templateVersion = templateVersion;
            return self();
        }

        /**
         * Name of the asset as it exists inside Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataset(final String dataset) {
            this.dataset = dataset;
            return self();
        }

        /**
         * Type of the dataset in Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B type(final String type) {
            this.type = type;
            return self();
        }

        /**
         * Description of this dataset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B description(final String description) {
            this.description = description;
            return self();
        }

        /**
         * Name that must match a data source defined in your config file.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B datasource(final String datasource) {
            this.datasource = datasource;
            return self();
        }

        /**
         * Owners of the dataset, which can include users (by username) and / or groups (by internal Atlan alias).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B owners(final Owners owners) {
            this.owners = owners;
            return self();
        }

        /**
         * Certification to apply to the dataset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B certification(final Certification certification) {
            this.certification = certification;
            return self();
        }

        /**
         * Announcement to apply to the dataset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B announcement(final Announcement announcement) {
            this.announcement = announcement;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B term(final String term) {
            if (this.terms == null) this.terms = new java.util.ArrayList<String>();
            this.terms.add(term);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B terms(final java.util.Collection<? extends String> terms) {
            if (terms == null) {
                throw new java.lang.NullPointerException("terms cannot be null");
            }
            if (this.terms == null) this.terms = new java.util.ArrayList<String>();
            this.terms.addAll(terms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTerms() {
            if (this.terms != null) this.terms.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tag(final DCTag tag) {
            if (this.tags == null) this.tags = new java.util.ArrayList<DCTag>();
            this.tags.add(tag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tags(final java.util.Collection<? extends DCTag> tags) {
            if (tags == null) {
                throw new java.lang.NullPointerException("tags cannot be null");
            }
            if (this.tags == null) this.tags = new java.util.ArrayList<DCTag>();
            this.tags.addAll(tags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTags() {
            if (this.tags != null) this.tags.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B customMetadataSet(final String customMetadataSetKey, final CustomMetadataAttributes customMetadataSetValue) {
            if (this.customMetadataSets$key == null) {
                this.customMetadataSets$key = new java.util.ArrayList<String>();
                this.customMetadataSets$value = new java.util.ArrayList<CustomMetadataAttributes>();
            }
            this.customMetadataSets$key.add(customMetadataSetKey);
            this.customMetadataSets$value.add(customMetadataSetValue);
            return self();
        }

        @JsonProperty("custom_metadata")
        @JsonDeserialize(using = ReadableCustomMetadataDeserializer.class)
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B customMetadataSets(final java.util.Map<? extends String, ? extends CustomMetadataAttributes> customMetadataSets) {
            if (customMetadataSets == null) {
                throw new java.lang.NullPointerException("customMetadataSets cannot be null");
            }
            if (this.customMetadataSets$key == null) {
                this.customMetadataSets$key = new java.util.ArrayList<String>();
                this.customMetadataSets$value = new java.util.ArrayList<CustomMetadataAttributes>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends CustomMetadataAttributes> $lombokEntry : customMetadataSets.entrySet()) {
                this.customMetadataSets$key.add($lombokEntry.getKey());
                this.customMetadataSets$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCustomMetadataSets() {
            if (this.customMetadataSets$key != null) {
                this.customMetadataSets$key.clear();
                this.customMetadataSets$value.clear();
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B column(final DCColumn column) {
            if (this.columns == null) this.columns = new java.util.ArrayList<DCColumn>();
            this.columns.add(column);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columns(final java.util.Collection<? extends DCColumn> columns) {
            if (columns == null) {
                throw new java.lang.NullPointerException("columns cannot be null");
            }
            if (this.columns == null) this.columns = new java.util.ArrayList<DCColumn>();
            this.columns.addAll(columns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumns() {
            if (this.columns != null) this.columns.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B check(final String check) {
            if (this.checks == null) this.checks = new java.util.ArrayList<String>();
            this.checks.add(check);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B checks(final java.util.Collection<? extends String> checks) {
            if (checks == null) {
                throw new java.lang.NullPointerException("checks cannot be null");
            }
            if (this.checks == null) this.checks = new java.util.ArrayList<String>();
            this.checks.addAll(checks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearChecks() {
            if (this.checks != null) this.checks.clear();
            return self();
        }

        @JsonAnySetter
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B extraProperty(final String extraPropertyKey, final Object extraPropertyValue) {
            if (this.extraProperties$key == null) {
                this.extraProperties$key = new java.util.ArrayList<String>();
                this.extraProperties$value = new java.util.ArrayList<Object>();
            }
            this.extraProperties$key.add(extraPropertyKey);
            this.extraProperties$value.add(extraPropertyValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B extraProperties(final java.util.Map<? extends String, ? extends Object> extraProperties) {
            if (extraProperties == null) {
                throw new java.lang.NullPointerException("extraProperties cannot be null");
            }
            if (this.extraProperties$key == null) {
                this.extraProperties$key = new java.util.ArrayList<String>();
                this.extraProperties$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : extraProperties.entrySet()) {
                this.extraProperties$key.add($lombokEntry.getKey());
                this.extraProperties$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearExtraProperties() {
            if (this.extraProperties$key != null) {
                this.extraProperties$key.clear();
                this.extraProperties$value.clear();
            }
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "DataContractSpec.DataContractSpecBuilder(super=" + super.toString() + ", kind$value=" + this.kind$value + ", status=" + this.status + ", templateVersion=" + this.templateVersion + ", dataset=" + this.dataset + ", type=" + this.type + ", description=" + this.description + ", datasource=" + this.datasource + ", owners=" + this.owners + ", certification=" + this.certification + ", announcement=" + this.announcement + ", terms=" + this.terms + ", tags=" + this.tags + ", customMetadataSets$key=" + this.customMetadataSets$key + ", customMetadataSets$value=" + this.customMetadataSets$value + ", columns=" + this.columns + ", checks=" + this.checks + ", extraProperties$key=" + this.extraProperties$key + ", extraProperties$value=" + this.extraProperties$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class DataContractSpecBuilderImpl extends DataContractSpec.DataContractSpecBuilder<DataContractSpec, DataContractSpec.DataContractSpecBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DataContractSpecBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DataContractSpec.DataContractSpecBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DataContractSpec build() {
            return new DataContractSpec(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected DataContractSpec(final DataContractSpec.DataContractSpecBuilder<?, ?> b) {
        super(b);
        if (b.kind$set) this.kind = b.kind$value;
         else this.kind = DataContractSpec.$default$kind();
        this.status = b.status;
        this.templateVersion = b.templateVersion;
        this.dataset = b.dataset;
        this.type = b.type;
        this.description = b.description;
        this.datasource = b.datasource;
        this.owners = b.owners;
        this.certification = b.certification;
        this.announcement = b.announcement;
        java.util.List<String> terms;
        switch (b.terms == null ? 0 : b.terms.size()) {
        case 0: 
            terms = java.util.Collections.emptyList();
            break;
        case 1: 
            terms = java.util.Collections.singletonList(b.terms.get(0));
            break;
        default: 
            terms = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.terms));
        }
        this.terms = terms;
        java.util.List<DCTag> tags;
        switch (b.tags == null ? 0 : b.tags.size()) {
        case 0: 
            tags = java.util.Collections.emptyList();
            break;
        case 1: 
            tags = java.util.Collections.singletonList(b.tags.get(0));
            break;
        default: 
            tags = java.util.Collections.unmodifiableList(new java.util.ArrayList<DCTag>(b.tags));
        }
        this.tags = tags;
        java.util.Map<String, CustomMetadataAttributes> customMetadataSets;
        switch (b.customMetadataSets$key == null ? 0 : b.customMetadataSets$key.size()) {
        case 0: 
            customMetadataSets = java.util.Collections.emptyMap();
            break;
        case 1: 
            customMetadataSets = java.util.Collections.singletonMap(b.customMetadataSets$key.get(0), b.customMetadataSets$value.get(0));
            break;
        default: 
            customMetadataSets = new java.util.LinkedHashMap<String, CustomMetadataAttributes>(b.customMetadataSets$key.size() < 1073741824 ? 1 + b.customMetadataSets$key.size() + (b.customMetadataSets$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.customMetadataSets$key.size(); $i++) customMetadataSets.put(b.customMetadataSets$key.get($i), (CustomMetadataAttributes) b.customMetadataSets$value.get($i));
            customMetadataSets = java.util.Collections.unmodifiableMap(customMetadataSets);
        }
        this.customMetadataSets = customMetadataSets;
        java.util.List<DCColumn> columns;
        switch (b.columns == null ? 0 : b.columns.size()) {
        case 0: 
            columns = java.util.Collections.emptyList();
            break;
        case 1: 
            columns = java.util.Collections.singletonList(b.columns.get(0));
            break;
        default: 
            columns = java.util.Collections.unmodifiableList(new java.util.ArrayList<DCColumn>(b.columns));
        }
        this.columns = columns;
        java.util.List<String> checks;
        switch (b.checks == null ? 0 : b.checks.size()) {
        case 0: 
            checks = java.util.Collections.emptyList();
            break;
        case 1: 
            checks = java.util.Collections.singletonList(b.checks.get(0));
            break;
        default: 
            checks = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.checks));
        }
        this.checks = checks;
        java.util.Map<String, Object> extraProperties;
        switch (b.extraProperties$key == null ? 0 : b.extraProperties$key.size()) {
        case 0: 
            extraProperties = java.util.Collections.emptyMap();
            break;
        case 1: 
            extraProperties = java.util.Collections.singletonMap(b.extraProperties$key.get(0), b.extraProperties$value.get(0));
            break;
        default: 
            extraProperties = new java.util.LinkedHashMap<String, Object>(b.extraProperties$key.size() < 1073741824 ? 1 + b.extraProperties$key.size() + (b.extraProperties$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.extraProperties$key.size(); $i++) extraProperties.put(b.extraProperties$key.get($i), (Object) b.extraProperties$value.get($i));
            extraProperties = java.util.Collections.unmodifiableMap(extraProperties);
        }
        this.extraProperties = extraProperties;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static DataContractSpec.DataContractSpecBuilder<?, ?> _internal() {
        return new DataContractSpec.DataContractSpecBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataContractSpec.DataContractSpecBuilder<?, ?> toBuilder() {
        return new DataContractSpec.DataContractSpecBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Controls the specification as one for a data contract.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getKind() {
        return this.kind;
    }

    /**
     * State of the contract.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DataContractStatus getStatus() {
        return this.status;
    }

    /**
     * Version of the template for the data contract.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTemplateVersion() {
        return this.templateVersion;
    }

    /**
     * Name of the asset as it exists inside Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataset() {
        return this.dataset;
    }

    /**
     * Type of the dataset in Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
        return this.type;
    }

    /**
     * Description of this dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Name that must match a data source defined in your config file.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatasource() {
        return this.datasource;
    }

    /**
     * Owners of the dataset, which can include users (by username) and / or groups (by internal Atlan alias).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Owners getOwners() {
        return this.owners;
    }

    /**
     * Certification to apply to the dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Certification getCertification() {
        return this.certification;
    }

    /**
     * Announcement to apply to the dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Announcement getAnnouncement() {
        return this.announcement;
    }

    /**
     * Glossary terms to assign to the dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getTerms() {
        return this.terms;
    }

    /**
     * Atlan tags for the dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<DCTag> getTags() {
        return this.tags;
    }

    /**
     * Custom metadata for the dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, CustomMetadataAttributes> getCustomMetadataSets() {
        return this.customMetadataSets;
    }

    /**
     * Details of each column in the dataset to be governed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<DCColumn> getColumns() {
        return this.columns;
    }

    /**
     * List of checks to run to verify data quality of the dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getChecks() {
        return this.checks;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DataContractSpec)) return false;
        final DataContractSpec other = (DataContractSpec) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$kind = this.getKind();
        final java.lang.Object other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$templateVersion = this.getTemplateVersion();
        final java.lang.Object other$templateVersion = other.getTemplateVersion();
        if (this$templateVersion == null ? other$templateVersion != null : !this$templateVersion.equals(other$templateVersion)) return false;
        final java.lang.Object this$dataset = this.getDataset();
        final java.lang.Object other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !this$dataset.equals(other$dataset)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$datasource = this.getDatasource();
        final java.lang.Object other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !this$datasource.equals(other$datasource)) return false;
        final java.lang.Object this$owners = this.getOwners();
        final java.lang.Object other$owners = other.getOwners();
        if (this$owners == null ? other$owners != null : !this$owners.equals(other$owners)) return false;
        final java.lang.Object this$certification = this.getCertification();
        final java.lang.Object other$certification = other.getCertification();
        if (this$certification == null ? other$certification != null : !this$certification.equals(other$certification)) return false;
        final java.lang.Object this$announcement = this.getAnnouncement();
        final java.lang.Object other$announcement = other.getAnnouncement();
        if (this$announcement == null ? other$announcement != null : !this$announcement.equals(other$announcement)) return false;
        final java.lang.Object this$terms = this.getTerms();
        final java.lang.Object other$terms = other.getTerms();
        if (this$terms == null ? other$terms != null : !this$terms.equals(other$terms)) return false;
        final java.lang.Object this$tags = this.getTags();
        final java.lang.Object other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) return false;
        final java.lang.Object this$customMetadataSets = this.getCustomMetadataSets();
        final java.lang.Object other$customMetadataSets = other.getCustomMetadataSets();
        if (this$customMetadataSets == null ? other$customMetadataSets != null : !this$customMetadataSets.equals(other$customMetadataSets)) return false;
        final java.lang.Object this$columns = this.getColumns();
        final java.lang.Object other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) return false;
        final java.lang.Object this$checks = this.getChecks();
        final java.lang.Object other$checks = other.getChecks();
        if (this$checks == null ? other$checks != null : !this$checks.equals(other$checks)) return false;
        final java.lang.Object this$extraProperties = this.getExtraProperties();
        final java.lang.Object other$extraProperties = other.getExtraProperties();
        if (this$extraProperties == null ? other$extraProperties != null : !this$extraProperties.equals(other$extraProperties)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DataContractSpec;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $kind = this.getKind();
        result = result * PRIME + ($kind == null ? 43 : $kind.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $templateVersion = this.getTemplateVersion();
        result = result * PRIME + ($templateVersion == null ? 43 : $templateVersion.hashCode());
        final java.lang.Object $dataset = this.getDataset();
        result = result * PRIME + ($dataset == null ? 43 : $dataset.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $datasource = this.getDatasource();
        result = result * PRIME + ($datasource == null ? 43 : $datasource.hashCode());
        final java.lang.Object $owners = this.getOwners();
        result = result * PRIME + ($owners == null ? 43 : $owners.hashCode());
        final java.lang.Object $certification = this.getCertification();
        result = result * PRIME + ($certification == null ? 43 : $certification.hashCode());
        final java.lang.Object $announcement = this.getAnnouncement();
        result = result * PRIME + ($announcement == null ? 43 : $announcement.hashCode());
        final java.lang.Object $terms = this.getTerms();
        result = result * PRIME + ($terms == null ? 43 : $terms.hashCode());
        final java.lang.Object $tags = this.getTags();
        result = result * PRIME + ($tags == null ? 43 : $tags.hashCode());
        final java.lang.Object $customMetadataSets = this.getCustomMetadataSets();
        result = result * PRIME + ($customMetadataSets == null ? 43 : $customMetadataSets.hashCode());
        final java.lang.Object $columns = this.getColumns();
        result = result * PRIME + ($columns == null ? 43 : $columns.hashCode());
        final java.lang.Object $checks = this.getChecks();
        result = result * PRIME + ($checks == null ? 43 : $checks.hashCode());
        final java.lang.Object $extraProperties = this.getExtraProperties();
        result = result * PRIME + ($extraProperties == null ? 43 : $extraProperties.hashCode());
        return result;
    }
}
