// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public class AtlanError extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * A numeric error code.
     */
    Long code;
    /**
     * A short string indicating the error code reported.
     */
    String errorCode;
    /**
     * A human-readable message providing more details about the error.
     */
    String errorMessage;
    /**
     * A human-readable description providing more details about the error.
     */
    @JsonProperty("error_description")
    String errorDescription;
    /**
     * A human-readable message providing more details about the error.
     */
    String message;
    /**
     * A human-readable suggestion on resolving the error.
     */
    String error;
    /**
     * TBC
     */
    String entityGuid;
    /**
     * TBC
     */
    String requestId;
    /**
     * TBC
     */
    String info;
    /**
     * Details about where the error occurred.
     */
    Map<String, String> errorDetailsMap;
    /**
     * TBC
     */
    String servlet;
    /**
     * Response code for unauthorized calls.
     */
    String status;
    /**
     * Path attempted to access for an unauthorized call.
     */
    String url;

    /**
     * Find the code within the error.
     *
     * @return the code
     */
    public String findCode() {
        if (errorCode != null && !errorCode.isEmpty()) {
            return errorCode;
        } else if (error != null && !error.isEmpty()) {
            return error;
        } else if (code != null) {
            return "" + code;
        } else if (status != null && !status.isEmpty()) {
            return status;
        } else {
            return "(unknown)";
        }
    }

    /**
     * Find the message within the error.
     *
     * @return the message
     */
    public String findMessage() {
        if (errorMessage != null && !errorMessage.isEmpty()) {
            return errorMessage;
        } else if (message != null && !message.isEmpty()) {
            if (url != null && !url.isEmpty()) {
                return message + " (" + url + ")";
            }
            return message;
        } else if (errorDescription != null && !errorDescription.isEmpty()) {
            return errorDescription;
        } else if (info != null && !info.isEmpty()) {
            return info;
        } else {
            return "";
        }
    }

    /**
     * A numeric error code.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCode() {
        return this.code;
    }

    /**
     * A short string indicating the error code reported.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getErrorCode() {
        return this.errorCode;
    }

    /**
     * A human-readable message providing more details about the error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /**
     * A human-readable description providing more details about the error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getErrorDescription() {
        return this.errorDescription;
    }

    /**
     * A human-readable message providing more details about the error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * A human-readable suggestion on resolving the error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getError() {
        return this.error;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEntityGuid() {
        return this.entityGuid;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRequestId() {
        return this.requestId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getInfo() {
        return this.info;
    }

    /**
     * Details about where the error occurred.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getErrorDetailsMap() {
        return this.errorDetailsMap;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getServlet() {
        return this.servlet;
    }

    /**
     * Response code for unauthorized calls.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
        return this.status;
    }

    /**
     * Path attempted to access for an unauthorized call.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUrl() {
        return this.url;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanError)) return false;
        final AtlanError other = (AtlanError) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$errorCode = this.getErrorCode();
        final java.lang.Object other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) return false;
        final java.lang.Object this$errorMessage = this.getErrorMessage();
        final java.lang.Object other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) return false;
        final java.lang.Object this$errorDescription = this.getErrorDescription();
        final java.lang.Object other$errorDescription = other.getErrorDescription();
        if (this$errorDescription == null ? other$errorDescription != null : !this$errorDescription.equals(other$errorDescription)) return false;
        final java.lang.Object this$message = this.getMessage();
        final java.lang.Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
        final java.lang.Object this$error = this.getError();
        final java.lang.Object other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) return false;
        final java.lang.Object this$entityGuid = this.getEntityGuid();
        final java.lang.Object other$entityGuid = other.getEntityGuid();
        if (this$entityGuid == null ? other$entityGuid != null : !this$entityGuid.equals(other$entityGuid)) return false;
        final java.lang.Object this$requestId = this.getRequestId();
        final java.lang.Object other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) return false;
        final java.lang.Object this$info = this.getInfo();
        final java.lang.Object other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) return false;
        final java.lang.Object this$errorDetailsMap = this.getErrorDetailsMap();
        final java.lang.Object other$errorDetailsMap = other.getErrorDetailsMap();
        if (this$errorDetailsMap == null ? other$errorDetailsMap != null : !this$errorDetailsMap.equals(other$errorDetailsMap)) return false;
        final java.lang.Object this$servlet = this.getServlet();
        final java.lang.Object other$servlet = other.getServlet();
        if (this$servlet == null ? other$servlet != null : !this$servlet.equals(other$servlet)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$url = this.getUrl();
        final java.lang.Object other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanError;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $errorCode = this.getErrorCode();
        result = result * PRIME + ($errorCode == null ? 43 : $errorCode.hashCode());
        final java.lang.Object $errorMessage = this.getErrorMessage();
        result = result * PRIME + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        final java.lang.Object $errorDescription = this.getErrorDescription();
        result = result * PRIME + ($errorDescription == null ? 43 : $errorDescription.hashCode());
        final java.lang.Object $message = this.getMessage();
        result = result * PRIME + ($message == null ? 43 : $message.hashCode());
        final java.lang.Object $error = this.getError();
        result = result * PRIME + ($error == null ? 43 : $error.hashCode());
        final java.lang.Object $entityGuid = this.getEntityGuid();
        result = result * PRIME + ($entityGuid == null ? 43 : $entityGuid.hashCode());
        final java.lang.Object $requestId = this.getRequestId();
        result = result * PRIME + ($requestId == null ? 43 : $requestId.hashCode());
        final java.lang.Object $info = this.getInfo();
        result = result * PRIME + ($info == null ? 43 : $info.hashCode());
        final java.lang.Object $errorDetailsMap = this.getErrorDetailsMap();
        result = result * PRIME + ($errorDetailsMap == null ? 43 : $errorDetailsMap.hashCode());
        final java.lang.Object $servlet = this.getServlet();
        result = result * PRIME + ($servlet == null ? 43 : $servlet.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $url = this.getUrl();
        result = result * PRIME + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanError(super=" + super.toString() + ", code=" + this.getCode() + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ", errorDescription=" + this.getErrorDescription() + ", message=" + this.getMessage() + ", error=" + this.getError() + ", entityGuid=" + this.getEntityGuid() + ", requestId=" + this.getRequestId() + ", info=" + this.getInfo() + ", errorDetailsMap=" + this.getErrorDetailsMap() + ", servlet=" + this.getServlet() + ", status=" + this.getStatus() + ", url=" + this.getUrl() + ")";
    }

    /**
     * A numeric error code.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCode(final Long code) {
        this.code = code;
    }

    /**
     * A human-readable message providing more details about the error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setErrorMessage(final String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
