// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.core;

import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.search.AuditDetail;
import com.atlan.model.structs.SourceTagAttachment;
import com.atlan.serde.AtlanTagDeserializer;
import com.atlan.serde.AtlanTagSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Comparator;
import java.util.List;

@JsonDeserialize(using = AtlanTagDeserializer.class)
@JsonSerialize(using = AtlanTagSerializer.class)
public class AtlanTag extends AtlanObject implements AuditDetail, Comparable<AtlanTag> {
    private static final long serialVersionUID = 2L;
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<AtlanTag> atlanTagComparator = Comparator.comparing(AtlanTag::getTypeName, stringComparator).thenComparing(AtlanTag::getEntityGuid, stringComparator).thenComparing(st -> st.getSourceTagAttachments().stream().map(SourceTagAttachment::getSourceTagGuid).toList().toString(), stringComparator);

    /**
     * Construct an Atlan tag assignment for an entity that is being created or updated.
     *
     * @param atlanTagName human-readable name of the Atlan tag
     * @return an Atlan tag assignment with default settings for propagation
     */
    public static AtlanTag of(String atlanTagName) {
        return of(atlanTagName, (String) null);
    }

    /**
     * Construct an Atlan tag assignment for an entity that is being created or updated.
     *
     * @param atlanTagName human-readable name of the Atlan tag
     * @param sta (optional) source-specific details for the tag
     * @return an Atlan tag assignment with default settings for propagation
     */
    public static AtlanTag of(String atlanTagName, SourceTagAttachment sta) {
        return of(atlanTagName, null, sta);
    }

    /**
     * Construct an Atlan tag assignment for a specific entity.
     *
     * @param atlanTagName human-readable name of the Atlan tag
     * @param entityGuid unique identifier (GUID) of the entity to which the Atlan tag is to be assigned
     * @return an Atlan tag assignment with default settings for propagation and a specific entity assignment
     */
    public static AtlanTag of(String atlanTagName, String entityGuid) {
        return of(atlanTagName, entityGuid, null);
    }

    /**
     * Construct an Atlan tag assignment for a specific entity.
     *
     * @param atlanTagName human-readable name of the Atlan tag
     * @param entityGuid unique identifier (GUID) of the entity to which the Atlan tag is to be assigned
     * @param sta (optional) source-specific details for the tag
     * @return an Atlan tag assignment with default settings for propagation and a specific entity assignment
     */
    public static AtlanTag of(String atlanTagName, String entityGuid, SourceTagAttachment sta) {
        AtlanTagBuilder<?, ?> builder = AtlanTag.builder().typeName(atlanTagName).propagate(true).removePropagationsOnEntityDelete(true).restrictPropagationThroughLineage(false).restrictPropagationThroughHierarchy(false);
        if (entityGuid != null) {
            builder.entityGuid(entityGuid).entityStatus(AtlanStatus.ACTIVE);
        }
        if (sta != null) {
            builder.sourceTagAttachment(sta);
        }
        return builder.build();
    }

    public AtlanTag() {
        // Necessary for Jackson deserialization
    }

    /**
     * Name of the Atlan tag. Note that this is the static-hashed unique name of the
     * Atlan tag, not the human-readable displayName.
     */
    String typeName;
    /**
     * Unique identifier of the entity to which this Atlan tag is attached.
     */
    String entityGuid;
    /**
     * Status of the entity.
     */
    AtlanStatus entityStatus;
    /**
     * Whether to propagate this Atlan tag to other entities related to the entity to which the
     * Atlan tag is attached.
     */
    Boolean propagate;
    /**
     * Whether to remove this Atlan tag from other entities to which it has been propagated when
     * the Atlan tag is removed from this entity.
     */
    Boolean removePropagationsOnEntityDelete;
    /**
     * Whether to prevent this Atlan tag from propagating through lineage (true) or allow it to
     * propagate through lineage (false).
     */
    Boolean restrictPropagationThroughLineage;
    /**
     * Whether to prevent this Atlan tag from propagating through hierarchy (true) or allow it to
     * propagate through hierarchy (false).
     */
    Boolean restrictPropagationThroughHierarchy;
    /**
     * List of attachments of this tag to source-specific tags.
     */
    List<SourceTagAttachment> sourceTagAttachments;

    /* Unused. List<Object> attributes; List<Object> validityPeriods; */
    /**
     * {@inheritDoc}
     */
    @Override
    public int compareTo(AtlanTag o) {
        return atlanTagComparator.compare(this, o);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AtlanTagBuilder<C extends AtlanTag, B extends AtlanTag.AtlanTagBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String entityGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanStatus entityStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean propagate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean removePropagationsOnEntityDelete;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean restrictPropagationThroughLineage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean restrictPropagationThroughHierarchy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<SourceTagAttachment> sourceTagAttachments;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AtlanTag.AtlanTagBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AtlanTag instance, final AtlanTag.AtlanTagBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.entityGuid(instance.entityGuid);
            b.entityStatus(instance.entityStatus);
            b.propagate(instance.propagate);
            b.removePropagationsOnEntityDelete(instance.removePropagationsOnEntityDelete);
            b.restrictPropagationThroughLineage(instance.restrictPropagationThroughLineage);
            b.restrictPropagationThroughHierarchy(instance.restrictPropagationThroughHierarchy);
            b.sourceTagAttachments(instance.sourceTagAttachments == null ? java.util.Collections.<SourceTagAttachment>emptyList() : instance.sourceTagAttachments);
        }

        /**
         * Name of the Atlan tag. Note that this is the static-hashed unique name of the
         * Atlan tag, not the human-readable displayName.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName = typeName;
            return self();
        }

        /**
         * Unique identifier of the entity to which this Atlan tag is attached.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entityGuid(final String entityGuid) {
            this.entityGuid = entityGuid;
            return self();
        }

        /**
         * Status of the entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entityStatus(final AtlanStatus entityStatus) {
            this.entityStatus = entityStatus;
            return self();
        }

        /**
         * Whether to propagate this Atlan tag to other entities related to the entity to which the
         * Atlan tag is attached.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B propagate(final Boolean propagate) {
            this.propagate = propagate;
            return self();
        }

        /**
         * Whether to remove this Atlan tag from other entities to which it has been propagated when
         * the Atlan tag is removed from this entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B removePropagationsOnEntityDelete(final Boolean removePropagationsOnEntityDelete) {
            this.removePropagationsOnEntityDelete = removePropagationsOnEntityDelete;
            return self();
        }

        /**
         * Whether to prevent this Atlan tag from propagating through lineage (true) or allow it to
         * propagate through lineage (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B restrictPropagationThroughLineage(final Boolean restrictPropagationThroughLineage) {
            this.restrictPropagationThroughLineage = restrictPropagationThroughLineage;
            return self();
        }

        /**
         * Whether to prevent this Atlan tag from propagating through hierarchy (true) or allow it to
         * propagate through hierarchy (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B restrictPropagationThroughHierarchy(final Boolean restrictPropagationThroughHierarchy) {
            this.restrictPropagationThroughHierarchy = restrictPropagationThroughHierarchy;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceTagAttachment(final SourceTagAttachment sourceTagAttachment) {
            if (this.sourceTagAttachments == null) this.sourceTagAttachments = new java.util.ArrayList<SourceTagAttachment>();
            this.sourceTagAttachments.add(sourceTagAttachment);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceTagAttachments(final java.util.Collection<? extends SourceTagAttachment> sourceTagAttachments) {
            if (sourceTagAttachments == null) {
                throw new java.lang.NullPointerException("sourceTagAttachments cannot be null");
            }
            if (this.sourceTagAttachments == null) this.sourceTagAttachments = new java.util.ArrayList<SourceTagAttachment>();
            this.sourceTagAttachments.addAll(sourceTagAttachments);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSourceTagAttachments() {
            if (this.sourceTagAttachments != null) this.sourceTagAttachments.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanTag.AtlanTagBuilder(super=" + super.toString() + ", typeName=" + this.typeName + ", entityGuid=" + this.entityGuid + ", entityStatus=" + this.entityStatus + ", propagate=" + this.propagate + ", removePropagationsOnEntityDelete=" + this.removePropagationsOnEntityDelete + ", restrictPropagationThroughLineage=" + this.restrictPropagationThroughLineage + ", restrictPropagationThroughHierarchy=" + this.restrictPropagationThroughHierarchy + ", sourceTagAttachments=" + this.sourceTagAttachments + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AtlanTagBuilderImpl extends AtlanTag.AtlanTagBuilder<AtlanTag, AtlanTag.AtlanTagBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTagBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AtlanTag.AtlanTagBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanTag build() {
            return new AtlanTag(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AtlanTag(final AtlanTag.AtlanTagBuilder<?, ?> b) {
        super(b);
        this.typeName = b.typeName;
        this.entityGuid = b.entityGuid;
        this.entityStatus = b.entityStatus;
        this.propagate = b.propagate;
        this.removePropagationsOnEntityDelete = b.removePropagationsOnEntityDelete;
        this.restrictPropagationThroughLineage = b.restrictPropagationThroughLineage;
        this.restrictPropagationThroughHierarchy = b.restrictPropagationThroughHierarchy;
        java.util.List<SourceTagAttachment> sourceTagAttachments;
        switch (b.sourceTagAttachments == null ? 0 : b.sourceTagAttachments.size()) {
        case 0: 
            sourceTagAttachments = java.util.Collections.emptyList();
            break;
        case 1: 
            sourceTagAttachments = java.util.Collections.singletonList(b.sourceTagAttachments.get(0));
            break;
        default: 
            sourceTagAttachments = java.util.Collections.unmodifiableList(new java.util.ArrayList<SourceTagAttachment>(b.sourceTagAttachments));
        }
        this.sourceTagAttachments = sourceTagAttachments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AtlanTag.AtlanTagBuilder<?, ?> builder() {
        return new AtlanTag.AtlanTagBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTag.AtlanTagBuilder<?, ?> toBuilder() {
        return new AtlanTag.AtlanTagBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Name of the Atlan tag. Note that this is the static-hashed unique name of the
     * Atlan tag, not the human-readable displayName.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }

    /**
     * Unique identifier of the entity to which this Atlan tag is attached.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEntityGuid() {
        return this.entityGuid;
    }

    /**
     * Status of the entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanStatus getEntityStatus() {
        return this.entityStatus;
    }

    /**
     * Whether to propagate this Atlan tag to other entities related to the entity to which the
     * Atlan tag is attached.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPropagate() {
        return this.propagate;
    }

    /**
     * Whether to remove this Atlan tag from other entities to which it has been propagated when
     * the Atlan tag is removed from this entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRemovePropagationsOnEntityDelete() {
        return this.removePropagationsOnEntityDelete;
    }

    /**
     * Whether to prevent this Atlan tag from propagating through lineage (true) or allow it to
     * propagate through lineage (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRestrictPropagationThroughLineage() {
        return this.restrictPropagationThroughLineage;
    }

    /**
     * Whether to prevent this Atlan tag from propagating through hierarchy (true) or allow it to
     * propagate through hierarchy (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRestrictPropagationThroughHierarchy() {
        return this.restrictPropagationThroughHierarchy;
    }

    /**
     * List of attachments of this tag to source-specific tags.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<SourceTagAttachment> getSourceTagAttachments() {
        return this.sourceTagAttachments;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanTag)) return false;
        final AtlanTag other = (AtlanTag) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$propagate = this.getPropagate();
        final java.lang.Object other$propagate = other.getPropagate();
        if (this$propagate == null ? other$propagate != null : !this$propagate.equals(other$propagate)) return false;
        final java.lang.Object this$removePropagationsOnEntityDelete = this.getRemovePropagationsOnEntityDelete();
        final java.lang.Object other$removePropagationsOnEntityDelete = other.getRemovePropagationsOnEntityDelete();
        if (this$removePropagationsOnEntityDelete == null ? other$removePropagationsOnEntityDelete != null : !this$removePropagationsOnEntityDelete.equals(other$removePropagationsOnEntityDelete)) return false;
        final java.lang.Object this$restrictPropagationThroughLineage = this.getRestrictPropagationThroughLineage();
        final java.lang.Object other$restrictPropagationThroughLineage = other.getRestrictPropagationThroughLineage();
        if (this$restrictPropagationThroughLineage == null ? other$restrictPropagationThroughLineage != null : !this$restrictPropagationThroughLineage.equals(other$restrictPropagationThroughLineage)) return false;
        final java.lang.Object this$restrictPropagationThroughHierarchy = this.getRestrictPropagationThroughHierarchy();
        final java.lang.Object other$restrictPropagationThroughHierarchy = other.getRestrictPropagationThroughHierarchy();
        if (this$restrictPropagationThroughHierarchy == null ? other$restrictPropagationThroughHierarchy != null : !this$restrictPropagationThroughHierarchy.equals(other$restrictPropagationThroughHierarchy)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$entityGuid = this.getEntityGuid();
        final java.lang.Object other$entityGuid = other.getEntityGuid();
        if (this$entityGuid == null ? other$entityGuid != null : !this$entityGuid.equals(other$entityGuid)) return false;
        final java.lang.Object this$entityStatus = this.getEntityStatus();
        final java.lang.Object other$entityStatus = other.getEntityStatus();
        if (this$entityStatus == null ? other$entityStatus != null : !this$entityStatus.equals(other$entityStatus)) return false;
        final java.lang.Object this$sourceTagAttachments = this.getSourceTagAttachments();
        final java.lang.Object other$sourceTagAttachments = other.getSourceTagAttachments();
        if (this$sourceTagAttachments == null ? other$sourceTagAttachments != null : !this$sourceTagAttachments.equals(other$sourceTagAttachments)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanTag;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $propagate = this.getPropagate();
        result = result * PRIME + ($propagate == null ? 43 : $propagate.hashCode());
        final java.lang.Object $removePropagationsOnEntityDelete = this.getRemovePropagationsOnEntityDelete();
        result = result * PRIME + ($removePropagationsOnEntityDelete == null ? 43 : $removePropagationsOnEntityDelete.hashCode());
        final java.lang.Object $restrictPropagationThroughLineage = this.getRestrictPropagationThroughLineage();
        result = result * PRIME + ($restrictPropagationThroughLineage == null ? 43 : $restrictPropagationThroughLineage.hashCode());
        final java.lang.Object $restrictPropagationThroughHierarchy = this.getRestrictPropagationThroughHierarchy();
        result = result * PRIME + ($restrictPropagationThroughHierarchy == null ? 43 : $restrictPropagationThroughHierarchy.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $entityGuid = this.getEntityGuid();
        result = result * PRIME + ($entityGuid == null ? 43 : $entityGuid.hashCode());
        final java.lang.Object $entityStatus = this.getEntityStatus();
        result = result * PRIME + ($entityStatus == null ? 43 : $entityStatus.hashCode());
        final java.lang.Object $sourceTagAttachments = this.getSourceTagAttachments();
        result = result * PRIME + ($sourceTagAttachments == null ? 43 : $sourceTagAttachments.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanTag(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", entityGuid=" + this.getEntityGuid() + ", entityStatus=" + this.getEntityStatus() + ", propagate=" + this.getPropagate() + ", removePropagationsOnEntityDelete=" + this.getRemovePropagationsOnEntityDelete() + ", restrictPropagationThroughLineage=" + this.getRestrictPropagationThroughLineage() + ", restrictPropagationThroughHierarchy=" + this.getRestrictPropagationThroughHierarchy() + ", sourceTagAttachments=" + this.getSourceTagAttachments() + ")";
    }
}
