// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.core;

import java.util.Map;

/**
 * Capture the attributes and values for a given set of custom metadata.
 */
@SuppressWarnings("cast")
public class CustomMetadataAttributes extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Mapping of custom metadata attributes to values, all by human-readable names.
     */
    private final Map<String, Object> attributes;
    /**
     * Mapping of archived custom metadata attributes to values, by human-readable names.
     * Note that the names here will all be of the form {@code <name>-archived-123456789}
     */
    private final Map<String, Object> archivedAttributes;

    /**
     * Quickly check if there are any custom metadata attributes defined.
     *
     * @return true if there are no custom metadata attributes defined, false if there are custom metadata attributes defined
     */
    public boolean isEmpty() {
        return attributes.isEmpty();
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class CustomMetadataAttributesBuilder<C extends CustomMetadataAttributes, B extends CustomMetadataAttributes.CustomMetadataAttributesBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> attributes$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Object> attributes$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> archivedAttributes$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Object> archivedAttributes$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            CustomMetadataAttributes.CustomMetadataAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final CustomMetadataAttributes instance, final CustomMetadataAttributes.CustomMetadataAttributesBuilder<?, ?> b) {
            b.attributes(instance.attributes == null ? java.util.Collections.<String, Object>emptyMap() : instance.attributes);
            b.archivedAttributes(instance.archivedAttributes == null ? java.util.Collections.<String, Object>emptyMap() : instance.archivedAttributes);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attribute(final String attributeKey, final Object attributeValue) {
            if (this.attributes$key == null) {
                this.attributes$key = new java.util.ArrayList<String>();
                this.attributes$value = new java.util.ArrayList<Object>();
            }
            this.attributes$key.add(attributeKey);
            this.attributes$value.add(attributeValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attributes(final java.util.Map<? extends String, ? extends Object> attributes) {
            if (attributes == null) {
                throw new java.lang.NullPointerException("attributes cannot be null");
            }
            if (this.attributes$key == null) {
                this.attributes$key = new java.util.ArrayList<String>();
                this.attributes$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : attributes.entrySet()) {
                this.attributes$key.add($lombokEntry.getKey());
                this.attributes$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAttributes() {
            if (this.attributes$key != null) {
                this.attributes$key.clear();
                this.attributes$value.clear();
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B archivedAttribute(final String archivedAttributeKey, final Object archivedAttributeValue) {
            if (this.archivedAttributes$key == null) {
                this.archivedAttributes$key = new java.util.ArrayList<String>();
                this.archivedAttributes$value = new java.util.ArrayList<Object>();
            }
            this.archivedAttributes$key.add(archivedAttributeKey);
            this.archivedAttributes$value.add(archivedAttributeValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B archivedAttributes(final java.util.Map<? extends String, ? extends Object> archivedAttributes) {
            if (archivedAttributes == null) {
                throw new java.lang.NullPointerException("archivedAttributes cannot be null");
            }
            if (this.archivedAttributes$key == null) {
                this.archivedAttributes$key = new java.util.ArrayList<String>();
                this.archivedAttributes$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : archivedAttributes.entrySet()) {
                this.archivedAttributes$key.add($lombokEntry.getKey());
                this.archivedAttributes$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearArchivedAttributes() {
            if (this.archivedAttributes$key != null) {
                this.archivedAttributes$key.clear();
                this.archivedAttributes$value.clear();
            }
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "CustomMetadataAttributes.CustomMetadataAttributesBuilder(super=" + super.toString() + ", attributes$key=" + this.attributes$key + ", attributes$value=" + this.attributes$value + ", archivedAttributes$key=" + this.archivedAttributes$key + ", archivedAttributes$value=" + this.archivedAttributes$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class CustomMetadataAttributesBuilderImpl extends CustomMetadataAttributes.CustomMetadataAttributesBuilder<CustomMetadataAttributes, CustomMetadataAttributes.CustomMetadataAttributesBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CustomMetadataAttributesBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected CustomMetadataAttributes.CustomMetadataAttributesBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CustomMetadataAttributes build() {
            return new CustomMetadataAttributes(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected CustomMetadataAttributes(final CustomMetadataAttributes.CustomMetadataAttributesBuilder<?, ?> b) {
        super(b);
        java.util.Map<String, Object> attributes;
        switch (b.attributes$key == null ? 0 : b.attributes$key.size()) {
        case 0: 
            attributes = java.util.Collections.emptyMap();
            break;
        case 1: 
            attributes = java.util.Collections.singletonMap(b.attributes$key.get(0), b.attributes$value.get(0));
            break;
        default: 
            attributes = new java.util.LinkedHashMap<String, Object>(b.attributes$key.size() < 1073741824 ? 1 + b.attributes$key.size() + (b.attributes$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.attributes$key.size(); $i++) attributes.put(b.attributes$key.get($i), (Object) b.attributes$value.get($i));
            attributes = java.util.Collections.unmodifiableMap(attributes);
        }
        this.attributes = attributes;
        java.util.Map<String, Object> archivedAttributes;
        switch (b.archivedAttributes$key == null ? 0 : b.archivedAttributes$key.size()) {
        case 0: 
            archivedAttributes = java.util.Collections.emptyMap();
            break;
        case 1: 
            archivedAttributes = java.util.Collections.singletonMap(b.archivedAttributes$key.get(0), b.archivedAttributes$value.get(0));
            break;
        default: 
            archivedAttributes = new java.util.LinkedHashMap<String, Object>(b.archivedAttributes$key.size() < 1073741824 ? 1 + b.archivedAttributes$key.size() + (b.archivedAttributes$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.archivedAttributes$key.size(); $i++) archivedAttributes.put(b.archivedAttributes$key.get($i), (Object) b.archivedAttributes$value.get($i));
            archivedAttributes = java.util.Collections.unmodifiableMap(archivedAttributes);
        }
        this.archivedAttributes = archivedAttributes;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static CustomMetadataAttributes.CustomMetadataAttributesBuilder<?, ?> builder() {
        return new CustomMetadataAttributes.CustomMetadataAttributesBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CustomMetadataAttributes.CustomMetadataAttributesBuilder<?, ?> toBuilder() {
        return new CustomMetadataAttributes.CustomMetadataAttributesBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Mapping of custom metadata attributes to values, all by human-readable names.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    /**
     * Mapping of archived custom metadata attributes to values, by human-readable names.
     * Note that the names here will all be of the form {@code <name>-archived-123456789}
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getArchivedAttributes() {
        return this.archivedAttributes;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CustomMetadataAttributes)) return false;
        final CustomMetadataAttributes other = (CustomMetadataAttributes) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$attributes = this.getAttributes();
        final java.lang.Object other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
        final java.lang.Object this$archivedAttributes = this.getArchivedAttributes();
        final java.lang.Object other$archivedAttributes = other.getArchivedAttributes();
        if (this$archivedAttributes == null ? other$archivedAttributes != null : !this$archivedAttributes.equals(other$archivedAttributes)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CustomMetadataAttributes;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $attributes = this.getAttributes();
        result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
        final java.lang.Object $archivedAttributes = this.getArchivedAttributes();
        result = result * PRIME + ($archivedAttributes == null ? 43 : $archivedAttributes.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "CustomMetadataAttributes(super=" + super.toString() + ", attributes=" + this.getAttributes() + ", archivedAttributes=" + this.getArchivedAttributes() + ")";
    }
}
