// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.discovery;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.ITag;
import java.util.List;

/**
 * Class to compose a single filter criterion, by tag, for use in a linkable query.
 */
public class TagFilter {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(TagFilter.class);
    /**
     * Atlan-internal tag name for the tag.
     */
    String name;
    /**
     * Human-readable name for the tag.
     */
    String displayName;
    /**
     * Value to compare the operand against.
     */
    List<TagValue> tagValues;


    public static final class TagValue {
        /**
         * Value of the tag to match.
         */
        String consolidatedValue;
        /**
         * Unique name(s) of the source tags to match the value against.
         */
        List<String> tagQFNames;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class TagValueBuilder<C extends TagFilter.TagValue, B extends TagFilter.TagValue.TagValueBuilder<C, B>> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String consolidatedValue;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private java.util.ArrayList<String> tagQFNames;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                TagFilter.TagValue.TagValueBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final TagFilter.TagValue instance, final TagFilter.TagValue.TagValueBuilder<?, ?> b) {
                b.consolidatedValue(instance.consolidatedValue);
                b.tagQFNames(instance.tagQFNames == null ? java.util.Collections.<String>emptyList() : instance.tagQFNames);
            }

            /**
             * Value of the tag to match.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B consolidatedValue(final String consolidatedValue) {
                this.consolidatedValue = consolidatedValue;
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B tagQFName(final String tagQFName) {
                if (this.tagQFNames == null) this.tagQFNames = new java.util.ArrayList<String>();
                this.tagQFNames.add(tagQFName);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B tagQFNames(final java.util.Collection<? extends String> tagQFNames) {
                if (tagQFNames == null) {
                    throw new java.lang.NullPointerException("tagQFNames cannot be null");
                }
                if (this.tagQFNames == null) this.tagQFNames = new java.util.ArrayList<String>();
                this.tagQFNames.addAll(tagQFNames);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B clearTagQFNames() {
                if (this.tagQFNames != null) this.tagQFNames.clear();
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "TagFilter.TagValue.TagValueBuilder(consolidatedValue=" + this.consolidatedValue + ", tagQFNames=" + this.tagQFNames + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static final class TagValueBuilderImpl extends TagFilter.TagValue.TagValueBuilder<TagFilter.TagValue, TagFilter.TagValue.TagValueBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private TagValueBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected TagFilter.TagValue.TagValueBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public TagFilter.TagValue build() {
                return new TagFilter.TagValue(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected TagValue(final TagFilter.TagValue.TagValueBuilder<?, ?> b) {
            this.consolidatedValue = b.consolidatedValue;
            java.util.List<String> tagQFNames;
            switch (b.tagQFNames == null ? 0 : b.tagQFNames.size()) {
            case 0: 
                tagQFNames = java.util.Collections.emptyList();
                break;
            case 1: 
                tagQFNames = java.util.Collections.singletonList(b.tagQFNames.get(0));
                break;
            default: 
                tagQFNames = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.tagQFNames));
            }
            this.tagQFNames = tagQFNames;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static TagFilter.TagValue.TagValueBuilder<?, ?> builder() {
            return new TagFilter.TagValue.TagValueBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TagFilter.TagValue.TagValueBuilder<?, ?> toBuilder() {
            return new TagFilter.TagValue.TagValueBuilderImpl().$fillValuesFrom(this);
        }

        /**
         * Value of the tag to match.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getConsolidatedValue() {
            return this.consolidatedValue;
        }

        /**
         * Unique name(s) of the source tags to match the value against.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getTagQFNames() {
            return this.tagQFNames;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof TagFilter.TagValue)) return false;
            final TagFilter.TagValue other = (TagFilter.TagValue) o;
            final java.lang.Object this$consolidatedValue = this.getConsolidatedValue();
            final java.lang.Object other$consolidatedValue = other.getConsolidatedValue();
            if (this$consolidatedValue == null ? other$consolidatedValue != null : !this$consolidatedValue.equals(other$consolidatedValue)) return false;
            final java.lang.Object this$tagQFNames = this.getTagQFNames();
            final java.lang.Object other$tagQFNames = other.getTagQFNames();
            if (this$tagQFNames == null ? other$tagQFNames != null : !this$tagQFNames.equals(other$tagQFNames)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $consolidatedValue = this.getConsolidatedValue();
            result = result * PRIME + ($consolidatedValue == null ? 43 : $consolidatedValue.hashCode());
            final java.lang.Object $tagQFNames = this.getTagQFNames();
            result = result * PRIME + ($tagQFNames == null ? 43 : $tagQFNames.hashCode());
            return result;
        }
    }

    /**
     * Create a new TagFilter to limit assets to those with the human-readable Atlan tag specified.
     *
     * @param client connectivity to the Atlan tenant
     * @param tagName human-readable name of the Atlan tag
     * @return a filter to limit assets to those with the tag
     */
    public static TagFilter of(AtlanClient client, String tagName) {
        try {
            String clsId = client.getAtlanTagCache().getIdForName(tagName);
            return TagFilter._internal().displayName(tagName).name(clsId).build();
        } catch (AtlanException e) {
            log.error("Unable to translate tag -- skipping: {}", tagName, e);
        }
        return null;
    }

    /**
     * Create a new TagFilter to limit assets to those with the human-readable Atlan tag specified,
     * which in turn is mapped to a source tag, and thus can be further narrowed by the value of the
     * source tag.
     *
     * @param client connectivity to the Atlan tenant
     * @param tagName human-readable name of the Atlan tag
     * @param value of the tag to further narrow by
     * @return a filter to limit assets to those with the tag
     */
    public static TagFilter of(AtlanClient client, String tagName, String value) {
        TagFilter starter = of(client, tagName);
        if (starter != null && value != null && !value.isEmpty()) {
            try {
                List<ITag> sourceTags = client.getSourceTagCache().getByMappedAtlanTag(starter.getName());
                List<String> qualifiedNames = sourceTags.stream().map(ITag::getQualifiedName).toList();
                return starter.toBuilder().tagValue(TagValue.builder().tagQFNames(qualifiedNames).consolidatedValue(value).build()).build();
            } catch (AtlanException e) {
                log.error("Unable to find any source tags mapped to tag -- skipping: {}", tagName, e);
            }
        }
        return starter;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class TagFilterBuilder<C extends TagFilter, B extends TagFilter.TagFilterBuilder<C, B>> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String name;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String displayName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<TagValue> tagValues;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            TagFilter.TagFilterBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final TagFilter instance, final TagFilter.TagFilterBuilder<?, ?> b) {
            b.name(instance.name);
            b.displayName(instance.displayName);
            b.tagValues(instance.tagValues == null ? java.util.Collections.<TagValue>emptyList() : instance.tagValues);
        }

        /**
         * Atlan-internal tag name for the tag.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B name(final String name) {
            this.name = name;
            return self();
        }

        /**
         * Human-readable name for the tag.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B displayName(final String displayName) {
            this.displayName = displayName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tagValue(final TagValue tagValue) {
            if (this.tagValues == null) this.tagValues = new java.util.ArrayList<TagValue>();
            this.tagValues.add(tagValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tagValues(final java.util.Collection<? extends TagValue> tagValues) {
            if (tagValues == null) {
                throw new java.lang.NullPointerException("tagValues cannot be null");
            }
            if (this.tagValues == null) this.tagValues = new java.util.ArrayList<TagValue>();
            this.tagValues.addAll(tagValues);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTagValues() {
            if (this.tagValues != null) this.tagValues.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TagFilter.TagFilterBuilder(name=" + this.name + ", displayName=" + this.displayName + ", tagValues=" + this.tagValues + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class TagFilterBuilderImpl extends TagFilter.TagFilterBuilder<TagFilter, TagFilter.TagFilterBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TagFilterBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected TagFilter.TagFilterBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TagFilter build() {
            return new TagFilter(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected TagFilter(final TagFilter.TagFilterBuilder<?, ?> b) {
        this.name = b.name;
        this.displayName = b.displayName;
        java.util.List<TagValue> tagValues;
        switch (b.tagValues == null ? 0 : b.tagValues.size()) {
        case 0: 
            tagValues = java.util.Collections.emptyList();
            break;
        case 1: 
            tagValues = java.util.Collections.singletonList(b.tagValues.get(0));
            break;
        default: 
            tagValues = java.util.Collections.unmodifiableList(new java.util.ArrayList<TagValue>(b.tagValues));
        }
        this.tagValues = tagValues;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static TagFilter.TagFilterBuilder<?, ?> _internal() {
        return new TagFilter.TagFilterBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TagFilter.TagFilterBuilder<?, ?> toBuilder() {
        return new TagFilter.TagFilterBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Atlan-internal tag name for the tag.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * Human-readable name for the tag.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Value to compare the operand against.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<TagValue> getTagValues() {
        return this.tagValues;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TagFilter)) return false;
        final TagFilter other = (TagFilter) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$displayName = this.getDisplayName();
        final java.lang.Object other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
        final java.lang.Object this$tagValues = this.getTagValues();
        final java.lang.Object other$tagValues = other.getTagValues();
        if (this$tagValues == null ? other$tagValues != null : !this$tagValues.equals(other$tagValues)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TagFilter;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $displayName = this.getDisplayName();
        result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
        final java.lang.Object $tagValues = this.getTagValues();
        result = result * PRIME + ($tagValues == null ? 43 : $tagValues.hashCode());
        return result;
    }
}
