// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.events;

import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "operationType")
@JsonSubTypes({@JsonSubTypes.Type(value = AssetCreatePayload.class, name = AssetCreatePayload.TYPE_NAME), @JsonSubTypes.Type(value = AssetUpdatePayload.class, name = AssetUpdatePayload.TYPE_NAME), @JsonSubTypes.Type(value = AssetDeletePayload.class, name = AssetDeletePayload.TYPE_NAME), @JsonSubTypes.Type(value = CustomMetadataUpdatePayload.class, name = CustomMetadataUpdatePayload.TYPE_NAME), @JsonSubTypes.Type(value = AtlanTagAddPayload.class, name = AtlanTagAddPayload.TYPE_NAME), @JsonSubTypes.Type(value = AtlanTagDeletePayload.class, name = AtlanTagDeletePayload.TYPE_NAME)})
public abstract class AtlanEventPayload extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Type of the event payload.
     */
    String type;
    /**
     * Type of the operation the event contains a payload for.
     */
    String operationType;
    /**
     * Time (epoch) the event was triggered in the source system, in milliseconds.
     */
    Long eventTime;
    /**
     * Details of the asset that was impacted by the event.
     * Note that the details some operations (like custom metadata changes) are NOT included in this object,
     * but only in the associated mutatedDetails.
     */
    @JsonProperty("entity")
    Asset asset;


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AtlanEventPayloadBuilder<C extends AtlanEventPayload, B extends AtlanEventPayload.AtlanEventPayloadBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String type;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String operationType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long eventTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Asset asset;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AtlanEventPayload.AtlanEventPayloadBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AtlanEventPayload instance, final AtlanEventPayload.AtlanEventPayloadBuilder<?, ?> b) {
            b.type(instance.type);
            b.operationType(instance.operationType);
            b.eventTime(instance.eventTime);
            b.asset(instance.asset);
        }

        /**
         * Type of the event payload.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B type(final String type) {
            this.type = type;
            return self();
        }

        /**
         * Type of the operation the event contains a payload for.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B operationType(final String operationType) {
            this.operationType = operationType;
            return self();
        }

        /**
         * Time (epoch) the event was triggered in the source system, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B eventTime(final Long eventTime) {
            this.eventTime = eventTime;
            return self();
        }

        /**
         * Details of the asset that was impacted by the event.
         * Note that the details some operations (like custom metadata changes) are NOT included in this object,
         * but only in the associated mutatedDetails.
         * @return {@code this}.
         */
        @JsonProperty("entity")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B asset(final Asset asset) {
            this.asset = asset;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanEventPayload.AtlanEventPayloadBuilder(super=" + super.toString() + ", type=" + this.type + ", operationType=" + this.operationType + ", eventTime=" + this.eventTime + ", asset=" + this.asset + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AtlanEventPayload(final AtlanEventPayload.AtlanEventPayloadBuilder<?, ?> b) {
        super(b);
        this.type = b.type;
        this.operationType = b.operationType;
        this.eventTime = b.eventTime;
        this.asset = b.asset;
    }

    /**
     * Type of the event payload.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
        return this.type;
    }

    /**
     * Type of the operation the event contains a payload for.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getOperationType() {
        return this.operationType;
    }

    /**
     * Time (epoch) the event was triggered in the source system, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getEventTime() {
        return this.eventTime;
    }

    /**
     * Details of the asset that was impacted by the event.
     * Note that the details some operations (like custom metadata changes) are NOT included in this object,
     * but only in the associated mutatedDetails.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Asset getAsset() {
        return this.asset;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanEventPayload)) return false;
        final AtlanEventPayload other = (AtlanEventPayload) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$eventTime = this.getEventTime();
        final java.lang.Object other$eventTime = other.getEventTime();
        if (this$eventTime == null ? other$eventTime != null : !this$eventTime.equals(other$eventTime)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$operationType = this.getOperationType();
        final java.lang.Object other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !this$operationType.equals(other$operationType)) return false;
        final java.lang.Object this$asset = this.getAsset();
        final java.lang.Object other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !this$asset.equals(other$asset)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanEventPayload;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $eventTime = this.getEventTime();
        result = result * PRIME + ($eventTime == null ? 43 : $eventTime.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $operationType = this.getOperationType();
        result = result * PRIME + ($operationType == null ? 43 : $operationType.hashCode());
        final java.lang.Object $asset = this.getAsset();
        result = result * PRIME + ($asset == null ? 43 : $asset.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanEventPayload(super=" + super.toString() + ", type=" + this.getType() + ", operationType=" + this.getOperationType() + ", eventTime=" + this.getEventTime() + ", asset=" + this.getAsset() + ")";
    }
}
