// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.events;

import com.atlan.model.core.AtlanObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Details that wrap events when sent through AWS (Lambda).
 */
public class AwsEventWrapper extends AtlanObject {
    private static final long serialVersionUID = 2L;

    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    public AwsEventWrapper(@JsonProperty("version") String version, @JsonProperty("routeKey") String routeKey, @JsonProperty("rawPath") String rawPath, @JsonProperty("rawQueryString") String rawQueryString, @JsonProperty("headers") Map<String, String> headers, @JsonProperty("requestContext") AwsRequestContext requestContext, @JsonProperty("body") String body, @JsonProperty("isBase64Encoded") boolean isBase64Encoded) {
        this.version = version;
        this.routeKey = routeKey;
        this.rawPath = rawPath;
        this.rawQueryString = rawQueryString;
        this.headers = headers;
        this.requestContext = requestContext;
        this.body = body;
        this.isBase64Encoded = isBase64Encoded;
    }

    /**
     * TBC
     */
    final String version;
    /**
     * TBC
     */
    final String routeKey;
    /**
     * TBC
     */
    final String rawPath;
    /**
     * TBC
     */
    final String rawQueryString;
    /**
     * Headers that were used when sending the event through to the Lambda URL.
     */
    final Map<String, String> headers;
    /**
     * TBC
     */
    final AwsRequestContext requestContext;
    /**
     * Actual contents of the event that was sent by Atlan.
     */
    final String body;
    /**
     * Whether the contents are base64-encoded (true) or plain text (false).
     */
    final boolean isBase64Encoded;


    public static final class AwsRequestContext extends AtlanObject {
        private static final long serialVersionUID = 2L;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        public AwsRequestContext(@JsonProperty("accountId") String accountId, @JsonProperty("apiId") String apiId, @JsonProperty("domainName") String domainName, @JsonProperty("domainPrefix") String domainPrefix, @JsonProperty("http") Map<String, String> http, @JsonProperty("requestId") String requestId, @JsonProperty("routeKey") String routeKey, @JsonProperty("stage") String stage, @JsonProperty("time") String time, @JsonProperty("timeEpoch") Long timeEpoch) {
            this.accountId = accountId;
            this.apiId = apiId;
            this.domainName = domainName;
            this.domainPrefix = domainPrefix;
            this.http = http;
            this.requestId = requestId;
            this.routeKey = routeKey;
            this.stage = stage;
            this.time = time;
            this.timeEpoch = timeEpoch;
        }

        /** Account from which the request originated. */
        final String accountId;
        /** TBC */
        final String apiId;
        /** TBC */
        final String domainName;
        /** TBC */
        final String domainPrefix;
        /** TBC */
        final Map<String, String> http;
        /** TBC */
        final String requestId;
        /** TBC */
        final String routeKey;
        /** TBC */
        final String stage;
        /** Time at which the event was received, as a formatted string. */
        final String time;
        /** Time at which the event was received, epoch-based, in milliseconds. */
        final Long timeEpoch;


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class AwsRequestContextBuilder<C extends AwsEventWrapper.AwsRequestContext, B extends AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String accountId;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String apiId;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String domainName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String domainPrefix;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Map<String, String> http;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String requestId;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String routeKey;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String stage;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String time;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long timeEpoch;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final AwsEventWrapper.AwsRequestContext instance, final AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilder<?, ?> b) {
                b.accountId(instance.accountId);
                b.apiId(instance.apiId);
                b.domainName(instance.domainName);
                b.domainPrefix(instance.domainPrefix);
                b.http(instance.http);
                b.requestId(instance.requestId);
                b.routeKey(instance.routeKey);
                b.stage(instance.stage);
                b.time(instance.time);
                b.timeEpoch(instance.timeEpoch);
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B accountId(final String accountId) {
                this.accountId = accountId;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B apiId(final String apiId) {
                this.apiId = apiId;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B domainName(final String domainName) {
                this.domainName = domainName;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B domainPrefix(final String domainPrefix) {
                this.domainPrefix = domainPrefix;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B http(final Map<String, String> http) {
                this.http = http;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B requestId(final String requestId) {
                this.requestId = requestId;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B routeKey(final String routeKey) {
                this.routeKey = routeKey;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B stage(final String stage) {
                this.stage = stage;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B time(final String time) {
                this.time = time;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B timeEpoch(final Long timeEpoch) {
                this.timeEpoch = timeEpoch;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilder(super=" + super.toString() + ", accountId=" + this.accountId + ", apiId=" + this.apiId + ", domainName=" + this.domainName + ", domainPrefix=" + this.domainPrefix + ", http=" + this.http + ", requestId=" + this.requestId + ", routeKey=" + this.routeKey + ", stage=" + this.stage + ", time=" + this.time + ", timeEpoch=" + this.timeEpoch + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static final class AwsRequestContextBuilderImpl extends AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilder<AwsEventWrapper.AwsRequestContext, AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private AwsRequestContextBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public AwsEventWrapper.AwsRequestContext build() {
                return new AwsEventWrapper.AwsRequestContext(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AwsRequestContext(final AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilder<?, ?> b) {
            super(b);
            this.accountId = b.accountId;
            this.apiId = b.apiId;
            this.domainName = b.domainName;
            this.domainPrefix = b.domainPrefix;
            this.http = b.http;
            this.requestId = b.requestId;
            this.routeKey = b.routeKey;
            this.stage = b.stage;
            this.time = b.time;
            this.timeEpoch = b.timeEpoch;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilder<?, ?> builder() {
            return new AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilder<?, ?> toBuilder() {
            return new AwsEventWrapper.AwsRequestContext.AwsRequestContextBuilderImpl().$fillValuesFrom(this);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountId() {
            return this.accountId;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getApiId() {
            return this.apiId;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDomainName() {
            return this.domainName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDomainPrefix() {
            return this.domainPrefix;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Map<String, String> getHttp() {
            return this.http;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getRequestId() {
            return this.requestId;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getRouteKey() {
            return this.routeKey;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getStage() {
            return this.stage;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTime() {
            return this.time;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getTimeEpoch() {
            return this.timeEpoch;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof AwsEventWrapper.AwsRequestContext)) return false;
            final AwsEventWrapper.AwsRequestContext other = (AwsEventWrapper.AwsRequestContext) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$timeEpoch = this.getTimeEpoch();
            final java.lang.Object other$timeEpoch = other.getTimeEpoch();
            if (this$timeEpoch == null ? other$timeEpoch != null : !this$timeEpoch.equals(other$timeEpoch)) return false;
            final java.lang.Object this$accountId = this.getAccountId();
            final java.lang.Object other$accountId = other.getAccountId();
            if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) return false;
            final java.lang.Object this$apiId = this.getApiId();
            final java.lang.Object other$apiId = other.getApiId();
            if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) return false;
            final java.lang.Object this$domainName = this.getDomainName();
            final java.lang.Object other$domainName = other.getDomainName();
            if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) return false;
            final java.lang.Object this$domainPrefix = this.getDomainPrefix();
            final java.lang.Object other$domainPrefix = other.getDomainPrefix();
            if (this$domainPrefix == null ? other$domainPrefix != null : !this$domainPrefix.equals(other$domainPrefix)) return false;
            final java.lang.Object this$http = this.getHttp();
            final java.lang.Object other$http = other.getHttp();
            if (this$http == null ? other$http != null : !this$http.equals(other$http)) return false;
            final java.lang.Object this$requestId = this.getRequestId();
            final java.lang.Object other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) return false;
            final java.lang.Object this$routeKey = this.getRouteKey();
            final java.lang.Object other$routeKey = other.getRouteKey();
            if (this$routeKey == null ? other$routeKey != null : !this$routeKey.equals(other$routeKey)) return false;
            final java.lang.Object this$stage = this.getStage();
            final java.lang.Object other$stage = other.getStage();
            if (this$stage == null ? other$stage != null : !this$stage.equals(other$stage)) return false;
            final java.lang.Object this$time = this.getTime();
            final java.lang.Object other$time = other.getTime();
            if (this$time == null ? other$time != null : !this$time.equals(other$time)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof AwsEventWrapper.AwsRequestContext;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $timeEpoch = this.getTimeEpoch();
            result = result * PRIME + ($timeEpoch == null ? 43 : $timeEpoch.hashCode());
            final java.lang.Object $accountId = this.getAccountId();
            result = result * PRIME + ($accountId == null ? 43 : $accountId.hashCode());
            final java.lang.Object $apiId = this.getApiId();
            result = result * PRIME + ($apiId == null ? 43 : $apiId.hashCode());
            final java.lang.Object $domainName = this.getDomainName();
            result = result * PRIME + ($domainName == null ? 43 : $domainName.hashCode());
            final java.lang.Object $domainPrefix = this.getDomainPrefix();
            result = result * PRIME + ($domainPrefix == null ? 43 : $domainPrefix.hashCode());
            final java.lang.Object $http = this.getHttp();
            result = result * PRIME + ($http == null ? 43 : $http.hashCode());
            final java.lang.Object $requestId = this.getRequestId();
            result = result * PRIME + ($requestId == null ? 43 : $requestId.hashCode());
            final java.lang.Object $routeKey = this.getRouteKey();
            result = result * PRIME + ($routeKey == null ? 43 : $routeKey.hashCode());
            final java.lang.Object $stage = this.getStage();
            result = result * PRIME + ($stage == null ? 43 : $stage.hashCode());
            final java.lang.Object $time = this.getTime();
            result = result * PRIME + ($time == null ? 43 : $time.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AwsEventWrapper.AwsRequestContext(super=" + super.toString() + ", accountId=" + this.getAccountId() + ", apiId=" + this.getApiId() + ", domainName=" + this.getDomainName() + ", domainPrefix=" + this.getDomainPrefix() + ", http=" + this.getHttp() + ", requestId=" + this.getRequestId() + ", routeKey=" + this.getRouteKey() + ", stage=" + this.getStage() + ", time=" + this.getTime() + ", timeEpoch=" + this.getTimeEpoch() + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AwsEventWrapperBuilder<C extends AwsEventWrapper, B extends AwsEventWrapper.AwsEventWrapperBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String version;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String routeKey;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String rawPath;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String rawQueryString;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> headers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AwsRequestContext requestContext;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String body;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean isBase64Encoded;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AwsEventWrapper.AwsEventWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AwsEventWrapper instance, final AwsEventWrapper.AwsEventWrapperBuilder<?, ?> b) {
            b.version(instance.version);
            b.routeKey(instance.routeKey);
            b.rawPath(instance.rawPath);
            b.rawQueryString(instance.rawQueryString);
            b.headers(instance.headers);
            b.requestContext(instance.requestContext);
            b.body(instance.body);
            b.isBase64Encoded(instance.isBase64Encoded);
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B version(final String version) {
            this.version = version;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B routeKey(final String routeKey) {
            this.routeKey = routeKey;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B rawPath(final String rawPath) {
            this.rawPath = rawPath;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B rawQueryString(final String rawQueryString) {
            this.rawQueryString = rawQueryString;
            return self();
        }

        /**
         * Headers that were used when sending the event through to the Lambda URL.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B headers(final Map<String, String> headers) {
            this.headers = headers;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestContext(final AwsRequestContext requestContext) {
            this.requestContext = requestContext;
            return self();
        }

        /**
         * Actual contents of the event that was sent by Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B body(final String body) {
            this.body = body;
            return self();
        }

        /**
         * Whether the contents are base64-encoded (true) or plain text (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isBase64Encoded(final boolean isBase64Encoded) {
            this.isBase64Encoded = isBase64Encoded;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AwsEventWrapper.AwsEventWrapperBuilder(super=" + super.toString() + ", version=" + this.version + ", routeKey=" + this.routeKey + ", rawPath=" + this.rawPath + ", rawQueryString=" + this.rawQueryString + ", headers=" + this.headers + ", requestContext=" + this.requestContext + ", body=" + this.body + ", isBase64Encoded=" + this.isBase64Encoded + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AwsEventWrapperBuilderImpl extends AwsEventWrapper.AwsEventWrapperBuilder<AwsEventWrapper, AwsEventWrapper.AwsEventWrapperBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AwsEventWrapperBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AwsEventWrapper.AwsEventWrapperBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AwsEventWrapper build() {
            return new AwsEventWrapper(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AwsEventWrapper(final AwsEventWrapper.AwsEventWrapperBuilder<?, ?> b) {
        super(b);
        this.version = b.version;
        this.routeKey = b.routeKey;
        this.rawPath = b.rawPath;
        this.rawQueryString = b.rawQueryString;
        this.headers = b.headers;
        this.requestContext = b.requestContext;
        this.body = b.body;
        this.isBase64Encoded = b.isBase64Encoded;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AwsEventWrapper.AwsEventWrapperBuilder<?, ?> builder() {
        return new AwsEventWrapper.AwsEventWrapperBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AwsEventWrapper.AwsEventWrapperBuilder<?, ?> toBuilder() {
        return new AwsEventWrapper.AwsEventWrapperBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getVersion() {
        return this.version;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRouteKey() {
        return this.routeKey;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRawPath() {
        return this.rawPath;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRawQueryString() {
        return this.rawQueryString;
    }

    /**
     * Headers that were used when sending the event through to the Lambda URL.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AwsRequestContext getRequestContext() {
        return this.requestContext;
    }

    /**
     * Actual contents of the event that was sent by Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBody() {
        return this.body;
    }

    /**
     * Whether the contents are base64-encoded (true) or plain text (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean getIsBase64Encoded() {
        return this.isBase64Encoded;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AwsEventWrapper)) return false;
        final AwsEventWrapper other = (AwsEventWrapper) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        if (this.getIsBase64Encoded() != other.getIsBase64Encoded()) return false;
        final java.lang.Object this$version = this.getVersion();
        final java.lang.Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
        final java.lang.Object this$routeKey = this.getRouteKey();
        final java.lang.Object other$routeKey = other.getRouteKey();
        if (this$routeKey == null ? other$routeKey != null : !this$routeKey.equals(other$routeKey)) return false;
        final java.lang.Object this$rawPath = this.getRawPath();
        final java.lang.Object other$rawPath = other.getRawPath();
        if (this$rawPath == null ? other$rawPath != null : !this$rawPath.equals(other$rawPath)) return false;
        final java.lang.Object this$rawQueryString = this.getRawQueryString();
        final java.lang.Object other$rawQueryString = other.getRawQueryString();
        if (this$rawQueryString == null ? other$rawQueryString != null : !this$rawQueryString.equals(other$rawQueryString)) return false;
        final java.lang.Object this$headers = this.getHeaders();
        final java.lang.Object other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) return false;
        final java.lang.Object this$requestContext = this.getRequestContext();
        final java.lang.Object other$requestContext = other.getRequestContext();
        if (this$requestContext == null ? other$requestContext != null : !this$requestContext.equals(other$requestContext)) return false;
        final java.lang.Object this$body = this.getBody();
        final java.lang.Object other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AwsEventWrapper;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = result * PRIME + (this.getIsBase64Encoded() ? 79 : 97);
        final java.lang.Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        final java.lang.Object $routeKey = this.getRouteKey();
        result = result * PRIME + ($routeKey == null ? 43 : $routeKey.hashCode());
        final java.lang.Object $rawPath = this.getRawPath();
        result = result * PRIME + ($rawPath == null ? 43 : $rawPath.hashCode());
        final java.lang.Object $rawQueryString = this.getRawQueryString();
        result = result * PRIME + ($rawQueryString == null ? 43 : $rawQueryString.hashCode());
        final java.lang.Object $headers = this.getHeaders();
        result = result * PRIME + ($headers == null ? 43 : $headers.hashCode());
        final java.lang.Object $requestContext = this.getRequestContext();
        result = result * PRIME + ($requestContext == null ? 43 : $requestContext.hashCode());
        final java.lang.Object $body = this.getBody();
        result = result * PRIME + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AwsEventWrapper(super=" + super.toString() + ", version=" + this.getVersion() + ", routeKey=" + this.getRouteKey() + ", rawPath=" + this.getRawPath() + ", rawQueryString=" + this.getRawQueryString() + ", headers=" + this.getHeaders() + ", requestContext=" + this.getRequestContext() + ", body=" + this.getBody() + ", isBase64Encoded=" + this.getIsBase64Encoded() + ")";
    }
}
