// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.fields;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;

/**
 * Base class for any relationship field in Atlan that can be searched.
 */
public class SearchableRelationship extends RelationField implements IRelationSearchable {
    private final String relationshipName;

    /**
     * Default constructor.
     *
     * @param atlan name of the attribute in the metastore
     * @param relationship name of the relationship type in the metastore
     */
    public SearchableRelationship(String atlan, String relationship) {
        super(atlan);
        this.relationshipName = relationship;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Query hasAny() {
        return IRelationSearchable.hasAny(getRelationshipName());
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected String getRelationshipName() {
        return this.relationshipName;
    }
}
