// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.lineage;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;

/**
 * Class used to define the composition of multiple filters for objects when retrieving lineage.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = FilterList.FilterListBuilderImpl.class)
public class FilterList extends AtlanObject {
    private static final long serialVersionUID = 2L;


    public enum Condition implements AtlanEnum {
        AND("AND"), OR("OR");
        @JsonValue
        private final String value;

        Condition(String value) {
            this.value = value;
        }

        public static Condition fromValue(String value) {
            for (Condition b : Condition.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return null;
        }

        @Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getValue() {
            return this.value;
        }
    }

    /**
     * Whether the criteria must all match (AND) or any matching is sufficient (OR).
     */
    Condition condition;
    /**
     * Basis on which to compare a result for inclusion.
     */
    @JsonProperty("criterion")
    List<EntityFilter> criteria;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Condition $default$condition() {
        return Condition.AND;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class FilterListBuilder<C extends FilterList, B extends FilterList.FilterListBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean condition$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Condition condition$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<EntityFilter> criteria;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            FilterList.FilterListBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final FilterList instance, final FilterList.FilterListBuilder<?, ?> b) {
            b.condition(instance.condition);
            b.criteria(instance.criteria == null ? java.util.Collections.<EntityFilter>emptyList() : instance.criteria);
        }

        /**
         * Whether the criteria must all match (AND) or any matching is sufficient (OR).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B condition(final Condition condition) {
            this.condition$value = condition;
            condition$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B criterion(final EntityFilter criterion) {
            if (this.criteria == null) this.criteria = new java.util.ArrayList<EntityFilter>();
            this.criteria.add(criterion);
            return self();
        }

        @JsonProperty("criterion")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B criteria(final java.util.Collection<? extends EntityFilter> criteria) {
            if (criteria == null) {
                throw new java.lang.NullPointerException("criteria cannot be null");
            }
            if (this.criteria == null) this.criteria = new java.util.ArrayList<EntityFilter>();
            this.criteria.addAll(criteria);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCriteria() {
            if (this.criteria != null) this.criteria.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "FilterList.FilterListBuilder(super=" + super.toString() + ", condition$value=" + this.condition$value + ", criteria=" + this.criteria + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class FilterListBuilderImpl extends FilterList.FilterListBuilder<FilterList, FilterList.FilterListBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private FilterListBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected FilterList.FilterListBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FilterList build() {
            return new FilterList(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected FilterList(final FilterList.FilterListBuilder<?, ?> b) {
        super(b);
        if (b.condition$set) this.condition = b.condition$value;
         else this.condition = FilterList.$default$condition();
        java.util.List<EntityFilter> criteria;
        switch (b.criteria == null ? 0 : b.criteria.size()) {
        case 0: 
            criteria = java.util.Collections.emptyList();
            break;
        case 1: 
            criteria = java.util.Collections.singletonList(b.criteria.get(0));
            break;
        default: 
            criteria = java.util.Collections.unmodifiableList(new java.util.ArrayList<EntityFilter>(b.criteria));
        }
        this.criteria = criteria;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static FilterList.FilterListBuilder<?, ?> builder() {
        return new FilterList.FilterListBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public FilterList.FilterListBuilder<?, ?> toBuilder() {
        return new FilterList.FilterListBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Whether the criteria must all match (AND) or any matching is sufficient (OR).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Condition getCondition() {
        return this.condition;
    }

    /**
     * Basis on which to compare a result for inclusion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<EntityFilter> getCriteria() {
        return this.criteria;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FilterList)) return false;
        final FilterList other = (FilterList) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$condition = this.getCondition();
        final java.lang.Object other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) return false;
        final java.lang.Object this$criteria = this.getCriteria();
        final java.lang.Object other$criteria = other.getCriteria();
        if (this$criteria == null ? other$criteria != null : !this$criteria.equals(other$criteria)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FilterList;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $condition = this.getCondition();
        result = result * PRIME + ($condition == null ? 43 : $condition.hashCode());
        final java.lang.Object $criteria = this.getCriteria();
        result = result * PRIME + ($criteria == null ? 43 : $criteria.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "FilterList(super=" + super.toString() + ", condition=" + this.getCondition() + ", criteria=" + this.getCriteria() + ")";
    }
}
