// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.lineage;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import com.atlan.model.enums.AtlanLineageDirection;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.fields.*;
import com.atlan.model.relations.Reference;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Lineage abstraction mechanism, to simplify the most common lineage requests against Atlan
 * (removing the need to understand the guts of Elastic).
 */
public class FluentLineage {
    public static final LineageFilter ACTIVE = Asset.STATUS.inLineage.eq(AtlanStatus.ACTIVE);

    /**
     * Build a fluent lineage request against the provided Atlan tenant.
     *
     * @param client connectivity to an Atlan tenant
     * @param startingFrom an asset reference that contains at least a GUID, from which to start traversing lineage
     * @return the start of a fluent lineage request against the tenant
     */
    public static FluentLineageBuilder builder(AtlanClient client, Reference startingFrom) {
        return builder(client, startingFrom.getGuid());
    }

    /**
     * Build a fluent lineage request against the provided Atlan tenant.
     *
     * @param client connectivity to an Atlan tenant
     * @param startingGuid unique identifier (GUID) of the asset from which to start lineage
     * @return the start of a fluent lineage request against the tenant
     */
    public static FluentLineageBuilder builder(AtlanClient client, String startingGuid) {
        return _internal().client(client).startingGuid(startingGuid);
    }

    /**
     * Client through which to retrieve the lineage.
     */
    AtlanClient client;
    /**
     * Unique identifier (GUID) of the asset from which to start lineage.
     */
    String startingGuid;
    /**
     * Direction of lineage to fetch (upstream or downstream).
     */
    AtlanLineageDirection direction;
    /**
     * Number of results to retrieve per underlying API request.
     */
    Integer pageSize;
    /**
     * Number of degrees of separation (hops) across which lineage should be fetched.
     */
    Integer depth;
    /**
     * Filters to apply on assets. Any assets excluded by the filters will exclude all assets beyond, as well.
     */
    List<LineageFilter> whereAssets;
    /**
     * Whether the {@code whereAssets} criteria should be combined (AND) or any matching is sufficient (OR).
     */
    FilterList.Condition assetsCondition;
    /**
     * Filters to apply on relationships. Any relationships excluded by the filters will exclude all assets and relationships beyond, as well.
     */
    List<LineageFilter> whereRelationships;
    /**
     * Whether the {@code whereRelationships} criteria should be combined (AND) or any matching is sufficient (OR).
     */
    FilterList.Condition relationshipsCondition;
    /**
     * Assets to include in the results. Any assets not matching these filters will not be included in the results,
     * but will still be traversed in the lineage so that any assets beyond them are still considered for inclusion
     * in the results.
     */
    List<LineageFilter> includesInResults;
    /**
     * Whether the {@code includesInResults} criteria should be combined (AND) or any matching is sufficient (OR).
     */
    FilterList.Condition includesCondition;
    /**
     * Attributes to retrieve for each asset in the lineage results.
     */
    List<AtlanField> includesOnResults;
    /**
     * Attributes to retrieve for each asset in the lineage results (for internal use, unchecked!).
     */
    List<String> _includesOnResults;
    /**
     * Attributes to retrieve for each asset related to the assets in the results.
     */
    List<AtlanField> includesOnRelations;
    /**
     * Attributes to retrieve for each asset related to the assets in the results (for internal use, unchecked!).
     */
    List<String> _includesOnRelations;

    /**
     * Translate the Atlan fluent lineage request into an Atlan lineage list request builder.
     *
     * @return an Atlan lineage list request builder that encapsulates the fluent lineage request
     */
    protected LineageListRequest.LineageListRequestBuilder<?, ?> _requestBuilder() {
        LineageListRequest.LineageListRequestBuilder<?, ?> request = LineageListRequest.builder(startingGuid).direction(direction);
        if (pageSize != null) {
            request.size(pageSize);
        }
        if (depth != null) {
            request.depth(depth);
        }
        if (whereAssets != null) {
            FilterList.FilterListBuilder<?, ?> entities = FilterList.builder().condition(assetsCondition);
            for (LineageFilter asset : whereAssets) {
                String attrName = getInternalAtlanName(asset.getField());
                entities.criterion(EntityFilter.builder().attributeName(attrName).operator(asset.getOperator()).attributeValue(asset.getValue()).build());
            }
            request.entityTraversalFilters(entities.build());
        }
        if (whereRelationships != null) {
            FilterList.FilterListBuilder<?, ?> relationships = FilterList.builder().condition(relationshipsCondition);
            for (LineageFilter relationship : whereRelationships) {
                String attrName = getInternalAtlanName(relationship.getField());
                relationships.criterion(EntityFilter.builder().attributeName(attrName).operator(relationship.getOperator()).attributeValue(relationship.getValue()).build());
            }
            request.relationshipTraversalFilters(relationships.build());
        }
        if (includesInResults != null) {
            FilterList.FilterListBuilder<?, ?> entities = FilterList.builder().condition(includesCondition);
            for (LineageFilter asset : includesInResults) {
                String attrName = getInternalAtlanName(asset.getField());
                entities.criterion(EntityFilter.builder().attributeName(attrName).operator(asset.getOperator()).attributeValue(asset.getValue()).build());
            }
            request.entityFilters(entities.build());
        }
        if (_includesOnResults != null) {
            request.attributes(_includesOnResults);
        }
        if (includesOnResults != null) {
            request.attributes(includesOnResults.stream().map(AtlanField::getAtlanFieldName).collect(Collectors.toList()));
        }
        if (_includesOnRelations != null) {
            request.relationAttributes(_includesOnRelations);
        }
        if (includesOnRelations != null) {
            request.relationAttributes(includesOnRelations.stream().map(AtlanField::getAtlanFieldName).collect(Collectors.toList()));
        }
        return request;
    }

    private String getInternalAtlanName(SearchableField candidate) {
        String attrName = "";
        if (candidate instanceof IInternalSearchable) {
            attrName = ((IInternalSearchable) candidate).getInternalFieldName();
        } else 
        // TODO: filtering lineage by custom metadata not currently possible
        if (candidate != null && !(candidate instanceof CustomMetadataField)) {
            attrName = candidate.getAtlanFieldName();
        }
        return attrName;
    }


    public static class FluentLineageBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanClient client;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String startingGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean direction$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanLineageDirection direction$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean pageSize$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer pageSize$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer depth;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<LineageFilter> whereAssets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean assetsCondition$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private FilterList.Condition assetsCondition$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<LineageFilter> whereRelationships;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean relationshipsCondition$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private FilterList.Condition relationshipsCondition$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<LineageFilter> includesInResults;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean includesCondition$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private FilterList.Condition includesCondition$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AtlanField> includesOnResults;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> _includesOnResults;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AtlanField> includesOnRelations;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> _includesOnRelations;

        /**
         * Translate the Atlan fluent lineage request into an Atlan lineage list request builder.
         *
         * @return an Atlan lineage list request builder that encapsulates the fluent lineage request
         */
        public LineageListRequest.LineageListRequestBuilder<?, ?> toRequestBuilder() {
            return build()._requestBuilder();
        }

        /**
         * Translate the Atlan fluent lineage request into an Atlan lineage list request.
         *
         * @return an Atlan lineage list request that encapsulates the fluent lineage request
         */
        public LineageListRequest toRequest() {
            return toRequestBuilder().build();
        }

        /**
         * Run the fluent lineage request to retrieve assets that match the supplied criteria.
         *
         * @return a stream of assets that match the specified criteria, lazily-fetched
         * @throws AtlanException on any issues interacting with the Atlan APIs
         */
        public Stream<Asset> stream() throws AtlanException {
            if (client == null) {
                throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
            }
            LineageListRequest request = toRequest();
            return request.fetch(client).stream();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        FluentLineageBuilder() {
        }

        /**
         * Client through which to retrieve the lineage.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder client(final AtlanClient client) {
            this.client = client;
            return this;
        }

        /**
         * Unique identifier (GUID) of the asset from which to start lineage.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder startingGuid(final String startingGuid) {
            this.startingGuid = startingGuid;
            return this;
        }

        /**
         * Direction of lineage to fetch (upstream or downstream).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder direction(final AtlanLineageDirection direction) {
            this.direction$value = direction;
            direction$set = true;
            return this;
        }

        /**
         * Number of results to retrieve per underlying API request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder pageSize(final Integer pageSize) {
            this.pageSize$value = pageSize;
            pageSize$set = true;
            return this;
        }

        /**
         * Number of degrees of separation (hops) across which lineage should be fetched.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder depth(final Integer depth) {
            this.depth = depth;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder whereAsset(final LineageFilter whereAsset) {
            if (this.whereAssets == null) this.whereAssets = new java.util.ArrayList<LineageFilter>();
            this.whereAssets.add(whereAsset);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder whereAssets(final java.util.Collection<? extends LineageFilter> whereAssets) {
            if (whereAssets == null) {
                throw new java.lang.NullPointerException("whereAssets cannot be null");
            }
            if (this.whereAssets == null) this.whereAssets = new java.util.ArrayList<LineageFilter>();
            this.whereAssets.addAll(whereAssets);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder clearWhereAssets() {
            if (this.whereAssets != null) this.whereAssets.clear();
            return this;
        }

        /**
         * Whether the {@code whereAssets} criteria should be combined (AND) or any matching is sufficient (OR).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder assetsCondition(final FilterList.Condition assetsCondition) {
            this.assetsCondition$value = assetsCondition;
            assetsCondition$set = true;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder whereRelationship(final LineageFilter whereRelationship) {
            if (this.whereRelationships == null) this.whereRelationships = new java.util.ArrayList<LineageFilter>();
            this.whereRelationships.add(whereRelationship);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder whereRelationships(final java.util.Collection<? extends LineageFilter> whereRelationships) {
            if (whereRelationships == null) {
                throw new java.lang.NullPointerException("whereRelationships cannot be null");
            }
            if (this.whereRelationships == null) this.whereRelationships = new java.util.ArrayList<LineageFilter>();
            this.whereRelationships.addAll(whereRelationships);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder clearWhereRelationships() {
            if (this.whereRelationships != null) this.whereRelationships.clear();
            return this;
        }

        /**
         * Whether the {@code whereRelationships} criteria should be combined (AND) or any matching is sufficient (OR).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder relationshipsCondition(final FilterList.Condition relationshipsCondition) {
            this.relationshipsCondition$value = relationshipsCondition;
            relationshipsCondition$set = true;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder includeInResults(final LineageFilter includeInResults) {
            if (this.includesInResults == null) this.includesInResults = new java.util.ArrayList<LineageFilter>();
            this.includesInResults.add(includeInResults);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder includesInResults(final java.util.Collection<? extends LineageFilter> includesInResults) {
            if (includesInResults == null) {
                throw new java.lang.NullPointerException("includesInResults cannot be null");
            }
            if (this.includesInResults == null) this.includesInResults = new java.util.ArrayList<LineageFilter>();
            this.includesInResults.addAll(includesInResults);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder clearIncludesInResults() {
            if (this.includesInResults != null) this.includesInResults.clear();
            return this;
        }

        /**
         * Whether the {@code includesInResults} criteria should be combined (AND) or any matching is sufficient (OR).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder includesCondition(final FilterList.Condition includesCondition) {
            this.includesCondition$value = includesCondition;
            includesCondition$set = true;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder includeOnResults(final AtlanField includeOnResults) {
            if (this.includesOnResults == null) this.includesOnResults = new java.util.ArrayList<AtlanField>();
            this.includesOnResults.add(includeOnResults);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder includesOnResults(final java.util.Collection<? extends AtlanField> includesOnResults) {
            if (includesOnResults == null) {
                throw new java.lang.NullPointerException("includesOnResults cannot be null");
            }
            if (this.includesOnResults == null) this.includesOnResults = new java.util.ArrayList<AtlanField>();
            this.includesOnResults.addAll(includesOnResults);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder clearIncludesOnResults() {
            if (this.includesOnResults != null) this.includesOnResults.clear();
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder _includeOnResults(final String _includeOnResults) {
            if (this._includesOnResults == null) this._includesOnResults = new java.util.ArrayList<String>();
            this._includesOnResults.add(_includeOnResults);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder _includesOnResults(final java.util.Collection<? extends String> _includesOnResults) {
            if (_includesOnResults == null) {
                throw new java.lang.NullPointerException("_includesOnResults cannot be null");
            }
            if (this._includesOnResults == null) this._includesOnResults = new java.util.ArrayList<String>();
            this._includesOnResults.addAll(_includesOnResults);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder clear_includesOnResults() {
            if (this._includesOnResults != null) this._includesOnResults.clear();
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder includeOnRelations(final AtlanField includeOnRelations) {
            if (this.includesOnRelations == null) this.includesOnRelations = new java.util.ArrayList<AtlanField>();
            this.includesOnRelations.add(includeOnRelations);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder includesOnRelations(final java.util.Collection<? extends AtlanField> includesOnRelations) {
            if (includesOnRelations == null) {
                throw new java.lang.NullPointerException("includesOnRelations cannot be null");
            }
            if (this.includesOnRelations == null) this.includesOnRelations = new java.util.ArrayList<AtlanField>();
            this.includesOnRelations.addAll(includesOnRelations);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder clearIncludesOnRelations() {
            if (this.includesOnRelations != null) this.includesOnRelations.clear();
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder _includeOnRelations(final String _includeOnRelations) {
            if (this._includesOnRelations == null) this._includesOnRelations = new java.util.ArrayList<String>();
            this._includesOnRelations.add(_includeOnRelations);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder _includesOnRelations(final java.util.Collection<? extends String> _includesOnRelations) {
            if (_includesOnRelations == null) {
                throw new java.lang.NullPointerException("_includesOnRelations cannot be null");
            }
            if (this._includesOnRelations == null) this._includesOnRelations = new java.util.ArrayList<String>();
            this._includesOnRelations.addAll(_includesOnRelations);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage.FluentLineageBuilder clear_includesOnRelations() {
            if (this._includesOnRelations != null) this._includesOnRelations.clear();
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentLineage build() {
            java.util.List<LineageFilter> whereAssets;
            switch (this.whereAssets == null ? 0 : this.whereAssets.size()) {
            case 0: 
                whereAssets = java.util.Collections.emptyList();
                break;
            case 1: 
                whereAssets = java.util.Collections.singletonList(this.whereAssets.get(0));
                break;
            default: 
                whereAssets = java.util.Collections.unmodifiableList(new java.util.ArrayList<LineageFilter>(this.whereAssets));
            }
            java.util.List<LineageFilter> whereRelationships;
            switch (this.whereRelationships == null ? 0 : this.whereRelationships.size()) {
            case 0: 
                whereRelationships = java.util.Collections.emptyList();
                break;
            case 1: 
                whereRelationships = java.util.Collections.singletonList(this.whereRelationships.get(0));
                break;
            default: 
                whereRelationships = java.util.Collections.unmodifiableList(new java.util.ArrayList<LineageFilter>(this.whereRelationships));
            }
            java.util.List<LineageFilter> includesInResults;
            switch (this.includesInResults == null ? 0 : this.includesInResults.size()) {
            case 0: 
                includesInResults = java.util.Collections.emptyList();
                break;
            case 1: 
                includesInResults = java.util.Collections.singletonList(this.includesInResults.get(0));
                break;
            default: 
                includesInResults = java.util.Collections.unmodifiableList(new java.util.ArrayList<LineageFilter>(this.includesInResults));
            }
            java.util.List<AtlanField> includesOnResults;
            switch (this.includesOnResults == null ? 0 : this.includesOnResults.size()) {
            case 0: 
                includesOnResults = java.util.Collections.emptyList();
                break;
            case 1: 
                includesOnResults = java.util.Collections.singletonList(this.includesOnResults.get(0));
                break;
            default: 
                includesOnResults = java.util.Collections.unmodifiableList(new java.util.ArrayList<AtlanField>(this.includesOnResults));
            }
            java.util.List<String> _includesOnResults;
            switch (this._includesOnResults == null ? 0 : this._includesOnResults.size()) {
            case 0: 
                _includesOnResults = java.util.Collections.emptyList();
                break;
            case 1: 
                _includesOnResults = java.util.Collections.singletonList(this._includesOnResults.get(0));
                break;
            default: 
                _includesOnResults = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this._includesOnResults));
            }
            java.util.List<AtlanField> includesOnRelations;
            switch (this.includesOnRelations == null ? 0 : this.includesOnRelations.size()) {
            case 0: 
                includesOnRelations = java.util.Collections.emptyList();
                break;
            case 1: 
                includesOnRelations = java.util.Collections.singletonList(this.includesOnRelations.get(0));
                break;
            default: 
                includesOnRelations = java.util.Collections.unmodifiableList(new java.util.ArrayList<AtlanField>(this.includesOnRelations));
            }
            java.util.List<String> _includesOnRelations;
            switch (this._includesOnRelations == null ? 0 : this._includesOnRelations.size()) {
            case 0: 
                _includesOnRelations = java.util.Collections.emptyList();
                break;
            case 1: 
                _includesOnRelations = java.util.Collections.singletonList(this._includesOnRelations.get(0));
                break;
            default: 
                _includesOnRelations = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this._includesOnRelations));
            }
            AtlanLineageDirection direction$value = this.direction$value;
            if (!this.direction$set) direction$value = FluentLineage.$default$direction();
            Integer pageSize$value = this.pageSize$value;
            if (!this.pageSize$set) pageSize$value = FluentLineage.$default$pageSize();
            FilterList.Condition assetsCondition$value = this.assetsCondition$value;
            if (!this.assetsCondition$set) assetsCondition$value = FluentLineage.$default$assetsCondition();
            FilterList.Condition relationshipsCondition$value = this.relationshipsCondition$value;
            if (!this.relationshipsCondition$set) relationshipsCondition$value = FluentLineage.$default$relationshipsCondition();
            FilterList.Condition includesCondition$value = this.includesCondition$value;
            if (!this.includesCondition$set) includesCondition$value = FluentLineage.$default$includesCondition();
            return new FluentLineage(this.client, this.startingGuid, direction$value, pageSize$value, this.depth, whereAssets, assetsCondition$value, whereRelationships, relationshipsCondition$value, includesInResults, includesCondition$value, includesOnResults, _includesOnResults, includesOnRelations, _includesOnRelations);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "FluentLineage.FluentLineageBuilder(client=" + this.client + ", startingGuid=" + this.startingGuid + ", direction$value=" + this.direction$value + ", pageSize$value=" + this.pageSize$value + ", depth=" + this.depth + ", whereAssets=" + this.whereAssets + ", assetsCondition$value=" + this.assetsCondition$value + ", whereRelationships=" + this.whereRelationships + ", relationshipsCondition$value=" + this.relationshipsCondition$value + ", includesInResults=" + this.includesInResults + ", includesCondition$value=" + this.includesCondition$value + ", includesOnResults=" + this.includesOnResults + ", _includesOnResults=" + this._includesOnResults + ", includesOnRelations=" + this.includesOnRelations + ", _includesOnRelations=" + this._includesOnRelations + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static AtlanLineageDirection $default$direction() {
        return AtlanLineageDirection.DOWNSTREAM;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Integer $default$pageSize() {
        return 1000;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static FilterList.Condition $default$assetsCondition() {
        return FilterList.Condition.AND;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static FilterList.Condition $default$relationshipsCondition() {
        return FilterList.Condition.AND;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static FilterList.Condition $default$includesCondition() {
        return FilterList.Condition.AND;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    FluentLineage(final AtlanClient client, final String startingGuid, final AtlanLineageDirection direction, final Integer pageSize, final Integer depth, final List<LineageFilter> whereAssets, final FilterList.Condition assetsCondition, final List<LineageFilter> whereRelationships, final FilterList.Condition relationshipsCondition, final List<LineageFilter> includesInResults, final FilterList.Condition includesCondition, final List<AtlanField> includesOnResults, final List<String> _includesOnResults, final List<AtlanField> includesOnRelations, final List<String> _includesOnRelations) {
        this.client = client;
        this.startingGuid = startingGuid;
        this.direction = direction;
        this.pageSize = pageSize;
        this.depth = depth;
        this.whereAssets = whereAssets;
        this.assetsCondition = assetsCondition;
        this.whereRelationships = whereRelationships;
        this.relationshipsCondition = relationshipsCondition;
        this.includesInResults = includesInResults;
        this.includesCondition = includesCondition;
        this.includesOnResults = includesOnResults;
        this._includesOnResults = _includesOnResults;
        this.includesOnRelations = includesOnRelations;
        this._includesOnRelations = _includesOnRelations;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static FluentLineage.FluentLineageBuilder _internal() {
        return new FluentLineage.FluentLineageBuilder();
    }
}
