// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.lineage;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanLineageDirection;
import com.atlan.model.relations.Reference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.*;

@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = LineageListRequest.LineageListRequestBuilderImpl.class)
public class LineageListRequest extends AtlanObject {
    private static final long serialVersionUID = 2L;

    /**
     * Build a lineage list request starting from the provided GUID and using default options.
     * (Searches for up to 1000000 downstream assets with minimal attributes and relationships,
     * paging 10 asset at a time, excluding both assigned terms and Atlan tags.)
     *
     * @param ref an asset reference that contains at least a GUID, from which to start traversing lineage
     * @return the lineage list request starting from that asset (reference)
     */
    public static LineageListRequestBuilder<?, ?> builder(Reference ref) {
        return builder(ref.getGuid());
    }

    /**
     * Build a lineage list request starting from the provided GUID and using default options.
     * (Searches for up to 1000000 downstream assets with minimal attributes and relationships,
     * paging 10 asset at a time, excluding both assigned terms and Atlan tags.)
     *
     * @param guid unique identifier (GUID) from which to start traversing lineage
     * @return the lineage list request starting from that GUID
     */
    public static LineageListRequestBuilder<?, ?> builder(String guid) {
        return _internal().guid(guid);
    }

    /**
     * Unique identifier of the asset for which to retrieve lineage.
     */
    String guid;
    /**
     * Number of degrees of separation (hops) across which lineage should be fetched.
     * A depth of {@code 1} will fetch the immediate upstream and/or downstream assets,
     * while {@code 2} will also fetch the immediate upstream and/or downstream assets
     * of those assets, and so on. A large integer value (for example, 1000000) will
     * therefore in effect fetch <em>all</em> upstream and/or downstream assets.
     * (BEWARE! This could take a long time and result in a very large response payload.)
     */
    Integer depth;
    /**
     * Indicates whether to fetch upstream lineage only, downstream lineage only, or both.
     */
    AtlanLineageDirection direction;
    /**
     * Filters to apply on entities.
     * Note that if the values in the properties of {@code entityFilters} are not valid, then the
     * filter will not be applied and you will receive all values in the response. If your filter
     * seems to be ignored, check that it is valid (if it is invalid it WILL be ignored).
     */
    FilterList entityFilters;
    /**
     * Filters to apply for skipping traversal based on entities.
     * Any sub-graphs beyond the entities filtered out by these filters will not be included in
     * the lineage result.
     */
    FilterList entityTraversalFilters;
    /**
     * Filters to apply for skipping traversal based on relationships.
     * Any sub-graphs beyond the relationships filtered out by these filters will not be included
     * in the lineage result.
     */
    FilterList relationshipTraversalFilters;
    /**
     * List of attributes to be returned for each asset.
     */
    List<String> attributes;
    /**
     * List of attributes to be returned for each asset.
     */
    List<String> relationAttributes;
    /**
     * Starting point for pagination.
     */
    Integer from;
    /**
     * How many results to include in each page of results.
     */
    Integer size;
    /**
     * Whether to include assigned terms for assets (false) or not (true).
     */
    Boolean excludeMeanings;
    /**
     * Whether to include Atlan tags for assets (false) or not (true).
     */
    @JsonProperty("excludeClassifications")
    Boolean excludeAtlanTags;
    /**
     * Whether to include immediate neighbors of the starting asset in the response.
     */
    @JsonProperty("immediateNeighbours")
    Boolean immediateNeighbors;

    /**
     * Fetch the lineage defined by this object.
     *
     * @return the results of the requested lineage
     */
    public LineageListResponse fetch() throws AtlanException {
        return fetch(Atlan.getDefaultClient());
    }

    /**
     * Fetch the lineage defined by this object.
     *
     * @param client connectivity to the Atlan tenant from which to fetch the lineage
     * @return the results of the requested lineage
     */
    public LineageListResponse fetch(AtlanClient client) throws AtlanException {
        if (direction == AtlanLineageDirection.BOTH) {
            throw new InvalidRequestException(ErrorCode.INVALID_LINEAGE_DIRECTION);
        }
        return client.assets.lineage(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Integer $default$depth() {
        return 1000000;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static AtlanLineageDirection $default$direction() {
        return AtlanLineageDirection.DOWNSTREAM;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Integer $default$from() {
        return 0;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Integer $default$size() {
        return 10;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$excludeMeanings() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$excludeAtlanTags() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$immediateNeighbors() {
        return false;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class LineageListRequestBuilder<C extends LineageListRequest, B extends LineageListRequest.LineageListRequestBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String guid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean depth$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer depth$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean direction$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanLineageDirection direction$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private FilterList entityFilters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private FilterList entityTraversalFilters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private FilterList relationshipTraversalFilters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> attributes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> relationAttributes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean from$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer from$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean size$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer size$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean excludeMeanings$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean excludeMeanings$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean excludeAtlanTags$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean excludeAtlanTags$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean immediateNeighbors$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean immediateNeighbors$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            LineageListRequest.LineageListRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final LineageListRequest instance, final LineageListRequest.LineageListRequestBuilder<?, ?> b) {
            b.guid(instance.guid);
            b.depth(instance.depth);
            b.direction(instance.direction);
            b.entityFilters(instance.entityFilters);
            b.entityTraversalFilters(instance.entityTraversalFilters);
            b.relationshipTraversalFilters(instance.relationshipTraversalFilters);
            b.attributes(instance.attributes == null ? java.util.Collections.<String>emptyList() : instance.attributes);
            b.relationAttributes(instance.relationAttributes == null ? java.util.Collections.<String>emptyList() : instance.relationAttributes);
            b.from(instance.from);
            b.size(instance.size);
            b.excludeMeanings(instance.excludeMeanings);
            b.excludeAtlanTags(instance.excludeAtlanTags);
            b.immediateNeighbors(instance.immediateNeighbors);
        }

        /**
         * Unique identifier of the asset for which to retrieve lineage.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B guid(final String guid) {
            this.guid = guid;
            return self();
        }

        /**
         * Number of degrees of separation (hops) across which lineage should be fetched.
         * A depth of {@code 1} will fetch the immediate upstream and/or downstream assets,
         * while {@code 2} will also fetch the immediate upstream and/or downstream assets
         * of those assets, and so on. A large integer value (for example, 1000000) will
         * therefore in effect fetch <em>all</em> upstream and/or downstream assets.
         * (BEWARE! This could take a long time and result in a very large response payload.)
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B depth(final Integer depth) {
            this.depth$value = depth;
            depth$set = true;
            return self();
        }

        /**
         * Indicates whether to fetch upstream lineage only, downstream lineage only, or both.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B direction(final AtlanLineageDirection direction) {
            this.direction$value = direction;
            direction$set = true;
            return self();
        }

        /**
         * Filters to apply on entities.
         * Note that if the values in the properties of {@code entityFilters} are not valid, then the
         * filter will not be applied and you will receive all values in the response. If your filter
         * seems to be ignored, check that it is valid (if it is invalid it WILL be ignored).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entityFilters(final FilterList entityFilters) {
            this.entityFilters = entityFilters;
            return self();
        }

        /**
         * Filters to apply for skipping traversal based on entities.
         * Any sub-graphs beyond the entities filtered out by these filters will not be included in
         * the lineage result.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entityTraversalFilters(final FilterList entityTraversalFilters) {
            this.entityTraversalFilters = entityTraversalFilters;
            return self();
        }

        /**
         * Filters to apply for skipping traversal based on relationships.
         * Any sub-graphs beyond the relationships filtered out by these filters will not be included
         * in the lineage result.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationshipTraversalFilters(final FilterList relationshipTraversalFilters) {
            this.relationshipTraversalFilters = relationshipTraversalFilters;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attribute(final String attribute) {
            if (this.attributes == null) this.attributes = new java.util.ArrayList<String>();
            this.attributes.add(attribute);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attributes(final java.util.Collection<? extends String> attributes) {
            if (attributes == null) {
                throw new java.lang.NullPointerException("attributes cannot be null");
            }
            if (this.attributes == null) this.attributes = new java.util.ArrayList<String>();
            this.attributes.addAll(attributes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAttributes() {
            if (this.attributes != null) this.attributes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationAttribute(final String relationAttribute) {
            if (this.relationAttributes == null) this.relationAttributes = new java.util.ArrayList<String>();
            this.relationAttributes.add(relationAttribute);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationAttributes(final java.util.Collection<? extends String> relationAttributes) {
            if (relationAttributes == null) {
                throw new java.lang.NullPointerException("relationAttributes cannot be null");
            }
            if (this.relationAttributes == null) this.relationAttributes = new java.util.ArrayList<String>();
            this.relationAttributes.addAll(relationAttributes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearRelationAttributes() {
            if (this.relationAttributes != null) this.relationAttributes.clear();
            return self();
        }

        /**
         * Starting point for pagination.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B from(final Integer from) {
            this.from$value = from;
            from$set = true;
            return self();
        }

        /**
         * How many results to include in each page of results.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B size(final Integer size) {
            this.size$value = size;
            size$set = true;
            return self();
        }

        /**
         * Whether to include assigned terms for assets (false) or not (true).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B excludeMeanings(final Boolean excludeMeanings) {
            this.excludeMeanings$value = excludeMeanings;
            excludeMeanings$set = true;
            return self();
        }

        /**
         * Whether to include Atlan tags for assets (false) or not (true).
         * @return {@code this}.
         */
        @JsonProperty("excludeClassifications")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B excludeAtlanTags(final Boolean excludeAtlanTags) {
            this.excludeAtlanTags$value = excludeAtlanTags;
            excludeAtlanTags$set = true;
            return self();
        }

        /**
         * Whether to include immediate neighbors of the starting asset in the response.
         * @return {@code this}.
         */
        @JsonProperty("immediateNeighbours")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B immediateNeighbors(final Boolean immediateNeighbors) {
            this.immediateNeighbors$value = immediateNeighbors;
            immediateNeighbors$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "LineageListRequest.LineageListRequestBuilder(super=" + super.toString() + ", guid=" + this.guid + ", depth$value=" + this.depth$value + ", direction$value=" + this.direction$value + ", entityFilters=" + this.entityFilters + ", entityTraversalFilters=" + this.entityTraversalFilters + ", relationshipTraversalFilters=" + this.relationshipTraversalFilters + ", attributes=" + this.attributes + ", relationAttributes=" + this.relationAttributes + ", from$value=" + this.from$value + ", size$value=" + this.size$value + ", excludeMeanings$value=" + this.excludeMeanings$value + ", excludeAtlanTags$value=" + this.excludeAtlanTags$value + ", immediateNeighbors$value=" + this.immediateNeighbors$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class LineageListRequestBuilderImpl extends LineageListRequest.LineageListRequestBuilder<LineageListRequest, LineageListRequest.LineageListRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private LineageListRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected LineageListRequest.LineageListRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LineageListRequest build() {
            return new LineageListRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected LineageListRequest(final LineageListRequest.LineageListRequestBuilder<?, ?> b) {
        super(b);
        this.guid = b.guid;
        if (b.depth$set) this.depth = b.depth$value;
         else this.depth = LineageListRequest.$default$depth();
        if (b.direction$set) this.direction = b.direction$value;
         else this.direction = LineageListRequest.$default$direction();
        this.entityFilters = b.entityFilters;
        this.entityTraversalFilters = b.entityTraversalFilters;
        this.relationshipTraversalFilters = b.relationshipTraversalFilters;
        java.util.List<String> attributes;
        switch (b.attributes == null ? 0 : b.attributes.size()) {
        case 0: 
            attributes = java.util.Collections.emptyList();
            break;
        case 1: 
            attributes = java.util.Collections.singletonList(b.attributes.get(0));
            break;
        default: 
            attributes = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.attributes));
        }
        this.attributes = attributes;
        java.util.List<String> relationAttributes;
        switch (b.relationAttributes == null ? 0 : b.relationAttributes.size()) {
        case 0: 
            relationAttributes = java.util.Collections.emptyList();
            break;
        case 1: 
            relationAttributes = java.util.Collections.singletonList(b.relationAttributes.get(0));
            break;
        default: 
            relationAttributes = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.relationAttributes));
        }
        this.relationAttributes = relationAttributes;
        if (b.from$set) this.from = b.from$value;
         else this.from = LineageListRequest.$default$from();
        if (b.size$set) this.size = b.size$value;
         else this.size = LineageListRequest.$default$size();
        if (b.excludeMeanings$set) this.excludeMeanings = b.excludeMeanings$value;
         else this.excludeMeanings = LineageListRequest.$default$excludeMeanings();
        if (b.excludeAtlanTags$set) this.excludeAtlanTags = b.excludeAtlanTags$value;
         else this.excludeAtlanTags = LineageListRequest.$default$excludeAtlanTags();
        if (b.immediateNeighbors$set) this.immediateNeighbors = b.immediateNeighbors$value;
         else this.immediateNeighbors = LineageListRequest.$default$immediateNeighbors();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static LineageListRequest.LineageListRequestBuilder<?, ?> _internal() {
        return new LineageListRequest.LineageListRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LineageListRequest.LineageListRequestBuilder<?, ?> toBuilder() {
        return new LineageListRequest.LineageListRequestBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Unique identifier of the asset for which to retrieve lineage.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGuid() {
        return this.guid;
    }

    /**
     * Number of degrees of separation (hops) across which lineage should be fetched.
     * A depth of {@code 1} will fetch the immediate upstream and/or downstream assets,
     * while {@code 2} will also fetch the immediate upstream and/or downstream assets
     * of those assets, and so on. A large integer value (for example, 1000000) will
     * therefore in effect fetch <em>all</em> upstream and/or downstream assets.
     * (BEWARE! This could take a long time and result in a very large response payload.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getDepth() {
        return this.depth;
    }

    /**
     * Indicates whether to fetch upstream lineage only, downstream lineage only, or both.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanLineageDirection getDirection() {
        return this.direction;
    }

    /**
     * Filters to apply on entities.
     * Note that if the values in the properties of {@code entityFilters} are not valid, then the
     * filter will not be applied and you will receive all values in the response. If your filter
     * seems to be ignored, check that it is valid (if it is invalid it WILL be ignored).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public FilterList getEntityFilters() {
        return this.entityFilters;
    }

    /**
     * Filters to apply for skipping traversal based on entities.
     * Any sub-graphs beyond the entities filtered out by these filters will not be included in
     * the lineage result.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public FilterList getEntityTraversalFilters() {
        return this.entityTraversalFilters;
    }

    /**
     * Filters to apply for skipping traversal based on relationships.
     * Any sub-graphs beyond the relationships filtered out by these filters will not be included
     * in the lineage result.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public FilterList getRelationshipTraversalFilters() {
        return this.relationshipTraversalFilters;
    }

    /**
     * List of attributes to be returned for each asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    /**
     * List of attributes to be returned for each asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getRelationAttributes() {
        return this.relationAttributes;
    }

    /**
     * Starting point for pagination.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getFrom() {
        return this.from;
    }

    /**
     * How many results to include in each page of results.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSize() {
        return this.size;
    }

    /**
     * Whether to include assigned terms for assets (false) or not (true).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getExcludeMeanings() {
        return this.excludeMeanings;
    }

    /**
     * Whether to include Atlan tags for assets (false) or not (true).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getExcludeAtlanTags() {
        return this.excludeAtlanTags;
    }

    /**
     * Whether to include immediate neighbors of the starting asset in the response.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getImmediateNeighbors() {
        return this.immediateNeighbors;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LineageListRequest)) return false;
        final LineageListRequest other = (LineageListRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$depth = this.getDepth();
        final java.lang.Object other$depth = other.getDepth();
        if (this$depth == null ? other$depth != null : !this$depth.equals(other$depth)) return false;
        final java.lang.Object this$from = this.getFrom();
        final java.lang.Object other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) return false;
        final java.lang.Object this$size = this.getSize();
        final java.lang.Object other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) return false;
        final java.lang.Object this$excludeMeanings = this.getExcludeMeanings();
        final java.lang.Object other$excludeMeanings = other.getExcludeMeanings();
        if (this$excludeMeanings == null ? other$excludeMeanings != null : !this$excludeMeanings.equals(other$excludeMeanings)) return false;
        final java.lang.Object this$excludeAtlanTags = this.getExcludeAtlanTags();
        final java.lang.Object other$excludeAtlanTags = other.getExcludeAtlanTags();
        if (this$excludeAtlanTags == null ? other$excludeAtlanTags != null : !this$excludeAtlanTags.equals(other$excludeAtlanTags)) return false;
        final java.lang.Object this$immediateNeighbors = this.getImmediateNeighbors();
        final java.lang.Object other$immediateNeighbors = other.getImmediateNeighbors();
        if (this$immediateNeighbors == null ? other$immediateNeighbors != null : !this$immediateNeighbors.equals(other$immediateNeighbors)) return false;
        final java.lang.Object this$guid = this.getGuid();
        final java.lang.Object other$guid = other.getGuid();
        if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) return false;
        final java.lang.Object this$direction = this.getDirection();
        final java.lang.Object other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !this$direction.equals(other$direction)) return false;
        final java.lang.Object this$entityFilters = this.getEntityFilters();
        final java.lang.Object other$entityFilters = other.getEntityFilters();
        if (this$entityFilters == null ? other$entityFilters != null : !this$entityFilters.equals(other$entityFilters)) return false;
        final java.lang.Object this$entityTraversalFilters = this.getEntityTraversalFilters();
        final java.lang.Object other$entityTraversalFilters = other.getEntityTraversalFilters();
        if (this$entityTraversalFilters == null ? other$entityTraversalFilters != null : !this$entityTraversalFilters.equals(other$entityTraversalFilters)) return false;
        final java.lang.Object this$relationshipTraversalFilters = this.getRelationshipTraversalFilters();
        final java.lang.Object other$relationshipTraversalFilters = other.getRelationshipTraversalFilters();
        if (this$relationshipTraversalFilters == null ? other$relationshipTraversalFilters != null : !this$relationshipTraversalFilters.equals(other$relationshipTraversalFilters)) return false;
        final java.lang.Object this$attributes = this.getAttributes();
        final java.lang.Object other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
        final java.lang.Object this$relationAttributes = this.getRelationAttributes();
        final java.lang.Object other$relationAttributes = other.getRelationAttributes();
        if (this$relationAttributes == null ? other$relationAttributes != null : !this$relationAttributes.equals(other$relationAttributes)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LineageListRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $depth = this.getDepth();
        result = result * PRIME + ($depth == null ? 43 : $depth.hashCode());
        final java.lang.Object $from = this.getFrom();
        result = result * PRIME + ($from == null ? 43 : $from.hashCode());
        final java.lang.Object $size = this.getSize();
        result = result * PRIME + ($size == null ? 43 : $size.hashCode());
        final java.lang.Object $excludeMeanings = this.getExcludeMeanings();
        result = result * PRIME + ($excludeMeanings == null ? 43 : $excludeMeanings.hashCode());
        final java.lang.Object $excludeAtlanTags = this.getExcludeAtlanTags();
        result = result * PRIME + ($excludeAtlanTags == null ? 43 : $excludeAtlanTags.hashCode());
        final java.lang.Object $immediateNeighbors = this.getImmediateNeighbors();
        result = result * PRIME + ($immediateNeighbors == null ? 43 : $immediateNeighbors.hashCode());
        final java.lang.Object $guid = this.getGuid();
        result = result * PRIME + ($guid == null ? 43 : $guid.hashCode());
        final java.lang.Object $direction = this.getDirection();
        result = result * PRIME + ($direction == null ? 43 : $direction.hashCode());
        final java.lang.Object $entityFilters = this.getEntityFilters();
        result = result * PRIME + ($entityFilters == null ? 43 : $entityFilters.hashCode());
        final java.lang.Object $entityTraversalFilters = this.getEntityTraversalFilters();
        result = result * PRIME + ($entityTraversalFilters == null ? 43 : $entityTraversalFilters.hashCode());
        final java.lang.Object $relationshipTraversalFilters = this.getRelationshipTraversalFilters();
        result = result * PRIME + ($relationshipTraversalFilters == null ? 43 : $relationshipTraversalFilters.hashCode());
        final java.lang.Object $attributes = this.getAttributes();
        result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
        final java.lang.Object $relationAttributes = this.getRelationAttributes();
        result = result * PRIME + ($relationAttributes == null ? 43 : $relationAttributes.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LineageListRequest(super=" + super.toString() + ", guid=" + this.getGuid() + ", depth=" + this.getDepth() + ", direction=" + this.getDirection() + ", entityFilters=" + this.getEntityFilters() + ", entityTraversalFilters=" + this.getEntityTraversalFilters() + ", relationshipTraversalFilters=" + this.getRelationshipTraversalFilters() + ", attributes=" + this.getAttributes() + ", relationAttributes=" + this.getRelationAttributes() + ", from=" + this.getFrom() + ", size=" + this.getSize() + ", excludeMeanings=" + this.getExcludeMeanings() + ", excludeAtlanTags=" + this.getExcludeAtlanTags() + ", immediateNeighbors=" + this.getImmediateNeighbors() + ")";
    }
}
