// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.lineage;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.*;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.*;

/**
 * Captures the response from a lineage retrieval against Atlan. Also provides the ability to iteratively
 * page through results, without needing to track or re-run the original query using {@link #getNextPage()}.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = LineageListResponse.LineageListResponseBuilder.class)
public class LineageListResponse extends ApiResource implements Iterable<Asset> {
    private static final long serialVersionUID = 2L;
    private static final int CHARACTERISTICS = Spliterator.NONNULL | Spliterator.IMMUTABLE | Spliterator.ORDERED;
    /**
     * Connectivity to the Atlan tenant where the lineage request was run.
     */
    @JsonIgnore
    AtlanClient client;
    /**
     * Entities in the lineage requested.
     */
    @JsonProperty("entities")
    List<Asset> assets;
    /**
     * Whether there are more entities present in lineage that can be traversed (true) or not (false).
     */
    Boolean hasMore;
    /**
     * Total count of entities returned, equal to the size of the {@code entities} list.
     */
    Integer entityCount;
    /**
     * Request used to produce this lineage.
     */
    LineageListRequest searchParameters;

    /**
     * Retrieve the next page of results from this response.
     *
     * @return next page of results from this response
     * @throws AtlanException on any API interaction problem
     */
    @JsonIgnore
    public LineageListResponse getNextPage() throws AtlanException {
        int from = searchParameters.getFrom() == null ? 0 : searchParameters.getFrom();
        int page = searchParameters.getSize() == null ? 10 : searchParameters.getSize();
        LineageListRequest nextRequest = searchParameters.toBuilder().from(from + page).build();
        return nextRequest.fetch(client);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Iterator<Asset> iterator() {
        return new LineageListResponseIterator(this);
    }

    /**
     * Stream the results (lazily) for processing without needing to manually manage paging.
     * @return a lazily-loaded stream of results from the search
     */
    public Stream<Asset> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator(), CHARACTERISTICS), false);
    }


    /**
     * Allow results to be iterated through without managing paging retrievals.
     */
    private static class LineageListResponseIterator implements Iterator<Asset> {
        private LineageListResponse response;
        private int i;

        public LineageListResponseIterator(LineageListResponse response) {
            this.response = response;
            this.i = 0;
        }

        /** {@inheritDoc} */
        @Override
        public boolean hasNext() {
            if (response.getAssets() != null && response.getAssets().size() > i) {
                return true;
            } else if (!response.getHasMore()) {
                return false;
            } else {
                try {
                    response = response.getNextPage();
                    i = 0;
                    return response.getAssets() != null && response.getAssets().size() > i;
                } catch (AtlanException e) {
                    throw new RuntimeException("Unable to iterate through all pages of lineage results.", e);
                }
            }
        }

        /** {@inheritDoc} */
        @Override
        public Asset next() {
            return response.getAssets().get(i++);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    LineageListResponse(final AtlanClient client, final List<Asset> assets, final Boolean hasMore, final Integer entityCount, final LineageListRequest searchParameters) {
        this.client = client;
        this.assets = assets;
        this.hasMore = hasMore;
        this.entityCount = entityCount;
        this.searchParameters = searchParameters;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class LineageListResponseBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanClient client;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<Asset> assets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean hasMore;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer entityCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private LineageListRequest searchParameters;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        LineageListResponseBuilder() {
        }

        /**
         * Connectivity to the Atlan tenant where the lineage request was run.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LineageListResponse.LineageListResponseBuilder client(final AtlanClient client) {
            this.client = client;
            return this;
        }

        /**
         * Entities in the lineage requested.
         * @return {@code this}.
         */
        @JsonProperty("entities")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LineageListResponse.LineageListResponseBuilder assets(final List<Asset> assets) {
            this.assets = assets;
            return this;
        }

        /**
         * Whether there are more entities present in lineage that can be traversed (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LineageListResponse.LineageListResponseBuilder hasMore(final Boolean hasMore) {
            this.hasMore = hasMore;
            return this;
        }

        /**
         * Total count of entities returned, equal to the size of the {@code entities} list.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LineageListResponse.LineageListResponseBuilder entityCount(final Integer entityCount) {
            this.entityCount = entityCount;
            return this;
        }

        /**
         * Request used to produce this lineage.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LineageListResponse.LineageListResponseBuilder searchParameters(final LineageListRequest searchParameters) {
            this.searchParameters = searchParameters;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LineageListResponse build() {
            return new LineageListResponse(this.client, this.assets, this.hasMore, this.entityCount, this.searchParameters);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "LineageListResponse.LineageListResponseBuilder(client=" + this.client + ", assets=" + this.assets + ", hasMore=" + this.hasMore + ", entityCount=" + this.entityCount + ", searchParameters=" + this.searchParameters + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static LineageListResponse.LineageListResponseBuilder builder() {
        return new LineageListResponse.LineageListResponseBuilder();
    }

    /**
     * Connectivity to the Atlan tenant where the lineage request was run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanClient getClient() {
        return this.client;
    }

    /**
     * Entities in the lineage requested.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Asset> getAssets() {
        return this.assets;
    }

    /**
     * Whether there are more entities present in lineage that can be traversed (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getHasMore() {
        return this.hasMore;
    }

    /**
     * Total count of entities returned, equal to the size of the {@code entities} list.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getEntityCount() {
        return this.entityCount;
    }

    /**
     * Request used to produce this lineage.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LineageListRequest getSearchParameters() {
        return this.searchParameters;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LineageListResponse)) return false;
        final LineageListResponse other = (LineageListResponse) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$hasMore = this.getHasMore();
        final java.lang.Object other$hasMore = other.getHasMore();
        if (this$hasMore == null ? other$hasMore != null : !this$hasMore.equals(other$hasMore)) return false;
        final java.lang.Object this$entityCount = this.getEntityCount();
        final java.lang.Object other$entityCount = other.getEntityCount();
        if (this$entityCount == null ? other$entityCount != null : !this$entityCount.equals(other$entityCount)) return false;
        final java.lang.Object this$client = this.getClient();
        final java.lang.Object other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) return false;
        final java.lang.Object this$assets = this.getAssets();
        final java.lang.Object other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !this$assets.equals(other$assets)) return false;
        final java.lang.Object this$searchParameters = this.getSearchParameters();
        final java.lang.Object other$searchParameters = other.getSearchParameters();
        if (this$searchParameters == null ? other$searchParameters != null : !this$searchParameters.equals(other$searchParameters)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LineageListResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $hasMore = this.getHasMore();
        result = result * PRIME + ($hasMore == null ? 43 : $hasMore.hashCode());
        final java.lang.Object $entityCount = this.getEntityCount();
        result = result * PRIME + ($entityCount == null ? 43 : $entityCount.hashCode());
        final java.lang.Object $client = this.getClient();
        result = result * PRIME + ($client == null ? 43 : $client.hashCode());
        final java.lang.Object $assets = this.getAssets();
        result = result * PRIME + ($assets == null ? 43 : $assets.hashCode());
        final java.lang.Object $searchParameters = this.getSearchParameters();
        result = result * PRIME + ($searchParameters == null ? 43 : $searchParameters.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LineageListResponse(super=" + super.toString() + ", client=" + this.getClient() + ", assets=" + this.getAssets() + ", hasMore=" + this.getHasMore() + ", entityCount=" + this.getEntityCount() + ", searchParameters=" + this.getSearchParameters() + ")";
    }

    /**
     * Connectivity to the Atlan tenant where the lineage request was run.
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setClient(final AtlanClient client) {
        this.client = client;
    }
}
