// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.lineage;

import com.atlan.AtlanClient;
import com.atlan.model.core.AtlanObject;
import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;

/**
 * Base class for handling OpenLineage datasets, passing through to the OpenLineage Java SDK
 * but wrapping datasets such that they are handled appropriately in the Atlan Java SDK.
 */
public class OpenLineageDataset extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Internal definition of the OpenLineage dataset.
     */
    OpenLineage.Dataset _dataset;
    /**
     * Producer definition for OpenLineage.
     */
    protected OpenLineage openLineage;
    /**
     * Name of the source where the dataset exists.
     * See: https://github.com/OpenLineage/OpenLineage/blob/main/spec/Naming.md
     */
    private String namespace;
    /**
     * Name of the asset, by OpenLineage standards.
     * For example: DB.SCHEMA.TABLE
     */
    private String assetName;

    /**
     * Builds the minimal object necessary to create an OpenLineage dataset.
     * Note: before you can use the dataset, you will need to wire it as either an input or output
     * using either {@code toInput()} or {@code toOutput()}.
     *
     * @param namespace name of the source of the asset (see: https://github.com/OpenLineage/OpenLineage/blob/main/spec/Naming.md)
     * @param assetName name of the asset, by OpenLineage standard (for example, DB.SCHEMA.TABLE)
     * @param producer a pre-configured OpenLineage producer
     * @return the minimal request necessary to create the dataset, as a builder
     */
    static OpenLineageDatasetBuilder<?, ?> creator(String namespace, String assetName, OpenLineage producer) {
        return _internal().openLineage(producer).namespace(namespace).assetName(assetName);
    }

    // TODO: provide some intuitive way to manage the facets of the dataset
    // TODO: provide some way to manage a schema, i.e. for partial assets
    // NOTE: If we want a structured partial asset, then we need the following lines, too
    //  (not needed for a "full" asset as they'll already be in Atlan)
    /*.dataSource(ol.newDatasourceDatasetFacetBuilder()
        .name("snowflake://qia75894.snowflakecomputing.com")
        .uri(URI.create("snowflake://qia75894.snowflakecomputing.com"))
        .build())
    .schema(ol.newSchemaDatasetFacetBuilder()
        .fields(listOf(
            ol.newSchemaDatasetFacetFieldsBuilder().name("ID").type("VARCHAR").build(),
            ol.newSchemaDatasetFacetFieldsBuilder().name("PARENT_ID").type("VARCHAR").build(),
            ol.newSchemaDatasetFacetFieldsBuilder().name("ORG_WIDE_EMAIL_ADDRESS_ID").type("VARCHAR").build(),
            ol.newSchemaDatasetFacetFieldsBuilder().name("SYSTEM_MODSTAMP").type("TIMESTAMPTZ").build(),
            ol.newSchemaDatasetFacetFieldsBuilder().name("_FIVETRAN_DELETED").type("BOOLEAN").build(),
            ol.newSchemaDatasetFacetFieldsBuilder().name("_FIVETRAN_SYNCED").type("TIMESTAMPTZ").build(),
        ))
        .build())
    .build())*/
    /**
     * {@inheritDoc}
     */
    @Override
    public String toJson(AtlanClient client) {
        return OpenLineageClientUtils.toJson(get_dataset());
    }


    public static abstract class OpenLineageDatasetBuilder<C extends OpenLineageDataset, B extends OpenLineageDataset.OpenLineageDatasetBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineage.Dataset _dataset;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineage openLineage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String namespace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String assetName;

        /**
         * Create an input dataset from this builder.
         *
         * @return the dataset as an input dataset.
         */
        public OpenLineageInputDataset.OpenLineageInputDatasetBuilder<?, ?> toInput() {
            return OpenLineageInputDataset.creator(namespace, assetName, openLineage);
        }

        /**
         * Create an output dataset from this builder.
         *
         * @return the dataset as an output dataset.
         */
        public OpenLineageOutputDataset.OpenLineageOutputDatasetBuilder<?, ?> toOutput() {
            return OpenLineageOutputDataset.creator(namespace, assetName, openLineage);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            OpenLineageDataset.OpenLineageDatasetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final OpenLineageDataset instance, final OpenLineageDataset.OpenLineageDatasetBuilder<?, ?> b) {
            b._dataset(instance._dataset);
            b.openLineage(instance.openLineage);
            b.namespace(instance.namespace);
            b.assetName(instance.assetName);
        }

        /**
         * Internal definition of the OpenLineage dataset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _dataset(final OpenLineage.Dataset _dataset) {
            this._dataset = _dataset;
            return self();
        }

        /**
         * Producer definition for OpenLineage.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B openLineage(final OpenLineage openLineage) {
            this.openLineage = openLineage;
            return self();
        }

        /**
         * Name of the source where the dataset exists.
         * See: https://github.com/OpenLineage/OpenLineage/blob/main/spec/Naming.md
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B namespace(final String namespace) {
            this.namespace = namespace;
            return self();
        }

        /**
         * Name of the asset, by OpenLineage standards.
         * For example: DB.SCHEMA.TABLE
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assetName(final String assetName) {
            this.assetName = assetName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "OpenLineageDataset.OpenLineageDatasetBuilder(super=" + super.toString() + ", _dataset=" + this._dataset + ", openLineage=" + this.openLineage + ", namespace=" + this.namespace + ", assetName=" + this.assetName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class OpenLineageDatasetBuilderImpl extends OpenLineageDataset.OpenLineageDatasetBuilder<OpenLineageDataset, OpenLineageDataset.OpenLineageDatasetBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineageDatasetBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected OpenLineageDataset.OpenLineageDatasetBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OpenLineageDataset build() {
            return new OpenLineageDataset(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected OpenLineageDataset(final OpenLineageDataset.OpenLineageDatasetBuilder<?, ?> b) {
        super(b);
        this._dataset = b._dataset;
        this.openLineage = b.openLineage;
        this.namespace = b.namespace;
        this.assetName = b.assetName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static OpenLineageDataset.OpenLineageDatasetBuilder<?, ?> _internal() {
        return new OpenLineageDataset.OpenLineageDatasetBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OpenLineageDataset.OpenLineageDatasetBuilder<?, ?> toBuilder() {
        return new OpenLineageDataset.OpenLineageDatasetBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OpenLineageDataset)) return false;
        final OpenLineageDataset other = (OpenLineageDataset) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$_dataset = this.get_dataset();
        final java.lang.Object other$_dataset = other.get_dataset();
        if (this$_dataset == null ? other$_dataset != null : !this$_dataset.equals(other$_dataset)) return false;
        final java.lang.Object this$openLineage = this.openLineage;
        final java.lang.Object other$openLineage = other.openLineage;
        if (this$openLineage == null ? other$openLineage != null : !this$openLineage.equals(other$openLineage)) return false;
        final java.lang.Object this$namespace = this.namespace;
        final java.lang.Object other$namespace = other.namespace;
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) return false;
        final java.lang.Object this$assetName = this.assetName;
        final java.lang.Object other$assetName = other.assetName;
        if (this$assetName == null ? other$assetName != null : !this$assetName.equals(other$assetName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OpenLineageDataset;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $_dataset = this.get_dataset();
        result = result * PRIME + ($_dataset == null ? 43 : $_dataset.hashCode());
        final java.lang.Object $openLineage = this.openLineage;
        result = result * PRIME + ($openLineage == null ? 43 : $openLineage.hashCode());
        final java.lang.Object $namespace = this.namespace;
        result = result * PRIME + ($namespace == null ? 43 : $namespace.hashCode());
        final java.lang.Object $assetName = this.assetName;
        result = result * PRIME + ($assetName == null ? 43 : $assetName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "OpenLineageDataset(super=" + super.toString() + ", _dataset=" + this.get_dataset() + ", openLineage=" + this.openLineage + ", namespace=" + this.namespace + ", assetName=" + this.assetName + ")";
    }

    /**
     * Internal definition of the OpenLineage dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    OpenLineage.Dataset get_dataset() {
        return this._dataset;
    }
}
