// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.lineage;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanConnectorType;
import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Atlan wrapper for abstracting OpenLineage events.
 * <br><br>
 * An event is a point-in-time representation of the state of a run.
 * <br><br>
 * You <em>must</em> have at least two states for any run for Atlan to process it for lineage:
 * <ul>
 *     <li>{@code START} to indicate that a run has begun</li>
 *     <li>One of the following to indicate that the run has finished:
 *     <ul>
 *         <li>{@code COMPLETE} to signify that execution of the run has concluded</li>
 *         <li>{@code ABORT} to signify the run has been stopped abnormally</li>
 *         <li>{@code FAIL} to signify the run has failed</li>
 *     </ul></li>
 * </ul>
 * In addition, for lineage to show any inputs and outputs to a process in Atlan, <em>at least one</em>
 * of the events must have {@code inputs} and {@code outputs} defined. It is not necessary to include these
 * on all events; they will be merged from across all events for the same run (by matching on {@code runId}).
 * <br><br>
 * For more details, see <a href="https://openlineage.io/docs/spec/run-cycle">OpenLineage docs</a>.
 */
public class OpenLineageEvent extends AtlanObject {
    private static final long serialVersionUID = 2L;
    private OpenLineage.RunEventBuilder _builder;
    /**
     * Complete details about the OpenLineage run.
     */
    OpenLineageRun run;
    /**
     * Inputs (sources) for the lineage.
     */
    List<OpenLineageInputDataset> inputs;
    /**
     * Outputs (targets) for the lineage.
     */
    List<OpenLineageOutputDataset> outputs;
    /**
     * Internal definition of the OpenLineage event.
     */
    OpenLineage.BaseEvent _event;

    public OpenLineageEvent(OpenLineage.BaseEvent event) {
        this._event = event;
    }

    /**
     * Builds the minimal object necessary to create an OpenLineage event.
     *
     * @param run the OpenLineage run for which to create a new event
     * @return the minimal request necessary to create the event, as a builder
     */
    public static OpenLineageEventBuilder<?, ?> creator(OpenLineageRun run, OpenLineage.RunEvent.EventType type) {
        OpenLineage ol = run.getJob().getOpenLineage();
        OpenLineage.RunEventBuilder b = ol.newRunEventBuilder().eventType(type).eventTime(ZonedDateTime.now(ZoneId.of("UTC"))).run(run.get_run()).job(run.getJob().get_job());
        return _internal().run(run)._builder(b);
    }

    /**
     * Send the OpenLineage event to Atlan to be processed.
     *
     * @throws AtlanException on any API communication issues
     */
    public void emit() throws AtlanException {
        emit(Atlan.getDefaultClient());
    }

    /**
     * Send the OpenLineage event to Atlan to be processed.
     *
     * @param client connectivity to an Atlan tenant
     * @throws AtlanException on any API communication issues
     */
    public void emit(AtlanClient client) throws AtlanException {
        client.openLineage.send(this, AtlanConnectorType.SPARK);
    }

    /**
     * Retrieve the Event in OpenLineage standard form.
     *
     * @return the OpenLineage standard for the Event
     */
    OpenLineage.BaseEvent get_event() {
        if (_event == null) {
            _event = _builder.inputs(inputs.stream().map(OpenLineageInputDataset::get_dataset).collect(Collectors.toList())).outputs(outputs.stream().map(OpenLineageOutputDataset::get_dataset).collect(Collectors.toList())).build();
        }
        return _event;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toJson(AtlanClient client) {
        return OpenLineageClientUtils.toJson(get_event());
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class OpenLineageEventBuilder<C extends OpenLineageEvent, B extends OpenLineageEvent.OpenLineageEventBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineage.RunEventBuilder _builder;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineageRun run;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<OpenLineageInputDataset> inputs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<OpenLineageOutputDataset> outputs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineage.BaseEvent _event;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            OpenLineageEvent.OpenLineageEventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final OpenLineageEvent instance, final OpenLineageEvent.OpenLineageEventBuilder<?, ?> b) {
            b._builder(instance._builder);
            b.run(instance.run);
            b.inputs(instance.inputs == null ? java.util.Collections.<OpenLineageInputDataset>emptyList() : instance.inputs);
            b.outputs(instance.outputs == null ? java.util.Collections.<OpenLineageOutputDataset>emptyList() : instance.outputs);
            b._event(instance._event);
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _builder(final OpenLineage.RunEventBuilder _builder) {
            this._builder = _builder;
            return self();
        }

        /**
         * Complete details about the OpenLineage run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B run(final OpenLineageRun run) {
            this.run = run;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B input(final OpenLineageInputDataset input) {
            if (this.inputs == null) this.inputs = new java.util.ArrayList<OpenLineageInputDataset>();
            this.inputs.add(input);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputs(final java.util.Collection<? extends OpenLineageInputDataset> inputs) {
            if (inputs == null) {
                throw new java.lang.NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) this.inputs = new java.util.ArrayList<OpenLineageInputDataset>();
            this.inputs.addAll(inputs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputs() {
            if (this.inputs != null) this.inputs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B output(final OpenLineageOutputDataset output) {
            if (this.outputs == null) this.outputs = new java.util.ArrayList<OpenLineageOutputDataset>();
            this.outputs.add(output);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputs(final java.util.Collection<? extends OpenLineageOutputDataset> outputs) {
            if (outputs == null) {
                throw new java.lang.NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) this.outputs = new java.util.ArrayList<OpenLineageOutputDataset>();
            this.outputs.addAll(outputs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputs() {
            if (this.outputs != null) this.outputs.clear();
            return self();
        }

        /**
         * Internal definition of the OpenLineage event.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _event(final OpenLineage.BaseEvent _event) {
            this._event = _event;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "OpenLineageEvent.OpenLineageEventBuilder(super=" + super.toString() + ", _builder=" + this._builder + ", run=" + this.run + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", _event=" + this._event + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class OpenLineageEventBuilderImpl extends OpenLineageEvent.OpenLineageEventBuilder<OpenLineageEvent, OpenLineageEvent.OpenLineageEventBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineageEventBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected OpenLineageEvent.OpenLineageEventBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OpenLineageEvent build() {
            return new OpenLineageEvent(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected OpenLineageEvent(final OpenLineageEvent.OpenLineageEventBuilder<?, ?> b) {
        super(b);
        this._builder = b._builder;
        this.run = b.run;
        java.util.List<OpenLineageInputDataset> inputs;
        switch (b.inputs == null ? 0 : b.inputs.size()) {
        case 0: 
            inputs = java.util.Collections.emptyList();
            break;
        case 1: 
            inputs = java.util.Collections.singletonList(b.inputs.get(0));
            break;
        default: 
            inputs = java.util.Collections.unmodifiableList(new java.util.ArrayList<OpenLineageInputDataset>(b.inputs));
        }
        this.inputs = inputs;
        java.util.List<OpenLineageOutputDataset> outputs;
        switch (b.outputs == null ? 0 : b.outputs.size()) {
        case 0: 
            outputs = java.util.Collections.emptyList();
            break;
        case 1: 
            outputs = java.util.Collections.singletonList(b.outputs.get(0));
            break;
        default: 
            outputs = java.util.Collections.unmodifiableList(new java.util.ArrayList<OpenLineageOutputDataset>(b.outputs));
        }
        this.outputs = outputs;
        this._event = b._event;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static OpenLineageEvent.OpenLineageEventBuilder<?, ?> _internal() {
        return new OpenLineageEvent.OpenLineageEventBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OpenLineageEvent.OpenLineageEventBuilder<?, ?> toBuilder() {
        return new OpenLineageEvent.OpenLineageEventBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OpenLineageEvent)) return false;
        final OpenLineageEvent other = (OpenLineageEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$_builder = this._builder;
        final java.lang.Object other$_builder = other._builder;
        if (this$_builder == null ? other$_builder != null : !this$_builder.equals(other$_builder)) return false;
        final java.lang.Object this$run = this.run;
        final java.lang.Object other$run = other.run;
        if (this$run == null ? other$run != null : !this$run.equals(other$run)) return false;
        final java.lang.Object this$inputs = this.inputs;
        final java.lang.Object other$inputs = other.inputs;
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) return false;
        final java.lang.Object this$outputs = this.outputs;
        final java.lang.Object other$outputs = other.outputs;
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) return false;
        final java.lang.Object this$_event = this.get_event();
        final java.lang.Object other$_event = other.get_event();
        if (this$_event == null ? other$_event != null : !this$_event.equals(other$_event)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OpenLineageEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $_builder = this._builder;
        result = result * PRIME + ($_builder == null ? 43 : $_builder.hashCode());
        final java.lang.Object $run = this.run;
        result = result * PRIME + ($run == null ? 43 : $run.hashCode());
        final java.lang.Object $inputs = this.inputs;
        result = result * PRIME + ($inputs == null ? 43 : $inputs.hashCode());
        final java.lang.Object $outputs = this.outputs;
        result = result * PRIME + ($outputs == null ? 43 : $outputs.hashCode());
        final java.lang.Object $_event = this.get_event();
        result = result * PRIME + ($_event == null ? 43 : $_event.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "OpenLineageEvent(super=" + super.toString() + ", _builder=" + this._builder + ", run=" + this.run + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", _event=" + this.get_event() + ")";
    }
}
