// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.lineage;

import io.openlineage.client.OpenLineage;

/**
 * Base class for handling OpenLineage datasets to be used as lineage sources (inputs),
 * passing through to the OpenLineage Java SDK but wrapping datasets such that they are
 * handled appropriately in the Atlan Java SDK.
 */
public class OpenLineageInputDataset extends OpenLineageDataset {
    private static final long serialVersionUID = 2L;
    private OpenLineage.InputDatasetBuilder _builder;

    /**
     * Builds the minimal object necessary to create an OpenLineage dataset use-able as a lineage source.
     *
     * @param namespace name of the source of the asset (see: https://github.com/OpenLineage/OpenLineage/blob/main/spec/Naming.md)
     * @param assetName name of the asset, by OpenLineage standard (for example, DB.SCHEMA.TABLE)
     * @param producer a pre-configured OpenLineage producer
     * @return the minimal request necessary to create the job, as a builder
     */
    static OpenLineageInputDatasetBuilder<?, ?> creator(String namespace, String assetName, OpenLineage producer) {
        return _internal().openLineage(producer)._builder(producer.newInputDatasetBuilder().namespace(namespace).name(assetName).facets(producer.newDatasetFacetsBuilder().build()));
    }

    // TODO: provide some intuitive way to manage the facets of the dataset
    /**
     * Retrieve the InputDataset in OpenLineage standard form.
     *
     * @return the OpenLineage standard for the InputDataset
     */
    @Override
    OpenLineage.InputDataset get_dataset() {
        if (_dataset == null) {
            _dataset = _builder.build();
        }
        return (OpenLineage.InputDataset) this._dataset;
    }

    /**
     * Create a new reference to a field within this input dataset.
     *
     * @param fieldName name of the field within the input dataset to reference
     * @return a reference to the field within this input dataset
     */
    public OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder fromField(String fieldName) {
        return openLineage.newColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder().namespace(get_dataset().getNamespace()).name(get_dataset().getName()).field(fieldName);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class OpenLineageInputDatasetBuilder<C extends OpenLineageInputDataset, B extends OpenLineageInputDataset.OpenLineageInputDatasetBuilder<C, B>> extends OpenLineageDataset.OpenLineageDatasetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineage.InputDatasetBuilder _builder;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            OpenLineageInputDataset.OpenLineageInputDatasetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final OpenLineageInputDataset instance, final OpenLineageInputDataset.OpenLineageInputDatasetBuilder<?, ?> b) {
            b._builder(instance._builder);
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _builder(final OpenLineage.InputDatasetBuilder _builder) {
            this._builder = _builder;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "OpenLineageInputDataset.OpenLineageInputDatasetBuilder(super=" + super.toString() + ", _builder=" + this._builder + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class OpenLineageInputDatasetBuilderImpl extends OpenLineageInputDataset.OpenLineageInputDatasetBuilder<OpenLineageInputDataset, OpenLineageInputDataset.OpenLineageInputDatasetBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineageInputDatasetBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected OpenLineageInputDataset.OpenLineageInputDatasetBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OpenLineageInputDataset build() {
            return new OpenLineageInputDataset(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected OpenLineageInputDataset(final OpenLineageInputDataset.OpenLineageInputDatasetBuilder<?, ?> b) {
        super(b);
        this._builder = b._builder;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static OpenLineageInputDataset.OpenLineageInputDatasetBuilder<?, ?> _internal() {
        return new OpenLineageInputDataset.OpenLineageInputDatasetBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OpenLineageInputDataset.OpenLineageInputDatasetBuilder<?, ?> toBuilder() {
        return new OpenLineageInputDataset.OpenLineageInputDatasetBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OpenLineageInputDataset)) return false;
        final OpenLineageInputDataset other = (OpenLineageInputDataset) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$_builder = this._builder;
        final java.lang.Object other$_builder = other._builder;
        if (this$_builder == null ? other$_builder != null : !this$_builder.equals(other$_builder)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OpenLineageInputDataset;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $_builder = this._builder;
        result = result * PRIME + ($_builder == null ? 43 : $_builder.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "OpenLineageInputDataset(super=" + super.toString() + ", _builder=" + this._builder + ")";
    }
}
