// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.lineage;

import com.atlan.AtlanClient;
import com.atlan.model.core.AtlanObject;
import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import java.net.URI;

/**
 * Atlan wrapper for abstracting OpenLineage jobs.
 * <br><br>
 * A job is a process that consumes or produces datasets.
 * <br><br>
 * This is abstract, and can map to different things in different operational contexts.
 * For example, a job could be a task in a workflow orchestration system. It could also be a model,
 * a query, or a checkpoint. Depending on the system under observation, a Job can represent a small
 * or large amount of work.
 * <br><br>
 * For more details, see <a href="https://openlineage.io/docs/spec/object-model#job">OpenLineage docs</a>.
 */
public class OpenLineageJob extends AtlanObject {
    private static final long serialVersionUID = 2L;
    private OpenLineage.JobBuilder _builder;
    /**
     * Producer definition for OpenLineage.
     */
    OpenLineage openLineage;
    /**
     * Internal definition of the OpenLineage job.
     */
    OpenLineage.Job _job;

    /**
     * Pass-through constructor for an Atlan wrapping of an existing OpenLineage job.
     *
     * @param openLineage definition of the OpenLineage producer
     * @param job an OpenLineage job object that already exists
     */
    public OpenLineageJob(OpenLineage openLineage, OpenLineage.Job job) {
        this.openLineage = openLineage;
        this._job = job;
    }

    /**
     * Builds the minimal object necessary to create an OpenLineage job.
     *
     * @param connectionName name of the Spark connection in which the OpenLineage job should be created
     * @param jobName unique name of the job - if it already exists the existing job will be updated
     * @param producer URI indicating the code or software that implements this job
     * @return the minimal request necessary to create the job, as a builder
     */
    public static OpenLineageJobBuilder<?, ?> creator(String connectionName, String jobName, String producer) {
        OpenLineage ol = new OpenLineage(URI.create(producer));
        return _internal().openLineage(ol)._builder(ol.newJobBuilder().namespace(connectionName).name(jobName).facets(ol.newJobFacetsBuilder().build()));
    }

    // TODO: provide some intuitive way to manage the facets of the job
    /**
     * Builds the minimal object necessary to create an OpenLineage dataset.
     * Note: before you can use the dataset, you will need to wire it as either an input or output
     * using either {@code toInput()} or {@code toOutput()}.
     *
     * @param namespace name of the source of the asset (see: https://github.com/OpenLineage/OpenLineage/blob/main/spec/Naming.md)
     * @param assetName name of the asset, by OpenLineage standard (for example, DB.SCHEMA.TABLE)
     * @return the minimal request necessary to create the dataset, as a builder
     */
    public OpenLineageDataset.OpenLineageDatasetBuilder<?, ?> createDataset(String namespace, String assetName) {
        return OpenLineageDataset.creator(namespace, assetName, openLineage);
    }

    /**
     * Builds the minimal object necessary to create an OpenLineage dataset, wired to use as an input (source)
     * for lineage.
     *
     * @param namespace name of the source of the asset (see: https://github.com/OpenLineage/OpenLineage/blob/main/spec/Naming.md)
     * @param assetName name of the asset, by OpenLineage standard (for example, DB.SCHEMA.TABLE)
     * @return the minimal request necessary to create the dataset, as a builder
     */
    public OpenLineageInputDataset.OpenLineageInputDatasetBuilder<?, ?> createInput(String namespace, String assetName) {
        return OpenLineageInputDataset.creator(namespace, assetName, openLineage);
    }

    /**
     * Builds the minimal object necessary to create an OpenLineage dataset, wired to use as an output (target)
     * for lineage.
     *
     * @param namespace name of the source of the asset (see: https://github.com/OpenLineage/OpenLineage/blob/main/spec/Naming.md)
     * @param assetName name of the asset, by OpenLineage standard (for example, DB.SCHEMA.TABLE)
     * @return the minimal request necessary to create the dataset, as a builder
     */
    public OpenLineageOutputDataset.OpenLineageOutputDatasetBuilder<?, ?> createOutput(String namespace, String assetName) {
        return OpenLineageOutputDataset.creator(namespace, assetName, openLineage);
    }

    /**
     * Retrieve the Job in OpenLineage standard form.
     *
     * @return the OpenLineage standard for the Job
     */
    OpenLineage.Job get_job() {
        if (_job == null) {
            _job = _builder.build();
        }
        return _job;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toJson(AtlanClient client) {
        return OpenLineageClientUtils.toJson(get_job());
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class OpenLineageJobBuilder<C extends OpenLineageJob, B extends OpenLineageJob.OpenLineageJobBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineage.JobBuilder _builder;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineage openLineage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineage.Job _job;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            OpenLineageJob.OpenLineageJobBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final OpenLineageJob instance, final OpenLineageJob.OpenLineageJobBuilder<?, ?> b) {
            b._builder(instance._builder);
            b.openLineage(instance.openLineage);
            b._job(instance._job);
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _builder(final OpenLineage.JobBuilder _builder) {
            this._builder = _builder;
            return self();
        }

        /**
         * Producer definition for OpenLineage.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B openLineage(final OpenLineage openLineage) {
            this.openLineage = openLineage;
            return self();
        }

        /**
         * Internal definition of the OpenLineage job.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _job(final OpenLineage.Job _job) {
            this._job = _job;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "OpenLineageJob.OpenLineageJobBuilder(super=" + super.toString() + ", _builder=" + this._builder + ", openLineage=" + this.openLineage + ", _job=" + this._job + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class OpenLineageJobBuilderImpl extends OpenLineageJob.OpenLineageJobBuilder<OpenLineageJob, OpenLineageJob.OpenLineageJobBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineageJobBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected OpenLineageJob.OpenLineageJobBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OpenLineageJob build() {
            return new OpenLineageJob(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected OpenLineageJob(final OpenLineageJob.OpenLineageJobBuilder<?, ?> b) {
        super(b);
        this._builder = b._builder;
        this.openLineage = b.openLineage;
        this._job = b._job;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static OpenLineageJob.OpenLineageJobBuilder<?, ?> _internal() {
        return new OpenLineageJob.OpenLineageJobBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OpenLineageJob.OpenLineageJobBuilder<?, ?> toBuilder() {
        return new OpenLineageJob.OpenLineageJobBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OpenLineageJob)) return false;
        final OpenLineageJob other = (OpenLineageJob) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$_builder = this._builder;
        final java.lang.Object other$_builder = other._builder;
        if (this$_builder == null ? other$_builder != null : !this$_builder.equals(other$_builder)) return false;
        final java.lang.Object this$openLineage = this.getOpenLineage();
        final java.lang.Object other$openLineage = other.getOpenLineage();
        if (this$openLineage == null ? other$openLineage != null : !this$openLineage.equals(other$openLineage)) return false;
        final java.lang.Object this$_job = this.get_job();
        final java.lang.Object other$_job = other.get_job();
        if (this$_job == null ? other$_job != null : !this$_job.equals(other$_job)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OpenLineageJob;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $_builder = this._builder;
        result = result * PRIME + ($_builder == null ? 43 : $_builder.hashCode());
        final java.lang.Object $openLineage = this.getOpenLineage();
        result = result * PRIME + ($openLineage == null ? 43 : $openLineage.hashCode());
        final java.lang.Object $_job = this.get_job();
        result = result * PRIME + ($_job == null ? 43 : $_job.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "OpenLineageJob(super=" + super.toString() + ", _builder=" + this._builder + ", openLineage=" + this.getOpenLineage() + ", _job=" + this.get_job() + ")";
    }

    /**
     * Producer definition for OpenLineage.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OpenLineage getOpenLineage() {
        return this.openLineage;
    }
}
