// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.lineage;

import io.openlineage.client.OpenLineage;
import java.util.List;
import java.util.Map;

/**
 * Base class for handling OpenLineage datasets to be used as lineage targets (outputs),
 * passing through to the OpenLineage Java SDK but wrapping datasets such that they are
 * handled appropriately in the Atlan Java SDK.
 */
@SuppressWarnings("cast")
public class OpenLineageOutputDataset extends OpenLineageDataset {
    private static final long serialVersionUID = 2L;
    private OpenLineage.OutputDatasetBuilder _builder;
    /**
     * Column-level lineage.
     * Each entry should be keyed by the name of a column in this output dataset, and the value
     * should be a list of all input datasets' fields that are used as input into the output column.
     */
    Map<String, List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields>> toFields;

    /**
     * Builds the minimal object necessary to create an OpenLineage dataset use-able as a lineage target.
     *
     * @param namespace name of the source of the asset (see: https://github.com/OpenLineage/OpenLineage/blob/main/spec/Naming.md)
     * @param assetName name of the asset, by OpenLineage standard (for example, DB.SCHEMA.TABLE)
     * @param producer a pre-configured OpenLineage producer
     * @return the minimal request necessary to create the job, as a builder
     */
    static OpenLineageOutputDatasetBuilder<?, ?> creator(String namespace, String assetName, OpenLineage producer) {
        return _internal().openLineage(producer)._builder(producer.newOutputDatasetBuilder().namespace(namespace).name(assetName).facets(producer.newDatasetFacetsBuilder().build()));
    }

    // TODO: provide some intuitive way to manage the facets of the dataset
    /**
     * Retrieve the OutputDataset in OpenLineage standard form.
     *
     * @return the OpenLineage standard for the OutputDataset
     */
    @Override
    OpenLineage.OutputDataset get_dataset() {
        if (toFields == null || toFields.isEmpty()) {
            return this._builder.build();
        } else {
            OpenLineage.ColumnLineageDatasetFacetFieldsBuilder fieldsBuilder = openLineage.newColumnLineageDatasetFacetFieldsBuilder();
            for (Map.Entry<String, List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields>> entry : toFields.entrySet()) {
                fieldsBuilder.put(entry.getKey(), openLineage.newColumnLineageDatasetFacetFieldsAdditionalBuilder().inputFields(entry.getValue()).build());
            }
            // TODO: below code will clobber any pre-existing facets
            return this._builder.facets(openLineage.newDatasetFacetsBuilder().columnLineage(openLineage.newColumnLineageDatasetFacetBuilder().fields(fieldsBuilder.build()).build()).build()).build();
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class OpenLineageOutputDatasetBuilder<C extends OpenLineageOutputDataset, B extends OpenLineageOutputDataset.OpenLineageOutputDatasetBuilder<C, B>> extends OpenLineageDataset.OpenLineageDatasetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineage.OutputDatasetBuilder _builder;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> toFields$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields>> toFields$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            OpenLineageOutputDataset.OpenLineageOutputDatasetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final OpenLineageOutputDataset instance, final OpenLineageOutputDataset.OpenLineageOutputDatasetBuilder<?, ?> b) {
            b._builder(instance._builder);
            b.toFields(instance.toFields == null ? java.util.Collections.<String, List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields>>emptyMap() : instance.toFields);
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _builder(final OpenLineage.OutputDatasetBuilder _builder) {
            this._builder = _builder;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B toField(final String toFieldKey, final List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields> toFieldValue) {
            if (this.toFields$key == null) {
                this.toFields$key = new java.util.ArrayList<String>();
                this.toFields$value = new java.util.ArrayList<List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields>>();
            }
            this.toFields$key.add(toFieldKey);
            this.toFields$value.add(toFieldValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B toFields(final java.util.Map<? extends String, ? extends List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields>> toFields) {
            if (toFields == null) {
                throw new java.lang.NullPointerException("toFields cannot be null");
            }
            if (this.toFields$key == null) {
                this.toFields$key = new java.util.ArrayList<String>();
                this.toFields$value = new java.util.ArrayList<List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields>>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields>> $lombokEntry : toFields.entrySet()) {
                this.toFields$key.add($lombokEntry.getKey());
                this.toFields$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearToFields() {
            if (this.toFields$key != null) {
                this.toFields$key.clear();
                this.toFields$value.clear();
            }
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "OpenLineageOutputDataset.OpenLineageOutputDatasetBuilder(super=" + super.toString() + ", _builder=" + this._builder + ", toFields$key=" + this.toFields$key + ", toFields$value=" + this.toFields$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class OpenLineageOutputDatasetBuilderImpl extends OpenLineageOutputDataset.OpenLineageOutputDatasetBuilder<OpenLineageOutputDataset, OpenLineageOutputDataset.OpenLineageOutputDatasetBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineageOutputDatasetBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected OpenLineageOutputDataset.OpenLineageOutputDatasetBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OpenLineageOutputDataset build() {
            return new OpenLineageOutputDataset(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected OpenLineageOutputDataset(final OpenLineageOutputDataset.OpenLineageOutputDatasetBuilder<?, ?> b) {
        super(b);
        this._builder = b._builder;
        java.util.Map<String, List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields>> toFields;
        switch (b.toFields$key == null ? 0 : b.toFields$key.size()) {
        case 0: 
            toFields = java.util.Collections.emptyMap();
            break;
        case 1: 
            toFields = java.util.Collections.singletonMap(b.toFields$key.get(0), b.toFields$value.get(0));
            break;
        default: 
            toFields = new java.util.LinkedHashMap<String, List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields>>(b.toFields$key.size() < 1073741824 ? 1 + b.toFields$key.size() + (b.toFields$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.toFields$key.size(); $i++) toFields.put(b.toFields$key.get($i), (List<OpenLineage.ColumnLineageDatasetFacetFieldsAdditionalInputFields>) b.toFields$value.get($i));
            toFields = java.util.Collections.unmodifiableMap(toFields);
        }
        this.toFields = toFields;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static OpenLineageOutputDataset.OpenLineageOutputDatasetBuilder<?, ?> _internal() {
        return new OpenLineageOutputDataset.OpenLineageOutputDatasetBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OpenLineageOutputDataset.OpenLineageOutputDatasetBuilder<?, ?> toBuilder() {
        return new OpenLineageOutputDataset.OpenLineageOutputDatasetBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OpenLineageOutputDataset)) return false;
        final OpenLineageOutputDataset other = (OpenLineageOutputDataset) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$_builder = this._builder;
        final java.lang.Object other$_builder = other._builder;
        if (this$_builder == null ? other$_builder != null : !this$_builder.equals(other$_builder)) return false;
        final java.lang.Object this$toFields = this.toFields;
        final java.lang.Object other$toFields = other.toFields;
        if (this$toFields == null ? other$toFields != null : !this$toFields.equals(other$toFields)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OpenLineageOutputDataset;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $_builder = this._builder;
        result = result * PRIME + ($_builder == null ? 43 : $_builder.hashCode());
        final java.lang.Object $toFields = this.toFields;
        result = result * PRIME + ($toFields == null ? 43 : $toFields.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "OpenLineageOutputDataset(super=" + super.toString() + ", _builder=" + this._builder + ", toFields=" + this.toFields + ")";
    }
}
