// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.lineage;

import com.atlan.AtlanClient;
import com.atlan.model.core.AtlanObject;
import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import java.util.UUID;

/**
 * Atlan wrapper for abstracting OpenLineage runs.
 * <br><br>
 * A run is an instance of a job that represents one of its occurrences in time.
 * <br><br>
 * Each run will have a uniquely identifiable {@code runId} that is generated by the client as a UUID. The client is responsible for maintaining the {@code runId} across different states in the same run.
 * <br><br>
 * For more details, see <a href="https://openlineage.io/docs/spec/object-model#run">OpenLineage docs</a>.
 */
public class OpenLineageRun extends AtlanObject {
    private static final long serialVersionUID = 2L;
    private OpenLineage.RunBuilder _builder;
    /**
     * Complete details about the OpenLineage job.
     */
    OpenLineageJob job;
    /**
     * Internal definition of the OpenLineage run.
     */
    OpenLineage.Run _run;

    /**
     * Pass-through constructor for an Atlan wrapping of an existing OpenLineage run.
     *
     * @param run an OpenLinage run object that already exists
     */
    public OpenLineageRun(OpenLineage.Run run) {
        this._run = run;
    }

    /**
     * Builds the minimal object necessary to create an OpenLineage run.
     *
     * @param job the OpenLineage job for which to create a new run
     * @return the minimal request necessary to create the run, as a builder
     */
    public static OpenLineageRunBuilder<?, ?> creator(OpenLineageJob job) {
        OpenLineage ol = job.getOpenLineage();
        return _internal().job(job)._builder(ol.newRunBuilder().runId(UUID.randomUUID()).facets(ol.newRunFacetsBuilder().build()));
    }

    // TODO: provide some intuitive way to manage the facets of the run
    /**
     * Retrieve the Run in OpenLineage standard form.
     *
     * @return the OpenLineage standard for the Run
     */
    OpenLineage.Run get_run() {
        if (_run == null) {
            _run = _builder.build();
        }
        return _run;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toJson(AtlanClient client) {
        return OpenLineageClientUtils.toJson(get_run());
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class OpenLineageRunBuilder<C extends OpenLineageRun, B extends OpenLineageRun.OpenLineageRunBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineage.RunBuilder _builder;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineageJob job;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineage.Run _run;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            OpenLineageRun.OpenLineageRunBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final OpenLineageRun instance, final OpenLineageRun.OpenLineageRunBuilder<?, ?> b) {
            b._builder(instance._builder);
            b.job(instance.job);
            b._run(instance._run);
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _builder(final OpenLineage.RunBuilder _builder) {
            this._builder = _builder;
            return self();
        }

        /**
         * Complete details about the OpenLineage job.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B job(final OpenLineageJob job) {
            this.job = job;
            return self();
        }

        /**
         * Internal definition of the OpenLineage run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _run(final OpenLineage.Run _run) {
            this._run = _run;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "OpenLineageRun.OpenLineageRunBuilder(super=" + super.toString() + ", _builder=" + this._builder + ", job=" + this.job + ", _run=" + this._run + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class OpenLineageRunBuilderImpl extends OpenLineageRun.OpenLineageRunBuilder<OpenLineageRun, OpenLineageRun.OpenLineageRunBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenLineageRunBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected OpenLineageRun.OpenLineageRunBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public OpenLineageRun build() {
            return new OpenLineageRun(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected OpenLineageRun(final OpenLineageRun.OpenLineageRunBuilder<?, ?> b) {
        super(b);
        this._builder = b._builder;
        this.job = b.job;
        this._run = b._run;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static OpenLineageRun.OpenLineageRunBuilder<?, ?> _internal() {
        return new OpenLineageRun.OpenLineageRunBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OpenLineageRun.OpenLineageRunBuilder<?, ?> toBuilder() {
        return new OpenLineageRun.OpenLineageRunBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OpenLineageRun)) return false;
        final OpenLineageRun other = (OpenLineageRun) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$_builder = this._builder;
        final java.lang.Object other$_builder = other._builder;
        if (this$_builder == null ? other$_builder != null : !this$_builder.equals(other$_builder)) return false;
        final java.lang.Object this$job = this.getJob();
        final java.lang.Object other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) return false;
        final java.lang.Object this$_run = this.get_run();
        final java.lang.Object other$_run = other.get_run();
        if (this$_run == null ? other$_run != null : !this$_run.equals(other$_run)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OpenLineageRun;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $_builder = this._builder;
        result = result * PRIME + ($_builder == null ? 43 : $_builder.hashCode());
        final java.lang.Object $job = this.getJob();
        result = result * PRIME + ($job == null ? 43 : $job.hashCode());
        final java.lang.Object $_run = this.get_run();
        result = result * PRIME + ($_run == null ? 43 : $_run.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "OpenLineageRun(super=" + super.toString() + ", _builder=" + this._builder + ", job=" + this.getJob() + ", _run=" + this.get_run() + ")";
    }

    /**
     * Complete details about the OpenLineage job.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OpenLineageJob getJob() {
        return this.job;
    }
}
