// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.packages;

import com.atlan.model.admin.Credential;
import com.atlan.model.admin.PackageParameter;
import com.atlan.model.workflow.NameValuePair;
import com.atlan.model.workflow.Workflow;
import com.atlan.model.workflow.WorkflowDAG;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowParameters;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.model.workflow.WorkflowTask;
import com.atlan.model.workflow.WorkflowTemplate;
import com.atlan.model.workflow.WorkflowTemplateRef;
import java.util.List;
import java.util.Map;

@SuppressWarnings("cast")
public abstract class AbstractPackage {
    /**
     * Uniquely identifies the type of package.
     */
    protected String _prefix;
    /**
     * Unique name of the package, usually @atlan/something.
     */
    protected String _name;
    /**
     * Unique name for the run of a package.
     */
    protected String _runName;
    /**
     * Labels associated with the package.
     */
    Map<String, String> _labels;
    /**
     * Annotations associated with the package.
     */
    Map<String, String> _annotations;
    /**
     * Parameters associated with the package.
     */
    Map<String, String> _parameters;
    /**
     * Credentials for the package to access its source.
     */
    Credential.CredentialBuilder<?, ?> _credential;

    /**
     * Generate an epoch timestamp for now.
     *
     * @return the string value of the epoch timestamp
     */
    public static String getEpoch() {
        return "" + System.currentTimeMillis() / 1000;
    }

    /**
     * Convert the package into a workflow that can be submitted (run).
     *
     * @return the workflow representing the package
     */
    public Workflow toWorkflow() {
        WorkflowParameters.WorkflowParametersBuilder<?, ?> argsBuilder = WorkflowParameters.builder();
        for (Map.Entry<String, String> entry : _parameters.entrySet()) {
            argsBuilder.parameter(NameValuePair.of(entry.getKey(), entry.getValue()));
        }
        List<PackageParameter> payload;
        if (_credential != null) {
            payload = List.of(PackageParameter.builder().parameter("credentialGuid").type("credential").body(_credential.build().toMap()).build());
        } else {
            payload = List.of();
        }
        return Workflow.builder().metadata(WorkflowMetadata.builder().labels(_labels).annotations(_annotations).name(_runName).namespace("default").build()).spec(WorkflowSpec.builder().templates(List.of(WorkflowTemplate.builder().name("main").dag(WorkflowDAG.builder().task(WorkflowTask.builder().name("run").arguments(argsBuilder.build()).templateRef(WorkflowTemplateRef.builder().name(_prefix).template("main").clusterScope(true).build()).build()).build()).build())).entrypoint("main").workflowMetadata(WorkflowMetadata.builder().annotation("package.argoproj.io/name", _name).build()).build()).payload(payload).build();
    }


    public static abstract class AbstractPackageBuilder<C extends AbstractPackage, B extends AbstractPackageBuilder<C, B>> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String _prefix;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String _name;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String _runName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> _labels$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> _labels$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> _annotations$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> _annotations$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> _parameters$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> _parameters$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Credential.CredentialBuilder<?, ?> _credential;
        /** Unique timestamp for the crawler. */
        protected String epoch;

        /**
         * Set up the crawler with its foundational information.
         *
         * @param prefix the unique prefix that identifies the type of the crawler
         * @param name the unique name of the crawler package
         * @return the builder, with all the common elements of the crawler configured
         */
        B setup(String prefix, String name) {
            this.epoch = getEpoch();
            return this._prefix(prefix)._name(name)._runName(prefix + "-" + epoch).metadata();
        }

        /**
         * Set all the annotations, labels and common parameters specific to the crawler.
         * (This will be called automatically by the 'setup' method.)
         *
         * @return the builder, with all the common metadata configured
         */
        protected abstract B metadata();

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            AbstractPackage.AbstractPackageBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AbstractPackage instance, final AbstractPackage.AbstractPackageBuilder<?, ?> b) {
            b._prefix(instance._prefix);
            b._name(instance._name);
            b._runName(instance._runName);
            b._labels(instance._labels == null ? java.util.Collections.<String, String>emptyMap() : instance._labels);
            b._annotations(instance._annotations == null ? java.util.Collections.<String, String>emptyMap() : instance._annotations);
            b._parameters(instance._parameters == null ? java.util.Collections.<String, String>emptyMap() : instance._parameters);
            b._credential(instance._credential);
        }

        /**
         * Uniquely identifies the type of package.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _prefix(final String _prefix) {
            this._prefix = _prefix;
            return self();
        }

        /**
         * Unique name of the package, usually @atlan/something.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _name(final String _name) {
            this._name = _name;
            return self();
        }

        /**
         * Unique name for the run of a package.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _runName(final String _runName) {
            this._runName = _runName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _label(final String _labelKey, final String _labelValue) {
            if (this._labels$key == null) {
                this._labels$key = new java.util.ArrayList<String>();
                this._labels$value = new java.util.ArrayList<String>();
            }
            this._labels$key.add(_labelKey);
            this._labels$value.add(_labelValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _labels(final java.util.Map<? extends String, ? extends String> _labels) {
            if (_labels == null) {
                throw new java.lang.NullPointerException("_labels cannot be null");
            }
            if (this._labels$key == null) {
                this._labels$key = new java.util.ArrayList<String>();
                this._labels$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : _labels.entrySet()) {
                this._labels$key.add($lombokEntry.getKey());
                this._labels$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clear_labels() {
            if (this._labels$key != null) {
                this._labels$key.clear();
                this._labels$value.clear();
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _annotation(final String _annotationKey, final String _annotationValue) {
            if (this._annotations$key == null) {
                this._annotations$key = new java.util.ArrayList<String>();
                this._annotations$value = new java.util.ArrayList<String>();
            }
            this._annotations$key.add(_annotationKey);
            this._annotations$value.add(_annotationValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _annotations(final java.util.Map<? extends String, ? extends String> _annotations) {
            if (_annotations == null) {
                throw new java.lang.NullPointerException("_annotations cannot be null");
            }
            if (this._annotations$key == null) {
                this._annotations$key = new java.util.ArrayList<String>();
                this._annotations$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : _annotations.entrySet()) {
                this._annotations$key.add($lombokEntry.getKey());
                this._annotations$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clear_annotations() {
            if (this._annotations$key != null) {
                this._annotations$key.clear();
                this._annotations$value.clear();
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _parameter(final String _parameterKey, final String _parameterValue) {
            if (this._parameters$key == null) {
                this._parameters$key = new java.util.ArrayList<String>();
                this._parameters$value = new java.util.ArrayList<String>();
            }
            this._parameters$key.add(_parameterKey);
            this._parameters$value.add(_parameterValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _parameters(final java.util.Map<? extends String, ? extends String> _parameters) {
            if (_parameters == null) {
                throw new java.lang.NullPointerException("_parameters cannot be null");
            }
            if (this._parameters$key == null) {
                this._parameters$key = new java.util.ArrayList<String>();
                this._parameters$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : _parameters.entrySet()) {
                this._parameters$key.add($lombokEntry.getKey());
                this._parameters$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clear_parameters() {
            if (this._parameters$key != null) {
                this._parameters$key.clear();
                this._parameters$value.clear();
            }
            return self();
        }

        /**
         * Credentials for the package to access its source.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _credential(final Credential.CredentialBuilder<?, ?> _credential) {
            this._credential = _credential;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AbstractPackage.AbstractPackageBuilder(_prefix=" + this._prefix + ", _name=" + this._name + ", _runName=" + this._runName + ", _labels$key=" + this._labels$key + ", _labels$value=" + this._labels$value + ", _annotations$key=" + this._annotations$key + ", _annotations$value=" + this._annotations$value + ", _parameters$key=" + this._parameters$key + ", _parameters$value=" + this._parameters$value + ", _credential=" + this._credential + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AbstractPackage(final AbstractPackage.AbstractPackageBuilder<?, ?> b) {
        this._prefix = b._prefix;
        this._name = b._name;
        this._runName = b._runName;
        java.util.Map<String, String> _labels;
        switch (b._labels$key == null ? 0 : b._labels$key.size()) {
        case 0: 
            _labels = java.util.Collections.emptyMap();
            break;
        case 1: 
            _labels = java.util.Collections.singletonMap(b._labels$key.get(0), b._labels$value.get(0));
            break;
        default: 
            _labels = new java.util.LinkedHashMap<String, String>(b._labels$key.size() < 1073741824 ? 1 + b._labels$key.size() + (b._labels$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b._labels$key.size(); $i++) _labels.put(b._labels$key.get($i), (String) b._labels$value.get($i));
            _labels = java.util.Collections.unmodifiableMap(_labels);
        }
        this._labels = _labels;
        java.util.Map<String, String> _annotations;
        switch (b._annotations$key == null ? 0 : b._annotations$key.size()) {
        case 0: 
            _annotations = java.util.Collections.emptyMap();
            break;
        case 1: 
            _annotations = java.util.Collections.singletonMap(b._annotations$key.get(0), b._annotations$value.get(0));
            break;
        default: 
            _annotations = new java.util.LinkedHashMap<String, String>(b._annotations$key.size() < 1073741824 ? 1 + b._annotations$key.size() + (b._annotations$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b._annotations$key.size(); $i++) _annotations.put(b._annotations$key.get($i), (String) b._annotations$value.get($i));
            _annotations = java.util.Collections.unmodifiableMap(_annotations);
        }
        this._annotations = _annotations;
        java.util.Map<String, String> _parameters;
        switch (b._parameters$key == null ? 0 : b._parameters$key.size()) {
        case 0: 
            _parameters = java.util.Collections.emptyMap();
            break;
        case 1: 
            _parameters = java.util.Collections.singletonMap(b._parameters$key.get(0), b._parameters$value.get(0));
            break;
        default: 
            _parameters = new java.util.LinkedHashMap<String, String>(b._parameters$key.size() < 1073741824 ? 1 + b._parameters$key.size() + (b._parameters$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b._parameters$key.size(); $i++) _parameters.put(b._parameters$key.get($i), (String) b._parameters$value.get($i));
            _parameters = java.util.Collections.unmodifiableMap(_parameters);
        }
        this._parameters = _parameters;
        this._credential = b._credential;
    }

    /**
     * Uniquely identifies the type of package.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String get_prefix() {
        return this._prefix;
    }

    /**
     * Unique name of the package, usually @atlan/something.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String get_name() {
        return this._name;
    }

    /**
     * Unique name for the run of a package.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String get_runName() {
        return this._runName;
    }

    /**
     * Labels associated with the package.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> get_labels() {
        return this._labels;
    }

    /**
     * Annotations associated with the package.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> get_annotations() {
        return this._annotations;
    }

    /**
     * Parameters associated with the package.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> get_parameters() {
        return this._parameters;
    }

    /**
     * Credentials for the package to access its source.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Credential.CredentialBuilder<?, ?> get_credential() {
        return this._credential;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AbstractPackage)) return false;
        final AbstractPackage other = (AbstractPackage) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$_prefix = this.get_prefix();
        final java.lang.Object other$_prefix = other.get_prefix();
        if (this$_prefix == null ? other$_prefix != null : !this$_prefix.equals(other$_prefix)) return false;
        final java.lang.Object this$_name = this.get_name();
        final java.lang.Object other$_name = other.get_name();
        if (this$_name == null ? other$_name != null : !this$_name.equals(other$_name)) return false;
        final java.lang.Object this$_runName = this.get_runName();
        final java.lang.Object other$_runName = other.get_runName();
        if (this$_runName == null ? other$_runName != null : !this$_runName.equals(other$_runName)) return false;
        final java.lang.Object this$_labels = this.get_labels();
        final java.lang.Object other$_labels = other.get_labels();
        if (this$_labels == null ? other$_labels != null : !this$_labels.equals(other$_labels)) return false;
        final java.lang.Object this$_annotations = this.get_annotations();
        final java.lang.Object other$_annotations = other.get_annotations();
        if (this$_annotations == null ? other$_annotations != null : !this$_annotations.equals(other$_annotations)) return false;
        final java.lang.Object this$_parameters = this.get_parameters();
        final java.lang.Object other$_parameters = other.get_parameters();
        if (this$_parameters == null ? other$_parameters != null : !this$_parameters.equals(other$_parameters)) return false;
        final java.lang.Object this$_credential = this.get_credential();
        final java.lang.Object other$_credential = other.get_credential();
        if (this$_credential == null ? other$_credential != null : !this$_credential.equals(other$_credential)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AbstractPackage;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $_prefix = this.get_prefix();
        result = result * PRIME + ($_prefix == null ? 43 : $_prefix.hashCode());
        final java.lang.Object $_name = this.get_name();
        result = result * PRIME + ($_name == null ? 43 : $_name.hashCode());
        final java.lang.Object $_runName = this.get_runName();
        result = result * PRIME + ($_runName == null ? 43 : $_runName.hashCode());
        final java.lang.Object $_labels = this.get_labels();
        result = result * PRIME + ($_labels == null ? 43 : $_labels.hashCode());
        final java.lang.Object $_annotations = this.get_annotations();
        result = result * PRIME + ($_annotations == null ? 43 : $_annotations.hashCode());
        final java.lang.Object $_parameters = this.get_parameters();
        result = result * PRIME + ($_parameters == null ? 43 : $_parameters.hashCode());
        final java.lang.Object $_credential = this.get_credential();
        result = result * PRIME + ($_credential == null ? 43 : $_credential.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AbstractPackage(super=" + super.toString() + ", _prefix=" + this.get_prefix() + ", _name=" + this.get_name() + ", _runName=" + this.get_runName() + ", _labels=" + this.get_labels() + ", _annotations=" + this.get_annotations() + ", _parameters=" + this.get_parameters() + ", _credential=" + this.get_credential() + ")";
    }
}
