// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;

public class SigmaCrawler extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.SIGMA.getValue();

    /**
     * Create the base configuration for a new Sigma crawler. Sets all admins as connection admins.
     *
     * @param client connectivity to an Atlan tenant
     * @param connectionName name of the connection to create when running the crawler for the first time
     * @return the builder for the base configuration of a Sigma crawler
     * @throws AtlanException if there is not at least one connection admin specified, or any specified are invalid
     */
    public static SigmaCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null);
    }

    /**
     * Create the base configuration for a new Sigma crawler.
     *
     * @param client connectivity to an Atlan tenant
     * @param connectionName name of the connection to create when running the crawler for the first time
     * @param adminRoles unique identifiers (GUIDs) of roles who will be connection admins on the connection
     * @param adminGroups internal names of groups who will be connection admins on the connection
     * @param adminUsers usernames of users who will be connection admins on the connection
     * @return the builder for the base configuration of a Sigma crawler
     * @throws AtlanException if there is not at least one connection admin specified, or any specified are invalid
     */
    public static SigmaCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws AtlanException {
        return _internal().setup(PREFIX, "@atlan/sigma", client, getConnection(client, connectionName, AtlanConnectorType.SIGMA, adminRoles, adminGroups, adminUsers, false, false, 0L, "http://assets.atlan.com/assets/sigma.svg")).include(null).exclude(null);
    }


    public static abstract class SigmaCrawlerBuilder<C extends SigmaCrawler, B extends SigmaCrawlerBuilder<C, B>> extends AbstractCrawlerBuilder<C, B> {
        /**
         * Set up the crawler to directly extract from Sigma.
         *
         * @param hostname of the Sigma host, for example aws-api.sigmacomputing.com
         * @return the builder, set up to extract directly from Sigma
         */
        public B direct(String hostname) {
            localCreds.name("default-sigma-" + epoch + "-0").host(hostname).port(443).connectorConfigName("atlan-connectors-sigma");
            return this._credential(localCreds);
        }

        /**
         * Set up the crawler to use API token-based authentication.
         *
         * @param clientId through which to access Sigma
         * @param apiToken through which to access Sigma
         * @return the builder, set up to use API token-based authentication
         */
        public B apiToken(String clientId, String apiToken) {
            localCreds.authType("api_token").username(clientId).password(apiToken);
            return this._credential(localCreds);
        }

        /**
         * Defines the filter for assets to include when crawling.
         *
         * @param workbooks the GUIDs of workbooks to include when crawling
         * @return the builder, set to include only those workbooks specified
         * @throws InvalidRequestException in the unlikely event the provided filter cannot be translated
         */
        public B include(List<String> workbooks) throws InvalidRequestException {
            Map<String, Map<String, String>> toInclude = buildFlatFilter(workbooks);
            try {
                return this._parameter("include-filter", Serde.allInclusiveMapper.writeValueAsString(toInclude));
            } catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, e);
            }
        }

        /**
         * Defines the filter for assets to exclude when crawling.
         *
         * @param workbooks the GUIDs of workbooks to exclude when crawling
         * @return the builder, set to exclude only those workbooks specified
         * @throws InvalidRequestException in the unlikely event the provided filter cannot be translated
         */
        public B exclude(List<String> workbooks) throws InvalidRequestException {
            Map<String, Map<String, String>> toExclude = buildFlatFilter(workbooks);
            try {
                return this._parameter("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(toExclude));
            } catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, e);
            }
        }

        /**
         * Set all the metadata for the package (labels, annotations, etc).
         *
         * @return the builder, with metadata set
         */
        @Override
        protected B metadata() {
            return this._label("orchestration.atlan.com/certified", "true")._label("orchestration.atlan.com/source", "sigma")._label("orchestration.atlan.com/sourceCategory", "bi")._label("orchestration.atlan.com/type", "connector")._label("orchestration.atlan.com/verified", "true")._label("package.argoproj.io/installer", "argopm")._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hsigma")._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com")._label("orchestration.atlan.com/default-sigma-" + epoch, "true")._label("orchestration.atlan.com/atlan-ui", "true")._annotation("orchestration.atlan.com/allowSchedule", "true")._annotation("orchestration.atlan.com/categories", "sigma,crawler")._annotation("orchestration.atlan.com/dependentPackage", "")._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/8731744918813")._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80")._annotation("orchestration.atlan.com/icon", "http://assets.atlan.com/assets/sigma.svg")._annotation("orchestration.atlan.com/logo", "http://assets.atlan.com/assets/sigma.svg")._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/sigma")._annotation("orchestration.atlan.com/name", "Sigma Assets")._annotation("package.argoproj.io/author", "Atlan")._annotation("package.argoproj.io/description", "Package to crawl Sigma assets and publish to Atlan for discovery")._annotation("package.argoproj.io/homepage", "https://github.com/atlanhq/marketplace-packages#readme")._annotation("package.argoproj.io/keywords", "[\"sigma\",\"bi\",\"connector\",\"crawler\"]")._annotation("package.argoproj.io/name", "@atlan/sigma")._annotation("package.argoproj.io/registry", "https://packages.atlan.com")._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git")._annotation("package.argoproj.io/support", "support@atlan.com")._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-sigma-" + epoch)._parameters(Map.ofEntries(Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("connection", connection.toJson(client)), Map.entry("atlas-auth-type", "internal"), Map.entry("publish-mode", "production")));
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SigmaCrawler.SigmaCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SigmaCrawler instance, final SigmaCrawler.SigmaCrawlerBuilder<?, ?> b) {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SigmaCrawler.SigmaCrawlerBuilder(super=" + super.toString() + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SigmaCrawlerBuilderImpl extends SigmaCrawler.SigmaCrawlerBuilder<SigmaCrawler, SigmaCrawler.SigmaCrawlerBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SigmaCrawlerBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SigmaCrawler.SigmaCrawlerBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SigmaCrawler build() {
            return new SigmaCrawler(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SigmaCrawler(final SigmaCrawler.SigmaCrawlerBuilder<?, ?> b) {
        super(b);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SigmaCrawler.SigmaCrawlerBuilder<?, ?> _internal() {
        return new SigmaCrawler.SigmaCrawlerBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SigmaCrawler.SigmaCrawlerBuilder<?, ?> toBuilder() {
        return new SigmaCrawler.SigmaCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SigmaCrawler)) return false;
        final SigmaCrawler other = (SigmaCrawler) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SigmaCrawler;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int result = super.hashCode();
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SigmaCrawler(super=" + super.toString() + ")";
    }
}
