// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.relations;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * Instance of a relationship's attributes where we cannot determine (have not yet modeled) its detailed information.
 * In the meanwhile, this provides a catch-all case where at least the basic relationship information is available.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = IndistinctRelationship.IndistinctRelationshipBuilderImpl.class)
public class IndistinctRelationship extends RelationshipAttributes {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "IndistinctRelationship";
    /**
     * Create a non-transient typeName to ensure it is included in serde.
     */
    String typeName;

    /**
     * {@inheritDoc}
     */
    @Override
    public Map<String, Object> getAll() {
        Map<String, Object> map = new HashMap<>();
        JsonNode node = getRawJsonObject();
        JsonNode attributes = node.get("attributes");
        if (attributes != null && !attributes.isNull()) {
            Iterator<String> itr = attributes.fieldNames();
            while (itr.hasNext()) {
                String relnKey = itr.next();
                map.put(relnKey, attributes.get(relnKey));
            }
        }
        return map;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class IndistinctRelationshipBuilder<C extends IndistinctRelationship, B extends IndistinctRelationship.IndistinctRelationshipBuilder<C, B>> extends RelationshipAttributes.RelationshipAttributesBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            IndistinctRelationship.IndistinctRelationshipBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final IndistinctRelationship instance, final IndistinctRelationship.IndistinctRelationshipBuilder<?, ?> b) {
            b.typeName(instance.typeName);
        }

        /**
         * Create a non-transient typeName to ensure it is included in serde.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "IndistinctRelationship.IndistinctRelationshipBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class IndistinctRelationshipBuilderImpl extends IndistinctRelationship.IndistinctRelationshipBuilder<IndistinctRelationship, IndistinctRelationship.IndistinctRelationshipBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IndistinctRelationshipBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected IndistinctRelationship.IndistinctRelationshipBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IndistinctRelationship build() {
            return new IndistinctRelationship(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected IndistinctRelationship(final IndistinctRelationship.IndistinctRelationshipBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = IndistinctRelationship.$default$typeName();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static IndistinctRelationship.IndistinctRelationshipBuilder<?, ?> _internal() {
        return new IndistinctRelationship.IndistinctRelationshipBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IndistinctRelationship.IndistinctRelationshipBuilder<?, ?> toBuilder() {
        return new IndistinctRelationship.IndistinctRelationshipBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof IndistinctRelationship)) return false;
        final IndistinctRelationship other = (IndistinctRelationship) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof IndistinctRelationship;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "IndistinctRelationship(super=" + super.toString() + ", typeName=" + this.getTypeName() + ")";
    }

    /**
     * Create a non-transient typeName to ensure it is included in serde.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
