// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.relations;

import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.search.AuditDetail;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.*;

@SuppressWarnings("cast")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = Reference.ReferenceBuilderImpl.class)
public class Reference extends AtlanObject implements Comparable<Reference>, AuditDetail {
    private static final long serialVersionUID = 2L;
    // Sort references in a set based first on their relationshipGuid (if any),
    // then by their guid (if any), then by their qualifiedName (if any),
    // and finally by their awsArn — at least one of these must exist if this
    // is any kind of valid reference. (And there cannot be duplicate combinations
    // of these properties to be a valid set of references: they would be duplicate
    // references.)
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<UniqueAttributes> uniqueAttrsComparator = Comparator.comparing(UniqueAttributes::getQualifiedName, stringComparator).thenComparing(UniqueAttributes::getAwsArn, stringComparator);
    private static final Comparator<Reference> referenceComparator = Comparator.comparing(Reference::getRelationshipGuid, stringComparator).thenComparing(Reference::getGuid, stringComparator).thenComparing(Reference::getUniqueAttributes, Comparator.nullsFirst(uniqueAttrsComparator));


    public enum SaveSemantic {
        REPLACE, APPEND, REMOVE;
    }

    /**
     * Quickly create a new reference to another asset, by its GUID.
     *
     * @param typeName type of the asset to reference
     * @param guid GUID of the asset to reference
     * @return a reference to another asset
     */
    public static Reference to(String typeName, String guid) {
        return Reference.builder().typeName(typeName).guid(guid).build();
    }

    /**
     * Quickly create a new reference to another asset, by its qualifiedName.
     *
     * @param typeName type of the asset to reference
     * @param qualifiedName of the asset to reference
     * @return a reference to another asset
     */
    public static Reference by(String typeName, String qualifiedName) {
        return Reference.builder().typeName(typeName).uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).build();
    }

    /**
     * Validate that the required parameters are present to carry out an operation.
     *
     * @param typeName type of asset being validated
     * @param parameters mapping of required parameters, keyed by parameter name with the value of that parameter
     * @throws InvalidRequestException if any of the parameters have a null or empty value
     */
    protected static void validateRequired(String typeName, Map<String, String> parameters) throws InvalidRequestException {
        validate(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, typeName, parameters);
    }

    /**
     * Validate that the required parameters are present to set up a relationship.
     *
     * @param typeName type of asset to which the relationship is being created
     * @param parameters mapping of required parameters, keyed by parameter name with the value of that parameter
     * @throws InvalidRequestException if any of the parameters have a null or empty value
     */
    protected static void validateRelationship(String typeName, Map<String, String> parameters) throws InvalidRequestException {
        validate(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, typeName, parameters);
    }

    private static void validate(ErrorCode code, String typeName, Map<String, String> parameters) throws InvalidRequestException {
        if (parameters != null && !parameters.isEmpty()) {
            List<String> missing = new ArrayList<>();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) {
                    missing.add(entry.getKey());
                }
            }
            if (!missing.isEmpty()) {
                throw new InvalidRequestException(code, typeName, String.join(",", missing));
            }
        }
    }

    /**
     * Semantic for how this relationship should be saved, if used in an asset request on which .save() is called.
     */
    @JsonIgnore
    transient SaveSemantic semantic;
    /**
     * Internal tracking of whether this represents a complete view of an object, or not.
     */
    @JsonIgnore
    transient boolean completeObject;

    /**
     * When true, indicates that this object represents a complete view of the entity.
     * When false, this object is only a reference or some partial view of the entity.
     */
    @JsonIgnore
    public boolean isComplete() {
        return completeObject;
    }

    /**
     * Sets the internal tracking of this object to indicate it is a complete representation of an entity.
     */
    @JsonIgnore
    protected void setCompleteObject() {
        this.completeObject = true;
    }

    /**
     * Indicates whether this object can be used as a valid reference by GUID.
     *
     * @return true if it is a valid GUID reference, false otherwise
     */
    @JsonIgnore
    public boolean isValidReferenceByGuid() {
        // Careful: because typeName is overridden (for default setting) in
        // derived classes, we must use the getter here and not the member directly
        return getTypeName() != null && !getTypeName().isEmpty() && getGuid() != null && !getGuid().isEmpty();
    }

    /**
     * Indicates whether this object can be used as a valid reference by qualifiedName.
     *
     * @return true if it is a valid qualifiedName reference, false otherwise
     */
    @JsonIgnore
    public boolean isValidReferenceByQualifiedName() {
        // Careful: because typeName is overridden (for default setting) in
        // derived classes, we must use the getter here and not the member directly
        return getTypeName() != null && !getTypeName().isEmpty() && getUniqueAttributes() != null && getUniqueAttributes().getQualifiedName() != null && !getUniqueAttributes().getQualifiedName().isEmpty();
    }

    /**
     * Indicates whether this object can be used as a reference (relationship).
     *
     * @return true if it is a valid reference, false otherwise
     */
    @JsonIgnore
    public boolean isValidReference() {
        return isValidReferenceByGuid() || isValidReferenceByQualifiedName();
    }

    /**
     * Name of the type that defines the entity.
     */
    String typeName;
    /**
     * Globally-unique identifier for the entity.
     */
    String guid;
    /**
     * Human-readable name of the entity.
     */
    String displayText;
    /**
     * Status of the entity (if this is a related entity).
     */
    String entityStatus;
    /**
     * Type of the relationship (if this is a related entity).
     */
    String relationshipType;
    /**
     * Unique identifier of the relationship (when this is a related entity).
     */
    String relationshipGuid;
    /**
     * Status of the relationship (when this is a related entity).
     */
    AtlanStatus relationshipStatus;
    /**
     * Attributes specific to the relationship.
     */
    RelationshipAttributes relationshipAttributes;
    /**
     * Attribute(s) that uniquely identify the entity (when this is a related entity).
     * If the guid is not provided, these must be provided.
     */
    UniqueAttributes uniqueAttributes;
    /**
     * Arbitrary textual labels for the asset.
     */
    List<String> labels;
    /**
     * Attribute(s) that handle custom information direct from source systems. Not to be
     * confused with custom metadata attributes, which are user-defined and user-managed, and
     * are instead found in {@code customMetadataSets}.
     */
    Map<String, String> customAttributes;

    /**
     * {@inheritDoc}
     */
    @Override
    public int compareTo(Reference o) {
        return referenceComparator.compare(this, o);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static SaveSemantic $default$semantic() {
        return SaveSemantic.REPLACE;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static boolean $default$completeObject() {
        return false;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class ReferenceBuilder<C extends Reference, B extends Reference.ReferenceBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean semantic$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SaveSemantic semantic$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean completeObject$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean completeObject$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String guid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String displayText;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String entityStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String relationshipType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String relationshipGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanStatus relationshipStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private RelationshipAttributes relationshipAttributes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private UniqueAttributes uniqueAttributes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> labels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> customAttributes$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> customAttributes$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Reference.ReferenceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Reference instance, final Reference.ReferenceBuilder<?, ?> b) {
            b.semantic(instance.semantic);
            b.completeObject(instance.completeObject);
            b.typeName(instance.typeName);
            b.guid(instance.guid);
            b.displayText(instance.displayText);
            b.entityStatus(instance.entityStatus);
            b.relationshipType(instance.relationshipType);
            b.relationshipGuid(instance.relationshipGuid);
            b.relationshipStatus(instance.relationshipStatus);
            b.relationshipAttributes(instance.relationshipAttributes);
            b.uniqueAttributes(instance.uniqueAttributes);
            b.labels(instance.labels == null ? java.util.Collections.<String>emptyList() : instance.labels);
            b.customAttributes(instance.customAttributes == null ? java.util.Collections.<String, String>emptyMap() : instance.customAttributes);
        }

        /**
         * Semantic for how this relationship should be saved, if used in an asset request on which .save() is called.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B semantic(final SaveSemantic semantic) {
            this.semantic$value = semantic;
            semantic$set = true;
            return self();
        }

        /**
         * Internal tracking of whether this represents a complete view of an object, or not.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B completeObject(final boolean completeObject) {
            this.completeObject$value = completeObject;
            completeObject$set = true;
            return self();
        }

        /**
         * Name of the type that defines the entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName = typeName;
            return self();
        }

        /**
         * Globally-unique identifier for the entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B guid(final String guid) {
            this.guid = guid;
            return self();
        }

        /**
         * Human-readable name of the entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B displayText(final String displayText) {
            this.displayText = displayText;
            return self();
        }

        /**
         * Status of the entity (if this is a related entity).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entityStatus(final String entityStatus) {
            this.entityStatus = entityStatus;
            return self();
        }

        /**
         * Type of the relationship (if this is a related entity).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationshipType(final String relationshipType) {
            this.relationshipType = relationshipType;
            return self();
        }

        /**
         * Unique identifier of the relationship (when this is a related entity).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationshipGuid(final String relationshipGuid) {
            this.relationshipGuid = relationshipGuid;
            return self();
        }

        /**
         * Status of the relationship (when this is a related entity).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationshipStatus(final AtlanStatus relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return self();
        }

        /**
         * Attributes specific to the relationship.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationshipAttributes(final RelationshipAttributes relationshipAttributes) {
            this.relationshipAttributes = relationshipAttributes;
            return self();
        }

        /**
         * Attribute(s) that uniquely identify the entity (when this is a related entity).
         * If the guid is not provided, these must be provided.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B uniqueAttributes(final UniqueAttributes uniqueAttributes) {
            this.uniqueAttributes = uniqueAttributes;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B label(final String label) {
            if (this.labels == null) this.labels = new java.util.ArrayList<String>();
            this.labels.add(label);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B labels(final java.util.Collection<? extends String> labels) {
            if (labels == null) {
                throw new java.lang.NullPointerException("labels cannot be null");
            }
            if (this.labels == null) this.labels = new java.util.ArrayList<String>();
            this.labels.addAll(labels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearLabels() {
            if (this.labels != null) this.labels.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B customAttribute(final String customAttributeKey, final String customAttributeValue) {
            if (this.customAttributes$key == null) {
                this.customAttributes$key = new java.util.ArrayList<String>();
                this.customAttributes$value = new java.util.ArrayList<String>();
            }
            this.customAttributes$key.add(customAttributeKey);
            this.customAttributes$value.add(customAttributeValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B customAttributes(final java.util.Map<? extends String, ? extends String> customAttributes) {
            if (customAttributes == null) {
                throw new java.lang.NullPointerException("customAttributes cannot be null");
            }
            if (this.customAttributes$key == null) {
                this.customAttributes$key = new java.util.ArrayList<String>();
                this.customAttributes$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : customAttributes.entrySet()) {
                this.customAttributes$key.add($lombokEntry.getKey());
                this.customAttributes$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCustomAttributes() {
            if (this.customAttributes$key != null) {
                this.customAttributes$key.clear();
                this.customAttributes$value.clear();
            }
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Reference.ReferenceBuilder(super=" + super.toString() + ", semantic$value=" + this.semantic$value + ", completeObject$value=" + this.completeObject$value + ", typeName=" + this.typeName + ", guid=" + this.guid + ", displayText=" + this.displayText + ", entityStatus=" + this.entityStatus + ", relationshipType=" + this.relationshipType + ", relationshipGuid=" + this.relationshipGuid + ", relationshipStatus=" + this.relationshipStatus + ", relationshipAttributes=" + this.relationshipAttributes + ", uniqueAttributes=" + this.uniqueAttributes + ", labels=" + this.labels + ", customAttributes$key=" + this.customAttributes$key + ", customAttributes$value=" + this.customAttributes$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class ReferenceBuilderImpl extends Reference.ReferenceBuilder<Reference, Reference.ReferenceBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ReferenceBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Reference.ReferenceBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Reference build() {
            return new Reference(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Reference(final Reference.ReferenceBuilder<?, ?> b) {
        super(b);
        if (b.semantic$set) this.semantic = b.semantic$value;
         else this.semantic = Reference.$default$semantic();
        if (b.completeObject$set) this.completeObject = b.completeObject$value;
         else this.completeObject = Reference.$default$completeObject();
        this.typeName = b.typeName;
        this.guid = b.guid;
        this.displayText = b.displayText;
        this.entityStatus = b.entityStatus;
        this.relationshipType = b.relationshipType;
        this.relationshipGuid = b.relationshipGuid;
        this.relationshipStatus = b.relationshipStatus;
        this.relationshipAttributes = b.relationshipAttributes;
        this.uniqueAttributes = b.uniqueAttributes;
        java.util.List<String> labels;
        switch (b.labels == null ? 0 : b.labels.size()) {
        case 0: 
            labels = java.util.Collections.emptyList();
            break;
        case 1: 
            labels = java.util.Collections.singletonList(b.labels.get(0));
            break;
        default: 
            labels = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.labels));
        }
        this.labels = labels;
        java.util.Map<String, String> customAttributes;
        switch (b.customAttributes$key == null ? 0 : b.customAttributes$key.size()) {
        case 0: 
            customAttributes = java.util.Collections.emptyMap();
            break;
        case 1: 
            customAttributes = java.util.Collections.singletonMap(b.customAttributes$key.get(0), b.customAttributes$value.get(0));
            break;
        default: 
            customAttributes = new java.util.LinkedHashMap<String, String>(b.customAttributes$key.size() < 1073741824 ? 1 + b.customAttributes$key.size() + (b.customAttributes$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.customAttributes$key.size(); $i++) customAttributes.put(b.customAttributes$key.get($i), (String) b.customAttributes$value.get($i));
            customAttributes = java.util.Collections.unmodifiableMap(customAttributes);
        }
        this.customAttributes = customAttributes;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Reference.ReferenceBuilder<?, ?> builder() {
        return new Reference.ReferenceBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Reference.ReferenceBuilder<?, ?> toBuilder() {
        return new Reference.ReferenceBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Semantic for how this relationship should be saved, if used in an asset request on which .save() is called.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SaveSemantic getSemantic() {
        return this.semantic;
    }

    /**
     * Internal tracking of whether this represents a complete view of an object, or not.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean getCompleteObject() {
        return this.completeObject;
    }

    /**
     * Name of the type that defines the entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }

    /**
     * Globally-unique identifier for the entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGuid() {
        return this.guid;
    }

    /**
     * Human-readable name of the entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisplayText() {
        return this.displayText;
    }

    /**
     * Status of the entity (if this is a related entity).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEntityStatus() {
        return this.entityStatus;
    }

    /**
     * Type of the relationship (if this is a related entity).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRelationshipType() {
        return this.relationshipType;
    }

    /**
     * Unique identifier of the relationship (when this is a related entity).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRelationshipGuid() {
        return this.relationshipGuid;
    }

    /**
     * Status of the relationship (when this is a related entity).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanStatus getRelationshipStatus() {
        return this.relationshipStatus;
    }

    /**
     * Attributes specific to the relationship.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RelationshipAttributes getRelationshipAttributes() {
        return this.relationshipAttributes;
    }

    /**
     * Attribute(s) that uniquely identify the entity (when this is a related entity).
     * If the guid is not provided, these must be provided.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UniqueAttributes getUniqueAttributes() {
        return this.uniqueAttributes;
    }

    /**
     * Arbitrary textual labels for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getLabels() {
        return this.labels;
    }

    /**
     * Attribute(s) that handle custom information direct from source systems. Not to be
     * confused with custom metadata attributes, which are user-defined and user-managed, and
     * are instead found in {@code customMetadataSets}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Reference)) return false;
        final Reference other = (Reference) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$guid = this.getGuid();
        final java.lang.Object other$guid = other.getGuid();
        if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) return false;
        final java.lang.Object this$displayText = this.getDisplayText();
        final java.lang.Object other$displayText = other.getDisplayText();
        if (this$displayText == null ? other$displayText != null : !this$displayText.equals(other$displayText)) return false;
        final java.lang.Object this$entityStatus = this.getEntityStatus();
        final java.lang.Object other$entityStatus = other.getEntityStatus();
        if (this$entityStatus == null ? other$entityStatus != null : !this$entityStatus.equals(other$entityStatus)) return false;
        final java.lang.Object this$relationshipType = this.getRelationshipType();
        final java.lang.Object other$relationshipType = other.getRelationshipType();
        if (this$relationshipType == null ? other$relationshipType != null : !this$relationshipType.equals(other$relationshipType)) return false;
        final java.lang.Object this$relationshipGuid = this.getRelationshipGuid();
        final java.lang.Object other$relationshipGuid = other.getRelationshipGuid();
        if (this$relationshipGuid == null ? other$relationshipGuid != null : !this$relationshipGuid.equals(other$relationshipGuid)) return false;
        final java.lang.Object this$relationshipStatus = this.getRelationshipStatus();
        final java.lang.Object other$relationshipStatus = other.getRelationshipStatus();
        if (this$relationshipStatus == null ? other$relationshipStatus != null : !this$relationshipStatus.equals(other$relationshipStatus)) return false;
        final java.lang.Object this$relationshipAttributes = this.getRelationshipAttributes();
        final java.lang.Object other$relationshipAttributes = other.getRelationshipAttributes();
        if (this$relationshipAttributes == null ? other$relationshipAttributes != null : !this$relationshipAttributes.equals(other$relationshipAttributes)) return false;
        final java.lang.Object this$uniqueAttributes = this.getUniqueAttributes();
        final java.lang.Object other$uniqueAttributes = other.getUniqueAttributes();
        if (this$uniqueAttributes == null ? other$uniqueAttributes != null : !this$uniqueAttributes.equals(other$uniqueAttributes)) return false;
        final java.lang.Object this$labels = this.getLabels();
        final java.lang.Object other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !this$labels.equals(other$labels)) return false;
        final java.lang.Object this$customAttributes = this.getCustomAttributes();
        final java.lang.Object other$customAttributes = other.getCustomAttributes();
        if (this$customAttributes == null ? other$customAttributes != null : !this$customAttributes.equals(other$customAttributes)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Reference;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $guid = this.getGuid();
        result = result * PRIME + ($guid == null ? 43 : $guid.hashCode());
        final java.lang.Object $displayText = this.getDisplayText();
        result = result * PRIME + ($displayText == null ? 43 : $displayText.hashCode());
        final java.lang.Object $entityStatus = this.getEntityStatus();
        result = result * PRIME + ($entityStatus == null ? 43 : $entityStatus.hashCode());
        final java.lang.Object $relationshipType = this.getRelationshipType();
        result = result * PRIME + ($relationshipType == null ? 43 : $relationshipType.hashCode());
        final java.lang.Object $relationshipGuid = this.getRelationshipGuid();
        result = result * PRIME + ($relationshipGuid == null ? 43 : $relationshipGuid.hashCode());
        final java.lang.Object $relationshipStatus = this.getRelationshipStatus();
        result = result * PRIME + ($relationshipStatus == null ? 43 : $relationshipStatus.hashCode());
        final java.lang.Object $relationshipAttributes = this.getRelationshipAttributes();
        result = result * PRIME + ($relationshipAttributes == null ? 43 : $relationshipAttributes.hashCode());
        final java.lang.Object $uniqueAttributes = this.getUniqueAttributes();
        result = result * PRIME + ($uniqueAttributes == null ? 43 : $uniqueAttributes.hashCode());
        final java.lang.Object $labels = this.getLabels();
        result = result * PRIME + ($labels == null ? 43 : $labels.hashCode());
        final java.lang.Object $customAttributes = this.getCustomAttributes();
        result = result * PRIME + ($customAttributes == null ? 43 : $customAttributes.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Reference(super=" + super.toString() + ", semantic=" + this.getSemantic() + ", completeObject=" + this.getCompleteObject() + ", typeName=" + this.getTypeName() + ", guid=" + this.getGuid() + ", displayText=" + this.getDisplayText() + ", entityStatus=" + this.getEntityStatus() + ", relationshipType=" + this.getRelationshipType() + ", relationshipGuid=" + this.getRelationshipGuid() + ", relationshipStatus=" + this.getRelationshipStatus() + ", relationshipAttributes=" + this.getRelationshipAttributes() + ", uniqueAttributes=" + this.getUniqueAttributes() + ", labels=" + this.getLabels() + ", customAttributes=" + this.getCustomAttributes() + ")";
    }
}
