// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.search;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.fields.CustomMetadataField;
import com.atlan.model.fields.ISearchable;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Captures the results of a single bucket within an aggregation.
 */
public class AggregationBucketDetails extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Key of the field representing this bucket of aggregate results, as a string.
     * For example, when the key is a date (numeric) this will be something like "2015-01-01".
     */
    @JsonProperty("key_as_string")
    String keyAsString;
    /**
     * Key of the field representing this bucket of aggregate results.
     * This could be a string, a number (in the case of dates), or an array
     * (in the case of multi-term aggregations).
     */
    Object key;
    /**
     * Number of results that fit within this bucket of the aggregation.
     */
    @JsonProperty("doc_count")
    Long docCount;
    /**
     * TBC
     */
    @JsonProperty("max_matching_length")
    Long maxMatchingLength;
    /**
     * End of a range (date, geo, IP, etc), as a number or string.
     */
    Object to;
    /**
     * End of a range, as a string.
     */
    @JsonProperty("to_as_string")
    String toAsString;
    /**
     * Start of a range (date, geo, IP, etc), as a number or string.
     */
    Object from;
    /**
     * Start of a range, as a string.
     */
    @JsonProperty("from_as_string")
    String fromAsString;
    /**
     * Nested aggregation results.
     */
    @JsonAnyGetter
    @JsonAnySetter
    Map<String, AggregationResult> nestedResults;

    /**
     * Return the source value of the specified field for this bucket.
     *
     * @param field field in Atlan for which to retrieve the value
     * @return the value of the field in Atlan that is represented within this bucket, if any
     */
    @JsonIgnore
    public Object getSourceValue(AtlanField field) {
        if (nestedResults != null && nestedResults.containsKey(ISearchable.EMBEDDED_SOURCE_VALUE)) {
            AggregationResult embedded = nestedResults.get(ISearchable.EMBEDDED_SOURCE_VALUE);
            if (embedded instanceof AggregationHitsResult) {
                AggregationHitsResult result = (AggregationHitsResult) embedded;
                if (result.getHits() != null && result.getHits().getHits() != null && !result.getHits().getHits().isEmpty()) {
                    AggregationHitsResult.Details details = result.getHits().getHits().get(0);
                    if (details != null && details.getSource() != null) {
                        if (field instanceof CustomMetadataField) {
                            // Need to handle the hashed-string ID stuff for custom metadata fields
                            return details.getSource().getOrDefault(((CustomMetadataField) field).getSearchableFieldName(), null);
                        } else {
                            return details.getSource().getOrDefault(field.getAtlanFieldName(), null);
                        }
                    }
                }
            }
        }
        return null;
    }

    /**
     * Key of the field representing this bucket of aggregate results, as a string.
     * For example, when the key is a date (numeric) this will be something like "2015-01-01".
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getKeyAsString() {
        return this.keyAsString;
    }

    /**
     * Key of the field representing this bucket of aggregate results.
     * This could be a string, a number (in the case of dates), or an array
     * (in the case of multi-term aggregations).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getKey() {
        return this.key;
    }

    /**
     * Number of results that fit within this bucket of the aggregation.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDocCount() {
        return this.docCount;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMaxMatchingLength() {
        return this.maxMatchingLength;
    }

    /**
     * End of a range (date, geo, IP, etc), as a number or string.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getTo() {
        return this.to;
    }

    /**
     * End of a range, as a string.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getToAsString() {
        return this.toAsString;
    }

    /**
     * Start of a range (date, geo, IP, etc), as a number or string.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getFrom() {
        return this.from;
    }

    /**
     * Start of a range, as a string.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFromAsString() {
        return this.fromAsString;
    }

    /**
     * Nested aggregation results.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, AggregationResult> getNestedResults() {
        return this.nestedResults;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AggregationBucketDetails)) return false;
        final AggregationBucketDetails other = (AggregationBucketDetails) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$docCount = this.getDocCount();
        final java.lang.Object other$docCount = other.getDocCount();
        if (this$docCount == null ? other$docCount != null : !this$docCount.equals(other$docCount)) return false;
        final java.lang.Object this$maxMatchingLength = this.getMaxMatchingLength();
        final java.lang.Object other$maxMatchingLength = other.getMaxMatchingLength();
        if (this$maxMatchingLength == null ? other$maxMatchingLength != null : !this$maxMatchingLength.equals(other$maxMatchingLength)) return false;
        final java.lang.Object this$keyAsString = this.getKeyAsString();
        final java.lang.Object other$keyAsString = other.getKeyAsString();
        if (this$keyAsString == null ? other$keyAsString != null : !this$keyAsString.equals(other$keyAsString)) return false;
        final java.lang.Object this$key = this.getKey();
        final java.lang.Object other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) return false;
        final java.lang.Object this$to = this.getTo();
        final java.lang.Object other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) return false;
        final java.lang.Object this$toAsString = this.getToAsString();
        final java.lang.Object other$toAsString = other.getToAsString();
        if (this$toAsString == null ? other$toAsString != null : !this$toAsString.equals(other$toAsString)) return false;
        final java.lang.Object this$from = this.getFrom();
        final java.lang.Object other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) return false;
        final java.lang.Object this$fromAsString = this.getFromAsString();
        final java.lang.Object other$fromAsString = other.getFromAsString();
        if (this$fromAsString == null ? other$fromAsString != null : !this$fromAsString.equals(other$fromAsString)) return false;
        final java.lang.Object this$nestedResults = this.getNestedResults();
        final java.lang.Object other$nestedResults = other.getNestedResults();
        if (this$nestedResults == null ? other$nestedResults != null : !this$nestedResults.equals(other$nestedResults)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AggregationBucketDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $docCount = this.getDocCount();
        result = result * PRIME + ($docCount == null ? 43 : $docCount.hashCode());
        final java.lang.Object $maxMatchingLength = this.getMaxMatchingLength();
        result = result * PRIME + ($maxMatchingLength == null ? 43 : $maxMatchingLength.hashCode());
        final java.lang.Object $keyAsString = this.getKeyAsString();
        result = result * PRIME + ($keyAsString == null ? 43 : $keyAsString.hashCode());
        final java.lang.Object $key = this.getKey();
        result = result * PRIME + ($key == null ? 43 : $key.hashCode());
        final java.lang.Object $to = this.getTo();
        result = result * PRIME + ($to == null ? 43 : $to.hashCode());
        final java.lang.Object $toAsString = this.getToAsString();
        result = result * PRIME + ($toAsString == null ? 43 : $toAsString.hashCode());
        final java.lang.Object $from = this.getFrom();
        result = result * PRIME + ($from == null ? 43 : $from.hashCode());
        final java.lang.Object $fromAsString = this.getFromAsString();
        result = result * PRIME + ($fromAsString == null ? 43 : $fromAsString.hashCode());
        final java.lang.Object $nestedResults = this.getNestedResults();
        result = result * PRIME + ($nestedResults == null ? 43 : $nestedResults.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AggregationBucketDetails(super=" + super.toString() + ", keyAsString=" + this.getKeyAsString() + ", key=" + this.getKey() + ", docCount=" + this.getDocCount() + ", maxMatchingLength=" + this.getMaxMatchingLength() + ", to=" + this.getTo() + ", toAsString=" + this.getToAsString() + ", from=" + this.getFrom() + ", fromAsString=" + this.getFromAsString() + ", nestedResults=" + this.getNestedResults() + ")";
    }
}
