// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.fields.AtlanField;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Search abstraction mechanism, to simplify the most common searches against Atlan's
 * audit log (removing the need to understand the guts of Elastic).
 */
@SuppressWarnings("cast")
public class AuditSearch extends CompoundQuery {
    /**
     * Build an audit search against the provided Atlan tenant.
     *
     * @param client connectivity to an Atlan tenant
     * @return the start of an audit search against the tenant
     */
    public static AuditSearchBuilder<?, ?> builder(AtlanClient client) {
        return _internal().client(client);
    }

    /**
     * Criteria by which to sort the results.
     */
    List<SortOptions> sorts;
    /**
     * Aggregations to run against the results of the search.
     * You provide any key you want to the map (you'll use it to look at the results of a specific aggregation).
     */
    Map<String, Aggregation> aggregations;
    /**
     * Number of results to retrieve per underlying API request.
     */
    Integer pageSize;
    /**
     * Attributes to retrieve for the entity detail in each audit log entry.
     */
    List<AtlanField> includesOnResults;
    /**
     * Attributes to retrieve for the entity detail in each audit log entry (for internal use, unchecked!).
     */
    List<String> _includesOnResults;

    /**
     * Translate the Atlan audit search into an Atlan audit search request.
     *
     * @return an Atlan audit search request that encapsulates the audit search
     */
    public AuditSearchRequest toRequest() {
        return _requestBuilder().build();
    }

    /**
     * Return the total number of audit entries that will match the supplied criteria,
     * using the most minimal query possible (retrieves minimal data).
     *
     * @return the count of audit entries that will match the supplied criteria
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public long count() throws AtlanException {
        if (client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        // As long as there is a client, build the search request for just a single result (with count)
        // and then just return the count
        AuditSearchRequest request = AuditSearchRequest.builder().dsl(_dsl().size(1).clearAggregations().build()).build();
        return request.search(client).getTotalCount();
    }

    /**
     * Run the audit search to retrieve audit entries that match the supplied criteria.
     *
     * @return a stream of audit entries that match the specified criteria, lazily-fetched
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public Stream<EntityAudit> stream() throws AtlanException {
        return stream(false);
    }

    /**
     * Run the audit search to retrieve audit entries that match the supplied criteria.
     *
     * @param parallel if true, returns a parallel stream
     * @return a stream of audit entries that match the specified criteria, lazily-fetched
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public Stream<EntityAudit> stream(boolean parallel) throws AtlanException {
        if (client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        if (parallel) {
            return toRequest().search(client).parallelStream();
        } else {
            return toRequest().search(client).stream();
        }
    }

    /**
     * Run the audit search to retrieve audit entries that match the supplied criteria, using a
     * parallel stream (multiple pages are retrieved in parallel for improved throughput).
     *
     * @return a stream of audit entries that match the specified criteria, lazily-fetched
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public Stream<EntityAudit> parallelStream() throws AtlanException {
        return stream(true);
    }

    /**
     * Translate the Atlan audit search into an Atlan search DSL builder.
     *
     * @return an Atlan search DSL builder that encapsulates the audit search
     */
    protected IndexSearchDSL.IndexSearchDSLBuilder<?, ?> _dsl() {
        return IndexSearchDSL.builder(toQuery());
    }

    /**
     * Translate the Atlan audit search into an Atlan audit search request builder.
     *
     * @return an Atlan audit search request builder that encapsulates the audit search
     */
    protected AuditSearchRequest.AuditSearchRequestBuilder<?, ?> _requestBuilder() {
        IndexSearchDSL.IndexSearchDSLBuilder<?, ?> dsl = _dsl();
        if (pageSize != null) {
            dsl.size(pageSize);
        }
        if (sorts != null) {
            dsl.sort(sorts);
        }
        if (aggregations != null) {
            dsl.aggregations(aggregations);
        }
        AuditSearchRequest.AuditSearchRequestBuilder<?, ?> request = AuditSearchRequest.builder().dsl(dsl.build());
        if (_includesOnResults != null) {
            request.attributes(_includesOnResults);
        }
        if (includesOnResults != null) {
            request.attributes(includesOnResults.stream().map(AtlanField::getAtlanFieldName).collect(Collectors.toList()));
        }
        return request;
    }


    public static abstract class AuditSearchBuilder<C extends AuditSearch, B extends AuditSearchBuilder<C, B>> extends CompoundQueryBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<SortOptions> sorts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> aggregations$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Aggregation> aggregations$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer pageSize;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AtlanField> includesOnResults;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> _includesOnResults;

        /**
         * Translate the Atlan audit search into an Atlan audit search request builder.
         *
         * @return an Atlan audit search request builder that encapsulates the audit search
         */
        public AuditSearchRequest.AuditSearchRequestBuilder<?, ?> toRequestBuilder() {
            return build()._requestBuilder();
        }

        /**
         * Translate the Atlan audit search into an Atlan audit search request.
         *
         * @return an Atlan audit search request that encapsulates the audit search
         */
        public AuditSearchRequest toRequest() {
            return build().toRequest();
        }

        /**
         * Return the total number of audit entries that will match the supplied criteria,
         * using the most minimal query possible (retrieves minimal data).
         *
         * @return the count of audit entries that will match the supplied criteria
         * @throws AtlanException on any issues interacting with the Atlan APIs
         */
        public long count() throws AtlanException {
            return build().count();
        }

        /**
         * Run the audit search to retrieve audit log entries that match the supplied criteria.
         *
         * @return a stream of audit log entries that match the specified criteria, lazily-fetched
         * @throws AtlanException on any issues interacting with the Atlan APIs
         */
        public Stream<EntityAudit> stream() throws AtlanException {
            return build().stream();
        }

        /**
         * Run the audit search to retrieve audit log entries that match the supplied criteria.
         *
         * @param parallel if true, returns a parallel stream
         * @return a stream of audit log entries that match the specified criteria, lazily-fetched
         * @throws AtlanException on any issues interacting with the Atlan APIs
         */
        public Stream<EntityAudit> stream(boolean parallel) throws AtlanException {
            return build().stream(parallel);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sort(final SortOptions sort) {
            if (this.sorts == null) this.sorts = new java.util.ArrayList<SortOptions>();
            this.sorts.add(sort);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sorts(final java.util.Collection<? extends SortOptions> sorts) {
            if (sorts == null) {
                throw new java.lang.NullPointerException("sorts cannot be null");
            }
            if (this.sorts == null) this.sorts = new java.util.ArrayList<SortOptions>();
            this.sorts.addAll(sorts);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSorts() {
            if (this.sorts != null) this.sorts.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B aggregate(final String aggregateKey, final Aggregation aggregateValue) {
            if (this.aggregations$key == null) {
                this.aggregations$key = new java.util.ArrayList<String>();
                this.aggregations$value = new java.util.ArrayList<Aggregation>();
            }
            this.aggregations$key.add(aggregateKey);
            this.aggregations$value.add(aggregateValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B aggregations(final java.util.Map<? extends String, ? extends Aggregation> aggregations) {
            if (aggregations == null) {
                throw new java.lang.NullPointerException("aggregations cannot be null");
            }
            if (this.aggregations$key == null) {
                this.aggregations$key = new java.util.ArrayList<String>();
                this.aggregations$value = new java.util.ArrayList<Aggregation>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Aggregation> $lombokEntry : aggregations.entrySet()) {
                this.aggregations$key.add($lombokEntry.getKey());
                this.aggregations$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAggregations() {
            if (this.aggregations$key != null) {
                this.aggregations$key.clear();
                this.aggregations$value.clear();
            }
            return self();
        }

        /**
         * Number of results to retrieve per underlying API request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B pageSize(final Integer pageSize) {
            this.pageSize = pageSize;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B includeOnResults(final AtlanField includeOnResults) {
            if (this.includesOnResults == null) this.includesOnResults = new java.util.ArrayList<AtlanField>();
            this.includesOnResults.add(includeOnResults);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B includesOnResults(final java.util.Collection<? extends AtlanField> includesOnResults) {
            if (includesOnResults == null) {
                throw new java.lang.NullPointerException("includesOnResults cannot be null");
            }
            if (this.includesOnResults == null) this.includesOnResults = new java.util.ArrayList<AtlanField>();
            this.includesOnResults.addAll(includesOnResults);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearIncludesOnResults() {
            if (this.includesOnResults != null) this.includesOnResults.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _includeOnResults(final String _includeOnResults) {
            if (this._includesOnResults == null) this._includesOnResults = new java.util.ArrayList<String>();
            this._includesOnResults.add(_includeOnResults);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _includesOnResults(final java.util.Collection<? extends String> _includesOnResults) {
            if (_includesOnResults == null) {
                throw new java.lang.NullPointerException("_includesOnResults cannot be null");
            }
            if (this._includesOnResults == null) this._includesOnResults = new java.util.ArrayList<String>();
            this._includesOnResults.addAll(_includesOnResults);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clear_includesOnResults() {
            if (this._includesOnResults != null) this._includesOnResults.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AuditSearch.AuditSearchBuilder(super=" + super.toString() + ", sorts=" + this.sorts + ", aggregations$key=" + this.aggregations$key + ", aggregations$value=" + this.aggregations$value + ", pageSize=" + this.pageSize + ", includesOnResults=" + this.includesOnResults + ", _includesOnResults=" + this._includesOnResults + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AuditSearchBuilderImpl extends AuditSearch.AuditSearchBuilder<AuditSearch, AuditSearch.AuditSearchBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AuditSearchBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AuditSearch.AuditSearchBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuditSearch build() {
            return new AuditSearch(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AuditSearch(final AuditSearch.AuditSearchBuilder<?, ?> b) {
        super(b);
        java.util.List<SortOptions> sorts;
        switch (b.sorts == null ? 0 : b.sorts.size()) {
        case 0: 
            sorts = java.util.Collections.emptyList();
            break;
        case 1: 
            sorts = java.util.Collections.singletonList(b.sorts.get(0));
            break;
        default: 
            sorts = java.util.Collections.unmodifiableList(new java.util.ArrayList<SortOptions>(b.sorts));
        }
        this.sorts = sorts;
        java.util.Map<String, Aggregation> aggregations;
        switch (b.aggregations$key == null ? 0 : b.aggregations$key.size()) {
        case 0: 
            aggregations = java.util.Collections.emptyMap();
            break;
        case 1: 
            aggregations = java.util.Collections.singletonMap(b.aggregations$key.get(0), b.aggregations$value.get(0));
            break;
        default: 
            aggregations = new java.util.LinkedHashMap<String, Aggregation>(b.aggregations$key.size() < 1073741824 ? 1 + b.aggregations$key.size() + (b.aggregations$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.aggregations$key.size(); $i++) aggregations.put(b.aggregations$key.get($i), (Aggregation) b.aggregations$value.get($i));
            aggregations = java.util.Collections.unmodifiableMap(aggregations);
        }
        this.aggregations = aggregations;
        this.pageSize = b.pageSize;
        java.util.List<AtlanField> includesOnResults;
        switch (b.includesOnResults == null ? 0 : b.includesOnResults.size()) {
        case 0: 
            includesOnResults = java.util.Collections.emptyList();
            break;
        case 1: 
            includesOnResults = java.util.Collections.singletonList(b.includesOnResults.get(0));
            break;
        default: 
            includesOnResults = java.util.Collections.unmodifiableList(new java.util.ArrayList<AtlanField>(b.includesOnResults));
        }
        this.includesOnResults = includesOnResults;
        java.util.List<String> _includesOnResults;
        switch (b._includesOnResults == null ? 0 : b._includesOnResults.size()) {
        case 0: 
            _includesOnResults = java.util.Collections.emptyList();
            break;
        case 1: 
            _includesOnResults = java.util.Collections.singletonList(b._includesOnResults.get(0));
            break;
        default: 
            _includesOnResults = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b._includesOnResults));
        }
        this._includesOnResults = _includesOnResults;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AuditSearch.AuditSearchBuilder<?, ?> _internal() {
        return new AuditSearch.AuditSearchBuilderImpl();
    }
}
