// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.fields.KeywordField;
import com.atlan.model.fields.NumericField;
import java.util.List;

/**
 * Class from which to configure and run a search against Atlan's activity log.
 */
public class AuditSearchRequest extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * When the asset was created.
     */
    public static final NumericField CREATED = new NumericField("createTime", "created");
    /**
     * Unique identifier (GUID) of the asset that was created or changed.
     */
    public static final KeywordField ENTITY_ID = new KeywordField("guid", "entityId");
    /**
     * Type of the asset that was created or changed.
     */
    public static final KeywordField ENTITY_TYPE = new KeywordField("typeName", "typeName");
    /**
     * Unique name of the asset that was created or changed.
     */
    public static final KeywordField QUALIFIED_NAME = new KeywordField("qualifiedName", "entityQualifiedName");
    /**
     * User who made the update to the asset.
     */
    public static final KeywordField USER = new KeywordField("updatedBy", "user");
    /**
     * Type of action made against the asset.
     */
    public static final KeywordField ACTION = new KeywordField("action", "action");
    /**
     * Type of actor (e.g. {@code workflow}) that created or changed the asset, if it was done programmatically.
     */
    public static final KeywordField AGENT = new KeywordField("headers", "headers.x-atlan-agent");
    /**
     * Name of the package that created or changed the asset.
     */
    public static final KeywordField PACKAGE_NAME = new KeywordField("headers", "headers.x-atlan-agent-package-name");
    /**
     * Name of the workflow (specific configuration of a package) that created or changed the asset.
     */
    public static final KeywordField WORKFLOW_ID = new KeywordField("headers", "headers.x-atlan-agent-workflow-id");
    /**
     * Name of the agent (specific run of a workflow) that created or changed the asset.
     */
    public static final KeywordField AGENT_ID = new KeywordField("headers", "headers.x-atlan-agent-id");
    private static final SortOptions LATEST_FIRST = CREATED.order(SortOrder.Desc);
    /**
     * Parameters for the search itself.
     */
    IndexSearchDSL dsl;
    /**
     * Attributes to include in the entityDetail of each resulting audit entry.
     */
    List<String> attributes;

    /**
     * Run the search.
     *
     * @return the matching audit log records
     */
    public AuditSearchResponse search() throws AtlanException {
        return search(Atlan.getDefaultClient());
    }

    /**
     * Run the search.
     *
     * @param client connectivity to the Atlan tenant on which to search the audit logs
     * @return the matching audit log records
     */
    public AuditSearchResponse search(AtlanClient client) throws AtlanException {
        return client.assets.auditLogs(this);
    }

    /**
     * Start building an audit search request for the last changes to an asset, by its GUID.
     *
     * @param guid unique identifier of the asset for which to retrieve the audit history
     * @param size number of changes to retrieve
     * @return a request builder pre-configured with these criteria
     */
    public static AuditSearchRequestBuilder<?, ?> byGuid(String guid, int size) {
        return byGuid(Atlan.getDefaultClient(), guid, size);
    }

    /**
     * Start building an audit search request for the last changes to an asset, by its GUID.
     *
     * @param client connectivity to the Atlan tenant on which to search the audit logs
     * @param guid unique identifier of the asset for which to retrieve the audit history
     * @param size number of changes to retrieve
     * @return a request builder pre-configured with these criteria
     */
    public static AuditSearchRequestBuilder<?, ?> byGuid(AtlanClient client, String guid, int size) {
        return AuditSearch.builder(client).where(ENTITY_ID.eq(guid)).pageSize(size).sort(LATEST_FIRST).toRequestBuilder();
    }

    /**
     * Start building an audit search request for the last changes to an asset, by its qualifiedName.
     *
     * @param typeName the type of asset for which to retrieve the audit history
     * @param qualifiedName unique name of the asset for which to retrieve the audit history
     * @param size number of changes to retrieve
     * @return a request builder pre-configured with these criteria
     */
    public static AuditSearchRequestBuilder<?, ?> byQualifiedName(String typeName, String qualifiedName, int size) {
        return byQualifiedName(Atlan.getDefaultClient(), typeName, qualifiedName, size);
    }

    /**
     * Start building an audit search request for the last changes to an asset, by its qualifiedName.
     *
     * @param client connectivity to the Atlan tenant on which to search the audit logs
     * @param typeName the type of asset for which to retrieve the audit history
     * @param qualifiedName unique name of the asset for which to retrieve the audit history
     * @param size number of changes to retrieve
     * @return a request builder pre-configured with these criteria
     */
    public static AuditSearchRequestBuilder<?, ?> byQualifiedName(AtlanClient client, String typeName, String qualifiedName, int size) {
        return AuditSearch.builder(client).where(QUALIFIED_NAME.eq(qualifiedName)).where(ENTITY_TYPE.eq(typeName)).pageSize(size).sort(LATEST_FIRST).toRequestBuilder();
    }

    /**
     * Start building an audit search request for the last changes made to any assets, by a given user.
     *
     * @param userName the name of the user for which to look for any changes
     * @param size number of changes to retrieve
     * @return a request builder pre-configured with these criteria
     */
    public static AuditSearchRequestBuilder<?, ?> byUser(String userName, int size) {
        return byUser(Atlan.getDefaultClient(), userName, size);
    }

    /**
     * Start building an audit search request for the last changes made to any assets, by a given user.
     *
     * @param client connectivity to the Atlan tenant on which to search the audit logs
     * @param userName the name of the user for which to look for any changes
     * @param size number of changes to retrieve
     * @return a request builder pre-configured with these criteria
     */
    public static AuditSearchRequestBuilder<?, ?> byUser(AtlanClient client, String userName, int size) {
        return AuditSearch.builder(client).where(USER.eq(userName)).pageSize(size).sort(LATEST_FIRST).toRequestBuilder();
    }

    /**
     * Start building an audit search request for the last common action made to any assets.
     *
     * @param action type of action (e.g. {@code ENTITY_CREATE})
     * @param size number of changes to retrieve
     * @return a request builder pre-configured with these criteria
     */
    public static AuditSearchRequestBuilder<?, ?> byAction(String action, int size) {
        return byAction(Atlan.getDefaultClient(), action, size);
    }

    /**
     * Start building an audit search request for the last common action made to any assets.
     *
     * @param client connectivity to the Atlan tenant on which to search the audit logs
     * @param action type of action (e.g. {@code ENTITY_CREATE})
     * @param size number of changes to retrieve
     * @return a request builder pre-configured with these criteria
     */
    public static AuditSearchRequestBuilder<?, ?> byAction(AtlanClient client, String action, int size) {
        return AuditSearch.builder(client).where(ACTION.eq(action)).pageSize(size).sort(LATEST_FIRST).toRequestBuilder();
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AuditSearchRequestBuilder<C extends AuditSearchRequest, B extends AuditSearchRequest.AuditSearchRequestBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IndexSearchDSL dsl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> attributes;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AuditSearchRequest.AuditSearchRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AuditSearchRequest instance, final AuditSearchRequest.AuditSearchRequestBuilder<?, ?> b) {
            b.dsl(instance.dsl);
            b.attributes(instance.attributes == null ? java.util.Collections.<String>emptyList() : instance.attributes);
        }

        /**
         * Parameters for the search itself.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dsl(final IndexSearchDSL dsl) {
            this.dsl = dsl;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attribute(final String attribute) {
            if (this.attributes == null) this.attributes = new java.util.ArrayList<String>();
            this.attributes.add(attribute);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attributes(final java.util.Collection<? extends String> attributes) {
            if (attributes == null) {
                throw new java.lang.NullPointerException("attributes cannot be null");
            }
            if (this.attributes == null) this.attributes = new java.util.ArrayList<String>();
            this.attributes.addAll(attributes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAttributes() {
            if (this.attributes != null) this.attributes.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AuditSearchRequest.AuditSearchRequestBuilder(super=" + super.toString() + ", dsl=" + this.dsl + ", attributes=" + this.attributes + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AuditSearchRequestBuilderImpl extends AuditSearchRequest.AuditSearchRequestBuilder<AuditSearchRequest, AuditSearchRequest.AuditSearchRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AuditSearchRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AuditSearchRequest.AuditSearchRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuditSearchRequest build() {
            return new AuditSearchRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AuditSearchRequest(final AuditSearchRequest.AuditSearchRequestBuilder<?, ?> b) {
        super(b);
        this.dsl = b.dsl;
        java.util.List<String> attributes;
        switch (b.attributes == null ? 0 : b.attributes.size()) {
        case 0: 
            attributes = java.util.Collections.emptyList();
            break;
        case 1: 
            attributes = java.util.Collections.singletonList(b.attributes.get(0));
            break;
        default: 
            attributes = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.attributes));
        }
        this.attributes = attributes;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AuditSearchRequest.AuditSearchRequestBuilder<?, ?> builder() {
        return new AuditSearchRequest.AuditSearchRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuditSearchRequest.AuditSearchRequestBuilder<?, ?> toBuilder() {
        return new AuditSearchRequest.AuditSearchRequestBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Parameters for the search itself.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IndexSearchDSL getDsl() {
        return this.dsl;
    }

    /**
     * Attributes to include in the entityDetail of each resulting audit entry.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AuditSearchRequest)) return false;
        final AuditSearchRequest other = (AuditSearchRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$dsl = this.getDsl();
        final java.lang.Object other$dsl = other.getDsl();
        if (this$dsl == null ? other$dsl != null : !this$dsl.equals(other$dsl)) return false;
        final java.lang.Object this$attributes = this.getAttributes();
        final java.lang.Object other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AuditSearchRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $dsl = this.getDsl();
        result = result * PRIME + ($dsl == null ? 43 : $dsl.hashCode());
        final java.lang.Object $attributes = this.getAttributes();
        result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AuditSearchRequest(super=" + super.toString() + ", dsl=" + this.getDsl() + ", attributes=" + this.getAttributes() + ")";
    }
}
