// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.search;

import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AuditActionType;
import java.util.Map;

/**
 * Detailed entry in the audit log. These objects should be treated as immutable.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = EntityAudit.EntityAuditBuilderImpl.class)
public class EntityAudit extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Unique name of the asset.
     */
    final String entityQualifiedName;
    /**
     * Type of the asset.
     */
    final String typeName;
    /**
     * Unique identifier (GUID) of the asset.
     */
    final String entityId;
    /**
     * Time (epoch) at which the activity started, in milliseconds.
     */
    final Long timestamp;
    /**
     * Time (epoch) at which the activity completed, in milliseconds.
     */
    final Long created;
    /**
     * User who carried out the activity.
     */
    final String user;
    /**
     * The type of activity that was done.
     */
    final AuditActionType action;
    /**
     * Unused.
     */
    final Object details;
    /**
     * Unique identifier of the activity.
     */
    final String eventKey;
    /**
     * Unused.
     */
    final Object entity;
    /**
     * Unused.
     */
    final Object type;
    /**
     * Details of the activity.
     * In practice this will either be details about an Atlan tag (for Atlan tag-
     * related actions) or an asset (for other actions).
     */
    final AuditDetail detail;
    /**
     * Minimal details about the asset that was acted upon.
     * Note that this contains current details about the asset, not the state of the
     * asset immediately before or after the given activity.
     */
    final Asset entityDetail;
    /**
     * Headers detailing how the action was taken, if not by a user.
     */
    final Map<String, String> headers;


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class EntityAuditBuilder<C extends EntityAudit, B extends EntityAudit.EntityAuditBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String entityQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String entityId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long timestamp;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long created;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String user;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AuditActionType action;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object details;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String eventKey;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object entity;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Object type;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AuditDetail detail;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Asset entityDetail;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> headers;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            EntityAudit.EntityAuditBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final EntityAudit instance, final EntityAudit.EntityAuditBuilder<?, ?> b) {
            b.entityQualifiedName(instance.entityQualifiedName);
            b.typeName(instance.typeName);
            b.entityId(instance.entityId);
            b.timestamp(instance.timestamp);
            b.created(instance.created);
            b.user(instance.user);
            b.action(instance.action);
            b.details(instance.details);
            b.eventKey(instance.eventKey);
            b.entity(instance.entity);
            b.type(instance.type);
            b.detail(instance.detail);
            b.entityDetail(instance.entityDetail);
            b.headers(instance.headers);
        }

        /**
         * Unique name of the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entityQualifiedName(final String entityQualifiedName) {
            this.entityQualifiedName = entityQualifiedName;
            return self();
        }

        /**
         * Type of the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName = typeName;
            return self();
        }

        /**
         * Unique identifier (GUID) of the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entityId(final String entityId) {
            this.entityId = entityId;
            return self();
        }

        /**
         * Time (epoch) at which the activity started, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B timestamp(final Long timestamp) {
            this.timestamp = timestamp;
            return self();
        }

        /**
         * Time (epoch) at which the activity completed, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B created(final Long created) {
            this.created = created;
            return self();
        }

        /**
         * User who carried out the activity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B user(final String user) {
            this.user = user;
            return self();
        }

        /**
         * The type of activity that was done.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B action(final AuditActionType action) {
            this.action = action;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B details(final Object details) {
            this.details = details;
            return self();
        }

        /**
         * Unique identifier of the activity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B eventKey(final String eventKey) {
            this.eventKey = eventKey;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entity(final Object entity) {
            this.entity = entity;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B type(final Object type) {
            this.type = type;
            return self();
        }

        /**
         * Details of the activity.
         * In practice this will either be details about an Atlan tag (for Atlan tag-
         * related actions) or an asset (for other actions).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B detail(final AuditDetail detail) {
            this.detail = detail;
            return self();
        }

        /**
         * Minimal details about the asset that was acted upon.
         * Note that this contains current details about the asset, not the state of the
         * asset immediately before or after the given activity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entityDetail(final Asset entityDetail) {
            this.entityDetail = entityDetail;
            return self();
        }

        /**
         * Headers detailing how the action was taken, if not by a user.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B headers(final Map<String, String> headers) {
            this.headers = headers;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "EntityAudit.EntityAuditBuilder(super=" + super.toString() + ", entityQualifiedName=" + this.entityQualifiedName + ", typeName=" + this.typeName + ", entityId=" + this.entityId + ", timestamp=" + this.timestamp + ", created=" + this.created + ", user=" + this.user + ", action=" + this.action + ", details=" + this.details + ", eventKey=" + this.eventKey + ", entity=" + this.entity + ", type=" + this.type + ", detail=" + this.detail + ", entityDetail=" + this.entityDetail + ", headers=" + this.headers + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class EntityAuditBuilderImpl extends EntityAudit.EntityAuditBuilder<EntityAudit, EntityAudit.EntityAuditBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private EntityAuditBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected EntityAudit.EntityAuditBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public EntityAudit build() {
            return new EntityAudit(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected EntityAudit(final EntityAudit.EntityAuditBuilder<?, ?> b) {
        super(b);
        this.entityQualifiedName = b.entityQualifiedName;
        this.typeName = b.typeName;
        this.entityId = b.entityId;
        this.timestamp = b.timestamp;
        this.created = b.created;
        this.user = b.user;
        this.action = b.action;
        this.details = b.details;
        this.eventKey = b.eventKey;
        this.entity = b.entity;
        this.type = b.type;
        this.detail = b.detail;
        this.entityDetail = b.entityDetail;
        this.headers = b.headers;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static EntityAudit.EntityAuditBuilder<?, ?> builder() {
        return new EntityAudit.EntityAuditBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EntityAudit.EntityAuditBuilder<?, ?> toBuilder() {
        return new EntityAudit.EntityAuditBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Unique name of the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEntityQualifiedName() {
        return this.entityQualifiedName;
    }

    /**
     * Type of the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }

    /**
     * Unique identifier (GUID) of the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEntityId() {
        return this.entityId;
    }

    /**
     * Time (epoch) at which the activity started, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    /**
     * Time (epoch) at which the activity completed, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCreated() {
        return this.created;
    }

    /**
     * User who carried out the activity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUser() {
        return this.user;
    }

    /**
     * The type of activity that was done.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuditActionType getAction() {
        return this.action;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getDetails() {
        return this.details;
    }

    /**
     * Unique identifier of the activity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEventKey() {
        return this.eventKey;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getEntity() {
        return this.entity;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object getType() {
        return this.type;
    }

    /**
     * Details of the activity.
     * In practice this will either be details about an Atlan tag (for Atlan tag-
     * related actions) or an asset (for other actions).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuditDetail getDetail() {
        return this.detail;
    }

    /**
     * Minimal details about the asset that was acted upon.
     * Note that this contains current details about the asset, not the state of the
     * asset immediately before or after the given activity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Asset getEntityDetail() {
        return this.entityDetail;
    }

    /**
     * Headers detailing how the action was taken, if not by a user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof EntityAudit)) return false;
        final EntityAudit other = (EntityAudit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$timestamp = this.getTimestamp();
        final java.lang.Object other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) return false;
        final java.lang.Object this$created = this.getCreated();
        final java.lang.Object other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
        final java.lang.Object this$entityQualifiedName = this.getEntityQualifiedName();
        final java.lang.Object other$entityQualifiedName = other.getEntityQualifiedName();
        if (this$entityQualifiedName == null ? other$entityQualifiedName != null : !this$entityQualifiedName.equals(other$entityQualifiedName)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$entityId = this.getEntityId();
        final java.lang.Object other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) return false;
        final java.lang.Object this$user = this.getUser();
        final java.lang.Object other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) return false;
        final java.lang.Object this$action = this.getAction();
        final java.lang.Object other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) return false;
        final java.lang.Object this$details = this.getDetails();
        final java.lang.Object other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) return false;
        final java.lang.Object this$eventKey = this.getEventKey();
        final java.lang.Object other$eventKey = other.getEventKey();
        if (this$eventKey == null ? other$eventKey != null : !this$eventKey.equals(other$eventKey)) return false;
        final java.lang.Object this$entity = this.getEntity();
        final java.lang.Object other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$detail = this.getDetail();
        final java.lang.Object other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) return false;
        final java.lang.Object this$entityDetail = this.getEntityDetail();
        final java.lang.Object other$entityDetail = other.getEntityDetail();
        if (this$entityDetail == null ? other$entityDetail != null : !this$entityDetail.equals(other$entityDetail)) return false;
        final java.lang.Object this$headers = this.getHeaders();
        final java.lang.Object other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof EntityAudit;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $timestamp = this.getTimestamp();
        result = result * PRIME + ($timestamp == null ? 43 : $timestamp.hashCode());
        final java.lang.Object $created = this.getCreated();
        result = result * PRIME + ($created == null ? 43 : $created.hashCode());
        final java.lang.Object $entityQualifiedName = this.getEntityQualifiedName();
        result = result * PRIME + ($entityQualifiedName == null ? 43 : $entityQualifiedName.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $entityId = this.getEntityId();
        result = result * PRIME + ($entityId == null ? 43 : $entityId.hashCode());
        final java.lang.Object $user = this.getUser();
        result = result * PRIME + ($user == null ? 43 : $user.hashCode());
        final java.lang.Object $action = this.getAction();
        result = result * PRIME + ($action == null ? 43 : $action.hashCode());
        final java.lang.Object $details = this.getDetails();
        result = result * PRIME + ($details == null ? 43 : $details.hashCode());
        final java.lang.Object $eventKey = this.getEventKey();
        result = result * PRIME + ($eventKey == null ? 43 : $eventKey.hashCode());
        final java.lang.Object $entity = this.getEntity();
        result = result * PRIME + ($entity == null ? 43 : $entity.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $detail = this.getDetail();
        result = result * PRIME + ($detail == null ? 43 : $detail.hashCode());
        final java.lang.Object $entityDetail = this.getEntityDetail();
        result = result * PRIME + ($entityDetail == null ? 43 : $entityDetail.hashCode());
        final java.lang.Object $headers = this.getHeaders();
        result = result * PRIME + ($headers == null ? 43 : $headers.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "EntityAudit(super=" + super.toString() + ", entityQualifiedName=" + this.getEntityQualifiedName() + ", typeName=" + this.getTypeName() + ", entityId=" + this.getEntityId() + ", timestamp=" + this.getTimestamp() + ", created=" + this.getCreated() + ", user=" + this.getUser() + ", action=" + this.getAction() + ", details=" + this.getDetails() + ", eventKey=" + this.getEventKey() + ", entity=" + this.getEntity() + ", type=" + this.getType() + ", detail=" + this.getDetail() + ", entityDetail=" + this.getEntityDetail() + ", headers=" + this.getHeaders() + ")";
    }
}
