// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import com.atlan.model.fields.AtlanField;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Search abstraction mechanism, to simplify the most common searches against Atlan
 * (removing the need to understand the guts of Elastic).
 */
@SuppressWarnings("cast")
public class FluentSearch extends CompoundQuery {
    /**
     * Build a fluent search against the provided Atlan tenant.
     *
     * @param client connectivity to an Atlan tenant
     * @return the start of a fluent search against the tenant
     */
    public static FluentSearchBuilder<?, ?> builder(AtlanClient client) {
        return _internal().client(client);
    }

    /**
     * Criteria by which to sort the results.
     */
    List<SortOptions> sorts;
    /**
     * Aggregations to run against the results of the search.
     * You provide any key you want to the map (you'll use it to look at the results of a specific aggregation).
     */
    Map<String, Aggregation> aggregations;
    /**
     * Number of results to retrieve per underlying API request.
     */
    Integer pageSize;
    /**
     * Attributes to retrieve for each asset.
     */
    List<AtlanField> includesOnResults;
    /**
     * Attributes to retrieve for each asset (for internal use, unchecked!).
     */
    List<String> _includesOnResults;
    /**
     * Attributes to retrieve for each asset related to the assets in the results.
     */
    List<AtlanField> includesOnRelations;
    /**
     * Attributes to retrieve for each asset related to the assets in the results (for internal use, unchecked!).
     */
    List<String> _includesOnRelations;
    /**
     * Whether to include relationship attributes on each relationship in the results.
     */
    Boolean includeRelationshipAttributes;

    /**
     * Translate the Atlan fluent search into an Atlan search request.
     *
     * @return an Atlan search request that encapsulates the fluent search
     */
    public IndexSearchRequest toRequest() {
        return _requestBuilder().build();
    }

    /**
     * Return the total number of assets that will match the supplied criteria,
     * using the most minimal query possible (retrieves minimal data).
     *
     * @return the count of assets that will match the supplied criteria
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public long count() throws AtlanException {
        if (client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        // As long as there is a client, build the search request for just a single result (with count)
        // and then just return the count
        IndexSearchRequest request = IndexSearchRequest.builder(_dsl().size(1).clearAggregations().build()).build();
        return request.search(client).getApproximateCount();
    }

    /**
     * Run the fluent search to retrieve assets that match the supplied criteria.
     *
     * @return a stream of assets that match the specified criteria, lazily-fetched
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public Stream<Asset> stream() throws AtlanException {
        return stream(false);
    }

    /**
     * Run the fluent search to retrieve assets that match the supplied criteria.
     * Note: if the number of results exceeds the predefined threshold (100,000 assets)
     * this will be automatically converted into a bulkStream().
     *
     * @param parallel if true, returns a parallel stream
     * @return a stream of assets that match the specified criteria, lazily-fetched
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public Stream<Asset> stream(boolean parallel) throws AtlanException {
        if (client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        if (parallel) {
            return toRequest().search(client).parallelStream();
        } else {
            return toRequest().search(client).stream();
        }
    }

    /**
     * Run the fluent search to retrieve assets that match the supplied criteria, using a
     * parallel stream (multiple pages are retrieved in parallel for improved throughput).
     * Note: if the number of results exceeds the predefined threshold (100,000 assets)
     * this will be automatically converted into a bulkStream().
     *
     * @return a stream of assets that match the specified criteria, lazily-fetched
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public Stream<Asset> parallelStream() throws AtlanException {
        return stream(true);
    }

    /**
     * Run the fluent search to retrieve assets that match the supplied criteria, using a
     * stream specifically meant for streaming large numbers of results (100,000's or more).
     * Note: this will apply its own sorting algorithm, so any sort order you have specified
     * may be ignored.
     *
     * @return a stream of assets that match the specified criteria, lazily-fetched
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public Stream<Asset> bulkStream() throws AtlanException {
        if (!IndexSearchResponse.presortedByTimestamp(sorts)) {
            sorts = IndexSearchResponse.sortByTimestampFirst(sorts);
        }
        return toRequest().search(client).bulkStream();
    }

    /**
     * Translate the Atlan fluent search into an Atlan search DSL builder.
     *
     * @return an Atlan search DSL builder that encapsulates the fluent search
     */
    protected IndexSearchDSL.IndexSearchDSLBuilder<?, ?> _dsl() {
        return IndexSearchDSL.builder(toQuery());
    }

    /**
     * Translate the Atlan fluent search into an Atlan search request builder.
     *
     * @return an Atlan search request builder that encapsulates the fluent search
     */
    protected IndexSearchRequest.IndexSearchRequestBuilder<?, ?> _requestBuilder() {
        IndexSearchDSL.IndexSearchDSLBuilder<?, ?> dsl = _dsl();
        if (pageSize != null) {
            dsl.size(pageSize);
        }
        if (sorts != null) {
            dsl.sort(sorts);
        }
        if (aggregations != null) {
            dsl.aggregations(aggregations);
        }
        IndexSearchRequest.IndexSearchRequestBuilder<?, ?> request = IndexSearchRequest.builder(dsl.build());
        if (_includesOnResults != null) {
            request.attributes(_includesOnResults);
        }
        if (includesOnResults != null) {
            request.attributes(includesOnResults.stream().map(AtlanField::getAtlanFieldName).collect(Collectors.toList()));
        }
        if (_includesOnRelations != null) {
            request.relationAttributes(_includesOnRelations);
        }
        if (includesOnRelations != null) {
            request.relationAttributes(includesOnRelations.stream().map(AtlanField::getAtlanFieldName).collect(Collectors.toList()));
        }
        if (includeRelationshipAttributes != null) {
            request.requestRelationshipAttrsForSearch(includeRelationshipAttributes);
        }
        return request;
    }


    public static abstract class FluentSearchBuilder<C extends FluentSearch, B extends FluentSearchBuilder<C, B>> extends CompoundQueryBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<SortOptions> sorts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> aggregations$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Aggregation> aggregations$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer pageSize;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AtlanField> includesOnResults;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> _includesOnResults;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AtlanField> includesOnRelations;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> _includesOnRelations;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean includeRelationshipAttributes;

        /**
         * Translate the Atlan fluent search into an Atlan search request builder.
         *
         * @return an Atlan search request builder that encapsulates the fluent search
         */
        public IndexSearchRequest.IndexSearchRequestBuilder<?, ?> toRequestBuilder() {
            return build()._requestBuilder();
        }

        /**
         * Translate the Atlan fluent search into an Atlan search request.
         *
         * @return an Atlan search request that encapsulates the fluent search
         */
        public IndexSearchRequest toRequest() {
            return build().toRequest();
        }

        /**
         * Return the total number of assets that will match the supplied criteria,
         * using the most minimal query possible (retrieves minimal data).
         *
         * @return the count of assets that will match the supplied criteria
         * @throws AtlanException on any issues interacting with the Atlan APIs
         */
        public long count() throws AtlanException {
            return build().count();
        }

        /**
         * Run the fluent search to retrieve assets that match the supplied criteria.
         *
         * @return a stream of assets that match the specified criteria, lazily-fetched
         * @throws AtlanException on any issues interacting with the Atlan APIs
         */
        public Stream<Asset> stream() throws AtlanException {
            return build().stream();
        }

        /**
         * Run the fluent search to retrieve assets that match the supplied criteria.
         *
         * @param parallel if true, returns a parallel stream
         * @return a stream of assets that match the specified criteria, lazily-fetched
         * @throws AtlanException on any issues interacting with the Atlan APIs
         */
        public Stream<Asset> stream(boolean parallel) throws AtlanException {
            return build().stream(parallel);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sort(final SortOptions sort) {
            if (this.sorts == null) this.sorts = new java.util.ArrayList<SortOptions>();
            this.sorts.add(sort);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sorts(final java.util.Collection<? extends SortOptions> sorts) {
            if (sorts == null) {
                throw new java.lang.NullPointerException("sorts cannot be null");
            }
            if (this.sorts == null) this.sorts = new java.util.ArrayList<SortOptions>();
            this.sorts.addAll(sorts);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSorts() {
            if (this.sorts != null) this.sorts.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B aggregate(final String aggregateKey, final Aggregation aggregateValue) {
            if (this.aggregations$key == null) {
                this.aggregations$key = new java.util.ArrayList<String>();
                this.aggregations$value = new java.util.ArrayList<Aggregation>();
            }
            this.aggregations$key.add(aggregateKey);
            this.aggregations$value.add(aggregateValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B aggregations(final java.util.Map<? extends String, ? extends Aggregation> aggregations) {
            if (aggregations == null) {
                throw new java.lang.NullPointerException("aggregations cannot be null");
            }
            if (this.aggregations$key == null) {
                this.aggregations$key = new java.util.ArrayList<String>();
                this.aggregations$value = new java.util.ArrayList<Aggregation>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Aggregation> $lombokEntry : aggregations.entrySet()) {
                this.aggregations$key.add($lombokEntry.getKey());
                this.aggregations$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAggregations() {
            if (this.aggregations$key != null) {
                this.aggregations$key.clear();
                this.aggregations$value.clear();
            }
            return self();
        }

        /**
         * Number of results to retrieve per underlying API request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B pageSize(final Integer pageSize) {
            this.pageSize = pageSize;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B includeOnResults(final AtlanField includeOnResults) {
            if (this.includesOnResults == null) this.includesOnResults = new java.util.ArrayList<AtlanField>();
            this.includesOnResults.add(includeOnResults);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B includesOnResults(final java.util.Collection<? extends AtlanField> includesOnResults) {
            if (includesOnResults == null) {
                throw new java.lang.NullPointerException("includesOnResults cannot be null");
            }
            if (this.includesOnResults == null) this.includesOnResults = new java.util.ArrayList<AtlanField>();
            this.includesOnResults.addAll(includesOnResults);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearIncludesOnResults() {
            if (this.includesOnResults != null) this.includesOnResults.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _includeOnResults(final String _includeOnResults) {
            if (this._includesOnResults == null) this._includesOnResults = new java.util.ArrayList<String>();
            this._includesOnResults.add(_includeOnResults);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _includesOnResults(final java.util.Collection<? extends String> _includesOnResults) {
            if (_includesOnResults == null) {
                throw new java.lang.NullPointerException("_includesOnResults cannot be null");
            }
            if (this._includesOnResults == null) this._includesOnResults = new java.util.ArrayList<String>();
            this._includesOnResults.addAll(_includesOnResults);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clear_includesOnResults() {
            if (this._includesOnResults != null) this._includesOnResults.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B includeOnRelations(final AtlanField includeOnRelations) {
            if (this.includesOnRelations == null) this.includesOnRelations = new java.util.ArrayList<AtlanField>();
            this.includesOnRelations.add(includeOnRelations);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B includesOnRelations(final java.util.Collection<? extends AtlanField> includesOnRelations) {
            if (includesOnRelations == null) {
                throw new java.lang.NullPointerException("includesOnRelations cannot be null");
            }
            if (this.includesOnRelations == null) this.includesOnRelations = new java.util.ArrayList<AtlanField>();
            this.includesOnRelations.addAll(includesOnRelations);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearIncludesOnRelations() {
            if (this.includesOnRelations != null) this.includesOnRelations.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _includeOnRelations(final String _includeOnRelations) {
            if (this._includesOnRelations == null) this._includesOnRelations = new java.util.ArrayList<String>();
            this._includesOnRelations.add(_includeOnRelations);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B _includesOnRelations(final java.util.Collection<? extends String> _includesOnRelations) {
            if (_includesOnRelations == null) {
                throw new java.lang.NullPointerException("_includesOnRelations cannot be null");
            }
            if (this._includesOnRelations == null) this._includesOnRelations = new java.util.ArrayList<String>();
            this._includesOnRelations.addAll(_includesOnRelations);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clear_includesOnRelations() {
            if (this._includesOnRelations != null) this._includesOnRelations.clear();
            return self();
        }

        /**
         * Whether to include relationship attributes on each relationship in the results.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B includeRelationshipAttributes(final Boolean includeRelationshipAttributes) {
            this.includeRelationshipAttributes = includeRelationshipAttributes;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "FluentSearch.FluentSearchBuilder(super=" + super.toString() + ", sorts=" + this.sorts + ", aggregations$key=" + this.aggregations$key + ", aggregations$value=" + this.aggregations$value + ", pageSize=" + this.pageSize + ", includesOnResults=" + this.includesOnResults + ", _includesOnResults=" + this._includesOnResults + ", includesOnRelations=" + this.includesOnRelations + ", _includesOnRelations=" + this._includesOnRelations + ", includeRelationshipAttributes=" + this.includeRelationshipAttributes + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class FluentSearchBuilderImpl extends FluentSearch.FluentSearchBuilder<FluentSearch, FluentSearch.FluentSearchBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private FluentSearchBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected FluentSearch.FluentSearchBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentSearch build() {
            return new FluentSearch(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected FluentSearch(final FluentSearch.FluentSearchBuilder<?, ?> b) {
        super(b);
        java.util.List<SortOptions> sorts;
        switch (b.sorts == null ? 0 : b.sorts.size()) {
        case 0: 
            sorts = java.util.Collections.emptyList();
            break;
        case 1: 
            sorts = java.util.Collections.singletonList(b.sorts.get(0));
            break;
        default: 
            sorts = java.util.Collections.unmodifiableList(new java.util.ArrayList<SortOptions>(b.sorts));
        }
        this.sorts = sorts;
        java.util.Map<String, Aggregation> aggregations;
        switch (b.aggregations$key == null ? 0 : b.aggregations$key.size()) {
        case 0: 
            aggregations = java.util.Collections.emptyMap();
            break;
        case 1: 
            aggregations = java.util.Collections.singletonMap(b.aggregations$key.get(0), b.aggregations$value.get(0));
            break;
        default: 
            aggregations = new java.util.LinkedHashMap<String, Aggregation>(b.aggregations$key.size() < 1073741824 ? 1 + b.aggregations$key.size() + (b.aggregations$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.aggregations$key.size(); $i++) aggregations.put(b.aggregations$key.get($i), (Aggregation) b.aggregations$value.get($i));
            aggregations = java.util.Collections.unmodifiableMap(aggregations);
        }
        this.aggregations = aggregations;
        this.pageSize = b.pageSize;
        java.util.List<AtlanField> includesOnResults;
        switch (b.includesOnResults == null ? 0 : b.includesOnResults.size()) {
        case 0: 
            includesOnResults = java.util.Collections.emptyList();
            break;
        case 1: 
            includesOnResults = java.util.Collections.singletonList(b.includesOnResults.get(0));
            break;
        default: 
            includesOnResults = java.util.Collections.unmodifiableList(new java.util.ArrayList<AtlanField>(b.includesOnResults));
        }
        this.includesOnResults = includesOnResults;
        java.util.List<String> _includesOnResults;
        switch (b._includesOnResults == null ? 0 : b._includesOnResults.size()) {
        case 0: 
            _includesOnResults = java.util.Collections.emptyList();
            break;
        case 1: 
            _includesOnResults = java.util.Collections.singletonList(b._includesOnResults.get(0));
            break;
        default: 
            _includesOnResults = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b._includesOnResults));
        }
        this._includesOnResults = _includesOnResults;
        java.util.List<AtlanField> includesOnRelations;
        switch (b.includesOnRelations == null ? 0 : b.includesOnRelations.size()) {
        case 0: 
            includesOnRelations = java.util.Collections.emptyList();
            break;
        case 1: 
            includesOnRelations = java.util.Collections.singletonList(b.includesOnRelations.get(0));
            break;
        default: 
            includesOnRelations = java.util.Collections.unmodifiableList(new java.util.ArrayList<AtlanField>(b.includesOnRelations));
        }
        this.includesOnRelations = includesOnRelations;
        java.util.List<String> _includesOnRelations;
        switch (b._includesOnRelations == null ? 0 : b._includesOnRelations.size()) {
        case 0: 
            _includesOnRelations = java.util.Collections.emptyList();
            break;
        case 1: 
            _includesOnRelations = java.util.Collections.singletonList(b._includesOnRelations.get(0));
            break;
        default: 
            _includesOnRelations = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b._includesOnRelations));
        }
        this._includesOnRelations = _includesOnRelations;
        this.includeRelationshipAttributes = b.includeRelationshipAttributes;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static FluentSearch.FluentSearchBuilder<?, ?> _internal() {
        return new FluentSearch.FluentSearchBuilderImpl();
    }
}
