// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.model.core.AtlanObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import lombok.*;

@SuppressWarnings("cast")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = IndexSearchDSL.IndexSearchDSLBuilderImpl.class)
public class IndexSearchDSL extends AtlanObject {
    private static final long serialVersionUID = 2L;
    public static final int DEFAULT_PAGE_SIZE = 300;

    /**
     * Build a search using the provided query and default options.
     *
     * @param query to use for the search
     * @return the search DSL for that query, with default options
     */
    public static IndexSearchDSL of(Query query) {
        return builder(query).build();
    }

    /**
     * Build a search using the provided query and default options.
     *
     * @param query to use for the search
     * @return a search DSL builder for that query, with default options
     */
    public static IndexSearchDSLBuilder<?, ?> builder(Query query) {
        return IndexSearchDSL._internal().query(query);
    }

    /**
     * Starting point for paging. Defaults to 0 (very first result) if not overridden.
     */
    Integer from;
    /**
     * Number of results to return per page. Defaults to 300 results per page if not overridden.
     */
    Integer size;
    /**
     * When true, specify the precise number of results in the response, otherwise estimate and max-out at 10,000.
     * (Defaults to true.)
     */
    @JsonProperty("track_total_hits")
    Boolean trackTotalHits;
    /**
     * (Optional) Aggregation to apply to the query.
     */
    Map<String, Aggregation> aggregations;
    /**
     * Query to run.
     */
    Query query;
    /**
     * (Optional) Properties by which to sort the results.
     */
    List<SortOptions> sort;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Integer $default$from() {
        return 0;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Integer $default$size() {
        return DEFAULT_PAGE_SIZE;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$trackTotalHits() {
        return true;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class IndexSearchDSLBuilder<C extends IndexSearchDSL, B extends IndexSearchDSL.IndexSearchDSLBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean from$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer from$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean size$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer size$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean trackTotalHits$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean trackTotalHits$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> aggregations$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Aggregation> aggregations$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Query query;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<SortOptions> sort;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            IndexSearchDSL.IndexSearchDSLBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final IndexSearchDSL instance, final IndexSearchDSL.IndexSearchDSLBuilder<?, ?> b) {
            b.from(instance.from);
            b.size(instance.size);
            b.trackTotalHits(instance.trackTotalHits);
            b.aggregations(instance.aggregations == null ? java.util.Collections.<String, Aggregation>emptyMap() : instance.aggregations);
            b.query(instance.query);
            b.sort(instance.sort == null ? java.util.Collections.<SortOptions>emptyList() : instance.sort);
        }

        /**
         * Starting point for paging. Defaults to 0 (very first result) if not overridden.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B from(final Integer from) {
            this.from$value = from;
            from$set = true;
            return self();
        }

        /**
         * Number of results to return per page. Defaults to 300 results per page if not overridden.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B size(final Integer size) {
            this.size$value = size;
            size$set = true;
            return self();
        }

        /**
         * When true, specify the precise number of results in the response, otherwise estimate and max-out at 10,000.
         * (Defaults to true.)
         * @return {@code this}.
         */
        @JsonProperty("track_total_hits")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B trackTotalHits(final Boolean trackTotalHits) {
            this.trackTotalHits$value = trackTotalHits;
            trackTotalHits$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B aggregation(final String aggregationKey, final Aggregation aggregationValue) {
            if (this.aggregations$key == null) {
                this.aggregations$key = new java.util.ArrayList<String>();
                this.aggregations$value = new java.util.ArrayList<Aggregation>();
            }
            this.aggregations$key.add(aggregationKey);
            this.aggregations$value.add(aggregationValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B aggregations(final java.util.Map<? extends String, ? extends Aggregation> aggregations) {
            if (aggregations == null) {
                throw new java.lang.NullPointerException("aggregations cannot be null");
            }
            if (this.aggregations$key == null) {
                this.aggregations$key = new java.util.ArrayList<String>();
                this.aggregations$value = new java.util.ArrayList<Aggregation>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Aggregation> $lombokEntry : aggregations.entrySet()) {
                this.aggregations$key.add($lombokEntry.getKey());
                this.aggregations$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAggregations() {
            if (this.aggregations$key != null) {
                this.aggregations$key.clear();
                this.aggregations$value.clear();
            }
            return self();
        }

        /**
         * Query to run.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B query(final Query query) {
            this.query = query;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sortOption(final SortOptions sortOption) {
            if (this.sort == null) this.sort = new java.util.ArrayList<SortOptions>();
            this.sort.add(sortOption);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sort(final java.util.Collection<? extends SortOptions> sort) {
            if (sort == null) {
                throw new java.lang.NullPointerException("sort cannot be null");
            }
            if (this.sort == null) this.sort = new java.util.ArrayList<SortOptions>();
            this.sort.addAll(sort);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSort() {
            if (this.sort != null) this.sort.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "IndexSearchDSL.IndexSearchDSLBuilder(super=" + super.toString() + ", from$value=" + this.from$value + ", size$value=" + this.size$value + ", trackTotalHits$value=" + this.trackTotalHits$value + ", aggregations$key=" + this.aggregations$key + ", aggregations$value=" + this.aggregations$value + ", query=" + this.query + ", sort=" + this.sort + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class IndexSearchDSLBuilderImpl extends IndexSearchDSL.IndexSearchDSLBuilder<IndexSearchDSL, IndexSearchDSL.IndexSearchDSLBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IndexSearchDSLBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected IndexSearchDSL.IndexSearchDSLBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IndexSearchDSL build() {
            return new IndexSearchDSL(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected IndexSearchDSL(final IndexSearchDSL.IndexSearchDSLBuilder<?, ?> b) {
        super(b);
        if (b.from$set) this.from = b.from$value;
         else this.from = IndexSearchDSL.$default$from();
        if (b.size$set) this.size = b.size$value;
         else this.size = IndexSearchDSL.$default$size();
        if (b.trackTotalHits$set) this.trackTotalHits = b.trackTotalHits$value;
         else this.trackTotalHits = IndexSearchDSL.$default$trackTotalHits();
        java.util.Map<String, Aggregation> aggregations;
        switch (b.aggregations$key == null ? 0 : b.aggregations$key.size()) {
        case 0: 
            aggregations = java.util.Collections.emptyMap();
            break;
        case 1: 
            aggregations = java.util.Collections.singletonMap(b.aggregations$key.get(0), b.aggregations$value.get(0));
            break;
        default: 
            aggregations = new java.util.LinkedHashMap<String, Aggregation>(b.aggregations$key.size() < 1073741824 ? 1 + b.aggregations$key.size() + (b.aggregations$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.aggregations$key.size(); $i++) aggregations.put(b.aggregations$key.get($i), (Aggregation) b.aggregations$value.get($i));
            aggregations = java.util.Collections.unmodifiableMap(aggregations);
        }
        this.aggregations = aggregations;
        this.query = b.query;
        java.util.List<SortOptions> sort;
        switch (b.sort == null ? 0 : b.sort.size()) {
        case 0: 
            sort = java.util.Collections.emptyList();
            break;
        case 1: 
            sort = java.util.Collections.singletonList(b.sort.get(0));
            break;
        default: 
            sort = java.util.Collections.unmodifiableList(new java.util.ArrayList<SortOptions>(b.sort));
        }
        this.sort = sort;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static IndexSearchDSL.IndexSearchDSLBuilder<?, ?> _internal() {
        return new IndexSearchDSL.IndexSearchDSLBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IndexSearchDSL.IndexSearchDSLBuilder<?, ?> toBuilder() {
        return new IndexSearchDSL.IndexSearchDSLBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Starting point for paging. Defaults to 0 (very first result) if not overridden.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getFrom() {
        return this.from;
    }

    /**
     * Number of results to return per page. Defaults to 300 results per page if not overridden.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSize() {
        return this.size;
    }

    /**
     * When true, specify the precise number of results in the response, otherwise estimate and max-out at 10,000.
     * (Defaults to true.)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getTrackTotalHits() {
        return this.trackTotalHits;
    }

    /**
     * (Optional) Aggregation to apply to the query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Aggregation> getAggregations() {
        return this.aggregations;
    }

    /**
     * Query to run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Query getQuery() {
        return this.query;
    }

    /**
     * (Optional) Properties by which to sort the results.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<SortOptions> getSort() {
        return this.sort;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof IndexSearchDSL)) return false;
        final IndexSearchDSL other = (IndexSearchDSL) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$from = this.getFrom();
        final java.lang.Object other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) return false;
        final java.lang.Object this$size = this.getSize();
        final java.lang.Object other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) return false;
        final java.lang.Object this$trackTotalHits = this.getTrackTotalHits();
        final java.lang.Object other$trackTotalHits = other.getTrackTotalHits();
        if (this$trackTotalHits == null ? other$trackTotalHits != null : !this$trackTotalHits.equals(other$trackTotalHits)) return false;
        final java.lang.Object this$aggregations = this.getAggregations();
        final java.lang.Object other$aggregations = other.getAggregations();
        if (this$aggregations == null ? other$aggregations != null : !this$aggregations.equals(other$aggregations)) return false;
        final java.lang.Object this$query = this.getQuery();
        final java.lang.Object other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) return false;
        final java.lang.Object this$sort = this.getSort();
        final java.lang.Object other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof IndexSearchDSL;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $from = this.getFrom();
        result = result * PRIME + ($from == null ? 43 : $from.hashCode());
        final java.lang.Object $size = this.getSize();
        result = result * PRIME + ($size == null ? 43 : $size.hashCode());
        final java.lang.Object $trackTotalHits = this.getTrackTotalHits();
        result = result * PRIME + ($trackTotalHits == null ? 43 : $trackTotalHits.hashCode());
        final java.lang.Object $aggregations = this.getAggregations();
        result = result * PRIME + ($aggregations == null ? 43 : $aggregations.hashCode());
        final java.lang.Object $query = this.getQuery();
        result = result * PRIME + ($query == null ? 43 : $query.hashCode());
        final java.lang.Object $sort = this.getSort();
        result = result * PRIME + ($sort == null ? 43 : $sort.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "IndexSearchDSL(super=" + super.toString() + ", from=" + this.getFrom() + ", size=" + this.getSize() + ", trackTotalHits=" + this.getTrackTotalHits() + ", aggregations=" + this.getAggregations() + ", query=" + this.getQuery() + ", sort=" + this.getSort() + ")";
    }
}
