// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.UTMTags;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.*;

/**
 * Class from which to configure and run a search against Atlan.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = IndexSearchRequest.IndexSearchRequestBuilderImpl.class)
public class IndexSearchRequest extends AtlanObject {
    private static final long serialVersionUID = 2L;

    /**
     * Build a search using the provided query and default options.
     *
     * @param query the query to use for the search
     * @return the search request, with default options
     */
    public static IndexSearchRequestBuilder<?, ?> builder(Query query) {
        return builder(IndexSearchDSL.of(query));
    }

    /**
     * Build a search using the provided DSL and default options.
     *
     * @param dsl the query details to use for the search
     * @return the search request, with default options
     */
    public static IndexSearchRequestBuilder<?, ?> builder(IndexSearchDSL dsl) {
        return IndexSearchRequest._internal().dsl(dsl);
    }

    /**
     * Parameters for the search itself.
     */
    IndexSearchDSL dsl;
    /**
     * Attributes to include on each result document.
     */
    List<String> attributes;
    /**
     * Attributes to include on each related entity of each result document.
     */
    List<String> relationAttributes;
    /**
     * TBC
     */
    Boolean suppressLogs;
    /**
     * When true, include the score of each result. By default, this is false and scores are excluded.
     */
    Boolean showSearchScore;
    /**
     * Whether to include term relationships for assets (false) or not (true). By default, this is false
     * and term relationships are therefore included.
     */
    Boolean excludeMeanings;
    /**
     * Whether to include Atlan tags for assets (false) or not (true). By default, this is false and
     * Atlan tags are therefore included.
     */
    @JsonProperty("excludeClassifications")
    Boolean excludeAtlanTags;
    /**
     * Whether to include Atlan tag names for assets (true) or not (false). By default, this is true and
     * Atlan tag names are therefore included. Note that this can be set to true even when excludeAtlanTags
     * is set to false.
     */
    @JsonProperty("includeClassificationNames")
    Boolean includeAtlanTagNames;
    /**
     * Whether to include deleted relationships to this asset (true) or not (false). By default, this is false
     * and therefore only active (not deleted) relationships will be included.
     */
    Boolean allowDeletedRelations;
    /**
     * Whether to include relationship-level attributes for any relationships to each asset (true) or not (false).
     * By default, this is false and therefore relationship-level attributes are not included.
     */
    Boolean requestRelationshipAttrsForSearch;
    /**
     * Controls how the search is logged (if at all).
     */
    Metadata requestMetadata;

    /**
     * Run the search.
     *
     * @return the matching assets
     */
    public IndexSearchResponse search() throws AtlanException {
        return search(Atlan.getDefaultClient());
    }

    /**
     * Run the search.
     *
     * @param client connectivity to the Atlan tenant on which to run the search
     * @return the matching assets
     */
    public IndexSearchResponse search(AtlanClient client) throws AtlanException {
        return client.assets.search(this);
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = IndexSearchRequest.Metadata.MetadataBuilderImpl.class)
    public static final class Metadata extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /** Whether to log this search (true) or not (false). */
        Boolean saveSearchLog;
        /** Tags to associate with the search request. */
        List<String> utmTags;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static Boolean $default$saveSearchLog() {
            return true;
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class MetadataBuilder<C extends IndexSearchRequest.Metadata, B extends IndexSearchRequest.Metadata.MetadataBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private boolean saveSearchLog$set;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Boolean saveSearchLog$value;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private java.util.ArrayList<String> utmTags;

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected B $fillValuesFrom(final C instance) {
                super.$fillValuesFrom(instance);
                IndexSearchRequest.Metadata.MetadataBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private static void $fillValuesFromInstanceIntoBuilder(final IndexSearchRequest.Metadata instance, final IndexSearchRequest.Metadata.MetadataBuilder<?, ?> b) {
                b.saveSearchLog(instance.saveSearchLog);
                b.utmTags(instance.utmTags == null ? java.util.Collections.<String>emptyList() : instance.utmTags);
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B saveSearchLog(final Boolean saveSearchLog) {
                this.saveSearchLog$value = saveSearchLog;
                saveSearchLog$set = true;
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B utmTag(final String utmTag) {
                if (this.utmTags == null) this.utmTags = new java.util.ArrayList<String>();
                this.utmTags.add(utmTag);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B utmTags(final java.util.Collection<? extends String> utmTags) {
                if (utmTags == null) {
                    throw new java.lang.NullPointerException("utmTags cannot be null");
                }
                if (this.utmTags == null) this.utmTags = new java.util.ArrayList<String>();
                this.utmTags.addAll(utmTags);
                return self();
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B clearUtmTags() {
                if (this.utmTags != null) this.utmTags.clear();
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "IndexSearchRequest.Metadata.MetadataBuilder(super=" + super.toString() + ", saveSearchLog$value=" + this.saveSearchLog$value + ", utmTags=" + this.utmTags + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class MetadataBuilderImpl extends IndexSearchRequest.Metadata.MetadataBuilder<IndexSearchRequest.Metadata, IndexSearchRequest.Metadata.MetadataBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private MetadataBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected IndexSearchRequest.Metadata.MetadataBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public IndexSearchRequest.Metadata build() {
                return new IndexSearchRequest.Metadata(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Metadata(final IndexSearchRequest.Metadata.MetadataBuilder<?, ?> b) {
            super(b);
            if (b.saveSearchLog$set) this.saveSearchLog = b.saveSearchLog$value;
             else this.saveSearchLog = IndexSearchRequest.Metadata.$default$saveSearchLog();
            java.util.List<String> utmTags;
            switch (b.utmTags == null ? 0 : b.utmTags.size()) {
            case 0: 
                utmTags = java.util.Collections.emptyList();
                break;
            case 1: 
                utmTags = java.util.Collections.singletonList(b.utmTags.get(0));
                break;
            default: 
                utmTags = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.utmTags));
            }
            this.utmTags = utmTags;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static IndexSearchRequest.Metadata.MetadataBuilder<?, ?> builder() {
            return new IndexSearchRequest.Metadata.MetadataBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IndexSearchRequest.Metadata.MetadataBuilder<?, ?> toBuilder() {
            return new IndexSearchRequest.Metadata.MetadataBuilderImpl().$fillValuesFrom(this);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getSaveSearchLog() {
            return this.saveSearchLog;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getUtmTags() {
            return this.utmTags;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof IndexSearchRequest.Metadata)) return false;
            final IndexSearchRequest.Metadata other = (IndexSearchRequest.Metadata) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$saveSearchLog = this.getSaveSearchLog();
            final java.lang.Object other$saveSearchLog = other.getSaveSearchLog();
            if (this$saveSearchLog == null ? other$saveSearchLog != null : !this$saveSearchLog.equals(other$saveSearchLog)) return false;
            final java.lang.Object this$utmTags = this.getUtmTags();
            final java.lang.Object other$utmTags = other.getUtmTags();
            if (this$utmTags == null ? other$utmTags != null : !this$utmTags.equals(other$utmTags)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof IndexSearchRequest.Metadata;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $saveSearchLog = this.getSaveSearchLog();
            result = result * PRIME + ($saveSearchLog == null ? 43 : $saveSearchLog.hashCode());
            final java.lang.Object $utmTags = this.getUtmTags();
            result = result * PRIME + ($utmTags == null ? 43 : $utmTags.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "IndexSearchRequest.Metadata(super=" + super.toString() + ", saveSearchLog=" + this.getSaveSearchLog() + ", utmTags=" + this.getUtmTags() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$suppressLogs() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$showSearchScore() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$excludeMeanings() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$excludeAtlanTags() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$includeAtlanTagNames() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$allowDeletedRelations() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$requestRelationshipAttrsForSearch() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Metadata $default$requestMetadata() {
        return Metadata.builder().utmTag(UTMTags.PROJECT_SDK_JAVA.getValue()).build();
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class IndexSearchRequestBuilder<C extends IndexSearchRequest, B extends IndexSearchRequest.IndexSearchRequestBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IndexSearchDSL dsl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> attributes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> relationAttributes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean suppressLogs$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean suppressLogs$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean showSearchScore$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean showSearchScore$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean excludeMeanings$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean excludeMeanings$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean excludeAtlanTags$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean excludeAtlanTags$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean includeAtlanTagNames$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean includeAtlanTagNames$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean allowDeletedRelations$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean allowDeletedRelations$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean requestRelationshipAttrsForSearch$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean requestRelationshipAttrsForSearch$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean requestMetadata$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Metadata requestMetadata$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            IndexSearchRequest.IndexSearchRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final IndexSearchRequest instance, final IndexSearchRequest.IndexSearchRequestBuilder<?, ?> b) {
            b.dsl(instance.dsl);
            b.attributes(instance.attributes == null ? java.util.Collections.<String>emptyList() : instance.attributes);
            b.relationAttributes(instance.relationAttributes == null ? java.util.Collections.<String>emptyList() : instance.relationAttributes);
            b.suppressLogs(instance.suppressLogs);
            b.showSearchScore(instance.showSearchScore);
            b.excludeMeanings(instance.excludeMeanings);
            b.excludeAtlanTags(instance.excludeAtlanTags);
            b.includeAtlanTagNames(instance.includeAtlanTagNames);
            b.allowDeletedRelations(instance.allowDeletedRelations);
            b.requestRelationshipAttrsForSearch(instance.requestRelationshipAttrsForSearch);
            b.requestMetadata(instance.requestMetadata);
        }

        /**
         * Parameters for the search itself.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dsl(final IndexSearchDSL dsl) {
            this.dsl = dsl;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attribute(final String attribute) {
            if (this.attributes == null) this.attributes = new java.util.ArrayList<String>();
            this.attributes.add(attribute);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attributes(final java.util.Collection<? extends String> attributes) {
            if (attributes == null) {
                throw new java.lang.NullPointerException("attributes cannot be null");
            }
            if (this.attributes == null) this.attributes = new java.util.ArrayList<String>();
            this.attributes.addAll(attributes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAttributes() {
            if (this.attributes != null) this.attributes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationAttribute(final String relationAttribute) {
            if (this.relationAttributes == null) this.relationAttributes = new java.util.ArrayList<String>();
            this.relationAttributes.add(relationAttribute);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationAttributes(final java.util.Collection<? extends String> relationAttributes) {
            if (relationAttributes == null) {
                throw new java.lang.NullPointerException("relationAttributes cannot be null");
            }
            if (this.relationAttributes == null) this.relationAttributes = new java.util.ArrayList<String>();
            this.relationAttributes.addAll(relationAttributes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearRelationAttributes() {
            if (this.relationAttributes != null) this.relationAttributes.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B suppressLogs(final Boolean suppressLogs) {
            this.suppressLogs$value = suppressLogs;
            suppressLogs$set = true;
            return self();
        }

        /**
         * When true, include the score of each result. By default, this is false and scores are excluded.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B showSearchScore(final Boolean showSearchScore) {
            this.showSearchScore$value = showSearchScore;
            showSearchScore$set = true;
            return self();
        }

        /**
         * Whether to include term relationships for assets (false) or not (true). By default, this is false
         * and term relationships are therefore included.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B excludeMeanings(final Boolean excludeMeanings) {
            this.excludeMeanings$value = excludeMeanings;
            excludeMeanings$set = true;
            return self();
        }

        /**
         * Whether to include Atlan tags for assets (false) or not (true). By default, this is false and
         * Atlan tags are therefore included.
         * @return {@code this}.
         */
        @JsonProperty("excludeClassifications")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B excludeAtlanTags(final Boolean excludeAtlanTags) {
            this.excludeAtlanTags$value = excludeAtlanTags;
            excludeAtlanTags$set = true;
            return self();
        }

        /**
         * Whether to include Atlan tag names for assets (true) or not (false). By default, this is true and
         * Atlan tag names are therefore included. Note that this can be set to true even when excludeAtlanTags
         * is set to false.
         * @return {@code this}.
         */
        @JsonProperty("includeClassificationNames")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B includeAtlanTagNames(final Boolean includeAtlanTagNames) {
            this.includeAtlanTagNames$value = includeAtlanTagNames;
            includeAtlanTagNames$set = true;
            return self();
        }

        /**
         * Whether to include deleted relationships to this asset (true) or not (false). By default, this is false
         * and therefore only active (not deleted) relationships will be included.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B allowDeletedRelations(final Boolean allowDeletedRelations) {
            this.allowDeletedRelations$value = allowDeletedRelations;
            allowDeletedRelations$set = true;
            return self();
        }

        /**
         * Whether to include relationship-level attributes for any relationships to each asset (true) or not (false).
         * By default, this is false and therefore relationship-level attributes are not included.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestRelationshipAttrsForSearch(final Boolean requestRelationshipAttrsForSearch) {
            this.requestRelationshipAttrsForSearch$value = requestRelationshipAttrsForSearch;
            requestRelationshipAttrsForSearch$set = true;
            return self();
        }

        /**
         * Controls how the search is logged (if at all).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B requestMetadata(final Metadata requestMetadata) {
            this.requestMetadata$value = requestMetadata;
            requestMetadata$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "IndexSearchRequest.IndexSearchRequestBuilder(super=" + super.toString() + ", dsl=" + this.dsl + ", attributes=" + this.attributes + ", relationAttributes=" + this.relationAttributes + ", suppressLogs$value=" + this.suppressLogs$value + ", showSearchScore$value=" + this.showSearchScore$value + ", excludeMeanings$value=" + this.excludeMeanings$value + ", excludeAtlanTags$value=" + this.excludeAtlanTags$value + ", includeAtlanTagNames$value=" + this.includeAtlanTagNames$value + ", allowDeletedRelations$value=" + this.allowDeletedRelations$value + ", requestRelationshipAttrsForSearch$value=" + this.requestRelationshipAttrsForSearch$value + ", requestMetadata$value=" + this.requestMetadata$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class IndexSearchRequestBuilderImpl extends IndexSearchRequest.IndexSearchRequestBuilder<IndexSearchRequest, IndexSearchRequest.IndexSearchRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IndexSearchRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected IndexSearchRequest.IndexSearchRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IndexSearchRequest build() {
            return new IndexSearchRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected IndexSearchRequest(final IndexSearchRequest.IndexSearchRequestBuilder<?, ?> b) {
        super(b);
        this.dsl = b.dsl;
        java.util.List<String> attributes;
        switch (b.attributes == null ? 0 : b.attributes.size()) {
        case 0: 
            attributes = java.util.Collections.emptyList();
            break;
        case 1: 
            attributes = java.util.Collections.singletonList(b.attributes.get(0));
            break;
        default: 
            attributes = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.attributes));
        }
        this.attributes = attributes;
        java.util.List<String> relationAttributes;
        switch (b.relationAttributes == null ? 0 : b.relationAttributes.size()) {
        case 0: 
            relationAttributes = java.util.Collections.emptyList();
            break;
        case 1: 
            relationAttributes = java.util.Collections.singletonList(b.relationAttributes.get(0));
            break;
        default: 
            relationAttributes = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.relationAttributes));
        }
        this.relationAttributes = relationAttributes;
        if (b.suppressLogs$set) this.suppressLogs = b.suppressLogs$value;
         else this.suppressLogs = IndexSearchRequest.$default$suppressLogs();
        if (b.showSearchScore$set) this.showSearchScore = b.showSearchScore$value;
         else this.showSearchScore = IndexSearchRequest.$default$showSearchScore();
        if (b.excludeMeanings$set) this.excludeMeanings = b.excludeMeanings$value;
         else this.excludeMeanings = IndexSearchRequest.$default$excludeMeanings();
        if (b.excludeAtlanTags$set) this.excludeAtlanTags = b.excludeAtlanTags$value;
         else this.excludeAtlanTags = IndexSearchRequest.$default$excludeAtlanTags();
        if (b.includeAtlanTagNames$set) this.includeAtlanTagNames = b.includeAtlanTagNames$value;
         else this.includeAtlanTagNames = IndexSearchRequest.$default$includeAtlanTagNames();
        if (b.allowDeletedRelations$set) this.allowDeletedRelations = b.allowDeletedRelations$value;
         else this.allowDeletedRelations = IndexSearchRequest.$default$allowDeletedRelations();
        if (b.requestRelationshipAttrsForSearch$set) this.requestRelationshipAttrsForSearch = b.requestRelationshipAttrsForSearch$value;
         else this.requestRelationshipAttrsForSearch = IndexSearchRequest.$default$requestRelationshipAttrsForSearch();
        if (b.requestMetadata$set) this.requestMetadata = b.requestMetadata$value;
         else this.requestMetadata = IndexSearchRequest.$default$requestMetadata();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static IndexSearchRequest.IndexSearchRequestBuilder<?, ?> _internal() {
        return new IndexSearchRequest.IndexSearchRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IndexSearchRequest.IndexSearchRequestBuilder<?, ?> toBuilder() {
        return new IndexSearchRequest.IndexSearchRequestBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Parameters for the search itself.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IndexSearchDSL getDsl() {
        return this.dsl;
    }

    /**
     * Attributes to include on each result document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    /**
     * Attributes to include on each related entity of each result document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getRelationAttributes() {
        return this.relationAttributes;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSuppressLogs() {
        return this.suppressLogs;
    }

    /**
     * When true, include the score of each result. By default, this is false and scores are excluded.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getShowSearchScore() {
        return this.showSearchScore;
    }

    /**
     * Whether to include term relationships for assets (false) or not (true). By default, this is false
     * and term relationships are therefore included.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getExcludeMeanings() {
        return this.excludeMeanings;
    }

    /**
     * Whether to include Atlan tags for assets (false) or not (true). By default, this is false and
     * Atlan tags are therefore included.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getExcludeAtlanTags() {
        return this.excludeAtlanTags;
    }

    /**
     * Whether to include Atlan tag names for assets (true) or not (false). By default, this is true and
     * Atlan tag names are therefore included. Note that this can be set to true even when excludeAtlanTags
     * is set to false.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIncludeAtlanTagNames() {
        return this.includeAtlanTagNames;
    }

    /**
     * Whether to include deleted relationships to this asset (true) or not (false). By default, this is false
     * and therefore only active (not deleted) relationships will be included.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAllowDeletedRelations() {
        return this.allowDeletedRelations;
    }

    /**
     * Whether to include relationship-level attributes for any relationships to each asset (true) or not (false).
     * By default, this is false and therefore relationship-level attributes are not included.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRequestRelationshipAttrsForSearch() {
        return this.requestRelationshipAttrsForSearch;
    }

    /**
     * Controls how the search is logged (if at all).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Metadata getRequestMetadata() {
        return this.requestMetadata;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof IndexSearchRequest)) return false;
        final IndexSearchRequest other = (IndexSearchRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$suppressLogs = this.getSuppressLogs();
        final java.lang.Object other$suppressLogs = other.getSuppressLogs();
        if (this$suppressLogs == null ? other$suppressLogs != null : !this$suppressLogs.equals(other$suppressLogs)) return false;
        final java.lang.Object this$showSearchScore = this.getShowSearchScore();
        final java.lang.Object other$showSearchScore = other.getShowSearchScore();
        if (this$showSearchScore == null ? other$showSearchScore != null : !this$showSearchScore.equals(other$showSearchScore)) return false;
        final java.lang.Object this$excludeMeanings = this.getExcludeMeanings();
        final java.lang.Object other$excludeMeanings = other.getExcludeMeanings();
        if (this$excludeMeanings == null ? other$excludeMeanings != null : !this$excludeMeanings.equals(other$excludeMeanings)) return false;
        final java.lang.Object this$excludeAtlanTags = this.getExcludeAtlanTags();
        final java.lang.Object other$excludeAtlanTags = other.getExcludeAtlanTags();
        if (this$excludeAtlanTags == null ? other$excludeAtlanTags != null : !this$excludeAtlanTags.equals(other$excludeAtlanTags)) return false;
        final java.lang.Object this$includeAtlanTagNames = this.getIncludeAtlanTagNames();
        final java.lang.Object other$includeAtlanTagNames = other.getIncludeAtlanTagNames();
        if (this$includeAtlanTagNames == null ? other$includeAtlanTagNames != null : !this$includeAtlanTagNames.equals(other$includeAtlanTagNames)) return false;
        final java.lang.Object this$allowDeletedRelations = this.getAllowDeletedRelations();
        final java.lang.Object other$allowDeletedRelations = other.getAllowDeletedRelations();
        if (this$allowDeletedRelations == null ? other$allowDeletedRelations != null : !this$allowDeletedRelations.equals(other$allowDeletedRelations)) return false;
        final java.lang.Object this$requestRelationshipAttrsForSearch = this.getRequestRelationshipAttrsForSearch();
        final java.lang.Object other$requestRelationshipAttrsForSearch = other.getRequestRelationshipAttrsForSearch();
        if (this$requestRelationshipAttrsForSearch == null ? other$requestRelationshipAttrsForSearch != null : !this$requestRelationshipAttrsForSearch.equals(other$requestRelationshipAttrsForSearch)) return false;
        final java.lang.Object this$dsl = this.getDsl();
        final java.lang.Object other$dsl = other.getDsl();
        if (this$dsl == null ? other$dsl != null : !this$dsl.equals(other$dsl)) return false;
        final java.lang.Object this$attributes = this.getAttributes();
        final java.lang.Object other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
        final java.lang.Object this$relationAttributes = this.getRelationAttributes();
        final java.lang.Object other$relationAttributes = other.getRelationAttributes();
        if (this$relationAttributes == null ? other$relationAttributes != null : !this$relationAttributes.equals(other$relationAttributes)) return false;
        final java.lang.Object this$requestMetadata = this.getRequestMetadata();
        final java.lang.Object other$requestMetadata = other.getRequestMetadata();
        if (this$requestMetadata == null ? other$requestMetadata != null : !this$requestMetadata.equals(other$requestMetadata)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof IndexSearchRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $suppressLogs = this.getSuppressLogs();
        result = result * PRIME + ($suppressLogs == null ? 43 : $suppressLogs.hashCode());
        final java.lang.Object $showSearchScore = this.getShowSearchScore();
        result = result * PRIME + ($showSearchScore == null ? 43 : $showSearchScore.hashCode());
        final java.lang.Object $excludeMeanings = this.getExcludeMeanings();
        result = result * PRIME + ($excludeMeanings == null ? 43 : $excludeMeanings.hashCode());
        final java.lang.Object $excludeAtlanTags = this.getExcludeAtlanTags();
        result = result * PRIME + ($excludeAtlanTags == null ? 43 : $excludeAtlanTags.hashCode());
        final java.lang.Object $includeAtlanTagNames = this.getIncludeAtlanTagNames();
        result = result * PRIME + ($includeAtlanTagNames == null ? 43 : $includeAtlanTagNames.hashCode());
        final java.lang.Object $allowDeletedRelations = this.getAllowDeletedRelations();
        result = result * PRIME + ($allowDeletedRelations == null ? 43 : $allowDeletedRelations.hashCode());
        final java.lang.Object $requestRelationshipAttrsForSearch = this.getRequestRelationshipAttrsForSearch();
        result = result * PRIME + ($requestRelationshipAttrsForSearch == null ? 43 : $requestRelationshipAttrsForSearch.hashCode());
        final java.lang.Object $dsl = this.getDsl();
        result = result * PRIME + ($dsl == null ? 43 : $dsl.hashCode());
        final java.lang.Object $attributes = this.getAttributes();
        result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
        final java.lang.Object $relationAttributes = this.getRelationAttributes();
        result = result * PRIME + ($relationAttributes == null ? 43 : $relationAttributes.hashCode());
        final java.lang.Object $requestMetadata = this.getRequestMetadata();
        result = result * PRIME + ($requestMetadata == null ? 43 : $requestMetadata.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "IndexSearchRequest(super=" + super.toString() + ", dsl=" + this.getDsl() + ", attributes=" + this.getAttributes() + ", relationAttributes=" + this.getRelationAttributes() + ", suppressLogs=" + this.getSuppressLogs() + ", showSearchScore=" + this.getShowSearchScore() + ", excludeMeanings=" + this.getExcludeMeanings() + ", excludeAtlanTags=" + this.getExcludeAtlanTags() + ", includeAtlanTagNames=" + this.getIncludeAtlanTagNames() + ", allowDeletedRelations=" + this.getAllowDeletedRelations() + ", requestRelationshipAttrsForSearch=" + this.getRequestRelationshipAttrsForSearch() + ", requestMetadata=" + this.getRequestMetadata() + ")";
    }
}
