// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.search;

import com.atlan.model.core.AtlanObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Set of search parameters that are returned as part of the response of a search against Atlan.
 */
public class SearchParameters extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * List of attributes that were requested in the search.
     */
    List<String> attributes;
    /**
     * List of attributes that were requested to be included on each relationship found in the search.
     */
    List<String> relationAttributes;
    /**
     * Whether to show the score associated with a result (true) or not (false).
     */
    Boolean showSearchScore;
    /**
     * TBC
     */
    Boolean suppressLogs;
    /**
     * Whether the term relationships for assets are excluded from the results (true) or not (false).
     */
    Boolean excludeMeanings;
    /**
     * Whether the Atlan tags of assets are excluded from the results (true) or not (false).
     */
    @JsonProperty("excludeClassifications")
    Boolean excludeAtlanTags;
    /**
     * TBC
     */
    Boolean allowDeletedRelations;
    /**
     * Query that was run to produce these search results.
     * Note that this is in string form, rather than a JSON object, but is equivalent content
     * to {@link IndexSearchDSL}.
     */
    String query;

    /**
     * List of attributes that were requested in the search.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    /**
     * List of attributes that were requested to be included on each relationship found in the search.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getRelationAttributes() {
        return this.relationAttributes;
    }

    /**
     * Whether to show the score associated with a result (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getShowSearchScore() {
        return this.showSearchScore;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSuppressLogs() {
        return this.suppressLogs;
    }

    /**
     * Whether the term relationships for assets are excluded from the results (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getExcludeMeanings() {
        return this.excludeMeanings;
    }

    /**
     * Whether the Atlan tags of assets are excluded from the results (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getExcludeAtlanTags() {
        return this.excludeAtlanTags;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAllowDeletedRelations() {
        return this.allowDeletedRelations;
    }

    /**
     * Query that was run to produce these search results.
     * Note that this is in string form, rather than a JSON object, but is equivalent content
     * to {@link IndexSearchDSL}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuery() {
        return this.query;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SearchParameters)) return false;
        final SearchParameters other = (SearchParameters) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$showSearchScore = this.getShowSearchScore();
        final java.lang.Object other$showSearchScore = other.getShowSearchScore();
        if (this$showSearchScore == null ? other$showSearchScore != null : !this$showSearchScore.equals(other$showSearchScore)) return false;
        final java.lang.Object this$suppressLogs = this.getSuppressLogs();
        final java.lang.Object other$suppressLogs = other.getSuppressLogs();
        if (this$suppressLogs == null ? other$suppressLogs != null : !this$suppressLogs.equals(other$suppressLogs)) return false;
        final java.lang.Object this$excludeMeanings = this.getExcludeMeanings();
        final java.lang.Object other$excludeMeanings = other.getExcludeMeanings();
        if (this$excludeMeanings == null ? other$excludeMeanings != null : !this$excludeMeanings.equals(other$excludeMeanings)) return false;
        final java.lang.Object this$excludeAtlanTags = this.getExcludeAtlanTags();
        final java.lang.Object other$excludeAtlanTags = other.getExcludeAtlanTags();
        if (this$excludeAtlanTags == null ? other$excludeAtlanTags != null : !this$excludeAtlanTags.equals(other$excludeAtlanTags)) return false;
        final java.lang.Object this$allowDeletedRelations = this.getAllowDeletedRelations();
        final java.lang.Object other$allowDeletedRelations = other.getAllowDeletedRelations();
        if (this$allowDeletedRelations == null ? other$allowDeletedRelations != null : !this$allowDeletedRelations.equals(other$allowDeletedRelations)) return false;
        final java.lang.Object this$attributes = this.getAttributes();
        final java.lang.Object other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
        final java.lang.Object this$relationAttributes = this.getRelationAttributes();
        final java.lang.Object other$relationAttributes = other.getRelationAttributes();
        if (this$relationAttributes == null ? other$relationAttributes != null : !this$relationAttributes.equals(other$relationAttributes)) return false;
        final java.lang.Object this$query = this.getQuery();
        final java.lang.Object other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SearchParameters;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $showSearchScore = this.getShowSearchScore();
        result = result * PRIME + ($showSearchScore == null ? 43 : $showSearchScore.hashCode());
        final java.lang.Object $suppressLogs = this.getSuppressLogs();
        result = result * PRIME + ($suppressLogs == null ? 43 : $suppressLogs.hashCode());
        final java.lang.Object $excludeMeanings = this.getExcludeMeanings();
        result = result * PRIME + ($excludeMeanings == null ? 43 : $excludeMeanings.hashCode());
        final java.lang.Object $excludeAtlanTags = this.getExcludeAtlanTags();
        result = result * PRIME + ($excludeAtlanTags == null ? 43 : $excludeAtlanTags.hashCode());
        final java.lang.Object $allowDeletedRelations = this.getAllowDeletedRelations();
        result = result * PRIME + ($allowDeletedRelations == null ? 43 : $allowDeletedRelations.hashCode());
        final java.lang.Object $attributes = this.getAttributes();
        result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
        final java.lang.Object $relationAttributes = this.getRelationAttributes();
        result = result * PRIME + ($relationAttributes == null ? 43 : $relationAttributes.hashCode());
        final java.lang.Object $query = this.getQuery();
        result = result * PRIME + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SearchParameters(super=" + super.toString() + ", attributes=" + this.getAttributes() + ", relationAttributes=" + this.getRelationAttributes() + ", showSearchScore=" + this.getShowSearchScore() + ", suppressLogs=" + this.getSuppressLogs() + ", excludeMeanings=" + this.getExcludeMeanings() + ", excludeAtlanTags=" + this.getExcludeAtlanTags() + ", allowDeletedRelations=" + this.getAllowDeletedRelations() + ", query=" + this.getQuery() + ")";
    }
}
