// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.search.aggregates;

/**
 * Captures a specific aggregate result of views of an asset by a specific user.
 */
public class UserViews {
    /**
     * Name of the user who viewed the asset.
     */
    String username;
    /**
     * Number of times the user viewed the asset.
     */
    Long viewCount;
    /**
     * When the user most recently viewed the asset (epoch-style), in milliseconds.
     */
    Long mostRecentView;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    UserViews(final String username, final Long viewCount, final Long mostRecentView) {
        this.username = username;
        this.viewCount = viewCount;
        this.mostRecentView = mostRecentView;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class UserViewsBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String username;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long viewCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long mostRecentView;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        UserViewsBuilder() {
        }

        /**
         * Name of the user who viewed the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public UserViews.UserViewsBuilder username(final String username) {
            this.username = username;
            return this;
        }

        /**
         * Number of times the user viewed the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public UserViews.UserViewsBuilder viewCount(final Long viewCount) {
            this.viewCount = viewCount;
            return this;
        }

        /**
         * When the user most recently viewed the asset (epoch-style), in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public UserViews.UserViewsBuilder mostRecentView(final Long mostRecentView) {
            this.mostRecentView = mostRecentView;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public UserViews build() {
            return new UserViews(this.username, this.viewCount, this.mostRecentView);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "UserViews.UserViewsBuilder(username=" + this.username + ", viewCount=" + this.viewCount + ", mostRecentView=" + this.mostRecentView + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static UserViews.UserViewsBuilder builder() {
        return new UserViews.UserViewsBuilder();
    }

    /**
     * Name of the user who viewed the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUsername() {
        return this.username;
    }

    /**
     * Number of times the user viewed the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getViewCount() {
        return this.viewCount;
    }

    /**
     * When the user most recently viewed the asset (epoch-style), in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMostRecentView() {
        return this.mostRecentView;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UserViews)) return false;
        final UserViews other = (UserViews) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$viewCount = this.getViewCount();
        final java.lang.Object other$viewCount = other.getViewCount();
        if (this$viewCount == null ? other$viewCount != null : !this$viewCount.equals(other$viewCount)) return false;
        final java.lang.Object this$mostRecentView = this.getMostRecentView();
        final java.lang.Object other$mostRecentView = other.getMostRecentView();
        if (this$mostRecentView == null ? other$mostRecentView != null : !this$mostRecentView.equals(other$mostRecentView)) return false;
        final java.lang.Object this$username = this.getUsername();
        final java.lang.Object other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof UserViews;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $viewCount = this.getViewCount();
        result = result * PRIME + ($viewCount == null ? 43 : $viewCount.hashCode());
        final java.lang.Object $mostRecentView = this.getMostRecentView();
        result = result * PRIME + ($mostRecentView == null ? 43 : $mostRecentView.hashCode());
        final java.lang.Object $username = this.getUsername();
        result = result * PRIME + ($username == null ? 43 : $username.hashCode());
        return result;
    }
}
