// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.structs;

import com.atlan.model.enums.BadgeComparisonOperator;
import com.atlan.model.enums.BadgeConditionColor;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Detailed information about a condition used in coloring a custom metadata badge in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = BadgeCondition.BadgeConditionBuilderImpl.class)
public class BadgeCondition extends AtlanStruct {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "BadgeCondition";
    /**
     * Fixed typeName for BadgeCondition.
     */
    @JsonIgnore
    String typeName;
    /**
     * Comparison operator to use when comparing a custom metadata attribute's value.
     */
    BadgeComparisonOperator badgeConditionOperator;
    /**
     * Value against which to compare the custom metadata attribute's content.
     */
    String badgeConditionValue;
    /**
     * Color (in RGB hex, with a # prefix) to use when custom metadata attribute's content matches the value through the comparison operator.
     */
    String badgeConditionColorhex;

    /**
     * Build a new condition for a badge on a string-based custom metadata property (including options (enumerations)).
     * Note that this will wrap the value itself in double-quotes, as this is needed to properly set the value for the
     * badge. So for example if you set the value as {@code abc123} and you retrieve this value back from the badge
     * condition, you will receive back {@code "abc123"}.
     *
     * @param operator the comparison operator for the condition
     * @param value the value to match against the comparison operator
     * @param color the color to use when a value matches (from the standard colors available in the UI)
     * @return the badge condition with these criteria
     */
    public static BadgeCondition of(BadgeComparisonOperator operator, String value, BadgeConditionColor color) {
        return BadgeCondition.builder().badgeConditionOperator(operator).badgeConditionValue("\"" + value + "\"").badgeConditionColorhex(color.getValue()).build();
    }

    /**
     * Build a new condition for a badge on a string-based custom metadata property (including options (enumerations)).
     * Note that this will wrap the value itself in double-quotes, as this is needed to properly set the value for the
     * badge. So for example if you set the value as {@code abc123} and you retrieve this value back from the badge
     * condition, you will receive back {@code "abc123"}.
     *
     * @param operator the comparison operator for the condition
     * @param value the value to match against the comparison operator
     * @param color the color to use when a value matches (any valid RGB hex string of the form {@code #ffffff})
     * @return the badge condition with these criteria
     */
    public static BadgeCondition of(BadgeComparisonOperator operator, String value, String color) {
        return BadgeCondition.builder().badgeConditionOperator(operator).badgeConditionValue("\"" + value + "\"").badgeConditionColorhex(color).build();
    }

    /**
     * Build a new condition for a badge on a number-based custom metadata property.
     *
     * @param operator the comparison operator for the condition
     * @param value the value to match against the comparison operator
     * @param color the color to use when a value matches (from the standard colors available in the UI)
     * @return the badge condition with these criteria
     */
    public static BadgeCondition of(BadgeComparisonOperator operator, Number value, BadgeConditionColor color) {
        return BadgeCondition.builder().badgeConditionOperator(operator).badgeConditionValue(value.toString()).badgeConditionColorhex(color.getValue()).build();
    }

    /**
     * Build a new condition for a badge on a number-based custom metadata property.
     *
     * @param operator the comparison operator for the condition
     * @param value the value to match against the comparison operator
     * @param color the color to use when a value matches (any valid RGB hex string of the form {@code #ffffff})
     * @return the badge condition with these criteria
     */
    public static BadgeCondition of(BadgeComparisonOperator operator, Number value, String color) {
        return BadgeCondition.builder().badgeConditionOperator(operator).badgeConditionValue(value.toString()).badgeConditionColorhex(color).build();
    }

    /**
     * Build a new condition for a badge on a boolean-based custom metadata property.
     *
     * @param operator the comparison operator for the condition
     * @param value the value to match against the comparison operator
     * @param color the color to use when a value matches (from the standard colors available in the UI)
     * @return the badge condition with these criteria
     */
    public static BadgeCondition of(BadgeComparisonOperator operator, boolean value, BadgeConditionColor color) {
        return BadgeCondition.builder().badgeConditionOperator(operator).badgeConditionValue(Boolean.toString(value)).badgeConditionColorhex(color.getValue()).build();
    }

    /**
     * Build a new condition for a badge on a boolean-based custom metadata property.
     *
     * @param operator the comparison operator for the condition
     * @param value the value to match against the comparison operator
     * @param color the color to use when a value matches (any valid RGB hex string of the form {@code #ffffff})
     * @return the badge condition with these criteria
     */
    public static BadgeCondition of(BadgeComparisonOperator operator, boolean value, String color) {
        return BadgeCondition.builder().badgeConditionOperator(operator).badgeConditionValue(Boolean.toString(value)).badgeConditionColorhex(color).build();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class BadgeConditionBuilder<C extends BadgeCondition, B extends BadgeCondition.BadgeConditionBuilder<C, B>> extends AtlanStruct.AtlanStructBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private BadgeComparisonOperator badgeConditionOperator;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String badgeConditionValue;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String badgeConditionColorhex;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            BadgeCondition.BadgeConditionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final BadgeCondition instance, final BadgeCondition.BadgeConditionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.badgeConditionOperator(instance.badgeConditionOperator);
            b.badgeConditionValue(instance.badgeConditionValue);
            b.badgeConditionColorhex(instance.badgeConditionColorhex);
        }

        /**
         * Fixed typeName for BadgeCondition.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Comparison operator to use when comparing a custom metadata attribute's value.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B badgeConditionOperator(final BadgeComparisonOperator badgeConditionOperator) {
            this.badgeConditionOperator = badgeConditionOperator;
            return self();
        }

        /**
         * Value against which to compare the custom metadata attribute's content.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B badgeConditionValue(final String badgeConditionValue) {
            this.badgeConditionValue = badgeConditionValue;
            return self();
        }

        /**
         * Color (in RGB hex, with a # prefix) to use when custom metadata attribute's content matches the value through the comparison operator.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B badgeConditionColorhex(final String badgeConditionColorhex) {
            this.badgeConditionColorhex = badgeConditionColorhex;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "BadgeCondition.BadgeConditionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", badgeConditionOperator=" + this.badgeConditionOperator + ", badgeConditionValue=" + this.badgeConditionValue + ", badgeConditionColorhex=" + this.badgeConditionColorhex + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class BadgeConditionBuilderImpl extends BadgeCondition.BadgeConditionBuilder<BadgeCondition, BadgeCondition.BadgeConditionBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private BadgeConditionBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected BadgeCondition.BadgeConditionBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public BadgeCondition build() {
            return new BadgeCondition(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected BadgeCondition(final BadgeCondition.BadgeConditionBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = BadgeCondition.$default$typeName();
        this.badgeConditionOperator = b.badgeConditionOperator;
        this.badgeConditionValue = b.badgeConditionValue;
        this.badgeConditionColorhex = b.badgeConditionColorhex;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static BadgeCondition.BadgeConditionBuilder<?, ?> builder() {
        return new BadgeCondition.BadgeConditionBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BadgeCondition.BadgeConditionBuilder<?, ?> toBuilder() {
        return new BadgeCondition.BadgeConditionBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Comparison operator to use when comparing a custom metadata attribute's value.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BadgeComparisonOperator getBadgeConditionOperator() {
        return this.badgeConditionOperator;
    }

    /**
     * Value against which to compare the custom metadata attribute's content.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBadgeConditionValue() {
        return this.badgeConditionValue;
    }

    /**
     * Color (in RGB hex, with a # prefix) to use when custom metadata attribute's content matches the value through the comparison operator.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBadgeConditionColorhex() {
        return this.badgeConditionColorhex;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof BadgeCondition)) return false;
        final BadgeCondition other = (BadgeCondition) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$badgeConditionOperator = this.getBadgeConditionOperator();
        final java.lang.Object other$badgeConditionOperator = other.getBadgeConditionOperator();
        if (this$badgeConditionOperator == null ? other$badgeConditionOperator != null : !this$badgeConditionOperator.equals(other$badgeConditionOperator)) return false;
        final java.lang.Object this$badgeConditionValue = this.getBadgeConditionValue();
        final java.lang.Object other$badgeConditionValue = other.getBadgeConditionValue();
        if (this$badgeConditionValue == null ? other$badgeConditionValue != null : !this$badgeConditionValue.equals(other$badgeConditionValue)) return false;
        final java.lang.Object this$badgeConditionColorhex = this.getBadgeConditionColorhex();
        final java.lang.Object other$badgeConditionColorhex = other.getBadgeConditionColorhex();
        if (this$badgeConditionColorhex == null ? other$badgeConditionColorhex != null : !this$badgeConditionColorhex.equals(other$badgeConditionColorhex)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof BadgeCondition;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $badgeConditionOperator = this.getBadgeConditionOperator();
        result = result * PRIME + ($badgeConditionOperator == null ? 43 : $badgeConditionOperator.hashCode());
        final java.lang.Object $badgeConditionValue = this.getBadgeConditionValue();
        result = result * PRIME + ($badgeConditionValue == null ? 43 : $badgeConditionValue.hashCode());
        final java.lang.Object $badgeConditionColorhex = this.getBadgeConditionColorhex();
        result = result * PRIME + ($badgeConditionColorhex == null ? 43 : $badgeConditionColorhex.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "BadgeCondition(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", badgeConditionOperator=" + this.getBadgeConditionOperator() + ", badgeConditionValue=" + this.getBadgeConditionValue() + ", badgeConditionColorhex=" + this.getBadgeConditionColorhex() + ")";
    }

    /**
     * Fixed typeName for BadgeCondition.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
