// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.structs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Detailed information about a dbt job run.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = DbtJobRun.DbtJobRunBuilderImpl.class)
public class DbtJobRun extends AtlanStruct {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtJobRun";
    /**
     * Fixed typeName for DbtJobRun.
     */
    @JsonIgnore
    String typeName;
    /**
     * Unique Id of the DBT job
     */
    String dbtJobId;
    /**
     * Name of the DBT job instance
     */
    String dbtJobName;
    /**
     * Unique environment id for the DBT job
     */
    String dbtEnvironmentId;
    /**
     * Environment name where the DBT job runs
     */
    String dbtEnvironmentName;
    /**
     * Unique id for the DBT job run
     */
    String dbtJobRunId;
    /**
     * Dbt job instance run completion timestamp
     */
    Long dbtJobRunCompletedAt;
    /**
     * Status of the dbt job run
     */
    String dbtJobRunStatus;
    /**
     * Status of the dbt test executed by current job run
     */
    String dbtTestRunStatus;
    /**
     * Status of the dbt model executed by current job run
     */
    String dbtModelRunStatus;
    /**
     * compiled sql executed by a dbt model/test triggered by this dbt job run instance
     */
    String dbtCompiledSQL;
    /**
     * compiled code executed by a dbt model/test triggered by this dbt job run instance
     */
    String dbtCompiledCode;

    /**
     * Quickly create a new DbtJobRun.
     * @param dbtJobId Unique Id of the DBT job
     * @param dbtJobName Name of the DBT job instance
     * @param dbtEnvironmentId Unique environment id for the DBT job
     * @param dbtEnvironmentName Environment name where the DBT job runs
     * @param dbtJobRunId Unique id for the DBT job run
     * @param dbtJobRunCompletedAt Dbt job instance run completion timestamp
     * @param dbtJobRunStatus Status of the dbt job run
     * @param dbtTestRunStatus Status of the dbt test executed by current job run
     * @param dbtModelRunStatus Status of the dbt model executed by current job run
     * @param dbtCompiledSQL compiled sql executed by a dbt model/test triggered by this dbt job run instance
     * @param dbtCompiledCode compiled code executed by a dbt model/test triggered by this dbt job run instance
     * @return a DbtJobRun with the provided information
     */
    public static DbtJobRun of(String dbtJobId, String dbtJobName, String dbtEnvironmentId, String dbtEnvironmentName, String dbtJobRunId, Long dbtJobRunCompletedAt, String dbtJobRunStatus, String dbtTestRunStatus, String dbtModelRunStatus, String dbtCompiledSQL, String dbtCompiledCode) {
        return DbtJobRun.builder().dbtJobId(dbtJobId).dbtJobName(dbtJobName).dbtEnvironmentId(dbtEnvironmentId).dbtEnvironmentName(dbtEnvironmentName).dbtJobRunId(dbtJobRunId).dbtJobRunCompletedAt(dbtJobRunCompletedAt).dbtJobRunStatus(dbtJobRunStatus).dbtTestRunStatus(dbtTestRunStatus).dbtModelRunStatus(dbtModelRunStatus).dbtCompiledSQL(dbtCompiledSQL).dbtCompiledCode(dbtCompiledCode).build();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class DbtJobRunBuilder<C extends DbtJobRun, B extends DbtJobRun.DbtJobRunBuilder<C, B>> extends AtlanStruct.AtlanStructBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtEnvironmentId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtEnvironmentName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobRunId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dbtJobRunCompletedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtJobRunStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtTestRunStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtModelRunStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtCompiledSQL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dbtCompiledCode;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            DbtJobRun.DbtJobRunBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final DbtJobRun instance, final DbtJobRun.DbtJobRunBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dbtJobId(instance.dbtJobId);
            b.dbtJobName(instance.dbtJobName);
            b.dbtEnvironmentId(instance.dbtEnvironmentId);
            b.dbtEnvironmentName(instance.dbtEnvironmentName);
            b.dbtJobRunId(instance.dbtJobRunId);
            b.dbtJobRunCompletedAt(instance.dbtJobRunCompletedAt);
            b.dbtJobRunStatus(instance.dbtJobRunStatus);
            b.dbtTestRunStatus(instance.dbtTestRunStatus);
            b.dbtModelRunStatus(instance.dbtModelRunStatus);
            b.dbtCompiledSQL(instance.dbtCompiledSQL);
            b.dbtCompiledCode(instance.dbtCompiledCode);
        }

        /**
         * Fixed typeName for DbtJobRun.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Unique Id of the DBT job
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobId(final String dbtJobId) {
            this.dbtJobId = dbtJobId;
            return self();
        }

        /**
         * Name of the DBT job instance
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobName(final String dbtJobName) {
            this.dbtJobName = dbtJobName;
            return self();
        }

        /**
         * Unique environment id for the DBT job
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtEnvironmentId(final String dbtEnvironmentId) {
            this.dbtEnvironmentId = dbtEnvironmentId;
            return self();
        }

        /**
         * Environment name where the DBT job runs
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtEnvironmentName(final String dbtEnvironmentName) {
            this.dbtEnvironmentName = dbtEnvironmentName;
            return self();
        }

        /**
         * Unique id for the DBT job run
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobRunId(final String dbtJobRunId) {
            this.dbtJobRunId = dbtJobRunId;
            return self();
        }

        /**
         * Dbt job instance run completion timestamp
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobRunCompletedAt(final Long dbtJobRunCompletedAt) {
            this.dbtJobRunCompletedAt = dbtJobRunCompletedAt;
            return self();
        }

        /**
         * Status of the dbt job run
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtJobRunStatus(final String dbtJobRunStatus) {
            this.dbtJobRunStatus = dbtJobRunStatus;
            return self();
        }

        /**
         * Status of the dbt test executed by current job run
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTestRunStatus(final String dbtTestRunStatus) {
            this.dbtTestRunStatus = dbtTestRunStatus;
            return self();
        }

        /**
         * Status of the dbt model executed by current job run
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModelRunStatus(final String dbtModelRunStatus) {
            this.dbtModelRunStatus = dbtModelRunStatus;
            return self();
        }

        /**
         * compiled sql executed by a dbt model/test triggered by this dbt job run instance
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtCompiledSQL(final String dbtCompiledSQL) {
            this.dbtCompiledSQL = dbtCompiledSQL;
            return self();
        }

        /**
         * compiled code executed by a dbt model/test triggered by this dbt job run instance
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtCompiledCode(final String dbtCompiledCode) {
            this.dbtCompiledCode = dbtCompiledCode;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "DbtJobRun.DbtJobRunBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dbtJobId=" + this.dbtJobId + ", dbtJobName=" + this.dbtJobName + ", dbtEnvironmentId=" + this.dbtEnvironmentId + ", dbtEnvironmentName=" + this.dbtEnvironmentName + ", dbtJobRunId=" + this.dbtJobRunId + ", dbtJobRunCompletedAt=" + this.dbtJobRunCompletedAt + ", dbtJobRunStatus=" + this.dbtJobRunStatus + ", dbtTestRunStatus=" + this.dbtTestRunStatus + ", dbtModelRunStatus=" + this.dbtModelRunStatus + ", dbtCompiledSQL=" + this.dbtCompiledSQL + ", dbtCompiledCode=" + this.dbtCompiledCode + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class DbtJobRunBuilderImpl extends DbtJobRun.DbtJobRunBuilder<DbtJobRun, DbtJobRun.DbtJobRunBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private DbtJobRunBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected DbtJobRun.DbtJobRunBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DbtJobRun build() {
            return new DbtJobRun(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected DbtJobRun(final DbtJobRun.DbtJobRunBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = DbtJobRun.$default$typeName();
        this.dbtJobId = b.dbtJobId;
        this.dbtJobName = b.dbtJobName;
        this.dbtEnvironmentId = b.dbtEnvironmentId;
        this.dbtEnvironmentName = b.dbtEnvironmentName;
        this.dbtJobRunId = b.dbtJobRunId;
        this.dbtJobRunCompletedAt = b.dbtJobRunCompletedAt;
        this.dbtJobRunStatus = b.dbtJobRunStatus;
        this.dbtTestRunStatus = b.dbtTestRunStatus;
        this.dbtModelRunStatus = b.dbtModelRunStatus;
        this.dbtCompiledSQL = b.dbtCompiledSQL;
        this.dbtCompiledCode = b.dbtCompiledCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static DbtJobRun.DbtJobRunBuilder<?, ?> builder() {
        return new DbtJobRun.DbtJobRunBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DbtJobRun.DbtJobRunBuilder<?, ?> toBuilder() {
        return new DbtJobRun.DbtJobRunBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Unique Id of the DBT job
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobId() {
        return this.dbtJobId;
    }

    /**
     * Name of the DBT job instance
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobName() {
        return this.dbtJobName;
    }

    /**
     * Unique environment id for the DBT job
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtEnvironmentId() {
        return this.dbtEnvironmentId;
    }

    /**
     * Environment name where the DBT job runs
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtEnvironmentName() {
        return this.dbtEnvironmentName;
    }

    /**
     * Unique id for the DBT job run
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobRunId() {
        return this.dbtJobRunId;
    }

    /**
     * Dbt job instance run completion timestamp
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDbtJobRunCompletedAt() {
        return this.dbtJobRunCompletedAt;
    }

    /**
     * Status of the dbt job run
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtJobRunStatus() {
        return this.dbtJobRunStatus;
    }

    /**
     * Status of the dbt test executed by current job run
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtTestRunStatus() {
        return this.dbtTestRunStatus;
    }

    /**
     * Status of the dbt model executed by current job run
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtModelRunStatus() {
        return this.dbtModelRunStatus;
    }

    /**
     * compiled sql executed by a dbt model/test triggered by this dbt job run instance
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtCompiledSQL() {
        return this.dbtCompiledSQL;
    }

    /**
     * compiled code executed by a dbt model/test triggered by this dbt job run instance
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDbtCompiledCode() {
        return this.dbtCompiledCode;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DbtJobRun)) return false;
        final DbtJobRun other = (DbtJobRun) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$dbtJobRunCompletedAt = this.getDbtJobRunCompletedAt();
        final java.lang.Object other$dbtJobRunCompletedAt = other.getDbtJobRunCompletedAt();
        if (this$dbtJobRunCompletedAt == null ? other$dbtJobRunCompletedAt != null : !this$dbtJobRunCompletedAt.equals(other$dbtJobRunCompletedAt)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dbtJobId = this.getDbtJobId();
        final java.lang.Object other$dbtJobId = other.getDbtJobId();
        if (this$dbtJobId == null ? other$dbtJobId != null : !this$dbtJobId.equals(other$dbtJobId)) return false;
        final java.lang.Object this$dbtJobName = this.getDbtJobName();
        final java.lang.Object other$dbtJobName = other.getDbtJobName();
        if (this$dbtJobName == null ? other$dbtJobName != null : !this$dbtJobName.equals(other$dbtJobName)) return false;
        final java.lang.Object this$dbtEnvironmentId = this.getDbtEnvironmentId();
        final java.lang.Object other$dbtEnvironmentId = other.getDbtEnvironmentId();
        if (this$dbtEnvironmentId == null ? other$dbtEnvironmentId != null : !this$dbtEnvironmentId.equals(other$dbtEnvironmentId)) return false;
        final java.lang.Object this$dbtEnvironmentName = this.getDbtEnvironmentName();
        final java.lang.Object other$dbtEnvironmentName = other.getDbtEnvironmentName();
        if (this$dbtEnvironmentName == null ? other$dbtEnvironmentName != null : !this$dbtEnvironmentName.equals(other$dbtEnvironmentName)) return false;
        final java.lang.Object this$dbtJobRunId = this.getDbtJobRunId();
        final java.lang.Object other$dbtJobRunId = other.getDbtJobRunId();
        if (this$dbtJobRunId == null ? other$dbtJobRunId != null : !this$dbtJobRunId.equals(other$dbtJobRunId)) return false;
        final java.lang.Object this$dbtJobRunStatus = this.getDbtJobRunStatus();
        final java.lang.Object other$dbtJobRunStatus = other.getDbtJobRunStatus();
        if (this$dbtJobRunStatus == null ? other$dbtJobRunStatus != null : !this$dbtJobRunStatus.equals(other$dbtJobRunStatus)) return false;
        final java.lang.Object this$dbtTestRunStatus = this.getDbtTestRunStatus();
        final java.lang.Object other$dbtTestRunStatus = other.getDbtTestRunStatus();
        if (this$dbtTestRunStatus == null ? other$dbtTestRunStatus != null : !this$dbtTestRunStatus.equals(other$dbtTestRunStatus)) return false;
        final java.lang.Object this$dbtModelRunStatus = this.getDbtModelRunStatus();
        final java.lang.Object other$dbtModelRunStatus = other.getDbtModelRunStatus();
        if (this$dbtModelRunStatus == null ? other$dbtModelRunStatus != null : !this$dbtModelRunStatus.equals(other$dbtModelRunStatus)) return false;
        final java.lang.Object this$dbtCompiledSQL = this.getDbtCompiledSQL();
        final java.lang.Object other$dbtCompiledSQL = other.getDbtCompiledSQL();
        if (this$dbtCompiledSQL == null ? other$dbtCompiledSQL != null : !this$dbtCompiledSQL.equals(other$dbtCompiledSQL)) return false;
        final java.lang.Object this$dbtCompiledCode = this.getDbtCompiledCode();
        final java.lang.Object other$dbtCompiledCode = other.getDbtCompiledCode();
        if (this$dbtCompiledCode == null ? other$dbtCompiledCode != null : !this$dbtCompiledCode.equals(other$dbtCompiledCode)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DbtJobRun;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $dbtJobRunCompletedAt = this.getDbtJobRunCompletedAt();
        result = result * PRIME + ($dbtJobRunCompletedAt == null ? 43 : $dbtJobRunCompletedAt.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dbtJobId = this.getDbtJobId();
        result = result * PRIME + ($dbtJobId == null ? 43 : $dbtJobId.hashCode());
        final java.lang.Object $dbtJobName = this.getDbtJobName();
        result = result * PRIME + ($dbtJobName == null ? 43 : $dbtJobName.hashCode());
        final java.lang.Object $dbtEnvironmentId = this.getDbtEnvironmentId();
        result = result * PRIME + ($dbtEnvironmentId == null ? 43 : $dbtEnvironmentId.hashCode());
        final java.lang.Object $dbtEnvironmentName = this.getDbtEnvironmentName();
        result = result * PRIME + ($dbtEnvironmentName == null ? 43 : $dbtEnvironmentName.hashCode());
        final java.lang.Object $dbtJobRunId = this.getDbtJobRunId();
        result = result * PRIME + ($dbtJobRunId == null ? 43 : $dbtJobRunId.hashCode());
        final java.lang.Object $dbtJobRunStatus = this.getDbtJobRunStatus();
        result = result * PRIME + ($dbtJobRunStatus == null ? 43 : $dbtJobRunStatus.hashCode());
        final java.lang.Object $dbtTestRunStatus = this.getDbtTestRunStatus();
        result = result * PRIME + ($dbtTestRunStatus == null ? 43 : $dbtTestRunStatus.hashCode());
        final java.lang.Object $dbtModelRunStatus = this.getDbtModelRunStatus();
        result = result * PRIME + ($dbtModelRunStatus == null ? 43 : $dbtModelRunStatus.hashCode());
        final java.lang.Object $dbtCompiledSQL = this.getDbtCompiledSQL();
        result = result * PRIME + ($dbtCompiledSQL == null ? 43 : $dbtCompiledSQL.hashCode());
        final java.lang.Object $dbtCompiledCode = this.getDbtCompiledCode();
        result = result * PRIME + ($dbtCompiledCode == null ? 43 : $dbtCompiledCode.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DbtJobRun(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dbtJobId=" + this.getDbtJobId() + ", dbtJobName=" + this.getDbtJobName() + ", dbtEnvironmentId=" + this.getDbtEnvironmentId() + ", dbtEnvironmentName=" + this.getDbtEnvironmentName() + ", dbtJobRunId=" + this.getDbtJobRunId() + ", dbtJobRunCompletedAt=" + this.getDbtJobRunCompletedAt() + ", dbtJobRunStatus=" + this.getDbtJobRunStatus() + ", dbtTestRunStatus=" + this.getDbtTestRunStatus() + ", dbtModelRunStatus=" + this.getDbtModelRunStatus() + ", dbtCompiledSQL=" + this.getDbtCompiledSQL() + ", dbtCompiledCode=" + this.getDbtCompiledCode() + ")";
    }

    /**
     * Fixed typeName for DbtJobRun.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
