// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.structs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Detailed information about the consumption of a Kafka topic.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = KafkaTopicConsumption.KafkaTopicConsumptionBuilderImpl.class)
public class KafkaTopicConsumption extends AtlanStruct {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "KafkaTopicConsumption";
    /**
     * Fixed typeName for KafkaTopicConsumption.
     */
    @JsonIgnore
    String typeName;
    /**
     * Name of the Kafka topic.
     */
    String topicName;
    /**
     * Partition of the Kafka topic.
     */
    String topicPartition;
    /**
     * Lag of the Kafka topic.
     */
    Long topicLag;
    /**
     * Current offset of the Kafka topic.
     */
    Long topicCurrentOffset;

    /**
     * Quickly create a new KafkaTopicConsumption.
     * @param topicName Name of the Kafka topic.
     * @param topicPartition Partition of the Kafka topic.
     * @param topicLag Lag of the Kafka topic.
     * @param topicCurrentOffset Current offset of the Kafka topic.
     * @return a KafkaTopicConsumption with the provided information
     */
    public static KafkaTopicConsumption of(String topicName, String topicPartition, Long topicLag, Long topicCurrentOffset) {
        return KafkaTopicConsumption.builder().topicName(topicName).topicPartition(topicPartition).topicLag(topicLag).topicCurrentOffset(topicCurrentOffset).build();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class KafkaTopicConsumptionBuilder<C extends KafkaTopicConsumption, B extends KafkaTopicConsumption.KafkaTopicConsumptionBuilder<C, B>> extends AtlanStruct.AtlanStructBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String topicName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String topicPartition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long topicLag;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long topicCurrentOffset;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            KafkaTopicConsumption.KafkaTopicConsumptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final KafkaTopicConsumption instance, final KafkaTopicConsumption.KafkaTopicConsumptionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.topicName(instance.topicName);
            b.topicPartition(instance.topicPartition);
            b.topicLag(instance.topicLag);
            b.topicCurrentOffset(instance.topicCurrentOffset);
        }

        /**
         * Fixed typeName for KafkaTopicConsumption.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Name of the Kafka topic.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B topicName(final String topicName) {
            this.topicName = topicName;
            return self();
        }

        /**
         * Partition of the Kafka topic.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B topicPartition(final String topicPartition) {
            this.topicPartition = topicPartition;
            return self();
        }

        /**
         * Lag of the Kafka topic.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B topicLag(final Long topicLag) {
            this.topicLag = topicLag;
            return self();
        }

        /**
         * Current offset of the Kafka topic.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B topicCurrentOffset(final Long topicCurrentOffset) {
            this.topicCurrentOffset = topicCurrentOffset;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "KafkaTopicConsumption.KafkaTopicConsumptionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", topicName=" + this.topicName + ", topicPartition=" + this.topicPartition + ", topicLag=" + this.topicLag + ", topicCurrentOffset=" + this.topicCurrentOffset + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class KafkaTopicConsumptionBuilderImpl extends KafkaTopicConsumption.KafkaTopicConsumptionBuilder<KafkaTopicConsumption, KafkaTopicConsumption.KafkaTopicConsumptionBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private KafkaTopicConsumptionBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected KafkaTopicConsumption.KafkaTopicConsumptionBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public KafkaTopicConsumption build() {
            return new KafkaTopicConsumption(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected KafkaTopicConsumption(final KafkaTopicConsumption.KafkaTopicConsumptionBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = KafkaTopicConsumption.$default$typeName();
        this.topicName = b.topicName;
        this.topicPartition = b.topicPartition;
        this.topicLag = b.topicLag;
        this.topicCurrentOffset = b.topicCurrentOffset;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static KafkaTopicConsumption.KafkaTopicConsumptionBuilder<?, ?> builder() {
        return new KafkaTopicConsumption.KafkaTopicConsumptionBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public KafkaTopicConsumption.KafkaTopicConsumptionBuilder<?, ?> toBuilder() {
        return new KafkaTopicConsumption.KafkaTopicConsumptionBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Name of the Kafka topic.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTopicName() {
        return this.topicName;
    }

    /**
     * Partition of the Kafka topic.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTopicPartition() {
        return this.topicPartition;
    }

    /**
     * Lag of the Kafka topic.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTopicLag() {
        return this.topicLag;
    }

    /**
     * Current offset of the Kafka topic.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTopicCurrentOffset() {
        return this.topicCurrentOffset;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof KafkaTopicConsumption)) return false;
        final KafkaTopicConsumption other = (KafkaTopicConsumption) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$topicLag = this.getTopicLag();
        final java.lang.Object other$topicLag = other.getTopicLag();
        if (this$topicLag == null ? other$topicLag != null : !this$topicLag.equals(other$topicLag)) return false;
        final java.lang.Object this$topicCurrentOffset = this.getTopicCurrentOffset();
        final java.lang.Object other$topicCurrentOffset = other.getTopicCurrentOffset();
        if (this$topicCurrentOffset == null ? other$topicCurrentOffset != null : !this$topicCurrentOffset.equals(other$topicCurrentOffset)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$topicName = this.getTopicName();
        final java.lang.Object other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) return false;
        final java.lang.Object this$topicPartition = this.getTopicPartition();
        final java.lang.Object other$topicPartition = other.getTopicPartition();
        if (this$topicPartition == null ? other$topicPartition != null : !this$topicPartition.equals(other$topicPartition)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof KafkaTopicConsumption;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $topicLag = this.getTopicLag();
        result = result * PRIME + ($topicLag == null ? 43 : $topicLag.hashCode());
        final java.lang.Object $topicCurrentOffset = this.getTopicCurrentOffset();
        result = result * PRIME + ($topicCurrentOffset == null ? 43 : $topicCurrentOffset.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $topicName = this.getTopicName();
        result = result * PRIME + ($topicName == null ? 43 : $topicName.hashCode());
        final java.lang.Object $topicPartition = this.getTopicPartition();
        result = result * PRIME + ($topicPartition == null ? 43 : $topicPartition.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "KafkaTopicConsumption(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", topicName=" + this.getTopicName() + ", topicPartition=" + this.getTopicPartition() + ", topicLag=" + this.getTopicLag() + ", topicCurrentOffset=" + this.getTopicCurrentOffset() + ")";
    }

    /**
     * Fixed typeName for KafkaTopicConsumption.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
