// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.structs;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.cache.SourceTagCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.ITag;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Detailed information about the attachment of a tag to an Atlan asset, synced from source.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = SourceTagAttachment.SourceTagAttachmentBuilderImpl.class)
public class SourceTagAttachment extends AtlanStruct {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SourceTagAttachment";
    /**
     * Fixed typeName for SourceTagAttachment.
     */
    @JsonIgnore
    String typeName;
    /**
     * Simple name of the source tag.
     */
    String sourceTagName;
    /**
     * Unique name of the source tag, in Atlan.
     */
    String sourceTagQualifiedName;
    /**
     * Unique identifier (GUID) of the source tag, in Atlan.
     */
    String sourceTagGuid;
    /**
     * Connector that is the source of the tag.
     */
    String sourceTagConnectorName;
    /**
     * Value of the tag attachment, from the source.
     */
    @JsonProperty("sourceTagValue")
    List<SourceTagAttachmentValue> sourceTagValues;
    /**
     * Whether the tag attachment has been synced at the source (true) or not (false).
     */
    Boolean isSourceTagSynced;
    /**
     * Time (epoch) when the tag attachment was synced at the source, in milliseconds.
     */
    Long sourceTagSyncTimestamp;
    /**
     * Error message if the tag attachment sync at the source failed.
     */
    String sourceTagSyncError;

    /**
     * Create a source-synced tag attachment with a particular value, when the attachment is
     * synced to the source.
     *
     * @param name Unique name of the source tag, in Atlan.
     * @param sourceTagValues Value of the tag attachment, from the source.
     * @param sourceTagSyncTimestamp Time (epoch) when the tag attachment was synced at the source, in milliseconds.
     * @param sourceTagSyncError Error message if the tag attachment sync at the source failed.
     * @return a SourceTagAttachment with the provided information
     * @throws AtlanException on any error communicating via the underlying APIs
     * @throws NotFoundException if the source-synced tag cannot be resolved
     */
    public static SourceTagAttachment byName(SourceTagCache.SourceTagName name, List<SourceTagAttachmentValue> sourceTagValues, Long sourceTagSyncTimestamp, String sourceTagSyncError) throws AtlanException {
        return byName(Atlan.getDefaultClient(), name, sourceTagValues, true, sourceTagSyncTimestamp, sourceTagSyncError);
    }

    /**
     * Create a source-synced tag attachment with a particular value, when the attachment is
     * synced to the source.
     *
     * @param client connectivity to an Atlan tenant
     * @param name Unique name of the source tag, in Atlan.
     * @param sourceTagValues Value of the tag attachment, from the source.
     * @param sourceTagSyncTimestamp Time (epoch) when the tag attachment was synced at the source, in milliseconds.
     * @param sourceTagSyncError Error message if the tag attachment sync at the source failed.
     * @return a SourceTagAttachment with the provided information
     * @throws AtlanException on any error communicating via the underlying APIs
     * @throws NotFoundException if the source-synced tag cannot be resolved
     */
    public static SourceTagAttachment byName(AtlanClient client, SourceTagCache.SourceTagName name, List<SourceTagAttachmentValue> sourceTagValues, Long sourceTagSyncTimestamp, String sourceTagSyncError) throws AtlanException {
        return byName(client, name, sourceTagValues, true, sourceTagSyncTimestamp, sourceTagSyncError);
    }

    /**
     * Create a source-synced tag attachment with a particular value, when the attachment is
     * not synced to the source.
     *
     * @param name Unique name of the source tag, in Atlan.
     * @param sourceTagValues Value of the tag attachment, from the source.
     * @return a SourceTagAttachment with the provided information
     * @throws AtlanException on any error communicating via the underlying APIs
     * @throws NotFoundException if the source-synced tag cannot be resolved
     */
    public static SourceTagAttachment byName(SourceTagCache.SourceTagName name, List<SourceTagAttachmentValue> sourceTagValues) throws AtlanException {
        return byName(Atlan.getDefaultClient(), name, sourceTagValues, false, null, null);
    }

    /**
     * Create a source-synced tag attachment with a particular value, when the attachment is
     * not synced to the source.
     *
     * @param client connectivity to an Atlan tenant
     * @param name Unique name of the source tag, in Atlan.
     * @param sourceTagValues Value of the tag attachment, from the source.
     * @return a SourceTagAttachment with the provided information
     * @throws AtlanException on any error communicating via the underlying APIs
     * @throws NotFoundException if the source-synced tag cannot be resolved
     */
    public static SourceTagAttachment byName(AtlanClient client, SourceTagCache.SourceTagName name, List<SourceTagAttachmentValue> sourceTagValues) throws AtlanException {
        return byName(client, name, sourceTagValues, false, null, null);
    }

    /**
     * Create a source-synced tag attachment with a particular value, when the attachment is
     * synced to the source.
     *
     * @param client connectivity to an Atlan tenant
     * @param name Unique name of the source tag, in Atlan.
     * @param sourceTagValues Value of the tag attachment, from the source.
     * @param isSourceTagSynced Whether the tag attachment has been synced at the source (true) or not (false).
     * @param sourceTagSyncTimestamp Time (epoch) when the tag attachment was synced at the source, in milliseconds.
     * @param sourceTagSyncError Error message if the tag attachment sync at the source failed.
     * @return a SourceTagAttachment with the provided information
     * @throws AtlanException on any error communicating via the underlying APIs
     * @throws NotFoundException if the source-synced tag cannot be resolved
     */
    private static SourceTagAttachment byName(AtlanClient client, SourceTagCache.SourceTagName name, List<SourceTagAttachmentValue> sourceTagValues, Boolean isSourceTagSynced, Long sourceTagSyncTimestamp, String sourceTagSyncError) throws AtlanException {
        ITag tag = (ITag) client.getSourceTagCache().getByName(name);
        String qualifiedName = tag.getQualifiedName();
        return of(tag.getName(), qualifiedName, tag.getGuid(), Connection.getConnectorTypeFromQualifiedName(qualifiedName).getValue(), sourceTagValues, isSourceTagSynced, sourceTagSyncTimestamp, sourceTagSyncError);
    }

    /**
     * Create a source-synced tag attachment with a particular value, when the attachment is
     * synced to the source.
     *
     * @param sourceTagQualifiedName Unique name of the source tag, in Atlan.
     * @param sourceTagValues Value of the tag attachment, from the source.
     * @param sourceTagSyncTimestamp Time (epoch) when the tag attachment was synced at the source, in milliseconds.
     * @param sourceTagSyncError Error message if the tag attachment sync at the source failed.
     * @return a SourceTagAttachment with the provided information
     * @throws AtlanException on any error communicating via the underlying APIs
     * @throws NotFoundException if the source-synced tag cannot be resolved
     */
    public static SourceTagAttachment byQualifiedName(String sourceTagQualifiedName, List<SourceTagAttachmentValue> sourceTagValues, Long sourceTagSyncTimestamp, String sourceTagSyncError) throws AtlanException {
        return byQualifiedName(Atlan.getDefaultClient(), sourceTagQualifiedName, sourceTagValues, true, sourceTagSyncTimestamp, sourceTagSyncError);
    }

    /**
     * Create a source-synced tag attachment with a particular value, when the attachment is
     * synced to the source.
     *
     * @param client connectivity to an Atlan tenant
     * @param sourceTagQualifiedName Unique name of the source tag, in Atlan.
     * @param sourceTagValues Value of the tag attachment, from the source.
     * @param sourceTagSyncTimestamp Time (epoch) when the tag attachment was synced at the source, in milliseconds.
     * @param sourceTagSyncError Error message if the tag attachment sync at the source failed.
     * @return a SourceTagAttachment with the provided information
     * @throws AtlanException on any error communicating via the underlying APIs
     * @throws NotFoundException if the source-synced tag cannot be resolved
     */
    public static SourceTagAttachment byQualifiedName(AtlanClient client, String sourceTagQualifiedName, List<SourceTagAttachmentValue> sourceTagValues, Long sourceTagSyncTimestamp, String sourceTagSyncError) throws AtlanException {
        return byQualifiedName(client, sourceTagQualifiedName, sourceTagValues, true, sourceTagSyncTimestamp, sourceTagSyncError);
    }

    /**
     * Create a source-synced tag attachment with a particular value, when the attachment is
     * not synced to the source.
     *
     * @param sourceTagQualifiedName Unique name of the source tag, in Atlan.
     * @param sourceTagValues Value of the tag attachment, from the source.
     * @return a SourceTagAttachment with the provided information
     * @throws AtlanException on any error communicating via the underlying APIs
     * @throws NotFoundException if the source-synced tag cannot be resolved
     */
    public static SourceTagAttachment byQualifiedName(String sourceTagQualifiedName, List<SourceTagAttachmentValue> sourceTagValues) throws AtlanException {
        return byQualifiedName(Atlan.getDefaultClient(), sourceTagQualifiedName, sourceTagValues, false, null, null);
    }

    /**
     * Create a source-synced tag attachment with a particular value, when the attachment is
     * not synced to the source.
     *
     * @param client connectivity to an Atlan tenant
     * @param sourceTagQualifiedName Unique name of the source tag, in Atlan.
     * @param sourceTagValues Value of the tag attachment, from the source.
     * @return a SourceTagAttachment with the provided information
     * @throws AtlanException on any error communicating via the underlying APIs
     * @throws NotFoundException if the source-synced tag cannot be resolved
     */
    public static SourceTagAttachment byQualifiedName(AtlanClient client, String sourceTagQualifiedName, List<SourceTagAttachmentValue> sourceTagValues) throws AtlanException {
        return byQualifiedName(client, sourceTagQualifiedName, sourceTagValues, false, null, null);
    }

    /**
     * Create a source-synced tag attachment with a particular value, when the attachment is
     * synced to the source.
     *
     * @param client connectivity to an Atlan tenant
     * @param sourceTagQualifiedName Unique name of the source tag, in Atlan.
     * @param sourceTagValues Value of the tag attachment, from the source.
     * @param isSourceTagSynced Whether the tag attachment has been synced at the source (true) or not (false).
     * @param sourceTagSyncTimestamp Time (epoch) when the tag attachment was synced at the source, in milliseconds.
     * @param sourceTagSyncError Error message if the tag attachment sync at the source failed.
     * @return a SourceTagAttachment with the provided information
     * @throws AtlanException on any error communicating via the underlying APIs
     * @throws NotFoundException if the source-synced tag cannot be resolved
     */
    private static SourceTagAttachment byQualifiedName(AtlanClient client, String sourceTagQualifiedName, List<SourceTagAttachmentValue> sourceTagValues, Boolean isSourceTagSynced, Long sourceTagSyncTimestamp, String sourceTagSyncError) throws AtlanException {
        ITag tag = (ITag) client.getSourceTagCache().getByQualifiedName(sourceTagQualifiedName);
        return of(tag.getName(), sourceTagQualifiedName, tag.getGuid(), Connection.getConnectorTypeFromQualifiedName(sourceTagQualifiedName).getValue(), sourceTagValues, isSourceTagSynced, sourceTagSyncTimestamp, sourceTagSyncError);
    }

    /**
     * Quickly create a new SourceTagAttachment.
     *
     * @param sourceTagName Simple name of the source tag.
     * @param sourceTagQualifiedName Unique name of the source tag, in Atlan.
     * @param sourceTagGuid Unique identifier (GUID) of the source tag, in Atlan.
     * @param sourceTagConnectorName Connector that is the source of the tag.
     * @param sourceTagValues Value of the tag attachment, from the source.
     * @param isSourceTagSynced Whether the tag attachment has been synced at the source (true) or not (false).
     * @param sourceTagSyncTimestamp Time (epoch) when the tag attachment was synced at the source, in milliseconds.
     * @param sourceTagSyncError Error message if the tag attachment sync at the source failed.
     * @return a SourceTagAttachment with the provided information
     */
    public static SourceTagAttachment of(String sourceTagName, String sourceTagQualifiedName, String sourceTagGuid, String sourceTagConnectorName, List<SourceTagAttachmentValue> sourceTagValues, Boolean isSourceTagSynced, Long sourceTagSyncTimestamp, String sourceTagSyncError) {
        return SourceTagAttachment.builder().sourceTagName(sourceTagName).sourceTagQualifiedName(sourceTagQualifiedName).sourceTagGuid(sourceTagGuid).sourceTagConnectorName(sourceTagConnectorName).sourceTagValues(sourceTagValues).isSourceTagSynced(isSourceTagSynced).sourceTagSyncTimestamp(sourceTagSyncTimestamp).sourceTagSyncError(sourceTagSyncError).build();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SourceTagAttachmentBuilder<C extends SourceTagAttachment, B extends SourceTagAttachment.SourceTagAttachmentBuilder<C, B>> extends AtlanStruct.AtlanStructBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceTagName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceTagQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceTagGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceTagConnectorName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<SourceTagAttachmentValue> sourceTagValues;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isSourceTagSynced;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sourceTagSyncTimestamp;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceTagSyncError;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SourceTagAttachment.SourceTagAttachmentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SourceTagAttachment instance, final SourceTagAttachment.SourceTagAttachmentBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.sourceTagName(instance.sourceTagName);
            b.sourceTagQualifiedName(instance.sourceTagQualifiedName);
            b.sourceTagGuid(instance.sourceTagGuid);
            b.sourceTagConnectorName(instance.sourceTagConnectorName);
            b.sourceTagValues(instance.sourceTagValues == null ? java.util.Collections.<SourceTagAttachmentValue>emptyList() : instance.sourceTagValues);
            b.isSourceTagSynced(instance.isSourceTagSynced);
            b.sourceTagSyncTimestamp(instance.sourceTagSyncTimestamp);
            b.sourceTagSyncError(instance.sourceTagSyncError);
        }

        /**
         * Fixed typeName for SourceTagAttachment.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Simple name of the source tag.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceTagName(final String sourceTagName) {
            this.sourceTagName = sourceTagName;
            return self();
        }

        /**
         * Unique name of the source tag, in Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceTagQualifiedName(final String sourceTagQualifiedName) {
            this.sourceTagQualifiedName = sourceTagQualifiedName;
            return self();
        }

        /**
         * Unique identifier (GUID) of the source tag, in Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceTagGuid(final String sourceTagGuid) {
            this.sourceTagGuid = sourceTagGuid;
            return self();
        }

        /**
         * Connector that is the source of the tag.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceTagConnectorName(final String sourceTagConnectorName) {
            this.sourceTagConnectorName = sourceTagConnectorName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceTagValue(final SourceTagAttachmentValue sourceTagValue) {
            if (this.sourceTagValues == null) this.sourceTagValues = new java.util.ArrayList<SourceTagAttachmentValue>();
            this.sourceTagValues.add(sourceTagValue);
            return self();
        }

        @JsonProperty("sourceTagValue")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceTagValues(final java.util.Collection<? extends SourceTagAttachmentValue> sourceTagValues) {
            if (sourceTagValues == null) {
                throw new java.lang.NullPointerException("sourceTagValues cannot be null");
            }
            if (this.sourceTagValues == null) this.sourceTagValues = new java.util.ArrayList<SourceTagAttachmentValue>();
            this.sourceTagValues.addAll(sourceTagValues);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSourceTagValues() {
            if (this.sourceTagValues != null) this.sourceTagValues.clear();
            return self();
        }

        /**
         * Whether the tag attachment has been synced at the source (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isSourceTagSynced(final Boolean isSourceTagSynced) {
            this.isSourceTagSynced = isSourceTagSynced;
            return self();
        }

        /**
         * Time (epoch) when the tag attachment was synced at the source, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceTagSyncTimestamp(final Long sourceTagSyncTimestamp) {
            this.sourceTagSyncTimestamp = sourceTagSyncTimestamp;
            return self();
        }

        /**
         * Error message if the tag attachment sync at the source failed.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceTagSyncError(final String sourceTagSyncError) {
            this.sourceTagSyncError = sourceTagSyncError;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SourceTagAttachment.SourceTagAttachmentBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", sourceTagName=" + this.sourceTagName + ", sourceTagQualifiedName=" + this.sourceTagQualifiedName + ", sourceTagGuid=" + this.sourceTagGuid + ", sourceTagConnectorName=" + this.sourceTagConnectorName + ", sourceTagValues=" + this.sourceTagValues + ", isSourceTagSynced=" + this.isSourceTagSynced + ", sourceTagSyncTimestamp=" + this.sourceTagSyncTimestamp + ", sourceTagSyncError=" + this.sourceTagSyncError + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class SourceTagAttachmentBuilderImpl extends SourceTagAttachment.SourceTagAttachmentBuilder<SourceTagAttachment, SourceTagAttachment.SourceTagAttachmentBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SourceTagAttachmentBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SourceTagAttachment.SourceTagAttachmentBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SourceTagAttachment build() {
            return new SourceTagAttachment(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SourceTagAttachment(final SourceTagAttachment.SourceTagAttachmentBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = SourceTagAttachment.$default$typeName();
        this.sourceTagName = b.sourceTagName;
        this.sourceTagQualifiedName = b.sourceTagQualifiedName;
        this.sourceTagGuid = b.sourceTagGuid;
        this.sourceTagConnectorName = b.sourceTagConnectorName;
        java.util.List<SourceTagAttachmentValue> sourceTagValues;
        switch (b.sourceTagValues == null ? 0 : b.sourceTagValues.size()) {
        case 0: 
            sourceTagValues = java.util.Collections.emptyList();
            break;
        case 1: 
            sourceTagValues = java.util.Collections.singletonList(b.sourceTagValues.get(0));
            break;
        default: 
            sourceTagValues = java.util.Collections.unmodifiableList(new java.util.ArrayList<SourceTagAttachmentValue>(b.sourceTagValues));
        }
        this.sourceTagValues = sourceTagValues;
        this.isSourceTagSynced = b.isSourceTagSynced;
        this.sourceTagSyncTimestamp = b.sourceTagSyncTimestamp;
        this.sourceTagSyncError = b.sourceTagSyncError;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SourceTagAttachment.SourceTagAttachmentBuilder<?, ?> builder() {
        return new SourceTagAttachment.SourceTagAttachmentBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SourceTagAttachment.SourceTagAttachmentBuilder<?, ?> toBuilder() {
        return new SourceTagAttachment.SourceTagAttachmentBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Simple name of the source tag.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceTagName() {
        return this.sourceTagName;
    }

    /**
     * Unique name of the source tag, in Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceTagQualifiedName() {
        return this.sourceTagQualifiedName;
    }

    /**
     * Unique identifier (GUID) of the source tag, in Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceTagGuid() {
        return this.sourceTagGuid;
    }

    /**
     * Connector that is the source of the tag.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceTagConnectorName() {
        return this.sourceTagConnectorName;
    }

    /**
     * Value of the tag attachment, from the source.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<SourceTagAttachmentValue> getSourceTagValues() {
        return this.sourceTagValues;
    }

    /**
     * Whether the tag attachment has been synced at the source (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsSourceTagSynced() {
        return this.isSourceTagSynced;
    }

    /**
     * Time (epoch) when the tag attachment was synced at the source, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSourceTagSyncTimestamp() {
        return this.sourceTagSyncTimestamp;
    }

    /**
     * Error message if the tag attachment sync at the source failed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceTagSyncError() {
        return this.sourceTagSyncError;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SourceTagAttachment)) return false;
        final SourceTagAttachment other = (SourceTagAttachment) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$isSourceTagSynced = this.getIsSourceTagSynced();
        final java.lang.Object other$isSourceTagSynced = other.getIsSourceTagSynced();
        if (this$isSourceTagSynced == null ? other$isSourceTagSynced != null : !this$isSourceTagSynced.equals(other$isSourceTagSynced)) return false;
        final java.lang.Object this$sourceTagSyncTimestamp = this.getSourceTagSyncTimestamp();
        final java.lang.Object other$sourceTagSyncTimestamp = other.getSourceTagSyncTimestamp();
        if (this$sourceTagSyncTimestamp == null ? other$sourceTagSyncTimestamp != null : !this$sourceTagSyncTimestamp.equals(other$sourceTagSyncTimestamp)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$sourceTagName = this.getSourceTagName();
        final java.lang.Object other$sourceTagName = other.getSourceTagName();
        if (this$sourceTagName == null ? other$sourceTagName != null : !this$sourceTagName.equals(other$sourceTagName)) return false;
        final java.lang.Object this$sourceTagQualifiedName = this.getSourceTagQualifiedName();
        final java.lang.Object other$sourceTagQualifiedName = other.getSourceTagQualifiedName();
        if (this$sourceTagQualifiedName == null ? other$sourceTagQualifiedName != null : !this$sourceTagQualifiedName.equals(other$sourceTagQualifiedName)) return false;
        final java.lang.Object this$sourceTagGuid = this.getSourceTagGuid();
        final java.lang.Object other$sourceTagGuid = other.getSourceTagGuid();
        if (this$sourceTagGuid == null ? other$sourceTagGuid != null : !this$sourceTagGuid.equals(other$sourceTagGuid)) return false;
        final java.lang.Object this$sourceTagConnectorName = this.getSourceTagConnectorName();
        final java.lang.Object other$sourceTagConnectorName = other.getSourceTagConnectorName();
        if (this$sourceTagConnectorName == null ? other$sourceTagConnectorName != null : !this$sourceTagConnectorName.equals(other$sourceTagConnectorName)) return false;
        final java.lang.Object this$sourceTagValues = this.getSourceTagValues();
        final java.lang.Object other$sourceTagValues = other.getSourceTagValues();
        if (this$sourceTagValues == null ? other$sourceTagValues != null : !this$sourceTagValues.equals(other$sourceTagValues)) return false;
        final java.lang.Object this$sourceTagSyncError = this.getSourceTagSyncError();
        final java.lang.Object other$sourceTagSyncError = other.getSourceTagSyncError();
        if (this$sourceTagSyncError == null ? other$sourceTagSyncError != null : !this$sourceTagSyncError.equals(other$sourceTagSyncError)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SourceTagAttachment;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $isSourceTagSynced = this.getIsSourceTagSynced();
        result = result * PRIME + ($isSourceTagSynced == null ? 43 : $isSourceTagSynced.hashCode());
        final java.lang.Object $sourceTagSyncTimestamp = this.getSourceTagSyncTimestamp();
        result = result * PRIME + ($sourceTagSyncTimestamp == null ? 43 : $sourceTagSyncTimestamp.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $sourceTagName = this.getSourceTagName();
        result = result * PRIME + ($sourceTagName == null ? 43 : $sourceTagName.hashCode());
        final java.lang.Object $sourceTagQualifiedName = this.getSourceTagQualifiedName();
        result = result * PRIME + ($sourceTagQualifiedName == null ? 43 : $sourceTagQualifiedName.hashCode());
        final java.lang.Object $sourceTagGuid = this.getSourceTagGuid();
        result = result * PRIME + ($sourceTagGuid == null ? 43 : $sourceTagGuid.hashCode());
        final java.lang.Object $sourceTagConnectorName = this.getSourceTagConnectorName();
        result = result * PRIME + ($sourceTagConnectorName == null ? 43 : $sourceTagConnectorName.hashCode());
        final java.lang.Object $sourceTagValues = this.getSourceTagValues();
        result = result * PRIME + ($sourceTagValues == null ? 43 : $sourceTagValues.hashCode());
        final java.lang.Object $sourceTagSyncError = this.getSourceTagSyncError();
        result = result * PRIME + ($sourceTagSyncError == null ? 43 : $sourceTagSyncError.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SourceTagAttachment(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", sourceTagName=" + this.getSourceTagName() + ", sourceTagQualifiedName=" + this.getSourceTagQualifiedName() + ", sourceTagGuid=" + this.getSourceTagGuid() + ", sourceTagConnectorName=" + this.getSourceTagConnectorName() + ", sourceTagValues=" + this.getSourceTagValues() + ", isSourceTagSynced=" + this.getIsSourceTagSynced() + ", sourceTagSyncTimestamp=" + this.getSourceTagSyncTimestamp() + ", sourceTagSyncError=" + this.getSourceTagSyncError() + ")";
    }

    /**
     * Fixed typeName for SourceTagAttachment.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
