// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.tasks;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanTaskStatus;
import com.atlan.model.enums.AtlanTaskType;
import com.atlan.model.fields.KeywordField;
import com.atlan.model.fields.NumericField;
import com.atlan.model.fields.TextField;
import java.util.Map;

/**
 * Detailed entry in the task queue. These objects should be treated as immutable.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AtlanTask.AtlanTaskBuilderImpl.class)
public class AtlanTask extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Type of the task.
     */
    public static final KeywordField TYPE = new KeywordField("type", "__task_type");
    /**
     * Unique identifier of the task.
     */
    public static final TextField GUID = new TextField("guid", "__task_guid");
    /**
     * User who created the task.
     */
    public static final KeywordField CREATED_BY = new KeywordField("createdBy", "__task_createdBy");
    /**
     * Time (epoch) at which the task was created, in milliseconds.
     */
    public static final NumericField CREATED_TIME = new NumericField("createdTime", "__task_timestamp");
    /**
     * Time (epoch) at which the task was last updated, in milliseconds.
     */
    public static final NumericField UPDATED_TIME = new NumericField("updatedTime", "__task_modificationTimestamp");
    /**
     * Time (epoch) at which the task was started, in milliseconds.
     */
    public static final NumericField START_TIME = new NumericField("startTime", "__task_startTime");
    /**
     * Time (epoch) at which the task was ended, in milliseconds.
     */
    public static final NumericField END_TIME = new NumericField("endTime", "__task_endTime");
    /**
     * Total time taken to complete the task, in seconds.
     */
    public static final NumericField TIME_TAKEN_IN_SECONDS = new NumericField("timeTakenInSeconds", "__task_timeTakenInSeconds");
    /**
     * Number of times the task has been attempted.
     */
    public static final NumericField ATTEMPT_COUNT = new NumericField("attemptCount", "__task_attemptCount");
    /**
     * Status of the task.
     */
    public static final TextField STATUS = new TextField("status", "__task_status");
    /**
     * TBC
     */
    public static final KeywordField CLASSIFICATION_ID = new KeywordField("classificationId", "__task_classificationId");
    /**
     * Unique identifier of the asset the task originated from.
     */
    public static final KeywordField ENTITY_GUID = new KeywordField("entityGuid", "__task_entityGuid");
    /**
     * Type of the task.
     */
    final AtlanTaskType type;
    /**
     * Unique identifier of the task.
     */
    final String guid;
    /**
     * User who created the task.
     */
    final String createdBy;
    /**
     * Time (epoch) at which the task was created, in milliseconds.
     */
    final Long createdTime;
    /**
     * Time (epoch) at which the task was last updated, in milliseconds.
     */
    final Long updatedTime;
    /**
     * Time (epoch) at which the task was started, in milliseconds.
     */
    final Long startTime;
    /**
     * Time (epoch) at which the task was ended, in milliseconds.
     */
    final Long endTime;
    /**
     * Total time taken to complete the task, in seconds.
     */
    final Long timeTakenInSeconds;
    /**
     * Parameters used for running the task.
     */
    final Map<String, Object> parameters;
    /**
     * Number of times the task has been attempted.
     */
    final Long attemptCount;
    /**
     * Status of the task.
     */
    final AtlanTaskStatus status;
    /**
     * TBC
     */
    final String classificationId;
    /**
     * Unique identifier of the asset the task originated from.
     */
    final String entityGuid;


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AtlanTaskBuilder<C extends AtlanTask, B extends AtlanTask.AtlanTaskBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTaskType type;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String guid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String createdBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long createdTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long updatedTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long startTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long endTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long timeTakenInSeconds;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, Object> parameters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long attemptCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTaskStatus status;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String classificationId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String entityGuid;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AtlanTask.AtlanTaskBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AtlanTask instance, final AtlanTask.AtlanTaskBuilder<?, ?> b) {
            b.type(instance.type);
            b.guid(instance.guid);
            b.createdBy(instance.createdBy);
            b.createdTime(instance.createdTime);
            b.updatedTime(instance.updatedTime);
            b.startTime(instance.startTime);
            b.endTime(instance.endTime);
            b.timeTakenInSeconds(instance.timeTakenInSeconds);
            b.parameters(instance.parameters);
            b.attemptCount(instance.attemptCount);
            b.status(instance.status);
            b.classificationId(instance.classificationId);
            b.entityGuid(instance.entityGuid);
        }

        /**
         * Type of the task.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B type(final AtlanTaskType type) {
            this.type = type;
            return self();
        }

        /**
         * Unique identifier of the task.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B guid(final String guid) {
            this.guid = guid;
            return self();
        }

        /**
         * User who created the task.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B createdBy(final String createdBy) {
            this.createdBy = createdBy;
            return self();
        }

        /**
         * Time (epoch) at which the task was created, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B createdTime(final Long createdTime) {
            this.createdTime = createdTime;
            return self();
        }

        /**
         * Time (epoch) at which the task was last updated, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B updatedTime(final Long updatedTime) {
            this.updatedTime = updatedTime;
            return self();
        }

        /**
         * Time (epoch) at which the task was started, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B startTime(final Long startTime) {
            this.startTime = startTime;
            return self();
        }

        /**
         * Time (epoch) at which the task was ended, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B endTime(final Long endTime) {
            this.endTime = endTime;
            return self();
        }

        /**
         * Total time taken to complete the task, in seconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B timeTakenInSeconds(final Long timeTakenInSeconds) {
            this.timeTakenInSeconds = timeTakenInSeconds;
            return self();
        }

        /**
         * Parameters used for running the task.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parameters(final Map<String, Object> parameters) {
            this.parameters = parameters;
            return self();
        }

        /**
         * Number of times the task has been attempted.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attemptCount(final Long attemptCount) {
            this.attemptCount = attemptCount;
            return self();
        }

        /**
         * Status of the task.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B status(final AtlanTaskStatus status) {
            this.status = status;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B classificationId(final String classificationId) {
            this.classificationId = classificationId;
            return self();
        }

        /**
         * Unique identifier of the asset the task originated from.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entityGuid(final String entityGuid) {
            this.entityGuid = entityGuid;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanTask.AtlanTaskBuilder(super=" + super.toString() + ", type=" + this.type + ", guid=" + this.guid + ", createdBy=" + this.createdBy + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", timeTakenInSeconds=" + this.timeTakenInSeconds + ", parameters=" + this.parameters + ", attemptCount=" + this.attemptCount + ", status=" + this.status + ", classificationId=" + this.classificationId + ", entityGuid=" + this.entityGuid + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class AtlanTaskBuilderImpl extends AtlanTask.AtlanTaskBuilder<AtlanTask, AtlanTask.AtlanTaskBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTaskBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AtlanTask.AtlanTaskBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanTask build() {
            return new AtlanTask(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AtlanTask(final AtlanTask.AtlanTaskBuilder<?, ?> b) {
        super(b);
        this.type = b.type;
        this.guid = b.guid;
        this.createdBy = b.createdBy;
        this.createdTime = b.createdTime;
        this.updatedTime = b.updatedTime;
        this.startTime = b.startTime;
        this.endTime = b.endTime;
        this.timeTakenInSeconds = b.timeTakenInSeconds;
        this.parameters = b.parameters;
        this.attemptCount = b.attemptCount;
        this.status = b.status;
        this.classificationId = b.classificationId;
        this.entityGuid = b.entityGuid;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AtlanTask.AtlanTaskBuilder<?, ?> builder() {
        return new AtlanTask.AtlanTaskBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTask.AtlanTaskBuilder<?, ?> toBuilder() {
        return new AtlanTask.AtlanTaskBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Type of the task.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTaskType getType() {
        return this.type;
    }

    /**
     * Unique identifier of the task.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGuid() {
        return this.guid;
    }

    /**
     * User who created the task.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    /**
     * Time (epoch) at which the task was created, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCreatedTime() {
        return this.createdTime;
    }

    /**
     * Time (epoch) at which the task was last updated, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getUpdatedTime() {
        return this.updatedTime;
    }

    /**
     * Time (epoch) at which the task was started, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getStartTime() {
        return this.startTime;
    }

    /**
     * Time (epoch) at which the task was ended, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getEndTime() {
        return this.endTime;
    }

    /**
     * Total time taken to complete the task, in seconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTimeTakenInSeconds() {
        return this.timeTakenInSeconds;
    }

    /**
     * Parameters used for running the task.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    /**
     * Number of times the task has been attempted.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAttemptCount() {
        return this.attemptCount;
    }

    /**
     * Status of the task.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTaskStatus getStatus() {
        return this.status;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getClassificationId() {
        return this.classificationId;
    }

    /**
     * Unique identifier of the asset the task originated from.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEntityGuid() {
        return this.entityGuid;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanTask)) return false;
        final AtlanTask other = (AtlanTask) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$createdTime = this.getCreatedTime();
        final java.lang.Object other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !this$createdTime.equals(other$createdTime)) return false;
        final java.lang.Object this$updatedTime = this.getUpdatedTime();
        final java.lang.Object other$updatedTime = other.getUpdatedTime();
        if (this$updatedTime == null ? other$updatedTime != null : !this$updatedTime.equals(other$updatedTime)) return false;
        final java.lang.Object this$startTime = this.getStartTime();
        final java.lang.Object other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) return false;
        final java.lang.Object this$endTime = this.getEndTime();
        final java.lang.Object other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) return false;
        final java.lang.Object this$timeTakenInSeconds = this.getTimeTakenInSeconds();
        final java.lang.Object other$timeTakenInSeconds = other.getTimeTakenInSeconds();
        if (this$timeTakenInSeconds == null ? other$timeTakenInSeconds != null : !this$timeTakenInSeconds.equals(other$timeTakenInSeconds)) return false;
        final java.lang.Object this$attemptCount = this.getAttemptCount();
        final java.lang.Object other$attemptCount = other.getAttemptCount();
        if (this$attemptCount == null ? other$attemptCount != null : !this$attemptCount.equals(other$attemptCount)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$guid = this.getGuid();
        final java.lang.Object other$guid = other.getGuid();
        if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) return false;
        final java.lang.Object this$createdBy = this.getCreatedBy();
        final java.lang.Object other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) return false;
        final java.lang.Object this$parameters = this.getParameters();
        final java.lang.Object other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$classificationId = this.getClassificationId();
        final java.lang.Object other$classificationId = other.getClassificationId();
        if (this$classificationId == null ? other$classificationId != null : !this$classificationId.equals(other$classificationId)) return false;
        final java.lang.Object this$entityGuid = this.getEntityGuid();
        final java.lang.Object other$entityGuid = other.getEntityGuid();
        if (this$entityGuid == null ? other$entityGuid != null : !this$entityGuid.equals(other$entityGuid)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanTask;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $createdTime = this.getCreatedTime();
        result = result * PRIME + ($createdTime == null ? 43 : $createdTime.hashCode());
        final java.lang.Object $updatedTime = this.getUpdatedTime();
        result = result * PRIME + ($updatedTime == null ? 43 : $updatedTime.hashCode());
        final java.lang.Object $startTime = this.getStartTime();
        result = result * PRIME + ($startTime == null ? 43 : $startTime.hashCode());
        final java.lang.Object $endTime = this.getEndTime();
        result = result * PRIME + ($endTime == null ? 43 : $endTime.hashCode());
        final java.lang.Object $timeTakenInSeconds = this.getTimeTakenInSeconds();
        result = result * PRIME + ($timeTakenInSeconds == null ? 43 : $timeTakenInSeconds.hashCode());
        final java.lang.Object $attemptCount = this.getAttemptCount();
        result = result * PRIME + ($attemptCount == null ? 43 : $attemptCount.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $guid = this.getGuid();
        result = result * PRIME + ($guid == null ? 43 : $guid.hashCode());
        final java.lang.Object $createdBy = this.getCreatedBy();
        result = result * PRIME + ($createdBy == null ? 43 : $createdBy.hashCode());
        final java.lang.Object $parameters = this.getParameters();
        result = result * PRIME + ($parameters == null ? 43 : $parameters.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $classificationId = this.getClassificationId();
        result = result * PRIME + ($classificationId == null ? 43 : $classificationId.hashCode());
        final java.lang.Object $entityGuid = this.getEntityGuid();
        result = result * PRIME + ($entityGuid == null ? 43 : $entityGuid.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanTask(super=" + super.toString() + ", type=" + this.getType() + ", guid=" + this.getGuid() + ", createdBy=" + this.getCreatedBy() + ", createdTime=" + this.getCreatedTime() + ", updatedTime=" + this.getUpdatedTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", timeTakenInSeconds=" + this.getTimeTakenInSeconds() + ", parameters=" + this.getParameters() + ", attemptCount=" + this.getAttemptCount() + ", status=" + this.getStatus() + ", classificationId=" + this.getClassificationId() + ", entityGuid=" + this.getEntityGuid() + ")";
    }
}
